// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __VECTOR_LAPLACIAN_F1_P3_Q3_TENSOR_H
#define __VECTOR_LAPLACIAN_F1_P3_Q3_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p3_q3_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q3_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q3_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p3_q3_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p3_q3_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q3_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q3_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('triangle', Space(2)), 3, 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 20;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 11:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 12:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 13:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 14:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 15:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 16:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 17:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 18:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 19:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[10] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[1];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[1];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[1];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[15] = vals[1];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[16] = vals[1];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[17] = vals[1];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[18] = vals[1];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[19] = vals[1];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[10];
    vertex_values[3] = dof_values[11];
    vertex_values[5] = dof_values[12];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p3_q3_tensor_finite_element_0();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p3_q3_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p3_q3_tensor_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vector_laplacian_f1_p3_q3_tensor_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vector_laplacian_f1_p3_q3_tensor_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q3_tensor_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0] + 2*m.num_entities[1] + m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 10;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 10;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 2;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vector_laplacian_f1_p3_q3_tensor_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class vector_laplacian_f1_p3_q3_tensor_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  vector_laplacian_f1_p3_q3_tensor_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q3_tensor_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Cell('triangle', Space(2)), 3, 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 2*m.num_entities[0] + 4*m.num_entities[1] + 2*m.num_entities[2];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 20;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 20;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 8;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 2;
        break;
      }
    case 1:
      {
        return 4;
        break;
      }
    case 2:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[3] = offset + 2*c.entity_indices[1][0];
    dofs[4] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[5] = offset + 2*c.entity_indices[1][1];
    dofs[6] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[7] = offset + 2*c.entity_indices[1][2];
    dofs[8] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[9] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
    dofs[10] = offset + c.entity_indices[0][0];
    dofs[11] = offset + c.entity_indices[0][1];
    dofs[12] = offset + c.entity_indices[0][2];
    offset += m.num_entities[0];
    dofs[13] = offset + 2*c.entity_indices[1][0];
    dofs[14] = offset + 2*c.entity_indices[1][0] + 1;
    dofs[15] = offset + 2*c.entity_indices[1][1];
    dofs[16] = offset + 2*c.entity_indices[1][1] + 1;
    dofs[17] = offset + 2*c.entity_indices[1][2];
    dofs[18] = offset + 2*c.entity_indices[1][2] + 1;
    offset += 2*m.num_entities[1];
    dofs[19] = offset + c.entity_indices[2][0];
    offset += m.num_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 11;
      dofs[5] = 12;
      dofs[6] = 13;
      dofs[7] = 14;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 5;
      dofs[3] = 6;
      dofs[4] = 10;
      dofs[5] = 12;
      dofs[6] = 15;
      dofs[7] = 16;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 7;
      dofs[3] = 8;
      dofs[4] = 10;
      dofs[5] = 11;
      dofs[6] = 17;
      dofs[7] = 18;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 10;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 11;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 12;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
        dofs[1] = 4;
        dofs[2] = 13;
        dofs[3] = 14;
          break;
        }
      case 1:
        {
          dofs[0] = 5;
        dofs[1] = 6;
        dofs[2] = 15;
        dofs[3] = 16;
          break;
        }
      case 2:
        {
          dofs[0] = 7;
        dofs[1] = 8;
        dofs[2] = 17;
        dofs[3] = 18;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 9;
      dofs[1] = 19;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[3][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[3][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[4][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[4][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[5][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[5][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[6][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[6][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[7][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[7][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[8][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[8][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[9][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[9][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[10][0] = x[0][0];
    coordinates[10][1] = x[0][1];
    coordinates[11][0] = x[1][0];
    coordinates[11][1] = x[1][1];
    coordinates[12][0] = x[2][0];
    coordinates[12][1] = x[2][1];
    coordinates[13][0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[13][1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    coordinates[14][0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    coordinates[14][1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    coordinates[15][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    coordinates[15][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    coordinates[16][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    coordinates[16][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    coordinates[17][0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    coordinates[17][1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    coordinates[18][0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    coordinates[18][1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    coordinates[19][0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    coordinates[19][1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 2;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p3_q3_tensor_dofmap_0();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p3_q3_tensor_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new vector_laplacian_f1_p3_q3_tensor_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class vector_laplacian_f1_p3_q3_tensor_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q3_tensor_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q3_tensor_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      11
    // Number of operations (multiply-add pairs) for geometry tensor:    432
    // Number of operations (multiply-add pairs) for tensor contraction: 7491
    // Total number of operations (multiply-add pairs):                  7934
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0_0_0_0 = det*(w[0][0]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_0_0_1 = det*(w[0][0]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_1_0_0 = det*(w[0][1]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_2_0_1 = det*(w[0][2]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_0 = det*(w[0][3]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_3_0_1 = det*(w[0][3]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_0 = det*(w[0][4]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_4_0_1 = det*(w[0][4]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_0 = det*(w[0][5]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_5_0_1 = det*(w[0][5]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_0_0 = det*(w[0][6]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_6_0_1 = det*(w[0][6]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_0_0 = det*(w[0][7]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_7_0_1 = det*(w[0][7]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_0_0 = det*(w[0][8]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_8_0_1 = det*(w[0][8]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_0_0 = det*(w[0][9]*K_00*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_9_0_1 = det*(w[0][9]*K_10*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_10_1_0 = det*(w[0][10]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_10_1_1 = det*(w[0][10]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_11_1_0 = det*(w[0][11]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_12_1_1 = det*(w[0][12]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_13_1_0 = det*(w[0][13]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_13_1_1 = det*(w[0][13]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_14_1_0 = det*(w[0][14]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_14_1_1 = det*(w[0][14]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_15_1_0 = det*(w[0][15]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_15_1_1 = det*(w[0][15]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_16_1_0 = det*(w[0][16]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_16_1_1 = det*(w[0][16]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_17_1_0 = det*(w[0][17]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_17_1_1 = det*(w[0][17]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_18_1_0 = det*(w[0][18]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_18_1_1 = det*(w[0][18]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_19_1_0 = det*(w[0][19]*K_01*((K_00*K_00 + K_01*K_01)));
    const double G0_0_0_19_1_1 = det*(w[0][19]*K_11*((K_00*K_00 + K_01*K_01)));
    const double G0_0_1_0_0_0 = det*(w[0][0]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_0_0_1 = det*(w[0][0]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_1_0_0 = det*(w[0][1]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_2_0_1 = det*(w[0][2]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_0 = det*(w[0][3]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_3_0_1 = det*(w[0][3]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_0 = det*(w[0][4]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_4_0_1 = det*(w[0][4]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_0 = det*(w[0][5]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_5_0_1 = det*(w[0][5]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_0_0 = det*(w[0][6]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_6_0_1 = det*(w[0][6]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_0_0 = det*(w[0][7]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_7_0_1 = det*(w[0][7]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_0_0 = det*(w[0][8]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_8_0_1 = det*(w[0][8]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_0_0 = det*(w[0][9]*K_00*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_9_0_1 = det*(w[0][9]*K_10*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_10_1_0 = det*(w[0][10]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_10_1_1 = det*(w[0][10]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_11_1_0 = det*(w[0][11]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_12_1_1 = det*(w[0][12]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_13_1_0 = det*(w[0][13]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_13_1_1 = det*(w[0][13]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_14_1_0 = det*(w[0][14]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_14_1_1 = det*(w[0][14]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_15_1_0 = det*(w[0][15]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_15_1_1 = det*(w[0][15]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_16_1_0 = det*(w[0][16]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_16_1_1 = det*(w[0][16]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_17_1_0 = det*(w[0][17]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_17_1_1 = det*(w[0][17]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_18_1_0 = det*(w[0][18]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_18_1_1 = det*(w[0][18]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_19_1_0 = det*(w[0][19]*K_01*((K_00*K_10 + K_01*K_11)));
    const double G0_0_1_19_1_1 = det*(w[0][19]*K_11*((K_00*K_10 + K_01*K_11)));
    const double G0_1_0_0_0_0 = det*(w[0][0]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_0_0_1 = det*(w[0][0]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_1_0_0 = det*(w[0][1]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_2_0_1 = det*(w[0][2]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_0 = det*(w[0][3]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_3_0_1 = det*(w[0][3]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_0 = det*(w[0][4]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_4_0_1 = det*(w[0][4]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_0 = det*(w[0][5]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_5_0_1 = det*(w[0][5]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_0_0 = det*(w[0][6]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_6_0_1 = det*(w[0][6]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_0_0 = det*(w[0][7]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_7_0_1 = det*(w[0][7]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_0_0 = det*(w[0][8]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_8_0_1 = det*(w[0][8]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_0_0 = det*(w[0][9]*K_00*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_9_0_1 = det*(w[0][9]*K_10*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_10_1_0 = det*(w[0][10]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_10_1_1 = det*(w[0][10]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_11_1_0 = det*(w[0][11]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_12_1_1 = det*(w[0][12]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_13_1_0 = det*(w[0][13]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_13_1_1 = det*(w[0][13]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_14_1_0 = det*(w[0][14]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_14_1_1 = det*(w[0][14]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_15_1_0 = det*(w[0][15]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_15_1_1 = det*(w[0][15]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_16_1_0 = det*(w[0][16]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_16_1_1 = det*(w[0][16]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_17_1_0 = det*(w[0][17]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_17_1_1 = det*(w[0][17]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_18_1_0 = det*(w[0][18]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_18_1_1 = det*(w[0][18]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_19_1_0 = det*(w[0][19]*K_01*((K_10*K_00 + K_11*K_01)));
    const double G0_1_0_19_1_1 = det*(w[0][19]*K_11*((K_10*K_00 + K_11*K_01)));
    const double G0_1_1_0_0_0 = det*(w[0][0]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_0_0_1 = det*(w[0][0]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_1_0_0 = det*(w[0][1]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_2_0_1 = det*(w[0][2]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_0 = det*(w[0][3]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_3_0_1 = det*(w[0][3]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_0 = det*(w[0][4]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_4_0_1 = det*(w[0][4]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_0 = det*(w[0][5]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_5_0_1 = det*(w[0][5]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_0_0 = det*(w[0][6]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_6_0_1 = det*(w[0][6]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_0_0 = det*(w[0][7]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_7_0_1 = det*(w[0][7]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_0_0 = det*(w[0][8]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_8_0_1 = det*(w[0][8]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_0_0 = det*(w[0][9]*K_00*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_9_0_1 = det*(w[0][9]*K_10*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_10_1_0 = det*(w[0][10]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_10_1_1 = det*(w[0][10]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_11_1_0 = det*(w[0][11]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_12_1_1 = det*(w[0][12]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_13_1_0 = det*(w[0][13]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_13_1_1 = det*(w[0][13]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_14_1_0 = det*(w[0][14]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_14_1_1 = det*(w[0][14]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_15_1_0 = det*(w[0][15]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_15_1_1 = det*(w[0][15]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_16_1_0 = det*(w[0][16]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_16_1_1 = det*(w[0][16]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_17_1_0 = det*(w[0][17]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_17_1_1 = det*(w[0][17]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_18_1_0 = det*(w[0][18]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_18_1_1 = det*(w[0][18]*K_11*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_19_1_0 = det*(w[0][19]*K_01*((K_10*K_10 + K_11*K_11)));
    const double G0_1_1_19_1_1 = det*(w[0][19]*K_11*((K_10*K_10 + K_11*K_11)));
    
    // Compute element tensor
    A[143] = -0.216964285714289*G0_0_0_0_0_0 - 0.216964285714289*G0_0_0_0_0_1 + 0.379687500000003*G0_0_0_1_0_0 + 0.0542410714285704*G0_0_0_2_0_1 + 0.86785714285718*G0_0_0_3_0_0 + 0.81361607142859*G0_0_0_3_0_1 + 0.271205357142863*G0_0_0_4_0_0 + 0.650892857142885*G0_0_0_4_0_1 + 0.976339285714305*G0_0_0_5_0_0 + 0.542410714285726*G0_0_0_5_0_1 - 0.271205357142863*G0_0_0_6_0_0 - 0.379687500000007*G0_0_0_6_0_1 + 0.976339285714295*G0_0_0_7_0_0 + 1.41026785714287*G0_0_0_7_0_1 - 1.13906250000001*G0_0_0_8_0_0 - 0.81361607142859*G0_0_0_8_0_1 - 1.84419642857148*G0_0_0_9_0_0 - 2.06116071428576*G0_0_0_9_0_1 - 0.216964285714289*G0_0_0_10_1_0 - 0.216964285714289*G0_0_0_10_1_1 + 0.379687500000003*G0_0_0_11_1_0 + 0.0542410714285704*G0_0_0_12_1_1 + 0.86785714285718*G0_0_0_13_1_0 + 0.81361607142859*G0_0_0_13_1_1 + 0.271205357142863*G0_0_0_14_1_0 + 0.650892857142885*G0_0_0_14_1_1 + 0.976339285714305*G0_0_0_15_1_0 + 0.542410714285726*G0_0_0_15_1_1 - 0.271205357142863*G0_0_0_16_1_0 - 0.379687500000007*G0_0_0_16_1_1 + 0.976339285714295*G0_0_0_17_1_0 + 1.41026785714287*G0_0_0_17_1_1 - 1.13906250000001*G0_0_0_18_1_0 - 0.81361607142859*G0_0_0_18_1_1 - 1.84419642857148*G0_0_0_19_1_0 - 2.06116071428576*G0_0_0_19_1_1 - 0.331473214285721*G0_0_1_0_0_0 - 0.33147321428572*G0_0_1_0_0_1 + 1.1450892857143*G0_0_1_1_0_0 - 0.0482142857142896*G0_0_1_2_0_1 + 0.81361607142859*G0_0_1_3_0_0 + 1.95267857142859*G0_0_1_3_0_1 + 0.0542410714285858*G0_0_1_4_0_1 + 0.379687500000006*G0_0_1_5_0_0 + 0.108482142857147*G0_0_1_5_0_1 + 0.271205357142863*G0_0_1_6_0_1 + 1.73571428571431*G0_0_1_7_0_0 + 2.00691964285717*G0_0_1_7_0_1 - 2.54933035714289*G0_0_1_8_0_0 - 1.95267857142859*G0_0_1_8_0_1 - 1.1933035714286*G0_0_1_9_0_0 - 2.06116071428576*G0_0_1_9_0_1 - 0.331473214285721*G0_0_1_10_1_0 - 0.33147321428572*G0_0_1_10_1_1 + 1.1450892857143*G0_0_1_11_1_0 - 0.0482142857142896*G0_0_1_12_1_1 + 0.81361607142859*G0_0_1_13_1_0 + 1.95267857142859*G0_0_1_13_1_1 + 0.0542410714285858*G0_0_1_14_1_1 + 0.379687500000006*G0_0_1_15_1_0 + 0.108482142857147*G0_0_1_15_1_1 + 0.271205357142863*G0_0_1_16_1_1 + 1.73571428571431*G0_0_1_17_1_0 + 2.00691964285717*G0_0_1_17_1_1 - 2.54933035714289*G0_0_1_18_1_0 - 1.95267857142859*G0_0_1_18_1_1 - 1.1933035714286*G0_0_1_19_1_0 - 2.06116071428576*G0_0_1_19_1_1 - 0.385714285714292*G0_1_0_0_0_0 - 0.385714285714292*G0_1_0_0_0_1 + 0.494196428571433*G0_1_0_1_0_0 - 0.0482142857142882*G0_1_0_2_0_1 + 1.08482142857146*G0_1_0_3_0_0 + 0.976339285714303*G0_1_0_3_0_1 + 0.21696428571429*G0_1_0_4_0_0 + 0.86785714285717*G0_1_0_4_0_1 + 0.650892857142867*G0_1_0_5_0_0 + 0.542410714285725*G0_1_0_5_0_1 - 0.21696428571429*G0_1_0_6_0_0 - 0.108482142857145*G0_1_0_6_0_1 + 1.41026785714287*G0_1_0_7_0_0 + 1.51875000000002*G0_1_0_7_0_1 - 1.51875000000002*G0_1_0_8_0_0 - 0.976339285714303*G0_1_0_8_0_1 - 1.73571428571433*G0_1_0_9_0_0 - 2.38660714285719*G0_1_0_9_0_1 - 0.385714285714292*G0_1_0_10_1_0 - 0.385714285714292*G0_1_0_10_1_1 + 0.494196428571433*G0_1_0_11_1_0 - 0.0482142857142882*G0_1_0_12_1_1 + 1.08482142857146*G0_1_0_13_1_0 + 0.976339285714303*G0_1_0_13_1_1 + 0.21696428571429*G0_1_0_14_1_0 + 0.86785714285717*G0_1_0_14_1_1 + 0.650892857142867*G0_1_0_15_1_0 + 0.542410714285725*G0_1_0_15_1_1 - 0.21696428571429*G0_1_0_16_1_0 - 0.108482142857145*G0_1_0_16_1_1 + 1.41026785714287*G0_1_0_17_1_0 + 1.51875000000002*G0_1_0_17_1_1 - 1.51875000000002*G0_1_0_18_1_0 - 0.976339285714303*G0_1_0_18_1_1 - 1.73571428571433*G0_1_0_19_1_0 - 2.38660714285719*G0_1_0_19_1_1 - 0.500223214285721*G0_1_1_0_0_0 - 0.500223214285721*G0_1_1_0_0_1 + 1.3138392857143*G0_1_1_1_0_0 - 0.0421875000000041*G0_1_1_2_0_1 + 0.976339285714303*G0_1_1_3_0_0 + 2.27812500000002*G0_1_1_3_0_1 - 0.0542410714285713*G0_1_1_4_0_0 + 0.216964285714292*G0_1_1_5_0_0 + 0.271205357142861*G0_1_1_5_0_1 + 0.0542410714285715*G0_1_1_6_0_0 + 0.271205357142863*G0_1_1_6_0_1 + 2.00691964285717*G0_1_1_7_0_0 + 1.9526785714286*G0_1_1_7_0_1 - 2.82053571428575*G0_1_1_8_0_0 - 2.27812500000002*G0_1_1_8_0_1 - 1.19330357142859*G0_1_1_9_0_0 - 1.95267857142862*G0_1_1_9_0_1 - 0.500223214285721*G0_1_1_10_1_0 - 0.500223214285721*G0_1_1_10_1_1 + 1.3138392857143*G0_1_1_11_1_0 - 0.0421875000000041*G0_1_1_12_1_1 + 0.976339285714303*G0_1_1_13_1_0 + 2.27812500000002*G0_1_1_13_1_1 - 0.0542410714285713*G0_1_1_14_1_0 + 0.216964285714292*G0_1_1_15_1_0 + 0.271205357142861*G0_1_1_15_1_1 + 0.0542410714285715*G0_1_1_16_1_0 + 0.271205357142863*G0_1_1_16_1_1 + 2.00691964285717*G0_1_1_17_1_0 + 1.9526785714286*G0_1_1_17_1_1 - 2.82053571428575*G0_1_1_18_1_0 - 2.27812500000002*G0_1_1_18_1_1 - 1.19330357142859*G0_1_1_19_1_0 - 1.95267857142862*G0_1_1_19_1_1;
    A[329] = 0.0;
    A[384] = 0.0;
    A[207] = 0.0;
    A[17] = 0.0;
    A[281] = 0.0;
    A[304] = 0.0;
    A[320] = 0.0;
    A[353] = A[143];
    A[172] = 0.0;
    A[178] = 0.0;
    A[199] = 0.0;
    A[288] = 0.0;
    A[248] = 0.0;
    A[58] = 0.0;
    A[14] = 0.0;
    A[71] = 0.0;
    A[35] = 0.0;
    A[92] = 0.0;
    A[52] = 0.0;
    A[77] = 0.0;
    A[327] = 0.0;
    A[134] = 0.0;
    A[346] = 0.0;
    A[155] = 0.0;
    A[365] = 0.0;
    A[209] = 0.0;
    A[224] = 0.0;
    A[247] = 0.0;
    A[266] = 0.0;
    A[91] = 0.0;
    A[110] = 0.0;
    A[97] = 0.0;
    A[381] = 0.0;
    A[239] = -0.433928571428571*G0_0_0_1_0_0 + 0.108482142857146*G0_0_0_2_0_1 - 0.831696428571444*G0_0_0_3_0_0 - 1.22946428571429*G0_0_0_3_0_1 + 0.542410714285724*G0_0_0_4_0_0 + 0.397767857142856*G0_0_0_4_0_1 - 0.61473214285716*G0_0_0_5_0_0 - 0.25312500000001*G0_0_0_5_0_1 - 0.542410714285724*G0_0_0_6_0_0 + 0.144642857142864*G0_0_0_6_0_1 - 0.108482142857142*G0_0_0_7_0_0 - 0.470089285714292*G0_0_0_7_0_1 + 0.542410714285712*G0_0_0_8_0_0 + 1.22946428571429*G0_0_0_8_0_1 + 1.4464285714286*G0_0_0_9_0_0 + 0.0723214285714358*G0_0_0_9_0_1 - 0.433928571428571*G0_0_0_11_1_0 + 0.108482142857146*G0_0_0_12_1_1 - 0.831696428571444*G0_0_0_13_1_0 - 1.22946428571429*G0_0_0_13_1_1 + 0.542410714285724*G0_0_0_14_1_0 + 0.397767857142856*G0_0_0_14_1_1 - 0.61473214285716*G0_0_0_15_1_0 - 0.25312500000001*G0_0_0_15_1_1 - 0.542410714285724*G0_0_0_16_1_0 + 0.144642857142864*G0_0_0_16_1_1 - 0.108482142857142*G0_0_0_17_1_0 - 0.470089285714292*G0_0_0_17_1_1 + 0.542410714285712*G0_0_0_18_1_0 + 1.22946428571429*G0_0_0_18_1_1 + 1.4464285714286*G0_0_0_19_1_0 + 0.0723214285714358*G0_0_0_19_1_1 + 0.108482142857145*G0_0_1_0_0_0 + 0.108482142857145*G0_0_1_0_0_1 + 0.108482142857145*G0_0_1_2_0_1 - 0.144642857142863*G0_0_1_3_0_0 + 0.180803571428572*G0_0_1_4_0_0 - 0.0723214285714366*G0_0_1_4_0_1 + 0.0723214285714277*G0_0_1_5_0_0 - 0.108482142857146*G0_0_1_5_0_1 - 0.180803571428572*G0_0_1_6_0_0 - 0.108482142857145*G0_0_1_6_0_1 - 0.253125000000008*G0_0_1_7_0_0 - 0.0723214285714344*G0_0_1_7_0_1 + 0.144642857142861*G0_0_1_8_0_0 + 0.0723214285714358*G0_0_1_9_0_0 + 0.144642857142871*G0_0_1_9_0_1 + 0.108482142857145*G0_0_1_10_1_0 + 0.108482142857145*G0_0_1_10_1_1 + 0.108482142857145*G0_0_1_12_1_1 - 0.144642857142863*G0_0_1_13_1_0 + 0.180803571428572*G0_0_1_14_1_0 - 0.0723214285714366*G0_0_1_14_1_1 + 0.0723214285714277*G0_0_1_15_1_0 - 0.108482142857146*G0_0_1_15_1_1 - 0.180803571428572*G0_0_1_16_1_0 - 0.108482142857145*G0_0_1_16_1_1 - 0.253125000000008*G0_0_1_17_1_0 - 0.0723214285714344*G0_0_1_17_1_1 + 0.144642857142861*G0_0_1_18_1_0 + 0.0723214285714358*G0_0_1_19_1_0 + 0.144642857142871*G0_0_1_19_1_1;
    A[180] = A[239] + 0.433928571428572*G0_0_0_0_0_0 + 0.433928571428572*G0_0_0_0_0_1 + 0.433928571428571*G0_0_0_1_0_0 + 1.44642857142861*G0_0_0_3_0_0 + 1.59107142857144*G0_0_0_3_0_1 + 0.289285714285734*G0_0_0_4_0_1 + 1.4464285714286*G0_0_0_5_0_0 - 0.144642857142842*G0_0_0_5_0_1 - 0.28928571428573*G0_0_0_6_0_1 - 0.433928571428572*G0_0_0_7_0_0 + 1.15714285714287*G0_0_0_7_0_1 - 0.43392857142857*G0_0_0_8_0_0 - 1.59107142857144*G0_0_0_8_0_1 - 2.89285714285721*G0_0_0_9_0_0 - 1.44642857142861*G0_0_0_9_0_1 + 0.433928571428572*G0_0_0_10_1_0 + 0.433928571428572*G0_0_0_10_1_1 + 0.433928571428571*G0_0_0_11_1_0 + 1.44642857142861*G0_0_0_13_1_0 + 1.59107142857144*G0_0_0_13_1_1 + 0.289285714285734*G0_0_0_14_1_1 + 1.4464285714286*G0_0_0_15_1_0 - 0.144642857142842*G0_0_0_15_1_1 - 0.28928571428573*G0_0_0_16_1_1 - 0.433928571428572*G0_0_0_17_1_0 + 1.15714285714287*G0_0_0_17_1_1 - 0.43392857142857*G0_0_0_18_1_0 - 1.59107142857144*G0_0_0_18_1_1 - 2.89285714285721*G0_0_0_19_1_0 - 1.44642857142861*G0_0_0_19_1_1 + 0.325446428571427*G0_0_1_0_0_0 + 0.325446428571427*G0_0_1_0_0_1 + 0.759375000000025*G0_0_1_3_0_0 + 0.361607142857149*G0_0_1_3_0_1 + 0.361607142857153*G0_0_1_4_0_0 + 0.759375000000027*G0_0_1_4_0_1 + 0.759375000000016*G0_0_1_5_0_0 - 0.289285714285706*G0_0_1_5_0_1 - 0.361607142857153*G0_0_1_6_0_0 - 0.0361607142857207*G0_0_1_6_0_1 - 0.289285714285707*G0_0_1_7_0_0 + 0.759375000000016*G0_0_1_7_0_1 - 0.0361607142857192*G0_0_1_8_0_0 - 0.361607142857149*G0_0_1_8_0_1 - 1.51875000000004*G0_0_1_9_0_0 - 1.51875000000004*G0_0_1_9_0_1 + 0.325446428571427*G0_0_1_10_1_0 + 0.325446428571427*G0_0_1_10_1_1 + 0.759375000000025*G0_0_1_13_1_0 + 0.361607142857149*G0_0_1_13_1_1 + 0.361607142857153*G0_0_1_14_1_0 + 0.759375000000027*G0_0_1_14_1_1 + 0.759375000000016*G0_0_1_15_1_0 - 0.289285714285706*G0_0_1_15_1_1 - 0.361607142857153*G0_0_1_16_1_0 - 0.0361607142857207*G0_0_1_16_1_1 - 0.289285714285707*G0_0_1_17_1_0 + 0.759375000000016*G0_0_1_17_1_1 - 0.0361607142857192*G0_0_1_18_1_0 - 0.361607142857149*G0_0_1_18_1_1 - 1.51875000000004*G0_0_1_19_1_0 - 1.51875000000004*G0_0_1_19_1_1 + 0.433928571428573*G0_1_0_0_0_0 + 0.433928571428574*G0_1_0_0_0_1 + 0.108482142857145*G0_1_0_1_0_0 + 0.68705357142859*G0_1_0_3_0_0 + 0.542410714285724*G0_1_0_3_0_1 + 0.361607142857152*G0_1_0_4_0_0 + 0.614732142857162*G0_1_0_4_0_1 + 0.687053571428583*G0_1_0_5_0_0 - 0.542410714285716*G0_1_0_5_0_1 - 0.361607142857152*G0_1_0_6_0_0 + 0.108482142857143*G0_1_0_6_0_1 - 0.397767857142853*G0_1_0_7_0_0 + 0.831696428571445*G0_1_0_7_0_1 - 0.144642857142866*G0_1_0_8_0_0 - 0.542410714285724*G0_1_0_8_0_1 - 1.37410714285717*G0_1_0_9_0_0 - 1.44642857142861*G0_1_0_9_0_1 + 0.433928571428573*G0_1_0_10_1_0 + 0.433928571428574*G0_1_0_10_1_1 + 0.108482142857145*G0_1_0_11_1_0 + 0.68705357142859*G0_1_0_13_1_0 + 0.542410714285724*G0_1_0_13_1_1 + 0.361607142857152*G0_1_0_14_1_0 + 0.614732142857162*G0_1_0_14_1_1 + 0.687053571428583*G0_1_0_15_1_0 - 0.542410714285716*G0_1_0_15_1_1 - 0.361607142857152*G0_1_0_16_1_0 + 0.108482142857143*G0_1_0_16_1_1 - 0.397767857142853*G0_1_0_17_1_0 + 0.831696428571445*G0_1_0_17_1_1 - 0.144642857142866*G0_1_0_18_1_0 - 0.542410714285724*G0_1_0_18_1_1 - 1.37410714285717*G0_1_0_19_1_0 - 1.44642857142861*G0_1_0_19_1_1 + 0.433928571428574*G0_1_1_0_0_0 + 0.433928571428574*G0_1_1_0_0_1 + 0.108482142857145*G0_1_1_1_0_0 + 0.68705357142859*G0_1_1_3_0_0 + 0.542410714285724*G0_1_1_3_0_1 + 0.361607142857152*G0_1_1_4_0_0 + 0.614732142857162*G0_1_1_4_0_1 + 0.687053571428583*G0_1_1_5_0_0 - 0.542410714285717*G0_1_1_5_0_1 - 0.361607142857152*G0_1_1_6_0_0 + 0.108482142857143*G0_1_1_6_0_1 - 0.397767857142853*G0_1_1_7_0_0 + 0.831696428571446*G0_1_1_7_0_1 - 0.144642857142866*G0_1_1_8_0_0 - 0.542410714285724*G0_1_1_8_0_1 - 1.37410714285717*G0_1_1_9_0_0 - 1.44642857142861*G0_1_1_9_0_1 + 0.433928571428574*G0_1_1_10_1_0 + 0.433928571428574*G0_1_1_10_1_1 + 0.108482142857145*G0_1_1_11_1_0 + 0.68705357142859*G0_1_1_13_1_0 + 0.542410714285724*G0_1_1_13_1_1 + 0.361607142857152*G0_1_1_14_1_0 + 0.614732142857162*G0_1_1_14_1_1 + 0.687053571428583*G0_1_1_15_1_0 - 0.542410714285717*G0_1_1_15_1_1 - 0.361607142857152*G0_1_1_16_1_0 + 0.108482142857143*G0_1_1_16_1_1 - 0.397767857142853*G0_1_1_17_1_0 + 0.831696428571446*G0_1_1_17_1_1 - 0.144642857142866*G0_1_1_18_1_0 - 0.542410714285724*G0_1_1_18_1_1 - 1.37410714285717*G0_1_1_19_1_0 - 1.44642857142861*G0_1_1_19_1_1;
    A[235] = A[239] + 0.0796875000000008*G0_0_0_0_0_0 + 0.0796875000000009*G0_0_0_0_0_1 + 0.408482142857141*G0_0_0_1_0_0 - 0.0676339285714307*G0_0_0_2_0_1 + 1.06071428571431*G0_0_0_3_0_0 + 1.39821428571429*G0_0_0_3_0_1 - 0.584598214285726*G0_0_0_4_0_0 - 0.445982142857142*G0_0_0_4_0_1 + 1.00044642857146*G0_0_0_5_0_0 + 0.391741071428588*G0_0_0_5_0_1 + 0.584598214285726*G0_0_0_6_0_0 - 0.403794642857159*G0_0_0_6_0_1 - 0.162723214285719*G0_0_0_7_0_0 + 0.445982142857151*G0_0_0_7_0_1 - 0.325446428571422*G0_0_0_8_0_0 - 1.3982142857143*G0_0_0_8_0_1 - 2.06116071428577*G0_0_0_9_0_0 + 0.0796875000000008*G0_0_0_10_1_0 + 0.0796875000000009*G0_0_0_10_1_1 + 0.408482142857141*G0_0_0_11_1_0 - 0.0676339285714307*G0_0_0_12_1_1 + 1.06071428571431*G0_0_0_13_1_0 + 1.39821428571429*G0_0_0_13_1_1 - 0.584598214285726*G0_0_0_14_1_0 - 0.445982142857142*G0_0_0_14_1_1 + 1.00044642857146*G0_0_0_15_1_0 + 0.391741071428588*G0_0_0_15_1_1 + 0.584598214285726*G0_0_0_16_1_0 - 0.403794642857159*G0_0_0_16_1_1 - 0.162723214285719*G0_0_0_17_1_0 + 0.445982142857151*G0_0_0_17_1_1 - 0.325446428571422*G0_0_0_18_1_0 - 1.3982142857143*G0_0_0_18_1_1 - 2.06116071428577*G0_0_0_19_1_0 - 0.295312500000004*G0_0_1_0_0_0 - 0.295312500000004*G0_0_1_0_0_1 - 0.0964285714285741*G0_0_1_2_0_1 + 0.259151785714295*G0_0_1_3_0_0 - 0.229017857142861*G0_0_1_4_0_0 + 0.126562500000007*G0_0_1_4_0_1 + 0.0662946428571506*G0_0_1_5_0_0 + 0.494196428571438*G0_0_1_5_0_1 + 0.229017857142861*G0_0_1_6_0_0 - 0.10245535714286*G0_0_1_6_0_1 + 0.554464285714297*G0_0_1_7_0_0 + 0.12656250000001*G0_0_1_7_0_1 - 0.259151785714292*G0_0_1_8_0_0 - 0.325446428571446*G0_0_1_9_0_0 - 0.253125000000017*G0_0_1_9_0_1 - 0.295312500000004*G0_0_1_10_1_0 - 0.295312500000004*G0_0_1_10_1_1 - 0.0964285714285741*G0_0_1_12_1_1 + 0.259151785714295*G0_0_1_13_1_0 - 0.229017857142861*G0_0_1_14_1_0 + 0.126562500000007*G0_0_1_14_1_1 + 0.0662946428571506*G0_0_1_15_1_0 + 0.494196428571438*G0_0_1_15_1_1 + 0.229017857142861*G0_0_1_16_1_0 - 0.10245535714286*G0_0_1_16_1_1 + 0.554464285714297*G0_0_1_17_1_0 + 0.12656250000001*G0_0_1_17_1_1 - 0.259151785714292*G0_0_1_18_1_0 - 0.325446428571446*G0_0_1_19_1_0 - 0.253125000000017*G0_0_1_19_1_1;
    A[101] = A[235] + 0.186830357142859*G0_0_1_0_0_0 + 0.186830357142859*G0_0_1_0_0_1 - 0.0120535714285714*G0_0_1_2_0_1 - 0.114508928571431*G0_0_1_3_0_0 + 0.0482142857142879*G0_0_1_4_0_0 - 0.0542410714285708*G0_0_1_4_0_1 - 0.138616071428578*G0_0_1_5_0_0 - 0.385714285714292*G0_0_1_5_0_1 - 0.0482142857142879*G0_0_1_6_0_0 + 0.210937500000005*G0_0_1_6_0_1 - 0.301339285714289*G0_0_1_7_0_0 - 0.054241071428575*G0_0_1_7_0_1 + 0.114508928571431*G0_0_1_8_0_0 + 0.25312500000001*G0_0_1_9_0_0 + 0.108482142857146*G0_0_1_9_0_1 + 0.186830357142859*G0_0_1_10_1_0 + 0.186830357142859*G0_0_1_10_1_1 - 0.0120535714285714*G0_0_1_12_1_1 - 0.114508928571431*G0_0_1_13_1_0 + 0.0482142857142879*G0_0_1_14_1_0 - 0.0542410714285708*G0_0_1_14_1_1 - 0.138616071428578*G0_0_1_15_1_0 - 0.385714285714292*G0_0_1_15_1_1 - 0.0482142857142879*G0_0_1_16_1_0 + 0.210937500000005*G0_0_1_16_1_1 - 0.301339285714289*G0_0_1_17_1_0 - 0.054241071428575*G0_0_1_17_1_1 + 0.114508928571431*G0_0_1_18_1_0 + 0.25312500000001*G0_0_1_19_1_0 + 0.108482142857146*G0_0_1_19_1_1 - 0.186830357142859*G0_1_0_0_0_0 - 0.186830357142859*G0_1_0_0_0_1 + 0.0120535714285714*G0_1_0_2_0_1 + 0.114508928571431*G0_1_0_3_0_0 - 0.0482142857142879*G0_1_0_4_0_0 + 0.0542410714285708*G0_1_0_4_0_1 + 0.138616071428578*G0_1_0_5_0_0 + 0.385714285714292*G0_1_0_5_0_1 + 0.048214285714288*G0_1_0_6_0_0 - 0.210937500000005*G0_1_0_6_0_1 + 0.301339285714289*G0_1_0_7_0_0 + 0.054241071428575*G0_1_0_7_0_1 - 0.114508928571431*G0_1_0_8_0_0 - 0.25312500000001*G0_1_0_9_0_0 - 0.108482142857146*G0_1_0_9_0_1 - 0.186830357142859*G0_1_0_10_1_0 - 0.186830357142859*G0_1_0_10_1_1 + 0.0120535714285714*G0_1_0_12_1_1 + 0.114508928571431*G0_1_0_13_1_0 - 0.0482142857142879*G0_1_0_14_1_0 + 0.0542410714285708*G0_1_0_14_1_1 + 0.138616071428578*G0_1_0_15_1_0 + 0.385714285714292*G0_1_0_15_1_1 + 0.048214285714288*G0_1_0_16_1_0 - 0.210937500000005*G0_1_0_16_1_1 + 0.301339285714289*G0_1_0_17_1_0 + 0.054241071428575*G0_1_0_17_1_1 - 0.114508928571431*G0_1_0_18_1_0 - 0.25312500000001*G0_1_0_19_1_0 - 0.108482142857146*G0_1_0_19_1_1;
    A[219] = A[180] + 0.108482142857145*G0_0_1_1_0_0 - 0.108482142857145*G0_0_1_2_0_1 + 0.0723214285714282*G0_0_1_3_0_0 + 0.180803571428574*G0_0_1_3_0_1 - 0.180803571428573*G0_0_1_4_0_0 - 0.0723214285714278*G0_0_1_4_0_1 - 0.144642857142862*G0_0_1_5_0_0 - 0.144642857142864*G0_0_1_5_0_1 + 0.180803571428573*G0_0_1_6_0_0 + 0.253125000000009*G0_0_1_6_0_1 + 0.144642857142861*G0_0_1_7_0_0 + 0.144642857142864*G0_0_1_7_0_1 - 0.253125000000008*G0_0_1_8_0_0 - 0.180803571428574*G0_0_1_8_0_1 + 0.0723214285714342*G0_0_1_9_0_0 - 0.0723214285714358*G0_0_1_9_0_1 + 0.108482142857145*G0_0_1_11_1_0 - 0.108482142857145*G0_0_1_12_1_1 + 0.0723214285714282*G0_0_1_13_1_0 + 0.180803571428574*G0_0_1_13_1_1 - 0.180803571428573*G0_0_1_14_1_0 - 0.0723214285714278*G0_0_1_14_1_1 - 0.144642857142862*G0_0_1_15_1_0 - 0.144642857142864*G0_0_1_15_1_1 + 0.180803571428573*G0_0_1_16_1_0 + 0.253125000000009*G0_0_1_16_1_1 + 0.144642857142861*G0_0_1_17_1_0 + 0.144642857142864*G0_0_1_17_1_1 - 0.253125000000008*G0_0_1_18_1_0 - 0.180803571428574*G0_0_1_18_1_1 + 0.0723214285714342*G0_0_1_19_1_0 - 0.0723214285714358*G0_0_1_19_1_1 - 0.108482142857145*G0_1_0_1_0_0 + 0.108482142857145*G0_1_0_2_0_1 - 0.072321428571428*G0_1_0_3_0_0 - 0.180803571428574*G0_1_0_3_0_1 + 0.180803571428573*G0_1_0_4_0_0 + 0.0723214285714278*G0_1_0_4_0_1 + 0.144642857142862*G0_1_0_5_0_0 + 0.144642857142864*G0_1_0_5_0_1 - 0.180803571428573*G0_1_0_6_0_0 - 0.253125000000009*G0_1_0_6_0_1 - 0.144642857142861*G0_1_0_7_0_0 - 0.144642857142864*G0_1_0_7_0_1 + 0.253125000000008*G0_1_0_8_0_0 + 0.180803571428574*G0_1_0_8_0_1 - 0.072321428571434*G0_1_0_9_0_0 + 0.0723214285714355*G0_1_0_9_0_1 - 0.108482142857145*G0_1_0_11_1_0 + 0.108482142857145*G0_1_0_12_1_1 - 0.072321428571428*G0_1_0_13_1_0 - 0.180803571428574*G0_1_0_13_1_1 + 0.180803571428573*G0_1_0_14_1_0 + 0.0723214285714278*G0_1_0_14_1_1 + 0.144642857142862*G0_1_0_15_1_0 + 0.144642857142864*G0_1_0_15_1_1 - 0.180803571428573*G0_1_0_16_1_0 - 0.253125000000009*G0_1_0_16_1_1 - 0.144642857142861*G0_1_0_17_1_0 - 0.144642857142864*G0_1_0_17_1_1 + 0.253125000000008*G0_1_0_18_1_0 + 0.180803571428574*G0_1_0_18_1_1 - 0.072321428571434*G0_1_0_19_1_0 + 0.0723214285714355*G0_1_0_19_1_1;
    A[121] = A[101] - 0.108482142857144*G0_0_0_0_0_0 - 0.108482142857144*G0_0_0_0_0_1 - 0.307366071428577*G0_0_0_2_0_1 + 0.27120535714286*G0_0_0_3_0_0 - 0.452008928571436*G0_0_0_4_0_0 + 0.126562500000001*G0_0_0_4_0_1 - 0.343526785714296*G0_0_0_5_0_0 - 0.0904017857142901*G0_0_0_5_0_1 + 0.452008928571436*G0_0_0_6_0_0 + 0.506250000000012*G0_0_0_6_0_1 + 0.379687500000005*G0_0_0_7_0_0 + 0.126562499999999*G0_0_0_7_0_1 - 0.271205357142861*G0_0_0_8_0_0 + 0.0723214285714364*G0_0_0_9_0_0 - 0.253125*G0_0_0_9_0_1 - 0.108482142857144*G0_0_0_10_1_0 - 0.108482142857144*G0_0_0_10_1_1 - 0.307366071428577*G0_0_0_12_1_1 + 0.27120535714286*G0_0_0_13_1_0 - 0.452008928571436*G0_0_0_14_1_0 + 0.126562500000001*G0_0_0_14_1_1 - 0.343526785714296*G0_0_0_15_1_0 - 0.0904017857142901*G0_0_0_15_1_1 + 0.452008928571436*G0_0_0_16_1_0 + 0.506250000000012*G0_0_0_16_1_1 + 0.379687500000005*G0_0_0_17_1_0 + 0.126562499999999*G0_0_0_17_1_1 - 0.271205357142861*G0_0_0_18_1_0 + 0.0723214285714364*G0_0_0_19_1_0 - 0.253125*G0_0_0_19_1_1 + 0.19888392857143*G0_1_0_0_0_0 + 0.19888392857143*G0_1_0_0_0_1 - 0.198883928571432*G0_1_0_2_0_1 - 0.198883928571429*G0_1_0_4_0_0 - 0.397767857142873*G0_1_0_5_0_0 - 0.596651785714297*G0_1_0_5_0_1 + 0.198883928571429*G0_1_0_6_0_0 + 0.596651785714299*G0_1_0_6_0_1 - 0.198883928571429*G0_1_0_7_0_0 + 0.397767857142874*G0_1_0_9_0_0 + 0.19888392857143*G0_1_0_10_1_0 + 0.19888392857143*G0_1_0_10_1_1 - 0.198883928571432*G0_1_0_12_1_1 - 0.198883928571429*G0_1_0_14_1_0 - 0.397767857142873*G0_1_0_15_1_0 - 0.596651785714297*G0_1_0_15_1_1 + 0.198883928571429*G0_1_0_16_1_0 + 0.596651785714299*G0_1_0_16_1_1 - 0.198883928571429*G0_1_0_17_1_0 + 0.397767857142874*G0_1_0_19_1_0;
    A[331] = A[121];
    A[138] = 0.0;
    A[386] = 0.0;
    A[205] = 0.0;
    A[228] = 0.0;
    A[19] = 0.0;
    A[287] = 0.0;
    A[259] = 0.108482142857146*G0_1_0_0_0_0 + 0.108482142857146*G0_1_0_0_0_1 + 0.108482142857146*G0_1_0_1_0_0 - 0.0723214285714349*G0_1_0_3_0_0 + 0.180803571428574*G0_1_0_3_0_1 - 0.144642857142864*G0_1_0_4_0_1 - 0.0723214285714339*G0_1_0_5_0_0 - 0.253125000000008*G0_1_0_5_0_1 + 0.144642857142862*G0_1_0_6_0_1 - 0.108482142857145*G0_1_0_7_0_0 + 0.072321428571429*G0_1_0_7_0_1 - 0.108482142857146*G0_1_0_8_0_0 - 0.180803571428574*G0_1_0_8_0_1 + 0.144642857142869*G0_1_0_9_0_0 + 0.0723214285714352*G0_1_0_9_0_1 + 0.108482142857146*G0_1_0_10_1_0 + 0.108482142857146*G0_1_0_10_1_1 + 0.108482142857146*G0_1_0_11_1_0 - 0.0723214285714349*G0_1_0_13_1_0 + 0.180803571428574*G0_1_0_13_1_1 - 0.144642857142864*G0_1_0_14_1_1 - 0.0723214285714339*G0_1_0_15_1_0 - 0.253125000000008*G0_1_0_15_1_1 + 0.144642857142862*G0_1_0_16_1_1 - 0.108482142857145*G0_1_0_17_1_0 + 0.072321428571429*G0_1_0_17_1_1 - 0.108482142857146*G0_1_0_18_1_0 - 0.180803571428574*G0_1_0_18_1_1 + 0.144642857142869*G0_1_0_19_1_0 + 0.0723214285714352*G0_1_0_19_1_1 + 0.108482142857145*G0_1_1_1_0_0 - 0.433928571428573*G0_1_1_2_0_1 + 0.397767857142859*G0_1_1_3_0_0 + 0.542410714285724*G0_1_1_3_0_1 - 1.2294642857143*G0_1_1_4_0_0 - 0.831696428571445*G0_1_1_4_0_1 - 0.470089285714294*G0_1_1_5_0_0 - 0.108482142857143*G0_1_1_5_0_1 + 1.2294642857143*G0_1_1_6_0_0 + 0.542410714285716*G0_1_1_6_0_1 - 0.253125000000011*G0_1_1_7_0_0 - 0.614732142857161*G0_1_1_7_0_1 + 0.144642857142865*G0_1_1_8_0_0 - 0.542410714285724*G0_1_1_8_0_1 + 0.0723214285714351*G0_1_1_9_0_0 + 1.44642857142861*G0_1_1_9_0_1 + 0.108482142857145*G0_1_1_11_1_0 - 0.433928571428573*G0_1_1_12_1_1 + 0.397767857142859*G0_1_1_13_1_0 + 0.542410714285724*G0_1_1_13_1_1 - 1.2294642857143*G0_1_1_14_1_0 - 0.831696428571445*G0_1_1_14_1_1 - 0.470089285714294*G0_1_1_15_1_0 - 0.108482142857143*G0_1_1_15_1_1 + 1.2294642857143*G0_1_1_16_1_0 + 0.542410714285716*G0_1_1_16_1_1 - 0.253125000000011*G0_1_1_17_1_0 - 0.614732142857161*G0_1_1_17_1_1 + 0.144642857142865*G0_1_1_18_1_0 - 0.542410714285724*G0_1_1_18_1_1 + 0.0723214285714351*G0_1_1_19_1_0 + 1.44642857142861*G0_1_1_19_1_1;
    A[257] = A[259] - 0.295312500000004*G0_1_0_0_0_0 - 0.295312500000004*G0_1_0_0_0_1 - 0.0964285714285752*G0_1_0_1_0_0 + 0.126562500000005*G0_1_0_3_0_0 - 0.229017857142864*G0_1_0_3_0_1 + 0.259151785714297*G0_1_0_4_0_1 + 0.126562500000009*G0_1_0_5_0_0 + 0.554464285714297*G0_1_0_5_0_1 - 0.259151785714293*G0_1_0_6_0_1 + 0.494196428571437*G0_1_0_7_0_0 + 0.0662946428571491*G0_1_0_7_0_1 - 0.102455357142858*G0_1_0_8_0_0 + 0.229017857142864*G0_1_0_8_0_1 - 0.253125000000014*G0_1_0_9_0_0 - 0.325446428571446*G0_1_0_9_0_1 - 0.295312500000004*G0_1_0_10_1_0 - 0.295312500000004*G0_1_0_10_1_1 - 0.0964285714285752*G0_1_0_11_1_0 + 0.126562500000005*G0_1_0_13_1_0 - 0.229017857142864*G0_1_0_13_1_1 + 0.259151785714297*G0_1_0_14_1_1 + 0.126562500000009*G0_1_0_15_1_0 + 0.554464285714297*G0_1_0_15_1_1 - 0.259151785714293*G0_1_0_16_1_1 + 0.494196428571437*G0_1_0_17_1_0 + 0.0662946428571491*G0_1_0_17_1_1 - 0.102455357142858*G0_1_0_18_1_0 + 0.229017857142864*G0_1_0_18_1_1 - 0.253125000000014*G0_1_0_19_1_0 - 0.325446428571446*G0_1_0_19_1_1 + 0.0796875000000007*G0_1_1_0_0_0 + 0.0796875000000008*G0_1_1_0_0_1 - 0.0676339285714309*G0_1_1_1_0_0 + 0.408482142857143*G0_1_1_2_0_1 - 0.445982142857147*G0_1_1_3_0_0 - 0.584598214285728*G0_1_1_3_0_1 + 1.3982142857143*G0_1_1_4_0_0 + 1.06071428571431*G0_1_1_4_0_1 + 0.445982142857153*G0_1_1_5_0_0 - 0.162723214285718*G0_1_1_5_0_1 - 1.3982142857143*G0_1_1_6_0_0 - 0.325446428571427*G0_1_1_6_0_1 + 0.391741071428589*G0_1_1_7_0_0 + 1.00044642857146*G0_1_1_7_0_1 - 0.403794642857159*G0_1_1_8_0_0 + 0.584598214285728*G0_1_1_8_0_1 - 2.06116071428577*G0_1_1_9_0_1 + 0.0796875000000007*G0_1_1_10_1_0 + 0.0796875000000008*G0_1_1_10_1_1 - 0.0676339285714309*G0_1_1_11_1_0 + 0.408482142857143*G0_1_1_12_1_1 - 0.445982142857147*G0_1_1_13_1_0 - 0.584598214285728*G0_1_1_13_1_1 + 1.3982142857143*G0_1_1_14_1_0 + 1.06071428571431*G0_1_1_14_1_1 + 0.445982142857153*G0_1_1_15_1_0 - 0.162723214285718*G0_1_1_15_1_1 - 1.3982142857143*G0_1_1_16_1_0 - 0.325446428571427*G0_1_1_16_1_1 + 0.391741071428589*G0_1_1_17_1_0 + 1.00044642857146*G0_1_1_17_1_1 - 0.403794642857159*G0_1_1_18_1_0 + 0.584598214285728*G0_1_1_18_1_1 - 2.06116071428577*G0_1_1_19_1_1;
    A[47] = A[257];
    A[38] = 0.0;
    A[306] = 0.0;
    A[9] = A[219];
    A[322] = 0.0;
    A[343] = 0.0;
    A[156] = 0.0;
    A[368] = 0.0;
    A[174] = 0.0;
    A[195] = 0.0;
    A[221] = 0.0;
    A[197] = 0.0;
    A[271] = -0.0796875000000009*G0_0_0_0_0_0 - 0.0796875000000008*G0_0_0_0_0_1 + 0.459375000000001*G0_0_0_1_0_0 - 0.149330357142861*G0_0_0_2_0_1 + 0.602678571428582*G0_0_0_3_0_0 + 1.06071428571429*G0_0_0_3_0_1 - 0.500223214285721*G0_0_0_4_0_0 - 0.349553571428569*G0_0_0_4_0_1 + 0.229017857142862*G0_0_0_5_0_0 + 0.114508928571432*G0_0_0_5_0_1 + 0.500223214285722*G0_0_0_6_0_0 + 0.11450892857143*G0_0_0_6_0_1 + 0.379687500000003*G0_0_0_7_0_0 + 0.494196428571433*G0_0_0_7_0_1 - 0.759375000000003*G0_0_0_8_0_0 - 1.06071428571429*G0_0_0_8_0_1 - 0.831696428571444*G0_0_0_9_0_0 - 0.144642857142863*G0_0_0_9_0_1 - 0.0796875000000009*G0_0_0_10_1_0 - 0.0796875000000008*G0_0_0_10_1_1 + 0.459375000000001*G0_0_0_11_1_0 - 0.149330357142861*G0_0_0_12_1_1 + 0.602678571428582*G0_0_0_13_1_0 + 1.06071428571429*G0_0_0_13_1_1 - 0.500223214285721*G0_0_0_14_1_0 - 0.349553571428569*G0_0_0_14_1_1 + 0.229017857142862*G0_0_0_15_1_0 + 0.114508928571432*G0_0_0_15_1_1 + 0.500223214285722*G0_0_0_16_1_0 + 0.11450892857143*G0_0_0_16_1_1 + 0.379687500000003*G0_0_0_17_1_0 + 0.494196428571433*G0_0_0_17_1_1 - 0.759375000000003*G0_0_0_18_1_0 - 1.06071428571429*G0_0_0_18_1_1 - 0.831696428571444*G0_0_0_19_1_0 - 0.144642857142863*G0_0_0_19_1_1 - 0.266517857142861*G0_1_0_0_0_0 - 0.26651785714286*G0_1_0_0_0_1 + 2.0263392857143*G0_1_0_1_0_0 + 0.26651785714286*G0_1_0_2_0_1 + 1.06071428571429*G0_1_0_3_0_0 + 3.96562500000003*G0_1_0_3_0_1 - 0.168750000000001*G0_1_0_4_0_0 - 1.3138392857143*G0_1_0_4_0_1 + 0.168750000000001*G0_1_0_5_0_0 + 0.168750000000001*G0_1_0_6_0_0 + 1.1450892857143*G0_1_0_7_0_0 + 1.3138392857143*G0_1_0_7_0_1 - 2.90491071428574*G0_1_0_8_0_0 - 3.96562500000003*G0_1_0_8_0_1 - 1.22946428571429*G0_1_0_9_0_0 - 0.266517857142861*G0_1_0_10_1_0 - 0.26651785714286*G0_1_0_10_1_1 + 2.0263392857143*G0_1_0_11_1_0 + 0.26651785714286*G0_1_0_12_1_1 + 1.06071428571429*G0_1_0_13_1_0 + 3.96562500000003*G0_1_0_13_1_1 - 0.168750000000001*G0_1_0_14_1_0 - 1.3138392857143*G0_1_0_14_1_1 + 0.168750000000001*G0_1_0_15_1_0 + 0.168750000000001*G0_1_0_16_1_0 + 1.1450892857143*G0_1_0_17_1_0 + 1.3138392857143*G0_1_0_17_1_1 - 2.90491071428574*G0_1_0_18_1_0 - 3.96562500000003*G0_1_0_18_1_1 - 1.22946428571429*G0_1_0_19_1_0;
    A[56] = 0.0;
    A[73] = 0.0;
    A[33] = 0.0;
    A[94] = 0.0;
    A[50] = 0.0;
    A[115] = 0.0;
    A[79] = 0.0;
    A[132] = 0.0;
    A[344] = 0.0;
    A[363] = 0.0;
    A[226] = 0.0;
    A[241] = 0.0;
    A[264] = 0.0;
    A[26] = A[235] - 0.108482142857144*G0_0_0_0_0_0 - 0.108482142857144*G0_0_0_0_0_1 - 0.307366071428577*G0_0_0_2_0_1 + 0.27120535714286*G0_0_0_3_0_0 - 0.452008928571436*G0_0_0_4_0_0 + 0.126562500000001*G0_0_0_4_0_1 - 0.343526785714296*G0_0_0_5_0_0 - 0.0904017857142901*G0_0_0_5_0_1 + 0.452008928571436*G0_0_0_6_0_0 + 0.506250000000012*G0_0_0_6_0_1 + 0.379687500000006*G0_0_0_7_0_0 + 0.126562499999999*G0_0_0_7_0_1 - 0.271205357142861*G0_0_0_8_0_0 + 0.0723214285714366*G0_0_0_9_0_0 - 0.253125*G0_0_0_9_0_1 - 0.108482142857144*G0_0_0_10_1_0 - 0.108482142857144*G0_0_0_10_1_1 - 0.307366071428577*G0_0_0_12_1_1 + 0.27120535714286*G0_0_0_13_1_0 - 0.452008928571436*G0_0_0_14_1_0 + 0.126562500000001*G0_0_0_14_1_1 - 0.343526785714296*G0_0_0_15_1_0 - 0.0904017857142901*G0_0_0_15_1_1 + 0.452008928571436*G0_0_0_16_1_0 + 0.506250000000012*G0_0_0_16_1_1 + 0.379687500000006*G0_0_0_17_1_0 + 0.126562499999999*G0_0_0_17_1_1 - 0.271205357142861*G0_0_0_18_1_0 + 0.0723214285714366*G0_0_0_19_1_0 - 0.253125*G0_0_0_19_1_1 + 0.19888392857143*G0_0_1_0_0_0 + 0.19888392857143*G0_0_1_0_0_1 - 0.198883928571432*G0_0_1_2_0_1 - 0.198883928571429*G0_0_1_4_0_0 - 0.397767857142873*G0_0_1_5_0_0 - 0.596651785714297*G0_0_1_5_0_1 + 0.198883928571429*G0_0_1_6_0_0 + 0.596651785714299*G0_0_1_6_0_1 - 0.198883928571429*G0_0_1_7_0_0 + 0.397767857142874*G0_0_1_9_0_0 + 0.19888392857143*G0_0_1_10_1_0 + 0.19888392857143*G0_0_1_10_1_1 - 0.198883928571432*G0_0_1_12_1_1 - 0.198883928571429*G0_0_1_14_1_0 - 0.397767857142873*G0_0_1_15_1_0 - 0.596651785714297*G0_0_1_15_1_1 + 0.198883928571429*G0_0_1_16_1_0 + 0.596651785714299*G0_0_1_16_1_1 - 0.198883928571429*G0_0_1_17_1_0 + 0.397767857142874*G0_0_1_19_1_0;
    A[99] = 0.0;
    A[118] = 0.0;
    A[383] = 0.0;
    A[282] = 0.0;
    A[61] = A[271];
    A[136] = 0.0;
    A[388] = 0.0;
    A[348] = 0.0;
    A[203] = 0.0;
    A[285] = 0.0;
    A[36] = 0.0;
    A[300] = 0.0;
    A[11] = 0.0;
    A[30] = 0.0;
    A[81] = -A[121] + 0.0529017857142857*G0_1_0_0_0_0 + 0.0529017857142856*G0_1_0_0_0_1 - 0.649553571428578*G0_1_0_1_0_0 - 0.33616071428572*G0_1_0_2_0_1 - 0.235044642857139*G0_1_0_3_0_0 - 1.3138392857143*G0_1_0_3_0_1 - 0.325446428571432*G0_1_0_4_0_0 + 0.439955357142868*G0_1_0_4_0_1 - 0.307366071428581*G0_1_0_5_0_0 - 0.156696428571434*G0_1_0_5_0_1 + 0.325446428571432*G0_1_0_6_0_0 + 0.439955357142869*G0_1_0_6_0_1 - 0.10848214285714*G0_1_0_7_0_0 - 0.259151785714287*G0_1_0_7_0_1 + 0.705133928571432*G0_1_0_8_0_0 + 1.3138392857143*G0_1_0_8_0_1 + 0.54241071428572*G0_1_0_9_0_0 - 0.180803571428582*G0_1_0_9_0_1 + 0.0529017857142857*G0_1_0_10_1_0 + 0.0529017857142856*G0_1_0_10_1_1 - 0.649553571428578*G0_1_0_11_1_0 - 0.33616071428572*G0_1_0_12_1_1 - 0.235044642857139*G0_1_0_13_1_0 - 1.3138392857143*G0_1_0_13_1_1 - 0.325446428571432*G0_1_0_14_1_0 + 0.439955357142868*G0_1_0_14_1_1 - 0.307366071428581*G0_1_0_15_1_0 - 0.156696428571434*G0_1_0_15_1_1 + 0.325446428571432*G0_1_0_16_1_0 + 0.439955357142869*G0_1_0_16_1_1 - 0.10848214285714*G0_1_0_17_1_0 - 0.259151785714287*G0_1_0_17_1_1 + 0.705133928571432*G0_1_0_18_1_0 + 1.3138392857143*G0_1_0_18_1_1 + 0.54241071428572*G0_1_0_19_1_0 - 0.180803571428582*G0_1_0_19_1_1;
    A[324] = 0.0;
    A[131] = 0.0;
    A[341] = 0.0;
    A[158] = 0.0;
    A[366] = 0.0;
    A[193] = 0.0;
    A[223] = 0.0;
    A[292] = -0.266517857142862*G0_0_1_0_0_0 - 0.266517857142862*G0_0_1_0_0_1 + 0.266517857142861*G0_0_1_1_0_0 + 2.02633928571431*G0_0_1_2_0_1 - 1.3138392857143*G0_0_1_3_0_0 - 0.16875*G0_0_1_3_0_1 + 3.96562500000004*G0_0_1_4_0_0 + 1.06071428571429*G0_0_1_4_0_1 + 1.3138392857143*G0_0_1_5_0_0 + 1.1450892857143*G0_0_1_5_0_1 - 3.96562500000004*G0_0_1_6_0_0 - 2.90491071428575*G0_0_1_6_0_1 + 0.168750000000004*G0_0_1_7_0_1 + 0.16875*G0_0_1_8_0_1 - 1.2294642857143*G0_0_1_9_0_1 - 0.266517857142862*G0_0_1_10_1_0 - 0.266517857142862*G0_0_1_10_1_1 + 0.266517857142861*G0_0_1_11_1_0 + 2.02633928571431*G0_0_1_12_1_1 - 1.3138392857143*G0_0_1_13_1_0 - 0.16875*G0_0_1_13_1_1 + 3.96562500000004*G0_0_1_14_1_0 + 1.06071428571429*G0_0_1_14_1_1 + 1.3138392857143*G0_0_1_15_1_0 + 1.1450892857143*G0_0_1_15_1_1 - 3.96562500000004*G0_0_1_16_1_0 - 2.90491071428575*G0_0_1_16_1_1 + 0.168750000000004*G0_0_1_17_1_1 + 0.16875*G0_0_1_18_1_1 - 1.2294642857143*G0_0_1_19_1_1 - 0.0796875000000013*G0_1_1_0_0_0 - 0.0796875000000013*G0_1_1_0_0_1 - 0.14933035714286*G0_1_1_1_0_0 + 0.459375000000002*G0_1_1_2_0_1 - 0.34955357142857*G0_1_1_3_0_0 - 0.50022321428572*G0_1_1_3_0_1 + 1.06071428571429*G0_1_1_4_0_0 + 0.602678571428582*G0_1_1_4_0_1 + 0.494196428571435*G0_1_1_5_0_0 + 0.379687500000004*G0_1_1_5_0_1 - 1.06071428571429*G0_1_1_6_0_0 - 0.759375000000006*G0_1_1_6_0_1 + 0.114508928571433*G0_1_1_7_0_0 + 0.229017857142863*G0_1_1_7_0_1 + 0.114508928571428*G0_1_1_8_0_0 + 0.50022321428572*G0_1_1_8_0_1 - 0.144642857142864*G0_1_1_9_0_0 - 0.831696428571445*G0_1_1_9_0_1 - 0.0796875000000013*G0_1_1_10_1_0 - 0.0796875000000013*G0_1_1_10_1_1 - 0.14933035714286*G0_1_1_11_1_0 + 0.459375000000002*G0_1_1_12_1_1 - 0.34955357142857*G0_1_1_13_1_0 - 0.50022321428572*G0_1_1_13_1_1 + 1.06071428571429*G0_1_1_14_1_0 + 0.602678571428582*G0_1_1_14_1_1 + 0.494196428571435*G0_1_1_15_1_0 + 0.379687500000004*G0_1_1_15_1_1 - 1.06071428571429*G0_1_1_16_1_0 - 0.759375000000006*G0_1_1_16_1_1 + 0.114508928571433*G0_1_1_17_1_0 + 0.229017857142863*G0_1_1_17_1_1 + 0.114508928571428*G0_1_1_18_1_0 + 0.50022321428572*G0_1_1_18_1_1 - 0.144642857142864*G0_1_1_19_1_0 - 0.831696428571445*G0_1_1_19_1_1;
    A[244] = 0.0;
    A[309] = 0.0;
    A[269] = 0.0;
    A[75] = 0.0;
    A[23] = A[271] - 0.266517857142861*G0_0_1_0_0_0 - 0.26651785714286*G0_0_1_0_0_1 + 2.0263392857143*G0_0_1_1_0_0 + 0.26651785714286*G0_0_1_2_0_1 + 1.06071428571429*G0_0_1_3_0_0 + 3.96562500000003*G0_0_1_3_0_1 - 0.168750000000001*G0_0_1_4_0_0 - 1.3138392857143*G0_0_1_4_0_1 + 0.168750000000001*G0_0_1_5_0_0 + 0.168750000000001*G0_0_1_6_0_0 + 1.1450892857143*G0_0_1_7_0_0 + 1.3138392857143*G0_0_1_7_0_1 - 2.90491071428574*G0_0_1_8_0_0 - 3.96562500000003*G0_0_1_8_0_1 - 1.22946428571429*G0_0_1_9_0_0 - 0.266517857142861*G0_0_1_10_1_0 - 0.26651785714286*G0_0_1_10_1_1 + 2.0263392857143*G0_0_1_11_1_0 + 0.26651785714286*G0_0_1_12_1_1 + 1.06071428571429*G0_0_1_13_1_0 + 3.96562500000003*G0_0_1_13_1_1 - 0.168750000000001*G0_0_1_14_1_0 - 1.3138392857143*G0_0_1_14_1_1 + 0.168750000000001*G0_0_1_15_1_0 + 0.168750000000001*G0_0_1_16_1_0 + 1.1450892857143*G0_0_1_17_1_0 + 1.3138392857143*G0_0_1_17_1_1 - 2.90491071428574*G0_0_1_18_1_0 - 3.96562500000003*G0_0_1_18_1_1 - 1.22946428571429*G0_0_1_19_1_0 + 0.266517857142861*G0_1_0_0_0_0 + 0.26651785714286*G0_1_0_0_0_1 - 2.0263392857143*G0_1_0_1_0_0 - 0.26651785714286*G0_1_0_2_0_1 - 1.06071428571429*G0_1_0_3_0_0 - 3.96562500000003*G0_1_0_3_0_1 + 0.168750000000001*G0_1_0_4_0_0 + 1.3138392857143*G0_1_0_4_0_1 - 0.168750000000001*G0_1_0_5_0_0 - 0.168750000000001*G0_1_0_6_0_0 - 1.1450892857143*G0_1_0_7_0_0 - 1.3138392857143*G0_1_0_7_0_1 + 2.90491071428574*G0_1_0_8_0_0 + 3.96562500000003*G0_1_0_8_0_1 + 1.22946428571429*G0_1_0_9_0_0 + 0.266517857142861*G0_1_0_10_1_0 + 0.26651785714286*G0_1_0_10_1_1 - 2.0263392857143*G0_1_0_11_1_0 - 0.26651785714286*G0_1_0_12_1_1 - 1.06071428571429*G0_1_0_13_1_0 - 3.96562500000003*G0_1_0_13_1_1 + 0.168750000000001*G0_1_0_14_1_0 + 1.3138392857143*G0_1_0_14_1_1 - 0.168750000000001*G0_1_0_15_1_0 - 0.168750000000001*G0_1_0_16_1_0 - 1.1450892857143*G0_1_0_17_1_0 - 1.3138392857143*G0_1_0_17_1_1 + 2.90491071428574*G0_1_0_18_1_0 + 3.96562500000003*G0_1_0_18_1_1 + 1.22946428571429*G0_1_0_19_1_0;
    A[48] = A[257] + 0.19888392857143*G0_1_0_0_0_0 + 0.19888392857143*G0_1_0_0_0_1 - 0.198883928571429*G0_1_0_1_0_0 - 0.198883928571424*G0_1_0_3_0_1 - 0.198883928571429*G0_1_0_5_0_1 - 0.596651785714296*G0_1_0_7_0_0 - 0.397767857142872*G0_1_0_7_0_1 + 0.596651785714295*G0_1_0_8_0_0 + 0.198883928571424*G0_1_0_8_0_1 + 0.397767857142876*G0_1_0_9_0_1 + 0.19888392857143*G0_1_0_10_1_0 + 0.19888392857143*G0_1_0_10_1_1 - 0.198883928571429*G0_1_0_11_1_0 - 0.198883928571424*G0_1_0_13_1_1 - 0.198883928571429*G0_1_0_15_1_1 - 0.596651785714296*G0_1_0_17_1_0 - 0.397767857142872*G0_1_0_17_1_1 + 0.596651785714295*G0_1_0_18_1_0 + 0.198883928571424*G0_1_0_18_1_1 + 0.397767857142876*G0_1_0_19_1_1 - 0.108482142857144*G0_1_1_0_0_0 - 0.108482142857145*G0_1_1_0_0_1 - 0.307366071428574*G0_1_1_1_0_0 + 0.126562500000004*G0_1_1_3_0_0 - 0.45200892857143*G0_1_1_3_0_1 + 0.271205357142857*G0_1_1_4_0_1 + 0.126562499999999*G0_1_1_5_0_0 + 0.379687500000005*G0_1_1_5_0_1 - 0.271205357142859*G0_1_1_6_0_1 - 0.0904017857142885*G0_1_1_7_0_0 - 0.343526785714294*G0_1_1_7_0_1 + 0.506250000000007*G0_1_1_8_0_0 + 0.45200892857143*G0_1_1_8_0_1 - 0.253125000000003*G0_1_1_9_0_0 + 0.072321428571437*G0_1_1_9_0_1 - 0.108482142857144*G0_1_1_10_1_0 - 0.108482142857145*G0_1_1_10_1_1 - 0.307366071428574*G0_1_1_11_1_0 + 0.126562500000004*G0_1_1_13_1_0 - 0.45200892857143*G0_1_1_13_1_1 + 0.271205357142857*G0_1_1_14_1_1 + 0.126562499999999*G0_1_1_15_1_0 + 0.379687500000005*G0_1_1_15_1_1 - 0.271205357142859*G0_1_1_16_1_1 - 0.0904017857142885*G0_1_1_17_1_0 - 0.343526785714294*G0_1_1_17_1_1 + 0.506250000000007*G0_1_1_18_1_0 + 0.45200892857143*G0_1_1_18_1_1 - 0.253125000000003*G0_1_1_19_1_0 + 0.072321428571437*G0_1_1_19_1_1;
    A[162] = A[48] + 0.0120535714285707*G0_0_1_0_0_0 + 0.0120535714285707*G0_0_1_0_0_1 - 0.186830357142859*G0_0_1_1_0_0 + 0.0542410714285757*G0_0_1_3_0_0 - 0.247098214285714*G0_0_1_3_0_1 + 0.114508928571428*G0_0_1_4_0_1 + 0.0542410714285702*G0_0_1_5_0_0 + 0.10245535714286*G0_0_1_5_0_1 - 0.11450892857143*G0_0_1_6_0_1 - 0.210937500000004*G0_0_1_7_0_0 - 0.259151785714293*G0_0_1_7_0_1 + 0.385714285714292*G0_0_1_8_0_0 + 0.247098214285714*G0_0_1_8_0_1 - 0.108482142857146*G0_0_1_9_0_0 + 0.144642857142865*G0_0_1_9_0_1 + 0.0120535714285707*G0_0_1_10_1_0 + 0.0120535714285707*G0_0_1_10_1_1 - 0.186830357142859*G0_0_1_11_1_0 + 0.0542410714285757*G0_0_1_13_1_0 - 0.247098214285714*G0_0_1_13_1_1 + 0.114508928571428*G0_0_1_14_1_1 + 0.0542410714285702*G0_0_1_15_1_0 + 0.10245535714286*G0_0_1_15_1_1 - 0.11450892857143*G0_0_1_16_1_1 - 0.210937500000004*G0_0_1_17_1_0 - 0.259151785714293*G0_0_1_17_1_1 + 0.385714285714292*G0_0_1_18_1_0 + 0.247098214285714*G0_0_1_18_1_1 - 0.108482142857146*G0_0_1_19_1_0 + 0.144642857142865*G0_0_1_19_1_1 - 0.0120535714285708*G0_1_0_0_0_0 - 0.0120535714285707*G0_1_0_0_0_1 + 0.186830357142859*G0_1_0_1_0_0 - 0.0542410714285756*G0_1_0_3_0_0 + 0.247098214285714*G0_1_0_3_0_1 - 0.114508928571428*G0_1_0_4_0_1 - 0.0542410714285702*G0_1_0_5_0_0 - 0.10245535714286*G0_1_0_5_0_1 + 0.11450892857143*G0_1_0_6_0_1 + 0.210937500000004*G0_1_0_7_0_0 + 0.259151785714294*G0_1_0_7_0_1 - 0.385714285714292*G0_1_0_8_0_0 - 0.247098214285714*G0_1_0_8_0_1 + 0.108482142857146*G0_1_0_9_0_0 - 0.144642857142865*G0_1_0_9_0_1 - 0.0120535714285708*G0_1_0_10_1_0 - 0.0120535714285707*G0_1_0_10_1_1 + 0.186830357142859*G0_1_0_11_1_0 - 0.0542410714285756*G0_1_0_13_1_0 + 0.247098214285714*G0_1_0_13_1_1 - 0.114508928571428*G0_1_0_14_1_1 - 0.0542410714285702*G0_1_0_15_1_0 - 0.10245535714286*G0_1_0_15_1_1 + 0.11450892857143*G0_1_0_16_1_1 + 0.210937500000004*G0_1_0_17_1_0 + 0.259151785714294*G0_1_0_17_1_1 - 0.385714285714292*G0_1_0_18_1_0 - 0.247098214285714*G0_1_0_18_1_1 + 0.108482142857146*G0_1_0_19_1_0 - 0.144642857142865*G0_1_0_19_1_1;
    A[62] = -A[162] + 0.0529017857142858*G0_0_1_0_0_0 + 0.0529017857142857*G0_0_1_0_0_1 - 0.33616071428572*G0_0_1_1_0_0 - 0.649553571428581*G0_0_1_2_0_1 + 0.439955357142872*G0_0_1_3_0_0 - 0.325446428571429*G0_0_1_3_0_1 - 1.3138392857143*G0_0_1_4_0_0 - 0.235044642857143*G0_0_1_4_0_1 - 0.25915178571429*G0_0_1_5_0_0 - 0.108482142857143*G0_0_1_5_0_1 + 1.3138392857143*G0_0_1_6_0_0 + 0.705133928571438*G0_0_1_6_0_1 - 0.156696428571433*G0_0_1_7_0_0 - 0.307366071428582*G0_0_1_7_0_1 + 0.439955357142867*G0_0_1_8_0_0 + 0.32544642857143*G0_0_1_8_0_1 - 0.180803571428581*G0_0_1_9_0_0 + 0.542410714285724*G0_0_1_9_0_1 + 0.0529017857142858*G0_0_1_10_1_0 + 0.0529017857142857*G0_0_1_10_1_1 - 0.33616071428572*G0_0_1_11_1_0 - 0.649553571428581*G0_0_1_12_1_1 + 0.439955357142872*G0_0_1_13_1_0 - 0.325446428571429*G0_0_1_13_1_1 - 1.3138392857143*G0_0_1_14_1_0 - 0.235044642857143*G0_0_1_14_1_1 - 0.25915178571429*G0_0_1_15_1_0 - 0.108482142857143*G0_0_1_15_1_1 + 1.3138392857143*G0_0_1_16_1_0 + 0.705133928571438*G0_0_1_16_1_1 - 0.156696428571433*G0_0_1_17_1_0 - 0.307366071428582*G0_0_1_17_1_1 + 0.439955357142867*G0_0_1_18_1_0 + 0.32544642857143*G0_0_1_18_1_1 - 0.180803571428581*G0_0_1_19_1_0 + 0.542410714285724*G0_0_1_19_1_1;
    A[370] = -A[162] - 0.675000000000007*G0_0_0_0_0_0 - 0.675000000000007*G0_0_0_0_0_1 + 0.41584821428572*G0_0_0_1_0_0 + 0.0120535714285707*G0_0_0_2_0_1 + 0.271205357142861*G0_0_0_3_0_0 + 0.572544642857151*G0_0_0_3_0_1 - 0.108482142857144*G0_0_0_4_0_0 - 0.0060267857142844*G0_0_0_4_0_1 - 0.379687500000003*G0_0_0_5_0_0 + 0.765401785714293*G0_0_0_5_0_1 + 0.108482142857144*G0_0_0_6_0_0 - 0.102455357142856*G0_0_0_6_0_1 + 1.29575892857145*G0_0_0_7_0_0 + 0.150669642857151*G0_0_0_7_0_1 - 1.03660714285716*G0_0_0_8_0_0 - 0.572544642857151*G0_0_0_8_0_1 + 0.108482142857142*G0_0_0_9_0_0 - 0.144642857142866*G0_0_0_9_0_1 - 0.675000000000007*G0_0_0_10_1_0 - 0.675000000000007*G0_0_0_10_1_1 + 0.41584821428572*G0_0_0_11_1_0 + 0.0120535714285707*G0_0_0_12_1_1 + 0.271205357142861*G0_0_0_13_1_0 + 0.572544642857151*G0_0_0_13_1_1 - 0.108482142857144*G0_0_0_14_1_0 - 0.0060267857142844*G0_0_0_14_1_1 - 0.379687500000003*G0_0_0_15_1_0 + 0.765401785714293*G0_0_0_15_1_1 + 0.108482142857144*G0_0_0_16_1_0 - 0.102455357142856*G0_0_0_16_1_1 + 1.29575892857145*G0_0_0_17_1_0 + 0.150669642857151*G0_0_0_17_1_1 - 1.03660714285716*G0_0_0_18_1_0 - 0.572544642857151*G0_0_0_18_1_1 + 0.108482142857142*G0_0_0_19_1_0 - 0.144642857142866*G0_0_0_19_1_1 - 0.662946428571437*G0_0_1_0_0_0 - 0.662946428571437*G0_0_1_0_0_1 + 0.229017857142861*G0_0_1_1_0_0 + 0.0120535714285699*G0_0_1_2_0_1 + 0.325446428571436*G0_0_1_3_0_0 + 0.325446428571437*G0_0_1_3_0_1 - 0.108482142857147*G0_0_1_4_0_0 + 0.108482142857144*G0_0_1_4_0_1 - 0.325446428571433*G0_0_1_5_0_0 + 0.867857142857153*G0_0_1_5_0_1 + 0.108482142857148*G0_0_1_6_0_0 - 0.216964285714286*G0_0_1_6_0_1 + 1.08482142857144*G0_0_1_7_0_0 - 0.108482142857143*G0_0_1_7_0_1 - 0.650892857142867*G0_0_1_8_0_0 - 0.325446428571437*G0_0_1_8_0_1 - 0.662946428571437*G0_0_1_10_1_0 - 0.662946428571437*G0_0_1_10_1_1 + 0.229017857142861*G0_0_1_11_1_0 + 0.0120535714285699*G0_0_1_12_1_1 + 0.325446428571436*G0_0_1_13_1_0 + 0.325446428571437*G0_0_1_13_1_1 - 0.108482142857147*G0_0_1_14_1_0 + 0.108482142857144*G0_0_1_14_1_1 - 0.325446428571433*G0_0_1_15_1_0 + 0.867857142857153*G0_0_1_15_1_1 + 0.108482142857148*G0_0_1_16_1_0 - 0.216964285714286*G0_0_1_16_1_1 + 1.08482142857144*G0_0_1_17_1_0 - 0.108482142857143*G0_0_1_17_1_1 - 0.650892857142867*G0_0_1_18_1_0 - 0.325446428571437*G0_0_1_18_1_1 - 0.0254464285714306*G0_1_0_0_0_0 - 0.0254464285714305*G0_1_0_0_0_1 + 0.266517857142861*G0_1_0_1_0_0 - 0.0287946428571436*G0_1_0_2_0_1 + 0.24709821428572*G0_1_0_3_0_0 + 0.494196428571436*G0_1_0_3_0_1 - 0.00602678571428589*G0_1_0_4_0_0 + 0.0421875000000032*G0_1_0_4_0_1 + 0.11450892857143*G0_1_0_5_0_0 - 0.0542410714285695*G0_1_0_5_0_1 + 0.00602678571428595*G0_1_0_6_0_0 + 0.108482142857144*G0_1_0_6_0_1 + 0.331473214285721*G0_1_0_7_0_0 + 0.500223214285721*G0_1_0_7_0_1 - 0.572544642857151*G0_1_0_8_0_0 - 0.494196428571436*G0_1_0_8_0_1 - 0.361607142857151*G0_1_0_9_0_0 - 0.542410714285724*G0_1_0_9_0_1 - 0.0254464285714306*G0_1_0_10_1_0 - 0.0254464285714305*G0_1_0_10_1_1 + 0.266517857142861*G0_1_0_11_1_0 - 0.0287946428571436*G0_1_0_12_1_1 + 0.24709821428572*G0_1_0_13_1_0 + 0.494196428571436*G0_1_0_13_1_1 - 0.00602678571428589*G0_1_0_14_1_0 + 0.0421875000000032*G0_1_0_14_1_1 + 0.11450892857143*G0_1_0_15_1_0 - 0.0542410714285695*G0_1_0_15_1_1 + 0.00602678571428595*G0_1_0_16_1_0 + 0.108482142857144*G0_1_0_16_1_1 + 0.331473214285721*G0_1_0_17_1_0 + 0.500223214285721*G0_1_0_17_1_1 - 0.572544642857151*G0_1_0_18_1_0 - 0.494196428571436*G0_1_0_18_1_1 - 0.361607142857151*G0_1_0_19_1_0 - 0.542410714285724*G0_1_0_19_1_1 - 0.0542410714285741*G0_1_1_0_0_0 - 0.054241071428574*G0_1_1_0_0_1 - 0.0542410714285741*G0_1_1_2_0_1 + 0.325446428571436*G0_1_1_3_0_0 + 0.162723214285714*G0_1_1_4_0_0 + 0.542410714285724*G0_1_1_4_0_1 + 0.216964285714288*G0_1_1_5_0_0 + 0.0542410714285743*G0_1_1_5_0_1 - 0.162723214285714*G0_1_1_6_0_0 + 0.0542410714285738*G0_1_1_6_0_1 + 0.379687500000011*G0_1_1_7_0_0 + 0.542410714285725*G0_1_1_7_0_1 - 0.325446428571437*G0_1_1_8_0_0 - 0.542410714285725*G0_1_1_9_0_0 - 1.08482142857145*G0_1_1_9_0_1 - 0.0542410714285741*G0_1_1_10_1_0 - 0.054241071428574*G0_1_1_10_1_1 - 0.0542410714285741*G0_1_1_12_1_1 + 0.325446428571436*G0_1_1_13_1_0 + 0.162723214285714*G0_1_1_14_1_0 + 0.542410714285724*G0_1_1_14_1_1 + 0.216964285714288*G0_1_1_15_1_0 + 0.0542410714285743*G0_1_1_15_1_1 - 0.162723214285714*G0_1_1_16_1_0 + 0.0542410714285738*G0_1_1_16_1_1 + 0.379687500000011*G0_1_1_17_1_0 + 0.542410714285725*G0_1_1_17_1_1 - 0.325446428571437*G0_1_1_18_1_0 - 0.542410714285725*G0_1_1_19_1_0 - 1.08482142857145*G0_1_1_19_1_1;
    A[160] = A[370];
    A[253] = -A[48] + 0.0529017857142858*G0_1_0_0_0_0 + 0.0529017857142857*G0_1_0_0_0_1 - 0.33616071428572*G0_1_0_1_0_0 - 0.649553571428581*G0_1_0_2_0_1 + 0.439955357142871*G0_1_0_3_0_0 - 0.325446428571429*G0_1_0_3_0_1 - 1.3138392857143*G0_1_0_4_0_0 - 0.235044642857142*G0_1_0_4_0_1 - 0.25915178571429*G0_1_0_5_0_0 - 0.108482142857143*G0_1_0_5_0_1 + 1.3138392857143*G0_1_0_6_0_0 + 0.705133928571438*G0_1_0_6_0_1 - 0.156696428571433*G0_1_0_7_0_0 - 0.307366071428582*G0_1_0_7_0_1 + 0.439955357142867*G0_1_0_8_0_0 + 0.32544642857143*G0_1_0_8_0_1 - 0.180803571428581*G0_1_0_9_0_0 + 0.542410714285724*G0_1_0_9_0_1 + 0.0529017857142858*G0_1_0_10_1_0 + 0.0529017857142857*G0_1_0_10_1_1 - 0.33616071428572*G0_1_0_11_1_0 - 0.649553571428581*G0_1_0_12_1_1 + 0.439955357142871*G0_1_0_13_1_0 - 0.325446428571429*G0_1_0_13_1_1 - 1.3138392857143*G0_1_0_14_1_0 - 0.235044642857142*G0_1_0_14_1_1 - 0.25915178571429*G0_1_0_15_1_0 - 0.108482142857143*G0_1_0_15_1_1 + 1.3138392857143*G0_1_0_16_1_0 + 0.705133928571438*G0_1_0_16_1_1 - 0.156696428571433*G0_1_0_17_1_0 - 0.307366071428582*G0_1_0_17_1_1 + 0.439955357142867*G0_1_0_18_1_0 + 0.32544642857143*G0_1_0_18_1_1 - 0.180803571428581*G0_1_0_19_1_0 + 0.542410714285724*G0_1_0_19_1_1;
    A[45] = A[253] - 0.190178571428576*G0_1_0_0_0_0 - 0.190178571428576*G0_1_0_0_0_1 + 0.190178571428576*G0_1_0_1_0_0 + 1.29910714285716*G0_1_0_2_0_1 - 0.699107142857156*G0_1_0_3_0_0 - 0.0241071428571423*G0_1_0_3_0_1 + 2.6276785714286*G0_1_0_4_0_0 + 0.843750000000005*G0_1_0_4_0_1 + 0.699107142857155*G0_1_0_5_0_0 + 0.675000000000013*G0_1_0_5_0_1 - 2.6276785714286*G0_1_0_6_0_0 - 1.7839285714286*G0_1_0_6_0_1 + 0.0241071428571475*G0_1_0_7_0_1 + 0.0241071428571424*G0_1_0_8_0_1 - 0.867857142857152*G0_1_0_9_0_1 - 0.190178571428576*G0_1_0_10_1_0 - 0.190178571428576*G0_1_0_10_1_1 + 0.190178571428576*G0_1_0_11_1_0 + 1.29910714285716*G0_1_0_12_1_1 - 0.699107142857156*G0_1_0_13_1_0 - 0.0241071428571423*G0_1_0_13_1_1 + 2.6276785714286*G0_1_0_14_1_0 + 0.843750000000005*G0_1_0_14_1_1 + 0.699107142857155*G0_1_0_15_1_0 + 0.675000000000013*G0_1_0_15_1_1 - 2.6276785714286*G0_1_0_16_1_0 - 1.7839285714286*G0_1_0_16_1_1 + 0.0241071428571475*G0_1_0_17_1_1 + 0.0241071428571424*G0_1_0_18_1_1 - 0.867857142857152*G0_1_0_19_1_1 - 0.444642857142864*G0_1_1_0_0_0 - 0.444642857142864*G0_1_1_0_0_1 - 0.254464285714288*G0_1_1_1_0_0 + 0.64955357142858*G0_1_1_2_0_1 - 0.132589285714287*G0_1_1_3_0_0 - 0.602678571428578*G0_1_1_3_0_1 + 1.3138392857143*G0_1_1_4_0_0 + 0.879910714285725*G0_1_1_4_0_1 + 0.566517857142869*G0_1_1_5_0_0 + 1.1450892857143*G0_1_1_5_0_1 - 1.3138392857143*G0_1_1_6_0_0 - 1.35000000000002*G0_1_1_6_0_1 + 0.349553571428579*G0_1_1_7_0_0 - 0.229017857142857*G0_1_1_7_0_1 + 0.349553571428573*G0_1_1_8_0_0 + 0.602678571428578*G0_1_1_8_0_1 - 0.433928571428582*G0_1_1_9_0_0 - 0.650892857142868*G0_1_1_9_0_1 - 0.444642857142864*G0_1_1_10_1_0 - 0.444642857142864*G0_1_1_10_1_1 - 0.254464285714288*G0_1_1_11_1_0 + 0.64955357142858*G0_1_1_12_1_1 - 0.132589285714287*G0_1_1_13_1_0 - 0.602678571428578*G0_1_1_13_1_1 + 1.3138392857143*G0_1_1_14_1_0 + 0.879910714285725*G0_1_1_14_1_1 + 0.566517857142869*G0_1_1_15_1_0 + 1.1450892857143*G0_1_1_15_1_1 - 1.3138392857143*G0_1_1_16_1_0 - 1.35000000000002*G0_1_1_16_1_1 + 0.349553571428579*G0_1_1_17_1_0 - 0.229017857142857*G0_1_1_17_1_1 + 0.349553571428573*G0_1_1_18_1_0 + 0.602678571428578*G0_1_1_18_1_1 - 0.433928571428582*G0_1_1_19_1_0 - 0.650892857142868*G0_1_1_19_1_1;
    A[113] = 0.0;
    A[122] = -A[292] + 0.33616071428572*G0_1_1_0_0_0 + 0.33616071428572*G0_1_1_0_0_1 - 0.33616071428572*G0_1_1_1_0_0 - 1.1075892857143*G0_1_1_2_0_1 + 0.470089285714298*G0_1_1_3_0_0 - 0.44598214285715*G0_1_1_3_0_1 - 1.84419642857145*G0_1_1_4_0_0 - 0.156696428571423*G0_1_1_4_0_1 - 0.470089285714296*G0_1_1_5_0_0 - 0.916071428571446*G0_1_1_5_0_1 + 1.84419642857145*G0_1_1_6_0_0 + 1.68750000000003*G0_1_1_6_0_1 + 0.445982142857153*G0_1_1_7_0_1 + 0.445982142857151*G0_1_1_8_0_1 - 0.289285714285729*G0_1_1_9_0_1 + 0.33616071428572*G0_1_1_10_1_0 + 0.33616071428572*G0_1_1_10_1_1 - 0.33616071428572*G0_1_1_11_1_0 - 1.1075892857143*G0_1_1_12_1_1 + 0.470089285714298*G0_1_1_13_1_0 - 0.44598214285715*G0_1_1_13_1_1 - 1.84419642857145*G0_1_1_14_1_0 - 0.156696428571423*G0_1_1_14_1_1 - 0.470089285714296*G0_1_1_15_1_0 - 0.916071428571446*G0_1_1_15_1_1 + 1.84419642857145*G0_1_1_16_1_0 + 1.68750000000003*G0_1_1_16_1_1 + 0.445982142857153*G0_1_1_17_1_1 + 0.445982142857151*G0_1_1_18_1_1 - 0.289285714285729*G0_1_1_19_1_1;
    A[151] = 0.0;
    A[361] = 0.0;
    A[243] = 0.0;
    A[262] = 0.0;
    A[24] = -A[26] + 0.0529017857142857*G0_0_1_0_0_0 + 0.0529017857142856*G0_0_1_0_0_1 - 0.649553571428578*G0_0_1_1_0_0 - 0.33616071428572*G0_0_1_2_0_1 - 0.235044642857139*G0_0_1_3_0_0 - 1.3138392857143*G0_0_1_3_0_1 - 0.325446428571432*G0_0_1_4_0_0 + 0.439955357142868*G0_0_1_4_0_1 - 0.307366071428581*G0_0_1_5_0_0 - 0.156696428571434*G0_0_1_5_0_1 + 0.325446428571432*G0_0_1_6_0_0 + 0.439955357142869*G0_0_1_6_0_1 - 0.10848214285714*G0_0_1_7_0_0 - 0.259151785714287*G0_0_1_7_0_1 + 0.705133928571432*G0_0_1_8_0_0 + 1.3138392857143*G0_0_1_8_0_1 + 0.54241071428572*G0_0_1_9_0_0 - 0.180803571428582*G0_0_1_9_0_1 + 0.0529017857142857*G0_0_1_10_1_0 + 0.0529017857142856*G0_0_1_10_1_1 - 0.649553571428578*G0_0_1_11_1_0 - 0.33616071428572*G0_0_1_12_1_1 - 0.235044642857139*G0_0_1_13_1_0 - 1.3138392857143*G0_0_1_13_1_1 - 0.325446428571432*G0_0_1_14_1_0 + 0.439955357142868*G0_0_1_14_1_1 - 0.307366071428581*G0_0_1_15_1_0 - 0.156696428571434*G0_0_1_15_1_1 + 0.325446428571432*G0_0_1_16_1_0 + 0.439955357142869*G0_0_1_16_1_1 - 0.10848214285714*G0_0_1_17_1_0 - 0.259151785714287*G0_0_1_17_1_1 + 0.705133928571432*G0_0_1_18_1_0 + 1.3138392857143*G0_0_1_18_1_1 + 0.54241071428572*G0_0_1_19_1_0 - 0.180803571428582*G0_0_1_19_1_1;
    A[43] = A[253];
    A[116] = 0.0;
    A[328] = 0.0;
    A[385] = 0.0;
    A[181] = A[239] - 0.108482142857145*G0_0_1_0_0_0 - 0.108482142857145*G0_0_1_0_0_1 - 0.108482142857145*G0_0_1_2_0_1 + 0.144642857142863*G0_0_1_3_0_0 - 0.180803571428572*G0_0_1_4_0_0 + 0.0723214285714366*G0_0_1_4_0_1 - 0.0723214285714281*G0_0_1_5_0_0 + 0.108482142857146*G0_0_1_5_0_1 + 0.180803571428572*G0_0_1_6_0_0 + 0.108482142857145*G0_0_1_6_0_1 + 0.253125000000008*G0_0_1_7_0_0 + 0.0723214285714341*G0_0_1_7_0_1 - 0.144642857142861*G0_0_1_8_0_0 - 0.072321428571435*G0_0_1_9_0_0 - 0.144642857142871*G0_0_1_9_0_1 - 0.108482142857145*G0_0_1_10_1_0 - 0.108482142857145*G0_0_1_10_1_1 - 0.108482142857145*G0_0_1_12_1_1 + 0.144642857142863*G0_0_1_13_1_0 - 0.180803571428572*G0_0_1_14_1_0 + 0.0723214285714366*G0_0_1_14_1_1 - 0.0723214285714281*G0_0_1_15_1_0 + 0.108482142857146*G0_0_1_15_1_1 + 0.180803571428572*G0_0_1_16_1_0 + 0.108482142857145*G0_0_1_16_1_1 + 0.253125000000008*G0_0_1_17_1_0 + 0.0723214285714341*G0_0_1_17_1_1 - 0.144642857142861*G0_0_1_18_1_0 - 0.072321428571435*G0_0_1_19_1_0 - 0.144642857142871*G0_0_1_19_1_1 + 0.108482142857145*G0_1_0_0_0_0 + 0.108482142857145*G0_1_0_0_0_1 + 0.108482142857145*G0_1_0_2_0_1 - 0.144642857142863*G0_1_0_3_0_0 + 0.180803571428572*G0_1_0_4_0_0 - 0.0723214285714365*G0_1_0_4_0_1 + 0.0723214285714282*G0_1_0_5_0_0 - 0.108482142857146*G0_1_0_5_0_1 - 0.180803571428572*G0_1_0_6_0_0 - 0.108482142857145*G0_1_0_6_0_1 - 0.253125000000008*G0_1_0_7_0_0 - 0.0723214285714339*G0_1_0_7_0_1 + 0.144642857142861*G0_1_0_8_0_0 + 0.0723214285714349*G0_1_0_9_0_0 + 0.144642857142871*G0_1_0_9_0_1 + 0.108482142857145*G0_1_0_10_1_0 + 0.108482142857145*G0_1_0_10_1_1 + 0.108482142857145*G0_1_0_12_1_1 - 0.144642857142863*G0_1_0_13_1_0 + 0.180803571428572*G0_1_0_14_1_0 - 0.0723214285714365*G0_1_0_14_1_1 + 0.0723214285714282*G0_1_0_15_1_0 - 0.108482142857146*G0_1_0_15_1_1 - 0.180803571428572*G0_1_0_16_1_0 - 0.108482142857145*G0_1_0_16_1_1 - 0.253125000000008*G0_1_0_17_1_0 - 0.0723214285714339*G0_1_0_17_1_1 + 0.144642857142861*G0_1_0_18_1_0 + 0.0723214285714349*G0_1_0_19_1_0 + 0.144642857142871*G0_1_0_19_1_1;
    A[379] = -A[181] + 0.108482142857142*G0_0_0_0_0_0 + 0.108482142857142*G0_0_0_0_0_1 + 0.108482142857142*G0_0_0_1_0_0 + 1.22946428571432*G0_0_0_3_0_0 + 0.831696428571444*G0_0_0_3_0_1 + 0.506250000000022*G0_0_0_4_0_1 + 1.22946428571432*G0_0_0_5_0_0 + 0.397767857142877*G0_0_0_5_0_1 - 0.506250000000019*G0_0_0_6_0_1 - 0.108482142857143*G0_0_0_7_0_0 + 0.723214285714302*G0_0_0_7_0_1 - 0.108482142857141*G0_0_0_8_0_0 - 0.831696428571445*G0_0_0_8_0_1 - 2.45892857142865*G0_0_0_9_0_0 - 1.22946428571432*G0_0_0_9_0_1 + 0.108482142857142*G0_0_0_10_1_0 + 0.108482142857142*G0_0_0_10_1_1 + 0.108482142857142*G0_0_0_11_1_0 + 1.22946428571432*G0_0_0_13_1_0 + 0.831696428571444*G0_0_0_13_1_1 + 0.506250000000022*G0_0_0_14_1_1 + 1.22946428571432*G0_0_0_15_1_0 + 0.397767857142877*G0_0_0_15_1_1 - 0.506250000000019*G0_0_0_16_1_1 - 0.108482142857143*G0_0_0_17_1_0 + 0.723214285714302*G0_0_0_17_1_1 - 0.108482142857141*G0_0_0_18_1_0 - 0.831696428571445*G0_0_0_18_1_1 - 2.45892857142865*G0_0_0_19_1_0 - 1.22946428571432*G0_0_0_19_1_1 - 0.144642857142866*G0_0_1_0_0_0 - 0.144642857142866*G0_0_1_0_0_1 + 0.144642857142861*G0_0_1_1_0_0 + 0.144642857142866*G0_0_1_2_0_1 + 1.51875000000003*G0_0_1_3_0_0 + 1.51875000000003*G0_0_1_3_0_1 - 0.433928571428568*G0_0_1_4_0_0 - 0.43392857142857*G0_0_1_4_0_1 - 0.216964285714275*G0_0_1_5_0_0 + 0.650892857142885*G0_0_1_5_0_1 + 0.433928571428569*G0_0_1_6_0_0 - 0.650892857142885*G0_0_1_6_0_1 - 1.30178571428573*G0_0_1_7_0_0 - 2.16964285714289*G0_0_1_7_0_1 + 1.30178571428573*G0_0_1_8_0_0 - 1.51875000000003*G0_0_1_8_0_1 - 1.30178571428576*G0_0_1_9_0_0 + 2.60357142857146*G0_0_1_9_0_1 - 0.144642857142866*G0_0_1_10_1_0 - 0.144642857142866*G0_0_1_10_1_1 + 0.144642857142861*G0_0_1_11_1_0 + 0.144642857142866*G0_0_1_12_1_1 + 1.51875000000003*G0_0_1_13_1_0 + 1.51875000000003*G0_0_1_13_1_1 - 0.433928571428568*G0_0_1_14_1_0 - 0.43392857142857*G0_0_1_14_1_1 - 0.216964285714275*G0_0_1_15_1_0 + 0.650892857142885*G0_0_1_15_1_1 + 0.433928571428569*G0_0_1_16_1_0 - 0.650892857142885*G0_0_1_16_1_1 - 1.30178571428573*G0_0_1_17_1_0 - 2.16964285714289*G0_0_1_17_1_1 + 1.30178571428573*G0_0_1_18_1_0 - 1.51875000000003*G0_0_1_18_1_1 - 1.30178571428576*G0_0_1_19_1_0 + 2.60357142857146*G0_0_1_19_1_1 - 0.253125000000005*G0_1_0_0_0_0 - 0.253125000000005*G0_1_0_0_0_1 + 1.22946428571429*G0_1_0_1_0_0 - 0.0723214285714289*G0_1_0_2_0_1 + 2.35044642857145*G0_1_0_3_0_0 + 3.03750000000002*G0_1_0_3_0_1 + 0.0723214285714316*G0_1_0_4_0_0 + 0.687053571428583*G0_1_0_4_0_1 + 0.18080357142858*G0_1_0_5_0_0 - 0.0723214285714309*G0_1_0_6_0_0 + 0.325446428571426*G0_1_0_6_0_1 + 0.940178571428588*G0_1_0_7_0_0 + 1.12098214285716*G0_1_0_7_0_1 - 1.91651785714288*G0_1_0_8_0_0 - 3.03750000000002*G0_1_0_8_0_1 - 2.53125000000003*G0_1_0_9_0_0 - 1.80803571428574*G0_1_0_9_0_1 - 0.253125000000005*G0_1_0_10_1_0 - 0.253125000000005*G0_1_0_10_1_1 + 1.22946428571429*G0_1_0_11_1_0 - 0.0723214285714289*G0_1_0_12_1_1 + 2.35044642857145*G0_1_0_13_1_0 + 3.03750000000002*G0_1_0_13_1_1 + 0.0723214285714316*G0_1_0_14_1_0 + 0.687053571428583*G0_1_0_14_1_1 + 0.18080357142858*G0_1_0_15_1_0 - 0.0723214285714309*G0_1_0_16_1_0 + 0.325446428571426*G0_1_0_16_1_1 + 0.940178571428588*G0_1_0_17_1_0 + 1.12098214285716*G0_1_0_17_1_1 - 1.91651785714288*G0_1_0_18_1_0 - 3.03750000000002*G0_1_0_18_1_1 - 2.53125000000003*G0_1_0_19_1_0 - 1.80803571428574*G0_1_0_19_1_1 - 0.542410714285724*G0_1_1_0_0_0 - 0.542410714285724*G0_1_1_0_0_1 - 0.542410714285724*G0_1_1_2_0_1 + 1.51875000000003*G0_1_1_3_0_0 - 0.108482142857139*G0_1_1_4_0_0 + 1.95267857142862*G0_1_1_4_0_1 + 0.433928571428583*G0_1_1_5_0_0 + 0.542410714285724*G0_1_1_5_0_1 + 0.10848214285714*G0_1_1_6_0_0 + 0.542410714285724*G0_1_1_6_0_1 + 2.06116071428576*G0_1_1_7_0_0 + 1.95267857142862*G0_1_1_7_0_1 - 1.51875000000003*G0_1_1_8_0_0 - 1.95267857142861*G0_1_1_9_0_0 - 3.90535714285723*G0_1_1_9_0_1 - 0.542410714285724*G0_1_1_10_1_0 - 0.542410714285724*G0_1_1_10_1_1 - 0.542410714285724*G0_1_1_12_1_1 + 1.51875000000003*G0_1_1_13_1_0 - 0.108482142857139*G0_1_1_14_1_0 + 1.95267857142862*G0_1_1_14_1_1 + 0.433928571428583*G0_1_1_15_1_0 + 0.542410714285724*G0_1_1_15_1_1 + 0.10848214285714*G0_1_1_16_1_0 + 0.542410714285724*G0_1_1_16_1_1 + 2.06116071428576*G0_1_1_17_1_0 + 1.95267857142862*G0_1_1_17_1_1 - 1.51875000000003*G0_1_1_18_1_0 - 1.95267857142861*G0_1_1_19_1_0 - 3.90535714285723*G0_1_1_19_1_1;
    A[186] = A[379] - 0.650892857142867*G0_0_0_0_0_0 - 0.650892857142867*G0_0_0_0_0_1 - 1.08482142857144*G0_0_0_1_0_0 + 0.108482142857147*G0_0_0_2_0_1 - 0.108482142857154*G0_0_0_3_0_0 - 2.16964285714288*G0_0_0_3_0_1 + 0.542410714285724*G0_0_0_4_0_0 + 1.41026785714287*G0_0_0_4_0_1 + 0.108482142857131*G0_0_0_5_0_0 + 1.41026785714287*G0_0_0_5_0_1 - 0.542410714285724*G0_0_0_6_0_0 - 0.867857142857149*G0_0_0_6_0_1 + 0.542410714285726*G0_0_0_7_0_0 - 0.759375000000013*G0_0_0_7_0_1 + 1.19330357142858*G0_0_0_8_0_0 + 2.16964285714288*G0_0_0_8_0_1 - 0.650892857142854*G0_0_0_9_0_1 - 0.650892857142867*G0_0_0_10_1_0 - 0.650892857142867*G0_0_0_10_1_1 - 1.08482142857144*G0_0_0_11_1_0 + 0.108482142857147*G0_0_0_12_1_1 - 0.108482142857154*G0_0_0_13_1_0 - 2.16964285714288*G0_0_0_13_1_1 + 0.542410714285724*G0_0_0_14_1_0 + 1.41026785714287*G0_0_0_14_1_1 + 0.108482142857131*G0_0_0_15_1_0 + 1.41026785714287*G0_0_0_15_1_1 - 0.542410714285724*G0_0_0_16_1_0 - 0.867857142857149*G0_0_0_16_1_1 + 0.542410714285726*G0_0_0_17_1_0 - 0.759375000000013*G0_0_0_17_1_1 + 1.19330357142858*G0_0_0_18_1_0 + 2.16964285714288*G0_0_0_18_1_1 - 0.650892857142854*G0_0_0_19_1_1 - 1.95267857142861*G0_0_1_3_0_0 - 1.9526785714286*G0_0_1_3_0_1 + 1.9526785714286*G0_0_1_4_0_0 + 1.9526785714286*G0_0_1_4_0_1 - 1.95267857142861*G0_0_1_5_0_0 - 1.95267857142861*G0_0_1_5_0_1 - 1.9526785714286*G0_0_1_6_0_0 + 1.95267857142861*G0_0_1_6_0_1 + 1.95267857142861*G0_0_1_7_0_0 + 1.95267857142861*G0_0_1_7_0_1 - 1.95267857142862*G0_0_1_8_0_0 + 1.9526785714286*G0_0_1_8_0_1 + 3.90535714285722*G0_0_1_9_0_0 - 3.90535714285722*G0_0_1_9_0_1 - 1.95267857142861*G0_0_1_13_1_0 - 1.9526785714286*G0_0_1_13_1_1 + 1.9526785714286*G0_0_1_14_1_0 + 1.9526785714286*G0_0_1_14_1_1 - 1.95267857142861*G0_0_1_15_1_0 - 1.95267857142861*G0_0_1_15_1_1 - 1.9526785714286*G0_0_1_16_1_0 + 1.95267857142861*G0_0_1_16_1_1 + 1.95267857142861*G0_0_1_17_1_0 + 1.95267857142861*G0_0_1_17_1_1 - 1.95267857142862*G0_0_1_18_1_0 + 1.9526785714286*G0_0_1_18_1_1 + 3.90535714285722*G0_0_1_19_1_0 - 3.90535714285722*G0_0_1_19_1_1 - 1.41026785714287*G0_1_0_1_0_0 + 1.41026785714287*G0_1_0_2_0_1 - 1.73571428571429*G0_1_0_3_0_0 - 3.14598214285716*G0_1_0_3_0_1 + 3.14598214285717*G0_1_0_4_0_0 + 1.73571428571429*G0_1_0_4_0_1 + 1.08482142857144*G0_1_0_5_0_0 + 1.08482142857145*G0_1_0_5_0_1 - 3.14598214285717*G0_1_0_6_0_0 - 2.49508928571432*G0_1_0_6_0_1 - 1.08482142857144*G0_1_0_7_0_0 - 1.08482142857144*G0_1_0_7_0_1 + 2.49508928571431*G0_1_0_8_0_0 + 3.14598214285716*G0_1_0_8_0_1 + 0.65089285714285*G0_1_0_9_0_0 - 0.650892857142853*G0_1_0_9_0_1 - 1.41026785714287*G0_1_0_11_1_0 + 1.41026785714287*G0_1_0_12_1_1 - 1.73571428571429*G0_1_0_13_1_0 - 3.14598214285716*G0_1_0_13_1_1 + 3.14598214285717*G0_1_0_14_1_0 + 1.73571428571429*G0_1_0_14_1_1 + 1.08482142857144*G0_1_0_15_1_0 + 1.08482142857145*G0_1_0_15_1_1 - 3.14598214285717*G0_1_0_16_1_0 - 2.49508928571432*G0_1_0_16_1_1 - 1.08482142857144*G0_1_0_17_1_0 - 1.08482142857144*G0_1_0_17_1_1 + 2.49508928571431*G0_1_0_18_1_0 + 3.14598214285716*G0_1_0_18_1_1 + 0.65089285714285*G0_1_0_19_1_0 - 0.650892857142853*G0_1_0_19_1_1 + 0.650892857142867*G0_1_1_0_0_0 + 0.650892857142867*G0_1_1_0_0_1 - 0.108482142857144*G0_1_1_1_0_0 + 1.08482142857144*G0_1_1_2_0_1 - 1.41026785714287*G0_1_1_3_0_0 - 0.54241071428572*G0_1_1_3_0_1 + 2.16964285714289*G0_1_1_4_0_0 + 0.108482142857152*G0_1_1_4_0_1 + 0.759375000000015*G0_1_1_5_0_0 - 0.542410714285725*G0_1_1_5_0_1 - 2.16964285714288*G0_1_1_6_0_0 - 1.19330357142858*G0_1_1_6_0_1 - 1.41026785714287*G0_1_1_7_0_0 - 0.108482142857131*G0_1_1_7_0_1 + 0.867857142857146*G0_1_1_8_0_0 + 0.54241071428572*G0_1_1_8_0_1 + 0.650892857142855*G0_1_1_9_0_0 + 0.650892857142867*G0_1_1_10_1_0 + 0.650892857142867*G0_1_1_10_1_1 - 0.108482142857144*G0_1_1_11_1_0 + 1.08482142857144*G0_1_1_12_1_1 - 1.41026785714287*G0_1_1_13_1_0 - 0.54241071428572*G0_1_1_13_1_1 + 2.16964285714289*G0_1_1_14_1_0 + 0.108482142857152*G0_1_1_14_1_1 + 0.759375000000015*G0_1_1_15_1_0 - 0.542410714285725*G0_1_1_15_1_1 - 2.16964285714288*G0_1_1_16_1_0 - 1.19330357142858*G0_1_1_16_1_1 - 1.41026785714287*G0_1_1_17_1_0 - 0.108482142857131*G0_1_1_17_1_1 + 0.867857142857146*G0_1_1_18_1_0 + 0.54241071428572*G0_1_1_18_1_1 + 0.650892857142855*G0_1_1_19_1_0;
    A[319] = A[186] + 1.37410714285717*G0_0_0_0_0_0 + 1.37410714285717*G0_0_0_0_0_1 - 0.0723214285714365*G0_0_0_1_0_0 - 0.0723214285714346*G0_0_0_2_0_1 - 1.95267857142861*G0_0_0_3_0_0 - 1.95267857142862*G0_0_0_4_0_0 - 3.90535714285722*G0_0_0_4_0_1 + 1.95267857142858*G0_0_0_5_0_0 - 0.650892857142884*G0_0_0_5_0_1 + 1.95267857142862*G0_0_0_6_0_0 - 0.650892857142852*G0_0_0_6_0_1 - 2.60357142857149*G0_0_0_7_0_0 + 1.30178571428576*G0_0_0_8_0_0 + 3.90535714285725*G0_0_0_9_0_1 + 1.37410714285717*G0_0_0_10_1_0 + 1.37410714285717*G0_0_0_10_1_1 - 0.0723214285714365*G0_0_0_11_1_0 - 0.0723214285714346*G0_0_0_12_1_1 - 1.95267857142861*G0_0_0_13_1_0 - 1.95267857142862*G0_0_0_14_1_0 - 3.90535714285722*G0_0_0_14_1_1 + 1.95267857142858*G0_0_0_15_1_0 - 0.650892857142884*G0_0_0_15_1_1 + 1.95267857142862*G0_0_0_16_1_0 - 0.650892857142852*G0_0_0_16_1_1 - 2.60357142857149*G0_0_0_17_1_0 + 1.30178571428576*G0_0_0_18_1_0 + 3.90535714285725*G0_0_0_19_1_1 + 0.831696428571448*G0_0_1_0_0_0 + 0.831696428571448*G0_0_1_0_0_1 - 0.0723214285714365*G0_0_1_1_0_0 - 0.614732142857156*G0_0_1_2_0_1 - 1.08482142857146*G0_0_1_3_0_0 - 2.71205357142863*G0_0_1_4_0_0 - 3.25446428571436*G0_0_1_4_0_1 + 1.73571428571428*G0_0_1_5_0_0 - 0.108482142857164*G0_0_1_5_0_1 + 2.71205357142863*G0_0_1_6_0_0 - 0.108482142857129*G0_0_1_6_0_1 - 1.19330357142862*G0_0_1_7_0_0 + 0.650892857142826*G0_0_1_7_0_1 + 0.433928571428608*G0_0_1_8_0_0 - 0.650892857142818*G0_0_1_9_0_0 + 2.60357142857154*G0_0_1_9_0_1 + 0.831696428571448*G0_0_1_10_1_0 + 0.831696428571448*G0_0_1_10_1_1 - 0.0723214285714365*G0_0_1_11_1_0 - 0.614732142857156*G0_0_1_12_1_1 - 1.08482142857146*G0_0_1_13_1_0 - 2.71205357142863*G0_0_1_14_1_0 - 3.25446428571436*G0_0_1_14_1_1 + 1.73571428571428*G0_0_1_15_1_0 - 0.108482142857164*G0_0_1_15_1_1 + 2.71205357142863*G0_0_1_16_1_0 - 0.108482142857129*G0_0_1_16_1_1 - 1.19330357142862*G0_0_1_17_1_0 + 0.650892857142826*G0_0_1_17_1_1 + 0.433928571428608*G0_0_1_18_1_0 - 0.650892857142818*G0_0_1_19_1_0 + 2.60357142857154*G0_0_1_19_1_1 - 0.0361607142856999*G0_1_0_0_0_0 - 0.0361607142856998*G0_1_0_0_0_1 - 0.0723214285714374*G0_1_0_1_0_0 - 1.48258928571431*G0_1_0_2_0_1 - 0.867857142857172*G0_1_0_3_0_0 - 5.09866071428578*G0_1_0_4_0_0 - 4.55625000000007*G0_1_0_4_0_1 + 0.216964285714276*G0_1_0_5_0_0 + 0.759374999999983*G0_1_0_5_0_1 + 5.09866071428578*G0_1_0_6_0_0 + 0.759375000000022*G0_1_0_6_0_1 - 0.108482142857179*G0_1_0_7_0_0 - 0.650892857142888*G0_1_0_7_0_1 + 0.216964285714318*G0_1_0_8_0_0 + 0.650892857142896*G0_1_0_9_0_0 + 5.20714285714296*G0_1_0_9_0_1 - 0.0361607142856999*G0_1_0_10_1_0 - 0.0361607142856998*G0_1_0_10_1_1 - 0.0723214285714374*G0_1_0_11_1_0 - 1.48258928571431*G0_1_0_12_1_1 - 0.867857142857172*G0_1_0_13_1_0 - 5.09866071428578*G0_1_0_14_1_0 - 4.55625000000007*G0_1_0_14_1_1 + 0.216964285714276*G0_1_0_15_1_0 + 0.759374999999983*G0_1_0_15_1_1 + 5.09866071428578*G0_1_0_16_1_0 + 0.759375000000022*G0_1_0_16_1_1 - 0.108482142857179*G0_1_0_17_1_0 - 0.650892857142888*G0_1_0_17_1_1 + 0.216964285714318*G0_1_0_18_1_0 + 0.650892857142896*G0_1_0_19_1_0 + 5.20714285714296*G0_1_0_19_1_1 - 0.650892857142859*G0_1_1_0_0_0 - 0.650892857142859*G0_1_1_0_0_1 - 0.650892857142859*G0_1_1_2_0_1 - 1.30178571428577*G0_1_1_3_0_0 - 3.25446428571435*G0_1_1_4_0_0 - 3.90535714285726*G0_1_1_4_0_1 - 2.60357142857149*G0_1_1_5_0_0 + 0.650892857142859*G0_1_1_5_0_1 + 3.25446428571434*G0_1_1_6_0_0 + 0.650892857142858*G0_1_1_6_0_1 - 0.65089285714291*G0_1_1_7_0_0 - 3.90535714285725*G0_1_1_7_0_1 + 1.30178571428577*G0_1_1_8_0_0 + 3.90535714285725*G0_1_1_9_0_0 + 7.81071428571451*G0_1_1_9_0_1 - 0.650892857142859*G0_1_1_10_1_0 - 0.650892857142859*G0_1_1_10_1_1 - 0.650892857142859*G0_1_1_12_1_1 - 1.30178571428577*G0_1_1_13_1_0 - 3.25446428571435*G0_1_1_14_1_0 - 3.90535714285726*G0_1_1_14_1_1 - 2.60357142857149*G0_1_1_15_1_0 + 0.650892857142859*G0_1_1_15_1_1 + 3.25446428571434*G0_1_1_16_1_0 + 0.650892857142858*G0_1_1_16_1_1 - 0.65089285714291*G0_1_1_17_1_0 - 3.90535714285725*G0_1_1_17_1_1 + 1.30178571428577*G0_1_1_18_1_0 + 3.90535714285725*G0_1_1_19_1_0 + 7.81071428571451*G0_1_1_19_1_1;
    A[395] = A[319] - 1.08482142857143*G0_0_1_0_0_0 - 1.08482142857143*G0_0_1_0_0_1 - 0.325446428571438*G0_0_1_1_0_0 + 0.216964285714286*G0_0_1_2_0_1 + 1.41026785714288*G0_0_1_3_0_0 + 0.325446428571429*G0_0_1_3_0_1 - 0.867857142857159*G0_0_1_4_0_0 - 0.325446428571431*G0_0_1_4_0_1 + 1.84419642857147*G0_0_1_5_0_0 + 3.36294642857147*G0_0_1_5_0_1 + 0.867857142857159*G0_0_1_6_0_0 - 2.49508928571432*G0_0_1_6_0_1 + 0.54241071428571*G0_0_1_7_0_0 - 0.976339285714285*G0_0_1_7_0_1 + 0.867857142857162*G0_0_1_8_0_0 - 0.32544642857143*G0_0_1_8_0_1 - 3.25446428571435*G0_0_1_9_0_0 + 1.30178571428572*G0_0_1_9_0_1 - 1.08482142857143*G0_0_1_10_1_0 - 1.08482142857143*G0_0_1_10_1_1 - 0.325446428571438*G0_0_1_11_1_0 + 0.216964285714286*G0_0_1_12_1_1 + 1.41026785714288*G0_0_1_13_1_0 + 0.325446428571429*G0_0_1_13_1_1 - 0.867857142857159*G0_0_1_14_1_0 - 0.325446428571431*G0_0_1_14_1_1 + 1.84419642857147*G0_0_1_15_1_0 + 3.36294642857147*G0_0_1_15_1_1 + 0.867857142857159*G0_0_1_16_1_0 - 2.49508928571432*G0_0_1_16_1_1 + 0.54241071428571*G0_0_1_17_1_0 - 0.976339285714285*G0_0_1_17_1_1 + 0.867857142857162*G0_0_1_18_1_0 - 0.32544642857143*G0_0_1_18_1_1 - 3.25446428571435*G0_0_1_19_1_0 + 1.30178571428572*G0_0_1_19_1_1 + 1.08482142857143*G0_1_0_0_0_0 + 1.08482142857143*G0_1_0_0_0_1 + 0.325446428571438*G0_1_0_1_0_0 - 0.216964285714286*G0_1_0_2_0_1 - 1.41026785714288*G0_1_0_3_0_0 - 0.325446428571429*G0_1_0_3_0_1 + 0.867857142857159*G0_1_0_4_0_0 + 0.325446428571431*G0_1_0_4_0_1 - 1.84419642857147*G0_1_0_5_0_0 - 3.36294642857147*G0_1_0_5_0_1 - 0.867857142857159*G0_1_0_6_0_0 + 2.49508928571432*G0_1_0_6_0_1 - 0.54241071428571*G0_1_0_7_0_0 + 0.976339285714285*G0_1_0_7_0_1 - 0.867857142857162*G0_1_0_8_0_0 + 0.32544642857143*G0_1_0_8_0_1 + 3.25446428571436*G0_1_0_9_0_0 - 1.30178571428572*G0_1_0_9_0_1 + 1.08482142857143*G0_1_0_10_1_0 + 1.08482142857143*G0_1_0_10_1_1 + 0.325446428571438*G0_1_0_11_1_0 - 0.216964285714286*G0_1_0_12_1_1 - 1.41026785714288*G0_1_0_13_1_0 - 0.325446428571429*G0_1_0_13_1_1 + 0.867857142857159*G0_1_0_14_1_0 + 0.325446428571431*G0_1_0_14_1_1 - 1.84419642857147*G0_1_0_15_1_0 - 3.36294642857147*G0_1_0_15_1_1 - 0.867857142857159*G0_1_0_16_1_0 + 2.49508928571432*G0_1_0_16_1_1 - 0.54241071428571*G0_1_0_17_1_0 + 0.976339285714285*G0_1_0_17_1_1 - 0.867857142857162*G0_1_0_18_1_0 + 0.32544642857143*G0_1_0_18_1_1 + 3.25446428571436*G0_1_0_19_1_0 - 1.30178571428572*G0_1_0_19_1_1;
    A[169] = A[379];
    A[184] = -A[186] + 0.542410714285724*G0_0_1_0_0_0 + 0.542410714285725*G0_0_1_0_0_1 + 0.54241071428572*G0_0_1_1_0_0 - 4.55625000000006*G0_0_1_3_0_0 - 1.19330357142859*G0_0_1_3_0_1 - 2.82053571428575*G0_0_1_4_0_1 - 4.55625000000007*G0_0_1_5_0_0 - 3.36294642857148*G0_0_1_5_0_1 + 2.82053571428576*G0_0_1_6_0_1 - 0.542410714285726*G0_0_1_7_0_0 - 1.73571428571431*G0_0_1_7_0_1 - 0.542410714285718*G0_0_1_8_0_0 + 1.19330357142859*G0_0_1_8_0_1 + 9.11250000000014*G0_0_1_9_0_0 + 4.55625000000006*G0_0_1_9_0_1 + 0.542410714285724*G0_0_1_10_1_0 + 0.542410714285725*G0_0_1_10_1_1 + 0.54241071428572*G0_0_1_11_1_0 - 4.55625000000006*G0_0_1_13_1_0 - 1.19330357142859*G0_0_1_13_1_1 - 2.82053571428575*G0_0_1_14_1_1 - 4.55625000000007*G0_0_1_15_1_0 - 3.36294642857148*G0_0_1_15_1_1 + 2.82053571428576*G0_0_1_16_1_1 - 0.542410714285726*G0_0_1_17_1_0 - 1.73571428571431*G0_0_1_17_1_1 - 0.542410714285718*G0_0_1_18_1_0 + 1.19330357142859*G0_0_1_18_1_1 + 9.11250000000014*G0_0_1_19_1_0 + 4.55625000000006*G0_0_1_19_1_1 + 0.723214285714305*G0_1_1_0_0_0 + 0.723214285714306*G0_1_1_0_0_1 - 0.180803571428582*G0_1_1_1_0_0 - 0.289285714285729*G0_1_1_2_0_1 - 4.01383928571433*G0_1_1_3_0_0 - 2.49508928571434*G0_1_1_3_0_1 - 0.433928571428568*G0_1_1_4_0_0 - 1.84419642857141*G0_1_1_4_0_1 - 0.54241071428573*G0_1_1_5_0_0 - 1.84419642857149*G0_1_1_5_0_1 + 0.433928571428568*G0_1_1_6_0_0 + 1.41026785714291*G0_1_1_6_0_1 + 0.542410714285732*G0_1_1_7_0_0 + 1.84419642857149*G0_1_1_7_0_1 - 1.08482142857146*G0_1_1_8_0_0 + 2.49508928571434*G0_1_1_8_0_1 + 4.55625000000006*G0_1_1_9_0_0 + 0.723214285714305*G0_1_1_10_1_0 + 0.723214285714306*G0_1_1_10_1_1 - 0.180803571428582*G0_1_1_11_1_0 - 0.289285714285729*G0_1_1_12_1_1 - 4.01383928571433*G0_1_1_13_1_0 - 2.49508928571434*G0_1_1_13_1_1 - 0.433928571428568*G0_1_1_14_1_0 - 1.84419642857141*G0_1_1_14_1_1 - 0.54241071428573*G0_1_1_15_1_0 - 1.84419642857149*G0_1_1_15_1_1 + 0.433928571428568*G0_1_1_16_1_0 + 1.41026785714291*G0_1_1_16_1_1 + 0.542410714285732*G0_1_1_17_1_0 + 1.84419642857149*G0_1_1_17_1_1 - 1.08482142857146*G0_1_1_18_1_0 + 2.49508928571434*G0_1_1_18_1_1 + 4.55625000000006*G0_1_1_19_1_0;
    A[299] = A[184] - 0.325446428571438*G0_0_1_0_0_0 - 0.325446428571438*G0_0_1_0_0_1 - 0.216964285714284*G0_0_1_1_0_0 - 1.08482142857143*G0_0_1_2_0_1 + 3.36294642857147*G0_0_1_3_0_0 + 0.867857142857159*G0_0_1_3_0_1 - 1.51874999999999*G0_0_1_4_0_0 + 1.84419642857147*G0_0_1_4_0_1 + 1.19330357142859*G0_0_1_5_0_0 + 0.867857142857159*G0_0_1_5_0_1 + 1.51875*G0_0_1_6_0_0 + 0.542410714285713*G0_0_1_6_0_1 + 1.08482142857146*G0_0_1_7_0_0 + 1.41026785714288*G0_0_1_7_0_1 - 0.542410714285734*G0_0_1_8_0_0 - 0.867857142857159*G0_0_1_8_0_1 - 4.55625000000007*G0_0_1_9_0_0 - 3.25446428571435*G0_0_1_9_0_1 - 0.325446428571438*G0_0_1_10_1_0 - 0.325446428571438*G0_0_1_10_1_1 - 0.216964285714284*G0_0_1_11_1_0 - 1.08482142857143*G0_0_1_12_1_1 + 3.36294642857147*G0_0_1_13_1_0 + 0.867857142857159*G0_0_1_13_1_1 - 1.51874999999999*G0_0_1_14_1_0 + 1.84419642857147*G0_0_1_14_1_1 + 1.19330357142859*G0_0_1_15_1_0 + 0.867857142857159*G0_0_1_15_1_1 + 1.51875*G0_0_1_16_1_0 + 0.542410714285713*G0_0_1_16_1_1 + 1.08482142857146*G0_0_1_17_1_0 + 1.41026785714288*G0_0_1_17_1_1 - 0.542410714285734*G0_0_1_18_1_0 - 0.867857142857159*G0_0_1_18_1_1 - 4.55625000000007*G0_0_1_19_1_0 - 3.25446428571435*G0_0_1_19_1_1 + 0.325446428571438*G0_1_0_0_0_0 + 0.325446428571438*G0_1_0_0_0_1 + 0.216964285714283*G0_1_0_1_0_0 + 1.08482142857143*G0_1_0_2_0_1 - 3.36294642857147*G0_1_0_3_0_0 - 0.867857142857158*G0_1_0_3_0_1 + 1.51874999999999*G0_1_0_4_0_0 - 1.84419642857147*G0_1_0_4_0_1 - 1.19330357142859*G0_1_0_5_0_0 - 0.867857142857159*G0_1_0_5_0_1 - 1.51875*G0_1_0_6_0_0 - 0.542410714285713*G0_1_0_6_0_1 - 1.08482142857146*G0_1_0_7_0_0 - 1.41026785714288*G0_1_0_7_0_1 + 0.542410714285734*G0_1_0_8_0_0 + 0.867857142857159*G0_1_0_8_0_1 + 4.55625000000007*G0_1_0_9_0_0 + 3.25446428571435*G0_1_0_9_0_1 + 0.325446428571438*G0_1_0_10_1_0 + 0.325446428571438*G0_1_0_10_1_1 + 0.216964285714283*G0_1_0_11_1_0 + 1.08482142857143*G0_1_0_12_1_1 - 3.36294642857147*G0_1_0_13_1_0 - 0.867857142857158*G0_1_0_13_1_1 + 1.51874999999999*G0_1_0_14_1_0 - 1.84419642857147*G0_1_0_14_1_1 - 1.19330357142859*G0_1_0_15_1_0 - 0.867857142857159*G0_1_0_15_1_1 - 1.51875*G0_1_0_16_1_0 - 0.542410714285713*G0_1_0_16_1_1 - 1.08482142857146*G0_1_0_17_1_0 - 1.41026785714288*G0_1_0_17_1_1 + 0.542410714285734*G0_1_0_18_1_0 + 0.867857142857159*G0_1_0_18_1_1 + 4.55625000000007*G0_1_0_19_1_0 + 3.25446428571435*G0_1_0_19_1_1;
    A[206] = 0.0;
    A[16] = 0.0;
    A[280] = 0.0;
    A[256] = A[122] - 0.266517857142862*G0_0_1_0_0_0 - 0.266517857142862*G0_0_1_0_0_1 + 0.266517857142862*G0_0_1_1_0_0 + 2.02633928571431*G0_0_1_2_0_1 - 1.3138392857143*G0_0_1_3_0_0 - 0.16875*G0_0_1_3_0_1 + 3.96562500000004*G0_0_1_4_0_0 + 1.06071428571429*G0_0_1_4_0_1 + 1.3138392857143*G0_0_1_5_0_0 + 1.1450892857143*G0_0_1_5_0_1 - 3.96562500000004*G0_0_1_6_0_0 - 2.90491071428575*G0_0_1_6_0_1 + 0.168750000000004*G0_0_1_7_0_1 + 0.16875*G0_0_1_8_0_1 - 1.2294642857143*G0_0_1_9_0_1 - 0.266517857142862*G0_0_1_10_1_0 - 0.266517857142862*G0_0_1_10_1_1 + 0.266517857142862*G0_0_1_11_1_0 + 2.02633928571431*G0_0_1_12_1_1 - 1.3138392857143*G0_0_1_13_1_0 - 0.16875*G0_0_1_13_1_1 + 3.96562500000004*G0_0_1_14_1_0 + 1.06071428571429*G0_0_1_14_1_1 + 1.3138392857143*G0_0_1_15_1_0 + 1.1450892857143*G0_0_1_15_1_1 - 3.96562500000004*G0_0_1_16_1_0 - 2.90491071428575*G0_0_1_16_1_1 + 0.168750000000004*G0_0_1_17_1_1 + 0.16875*G0_0_1_18_1_1 - 1.2294642857143*G0_0_1_19_1_1 + 0.266517857142862*G0_1_0_0_0_0 + 0.266517857142862*G0_1_0_0_0_1 - 0.266517857142862*G0_1_0_1_0_0 - 2.02633928571431*G0_1_0_2_0_1 + 1.3138392857143*G0_1_0_3_0_0 + 0.16875*G0_1_0_3_0_1 - 3.96562500000004*G0_1_0_4_0_0 - 1.06071428571429*G0_1_0_4_0_1 - 1.3138392857143*G0_1_0_5_0_0 - 1.1450892857143*G0_1_0_5_0_1 + 3.96562500000004*G0_1_0_6_0_0 + 2.90491071428575*G0_1_0_6_0_1 - 0.168750000000004*G0_1_0_7_0_1 - 0.16875*G0_1_0_8_0_1 + 1.2294642857143*G0_1_0_9_0_1 + 0.266517857142862*G0_1_0_10_1_0 + 0.266517857142862*G0_1_0_10_1_1 - 0.266517857142862*G0_1_0_11_1_0 - 2.02633928571431*G0_1_0_12_1_1 + 1.3138392857143*G0_1_0_13_1_0 + 0.16875*G0_1_0_13_1_1 - 3.96562500000004*G0_1_0_14_1_0 - 1.06071428571429*G0_1_0_14_1_1 - 1.3138392857143*G0_1_0_15_1_0 - 1.1450892857143*G0_1_0_15_1_1 + 3.96562500000004*G0_1_0_16_1_0 + 2.90491071428575*G0_1_0_16_1_1 - 0.168750000000004*G0_1_0_17_1_1 - 0.16875*G0_1_0_18_1_1 + 1.2294642857143*G0_1_0_19_1_1;
    A[305] = 0.0;
    A[390] = A[180];
    A[171] = 0.0;
    A[190] = 0.0;
    A[201] = 0.0;
    A[177] = 0.0;
    A[232] = -0.00781249999999977*G0_0_1_0_0_0 - 0.00781249999999973*G0_0_1_0_0_1 + 0.182589285714288*G0_0_1_1_0_0 + 0.182589285714289*G0_0_1_2_0_1 - 0.149330357142861*G0_0_1_3_0_0 + 0.26651785714286*G0_0_1_3_0_1 + 0.266517857142861*G0_0_1_4_0_0 - 0.14933035714286*G0_0_1_4_0_1 + 0.040848214285715*G0_0_1_5_0_0 + 0.0120535714285713*G0_0_1_5_0_1 - 0.266517857142862*G0_0_1_6_0_0 - 0.18683035714286*G0_0_1_6_0_1 + 0.0120535714285706*G0_0_1_7_0_0 + 0.0408482142857145*G0_0_1_7_0_1 - 0.186830357142859*G0_0_1_8_0_0 - 0.26651785714286*G0_0_1_8_0_1 + 0.108482142857146*G0_0_1_9_0_0 + 0.108482142857145*G0_0_1_9_0_1 - 0.00781249999999977*G0_0_1_10_1_0 - 0.00781249999999973*G0_0_1_10_1_1 + 0.182589285714288*G0_0_1_11_1_0 + 0.182589285714289*G0_0_1_12_1_1 - 0.149330357142861*G0_0_1_13_1_0 + 0.26651785714286*G0_0_1_13_1_1 + 0.266517857142861*G0_0_1_14_1_0 - 0.14933035714286*G0_0_1_14_1_1 + 0.040848214285715*G0_0_1_15_1_0 + 0.0120535714285713*G0_0_1_15_1_1 - 0.266517857142862*G0_0_1_16_1_0 - 0.18683035714286*G0_0_1_16_1_1 + 0.0120535714285706*G0_0_1_17_1_0 + 0.0408482142857145*G0_0_1_17_1_1 - 0.186830357142859*G0_0_1_18_1_0 - 0.26651785714286*G0_0_1_18_1_1 + 0.108482142857146*G0_0_1_19_1_0 + 0.108482142857145*G0_0_1_19_1_1;
    A[20] = -A[232] + 0.182589285714288*G0_0_0_0_0_0 + 0.182589285714288*G0_0_0_0_0_1 - 0.182589285714288*G0_0_0_1_0_0 - 0.00781249999999974*G0_0_0_2_0_1 - 0.0796875000000009*G0_0_0_3_0_0 - 0.266517857142861*G0_0_0_3_0_1 + 0.0287946428571436*G0_0_0_4_0_0 + 0.0408482142857147*G0_0_0_4_0_1 + 0.0796875000000008*G0_0_0_5_0_0 - 0.186830357142859*G0_0_0_5_0_1 - 0.0287946428571436*G0_0_0_6_0_0 + 0.012053571428571*G0_0_0_6_0_1 - 0.41584821428572*G0_0_0_7_0_0 - 0.14933035714286*G0_0_0_7_0_1 + 0.41584821428572*G0_0_0_8_0_0 + 0.266517857142861*G0_0_0_8_0_1 + 0.108482142857145*G0_0_0_9_0_1 + 0.182589285714288*G0_0_0_10_1_0 + 0.182589285714288*G0_0_0_10_1_1 - 0.182589285714288*G0_0_0_11_1_0 - 0.00781249999999974*G0_0_0_12_1_1 - 0.0796875000000009*G0_0_0_13_1_0 - 0.266517857142861*G0_0_0_13_1_1 + 0.0287946428571436*G0_0_0_14_1_0 + 0.0408482142857147*G0_0_0_14_1_1 + 0.0796875000000008*G0_0_0_15_1_0 - 0.186830357142859*G0_0_0_15_1_1 - 0.0287946428571436*G0_0_0_16_1_0 + 0.012053571428571*G0_0_0_16_1_1 - 0.41584821428572*G0_0_0_17_1_0 - 0.14933035714286*G0_0_0_17_1_1 + 0.41584821428572*G0_0_0_18_1_0 + 0.266517857142861*G0_0_0_18_1_1 + 0.108482142857145*G0_0_0_19_1_1 + 0.174776785714288*G0_0_1_0_0_0 + 0.174776785714288*G0_0_1_0_0_1 + 0.174776785714289*G0_0_1_2_0_1 - 0.229017857142862*G0_0_1_3_0_0 + 0.295312500000005*G0_0_1_4_0_0 - 0.108482142857145*G0_0_1_4_0_1 + 0.120535714285716*G0_0_1_5_0_0 - 0.174776785714288*G0_0_1_5_0_1 - 0.295312500000005*G0_0_1_6_0_0 - 0.174776785714289*G0_0_1_6_0_1 - 0.403794642857149*G0_0_1_7_0_0 - 0.108482142857146*G0_0_1_7_0_1 + 0.229017857142861*G0_0_1_8_0_0 + 0.108482142857146*G0_0_1_9_0_0 + 0.216964285714291*G0_0_1_9_0_1 + 0.174776785714288*G0_0_1_10_1_0 + 0.174776785714288*G0_0_1_10_1_1 + 0.174776785714289*G0_0_1_12_1_1 - 0.229017857142862*G0_0_1_13_1_0 + 0.295312500000005*G0_0_1_14_1_0 - 0.108482142857145*G0_0_1_14_1_1 + 0.120535714285716*G0_0_1_15_1_0 - 0.174776785714288*G0_0_1_15_1_1 - 0.295312500000005*G0_0_1_16_1_0 - 0.174776785714289*G0_0_1_16_1_1 - 0.403794642857149*G0_0_1_17_1_0 - 0.108482142857146*G0_0_1_17_1_1 + 0.229017857142861*G0_0_1_18_1_0 + 0.108482142857146*G0_0_1_19_1_0 + 0.216964285714291*G0_0_1_19_1_1;
    A[212] = -A[232] + 0.174776785714288*G0_0_1_0_0_0 + 0.174776785714288*G0_0_1_0_0_1 + 0.174776785714288*G0_0_1_1_0_0 - 0.108482142857146*G0_0_1_3_0_0 + 0.295312500000003*G0_0_1_3_0_1 - 0.229017857142861*G0_0_1_4_0_1 - 0.108482142857146*G0_0_1_5_0_0 - 0.403794642857149*G0_0_1_5_0_1 + 0.229017857142861*G0_0_1_6_0_1 - 0.174776785714288*G0_0_1_7_0_0 + 0.120535714285715*G0_0_1_7_0_1 - 0.174776785714288*G0_0_1_8_0_0 - 0.295312500000003*G0_0_1_8_0_1 + 0.216964285714291*G0_0_1_9_0_0 + 0.108482142857146*G0_0_1_9_0_1 + 0.174776785714288*G0_0_1_10_1_0 + 0.174776785714288*G0_0_1_10_1_1 + 0.174776785714288*G0_0_1_11_1_0 - 0.108482142857146*G0_0_1_13_1_0 + 0.295312500000003*G0_0_1_13_1_1 - 0.229017857142861*G0_0_1_14_1_1 - 0.108482142857146*G0_0_1_15_1_0 - 0.403794642857149*G0_0_1_15_1_1 + 0.229017857142861*G0_0_1_16_1_1 - 0.174776785714288*G0_0_1_17_1_0 + 0.120535714285715*G0_0_1_17_1_1 - 0.174776785714288*G0_0_1_18_1_0 - 0.295312500000003*G0_0_1_18_1_1 + 0.216964285714291*G0_0_1_19_1_0 + 0.108482142857146*G0_0_1_19_1_1 + 0.182589285714288*G0_1_1_0_0_0 + 0.182589285714288*G0_1_1_0_0_1 - 0.00781249999999974*G0_1_1_1_0_0 - 0.182589285714289*G0_1_1_2_0_1 + 0.0408482142857151*G0_1_1_3_0_0 + 0.0287946428571437*G0_1_1_3_0_1 - 0.266517857142862*G0_1_1_4_0_0 - 0.0796875000000014*G0_1_1_4_0_1 - 0.149330357142861*G0_1_1_5_0_0 - 0.415848214285721*G0_1_1_5_0_1 + 0.266517857142862*G0_1_1_6_0_0 + 0.415848214285722*G0_1_1_6_0_1 - 0.186830357142859*G0_1_1_7_0_0 + 0.079687500000001*G0_1_1_7_0_1 + 0.0120535714285707*G0_1_1_8_0_0 - 0.0287946428571436*G0_1_1_8_0_1 + 0.108482142857146*G0_1_1_9_0_0 + 0.182589285714288*G0_1_1_10_1_0 + 0.182589285714288*G0_1_1_10_1_1 - 0.00781249999999974*G0_1_1_11_1_0 - 0.182589285714289*G0_1_1_12_1_1 + 0.0408482142857151*G0_1_1_13_1_0 + 0.0287946428571437*G0_1_1_13_1_1 - 0.266517857142862*G0_1_1_14_1_0 - 0.0796875000000014*G0_1_1_14_1_1 - 0.149330357142861*G0_1_1_15_1_0 - 0.415848214285721*G0_1_1_15_1_1 + 0.266517857142862*G0_1_1_16_1_0 + 0.415848214285722*G0_1_1_16_1_1 - 0.186830357142859*G0_1_1_17_1_0 + 0.079687500000001*G0_1_1_17_1_1 + 0.0120535714285707*G0_1_1_18_1_0 - 0.0287946428571436*G0_1_1_18_1_1 + 0.108482142857146*G0_1_1_19_1_0;
    A[230] = A[20];
    A[2] = A[212];
    A[291] = A[81];
    A[255] = A[45];
    A[302] = 0.0;
    A[13] = 0.0;
    A[28] = -A[23] + 0.336160714285719*G0_0_0_0_0_0 + 0.336160714285719*G0_0_0_0_0_1 - 1.1075892857143*G0_0_0_1_0_0 - 0.33616071428572*G0_0_0_2_0_1 - 0.15669642857142*G0_0_0_3_0_0 - 1.84419642857144*G0_0_0_3_0_1 - 0.445982142857151*G0_0_0_4_0_0 + 0.470089285714293*G0_0_0_4_0_1 + 0.445982142857152*G0_0_0_5_0_0 + 0.445982142857151*G0_0_0_6_0_0 - 0.916071428571443*G0_0_0_7_0_0 - 0.470089285714292*G0_0_0_7_0_1 + 1.68750000000002*G0_0_0_8_0_0 + 1.84419642857145*G0_0_0_8_0_1 - 0.289285714285732*G0_0_0_9_0_0 + 0.336160714285719*G0_0_0_10_1_0 + 0.336160714285719*G0_0_0_10_1_1 - 1.1075892857143*G0_0_0_11_1_0 - 0.33616071428572*G0_0_0_12_1_1 - 0.15669642857142*G0_0_0_13_1_0 - 1.84419642857144*G0_0_0_13_1_1 - 0.445982142857151*G0_0_0_14_1_0 + 0.470089285714293*G0_0_0_14_1_1 + 0.445982142857152*G0_0_0_15_1_0 + 0.445982142857151*G0_0_0_16_1_0 - 0.916071428571443*G0_0_0_17_1_0 - 0.470089285714292*G0_0_0_17_1_1 + 1.68750000000002*G0_0_0_18_1_0 + 1.84419642857145*G0_0_0_18_1_1 - 0.289285714285732*G0_0_0_19_1_0;
    A[55] = 0.0;
    A[102] = A[62] - 0.190178571428576*G0_0_1_0_0_0 - 0.190178571428576*G0_0_1_0_0_1 + 0.190178571428576*G0_0_1_1_0_0 + 1.29910714285716*G0_0_1_2_0_1 - 0.699107142857156*G0_0_1_3_0_0 - 0.0241071428571423*G0_0_1_3_0_1 + 2.6276785714286*G0_0_1_4_0_0 + 0.843750000000005*G0_0_1_4_0_1 + 0.699107142857156*G0_0_1_5_0_0 + 0.675000000000013*G0_0_1_5_0_1 - 2.6276785714286*G0_0_1_6_0_0 - 1.7839285714286*G0_0_1_6_0_1 + 0.0241071428571475*G0_0_1_7_0_1 + 0.0241071428571424*G0_0_1_8_0_1 - 0.867857142857152*G0_0_1_9_0_1 - 0.190178571428576*G0_0_1_10_1_0 - 0.190178571428576*G0_0_1_10_1_1 + 0.190178571428576*G0_0_1_11_1_0 + 1.29910714285716*G0_0_1_12_1_1 - 0.699107142857156*G0_0_1_13_1_0 - 0.0241071428571423*G0_0_1_13_1_1 + 2.6276785714286*G0_0_1_14_1_0 + 0.843750000000005*G0_0_1_14_1_1 + 0.699107142857156*G0_0_1_15_1_0 + 0.675000000000013*G0_0_1_15_1_1 - 2.6276785714286*G0_0_1_16_1_0 - 1.7839285714286*G0_0_1_16_1_1 + 0.0241071428571475*G0_0_1_17_1_1 + 0.0241071428571424*G0_0_1_18_1_1 - 0.867857142857152*G0_0_1_19_1_1 - 0.444642857142864*G0_1_1_0_0_0 - 0.444642857142864*G0_1_1_0_0_1 - 0.254464285714288*G0_1_1_1_0_0 + 0.64955357142858*G0_1_1_2_0_1 - 0.132589285714287*G0_1_1_3_0_0 - 0.602678571428578*G0_1_1_3_0_1 + 1.3138392857143*G0_1_1_4_0_0 + 0.879910714285725*G0_1_1_4_0_1 + 0.566517857142869*G0_1_1_5_0_0 + 1.1450892857143*G0_1_1_5_0_1 - 1.3138392857143*G0_1_1_6_0_0 - 1.35000000000002*G0_1_1_6_0_1 + 0.349553571428579*G0_1_1_7_0_0 - 0.229017857142857*G0_1_1_7_0_1 + 0.349553571428573*G0_1_1_8_0_0 + 0.602678571428578*G0_1_1_8_0_1 - 0.433928571428582*G0_1_1_9_0_0 - 0.650892857142868*G0_1_1_9_0_1 - 0.444642857142864*G0_1_1_10_1_0 - 0.444642857142864*G0_1_1_10_1_1 - 0.254464285714288*G0_1_1_11_1_0 + 0.64955357142858*G0_1_1_12_1_1 - 0.132589285714287*G0_1_1_13_1_0 - 0.602678571428578*G0_1_1_13_1_1 + 1.3138392857143*G0_1_1_14_1_0 + 0.879910714285725*G0_1_1_14_1_1 + 0.566517857142869*G0_1_1_15_1_0 + 1.1450892857143*G0_1_1_15_1_1 - 1.3138392857143*G0_1_1_16_1_0 - 1.35000000000002*G0_1_1_16_1_1 + 0.349553571428579*G0_1_1_17_1_0 - 0.229017857142857*G0_1_1_17_1_1 + 0.349553571428573*G0_1_1_18_1_0 + 0.602678571428578*G0_1_1_18_1_1 - 0.433928571428582*G0_1_1_19_1_0 - 0.650892857142868*G0_1_1_19_1_1;
    A[326] = 0.0;
    A[129] = -A[299] + 0.542410714285724*G0_1_0_0_0_0 + 0.542410714285725*G0_1_0_0_0_1 + 0.54241071428572*G0_1_0_1_0_0 - 4.55625000000006*G0_1_0_3_0_0 - 1.19330357142859*G0_1_0_3_0_1 - 2.82053571428575*G0_1_0_4_0_1 - 4.55625000000007*G0_1_0_5_0_0 - 3.36294642857148*G0_1_0_5_0_1 + 2.82053571428576*G0_1_0_6_0_1 - 0.542410714285726*G0_1_0_7_0_0 - 1.73571428571431*G0_1_0_7_0_1 - 0.542410714285718*G0_1_0_8_0_0 + 1.19330357142859*G0_1_0_8_0_1 + 9.11250000000014*G0_1_0_9_0_0 + 4.55625000000006*G0_1_0_9_0_1 + 0.542410714285724*G0_1_0_10_1_0 + 0.542410714285725*G0_1_0_10_1_1 + 0.54241071428572*G0_1_0_11_1_0 - 4.55625000000006*G0_1_0_13_1_0 - 1.19330357142859*G0_1_0_13_1_1 - 2.82053571428575*G0_1_0_14_1_1 - 4.55625000000007*G0_1_0_15_1_0 - 3.36294642857148*G0_1_0_15_1_1 + 2.82053571428576*G0_1_0_16_1_1 - 0.542410714285726*G0_1_0_17_1_0 - 1.73571428571431*G0_1_0_17_1_1 - 0.542410714285718*G0_1_0_18_1_0 + 1.19330357142859*G0_1_0_18_1_1 + 9.11250000000014*G0_1_0_19_1_0 + 4.55625000000006*G0_1_0_19_1_1 + 0.723214285714305*G0_1_1_0_0_0 + 0.723214285714306*G0_1_1_0_0_1 - 0.180803571428582*G0_1_1_1_0_0 - 0.289285714285729*G0_1_1_2_0_1 - 4.01383928571433*G0_1_1_3_0_0 - 2.49508928571434*G0_1_1_3_0_1 - 0.433928571428568*G0_1_1_4_0_0 - 1.84419642857141*G0_1_1_4_0_1 - 0.54241071428573*G0_1_1_5_0_0 - 1.84419642857149*G0_1_1_5_0_1 + 0.433928571428568*G0_1_1_6_0_0 + 1.41026785714291*G0_1_1_6_0_1 + 0.542410714285732*G0_1_1_7_0_0 + 1.84419642857149*G0_1_1_7_0_1 - 1.08482142857146*G0_1_1_8_0_0 + 2.49508928571434*G0_1_1_8_0_1 + 4.55625000000006*G0_1_1_9_0_0 + 0.723214285714305*G0_1_1_10_1_0 + 0.723214285714306*G0_1_1_10_1_1 - 0.180803571428582*G0_1_1_11_1_0 - 0.289285714285729*G0_1_1_12_1_1 - 4.01383928571433*G0_1_1_13_1_0 - 2.49508928571434*G0_1_1_13_1_1 - 0.433928571428568*G0_1_1_14_1_0 - 1.84419642857141*G0_1_1_14_1_1 - 0.54241071428573*G0_1_1_15_1_0 - 1.84419642857149*G0_1_1_15_1_1 + 0.433928571428568*G0_1_1_16_1_0 + 1.41026785714291*G0_1_1_16_1_1 + 0.542410714285732*G0_1_1_17_1_0 + 1.84419642857149*G0_1_1_17_1_1 - 1.08482142857146*G0_1_1_18_1_0 + 2.49508928571434*G0_1_1_18_1_1 + 4.55625000000006*G0_1_1_19_1_0;
    A[347] = 0.0;
    A[152] = 0.0;
    A[364] = 0.0;
    A[208] = 0.0;
    A[225] = 0.0;
    A[246] = 0.0;
    A[218] = A[370] + 0.649553571428577*G0_0_1_0_0_0 + 0.649553571428577*G0_0_1_0_0_1 - 0.149330357142859*G0_0_1_1_0_0 - 0.0408482142857143*G0_0_1_2_0_1 - 0.0241071428571402*G0_0_1_3_0_0 - 0.0783482142857146*G0_0_1_3_0_1 + 0.102455357142858*G0_0_1_4_0_0 + 0.0482142857142874*G0_0_1_4_0_1 + 0.494196428571433*G0_0_1_5_0_0 - 0.819642857142863*G0_0_1_5_0_1 - 0.102455357142858*G0_0_1_6_0_0 + 0.2109375*G0_0_1_6_0_1 - 0.964285714285724*G0_0_1_7_0_0 + 0.34955357142857*G0_0_1_7_0_1 + 0.464062500000007*G0_0_1_8_0_0 + 0.0783482142857148*G0_0_1_8_0_1 - 0.470089285714293*G0_0_1_9_0_0 - 0.397767857142858*G0_0_1_9_0_1 + 0.649553571428577*G0_0_1_10_1_0 + 0.649553571428577*G0_0_1_10_1_1 - 0.149330357142859*G0_0_1_11_1_0 - 0.0408482142857143*G0_0_1_12_1_1 - 0.0241071428571402*G0_0_1_13_1_0 - 0.0783482142857146*G0_0_1_13_1_1 + 0.102455357142858*G0_0_1_14_1_0 + 0.0482142857142874*G0_0_1_14_1_1 + 0.494196428571433*G0_0_1_15_1_0 - 0.819642857142863*G0_0_1_15_1_1 - 0.102455357142858*G0_0_1_16_1_0 + 0.2109375*G0_0_1_16_1_1 - 0.964285714285724*G0_0_1_17_1_0 + 0.34955357142857*G0_0_1_17_1_1 + 0.464062500000007*G0_0_1_18_1_0 + 0.0783482142857148*G0_0_1_18_1_1 - 0.470089285714293*G0_0_1_19_1_0 - 0.397767857142858*G0_0_1_19_1_1 - 0.649553571428577*G0_1_0_0_0_0 - 0.649553571428577*G0_1_0_0_0_1 + 0.149330357142859*G0_1_0_1_0_0 + 0.0408482142857142*G0_1_0_2_0_1 + 0.0241071428571402*G0_1_0_3_0_0 + 0.0783482142857146*G0_1_0_3_0_1 - 0.102455357142858*G0_1_0_4_0_0 - 0.0482142857142874*G0_1_0_4_0_1 - 0.494196428571433*G0_1_0_5_0_0 + 0.819642857142863*G0_1_0_5_0_1 + 0.102455357142858*G0_1_0_6_0_0 - 0.2109375*G0_1_0_6_0_1 + 0.964285714285724*G0_1_0_7_0_0 - 0.34955357142857*G0_1_0_7_0_1 - 0.464062500000007*G0_1_0_8_0_0 - 0.0783482142857148*G0_1_0_8_0_1 + 0.470089285714293*G0_1_0_9_0_0 + 0.397767857142858*G0_1_0_9_0_1 - 0.649553571428577*G0_1_0_10_1_0 - 0.649553571428577*G0_1_0_10_1_1 + 0.149330357142859*G0_1_0_11_1_0 + 0.0408482142857142*G0_1_0_12_1_1 + 0.0241071428571402*G0_1_0_13_1_0 + 0.0783482142857146*G0_1_0_13_1_1 - 0.102455357142858*G0_1_0_14_1_0 - 0.0482142857142874*G0_1_0_14_1_1 - 0.494196428571433*G0_1_0_15_1_0 + 0.819642857142863*G0_1_0_15_1_1 + 0.102455357142858*G0_1_0_16_1_0 - 0.2109375*G0_1_0_16_1_1 + 0.964285714285724*G0_1_0_17_1_0 - 0.34955357142857*G0_1_0_17_1_1 - 0.464062500000007*G0_1_0_18_1_0 - 0.0783482142857148*G0_1_0_18_1_1 + 0.470089285714293*G0_1_0_19_1_0 + 0.397767857142858*G0_1_0_19_1_1;
    A[311] = A[101];
    A[267] = 0.0;
    A[21] = -0.182589285714288*G0_0_0_0_0_0 - 0.182589285714288*G0_0_0_0_0_1 + 1.07455357142858*G0_0_0_1_0_0 + 0.182589285714288*G0_0_0_2_0_1 + 0.459375000000001*G0_0_0_3_0_0 + 2.0263392857143*G0_0_0_3_0_1 + 0.0254464285714301*G0_0_0_4_0_0 - 0.649553571428577*G0_0_0_4_0_1 - 0.0254464285714302*G0_0_0_5_0_0 - 0.0254464285714299*G0_0_0_6_0_0 + 0.675000000000008*G0_0_0_7_0_0 + 0.649553571428578*G0_0_0_7_0_1 - 1.5669642857143*G0_0_0_8_0_0 - 2.0263392857143*G0_0_0_8_0_1 - 0.433928571428571*G0_0_0_9_0_0 - 0.182589285714288*G0_0_0_10_1_0 - 0.182589285714288*G0_0_0_10_1_1 + 1.07455357142858*G0_0_0_11_1_0 + 0.182589285714288*G0_0_0_12_1_1 + 0.459375000000001*G0_0_0_13_1_0 + 2.0263392857143*G0_0_0_13_1_1 + 0.0254464285714301*G0_0_0_14_1_0 - 0.649553571428577*G0_0_0_14_1_1 - 0.0254464285714302*G0_0_0_15_1_0 - 0.0254464285714299*G0_0_0_16_1_0 + 0.675000000000008*G0_0_0_17_1_0 + 0.649553571428578*G0_0_0_17_1_1 - 1.5669642857143*G0_0_0_18_1_0 - 2.0263392857143*G0_0_0_18_1_1 - 0.433928571428571*G0_0_0_19_1_0;
    A[0] = A[21] - 0.891964285714293*G0_0_0_0_0_0 - 0.891964285714293*G0_0_0_0_0_1 - 0.891964285714293*G0_0_0_1_0_0 - 0.433928571428572*G0_0_0_3_0_0 - 2.00089285714287*G0_0_0_3_0_1 + 0.675000000000006*G0_0_0_4_0_1 - 0.433928571428571*G0_0_0_5_0_0 + 1.5669642857143*G0_0_0_5_0_1 - 0.675000000000008*G0_0_0_6_0_1 + 0.891964285714293*G0_0_0_7_0_0 - 1.10892857142858*G0_0_0_7_0_1 + 0.891964285714294*G0_0_0_8_0_0 + 2.00089285714287*G0_0_0_8_0_1 + 0.867857142857143*G0_0_0_9_0_0 + 0.433928571428572*G0_0_0_9_0_1 - 0.891964285714293*G0_0_0_10_1_0 - 0.891964285714293*G0_0_0_10_1_1 - 0.891964285714293*G0_0_0_11_1_0 - 0.433928571428572*G0_0_0_13_1_0 - 2.00089285714287*G0_0_0_13_1_1 + 0.675000000000006*G0_0_0_14_1_1 - 0.433928571428571*G0_0_0_15_1_0 + 1.5669642857143*G0_0_0_15_1_1 - 0.675000000000008*G0_0_0_16_1_1 + 0.891964285714293*G0_0_0_17_1_0 - 1.10892857142858*G0_0_0_17_1_1 + 0.891964285714294*G0_0_0_18_1_0 + 2.00089285714287*G0_0_0_18_1_1 + 0.867857142857143*G0_0_0_19_1_0 + 0.433928571428572*G0_0_0_19_1_1 - 1.07455357142858*G0_0_1_0_0_0 - 1.07455357142858*G0_0_1_0_0_1 + 0.182589285714288*G0_0_1_1_0_0 + 0.182589285714288*G0_0_1_2_0_1 + 0.0254464285714291*G0_0_1_3_0_0 + 0.0254464285714301*G0_0_1_3_0_1 + 0.0254464285714299*G0_0_1_4_0_0 + 0.0254464285714291*G0_0_1_4_0_1 - 0.459375000000002*G0_0_1_5_0_0 + 1.5669642857143*G0_0_1_5_0_1 - 0.02544642857143*G0_0_1_6_0_0 - 0.675000000000008*G0_0_1_6_0_1 + 1.5669642857143*G0_0_1_7_0_0 - 0.459375000000002*G0_0_1_7_0_1 - 0.675000000000007*G0_0_1_8_0_0 - 0.0254464285714304*G0_0_1_8_0_1 + 0.433928571428572*G0_0_1_9_0_0 + 0.433928571428574*G0_0_1_9_0_1 - 1.07455357142858*G0_0_1_10_1_0 - 1.07455357142858*G0_0_1_10_1_1 + 0.182589285714288*G0_0_1_11_1_0 + 0.182589285714288*G0_0_1_12_1_1 + 0.0254464285714291*G0_0_1_13_1_0 + 0.0254464285714301*G0_0_1_13_1_1 + 0.0254464285714299*G0_0_1_14_1_0 + 0.0254464285714291*G0_0_1_14_1_1 - 0.459375000000002*G0_0_1_15_1_0 + 1.5669642857143*G0_0_1_15_1_1 - 0.02544642857143*G0_0_1_16_1_0 - 0.675000000000008*G0_0_1_16_1_1 + 1.5669642857143*G0_0_1_17_1_0 - 0.459375000000002*G0_0_1_17_1_1 - 0.675000000000007*G0_0_1_18_1_0 - 0.0254464285714304*G0_0_1_18_1_1 + 0.433928571428572*G0_0_1_19_1_0 + 0.433928571428574*G0_0_1_19_1_1 - 1.07455357142858*G0_1_0_0_0_0 - 1.07455357142858*G0_1_0_0_0_1 + 0.182589285714288*G0_1_0_1_0_0 + 0.182589285714288*G0_1_0_2_0_1 + 0.0254464285714291*G0_1_0_3_0_0 + 0.0254464285714301*G0_1_0_3_0_1 + 0.0254464285714299*G0_1_0_4_0_0 + 0.0254464285714291*G0_1_0_4_0_1 - 0.459375000000002*G0_1_0_5_0_0 + 1.5669642857143*G0_1_0_5_0_1 - 0.02544642857143*G0_1_0_6_0_0 - 0.675000000000008*G0_1_0_6_0_1 + 1.5669642857143*G0_1_0_7_0_0 - 0.459375000000002*G0_1_0_7_0_1 - 0.675000000000007*G0_1_0_8_0_0 - 0.0254464285714304*G0_1_0_8_0_1 + 0.433928571428572*G0_1_0_9_0_0 + 0.433928571428574*G0_1_0_9_0_1 - 1.07455357142858*G0_1_0_10_1_0 - 1.07455357142858*G0_1_0_10_1_1 + 0.182589285714288*G0_1_0_11_1_0 + 0.182589285714288*G0_1_0_12_1_1 + 0.0254464285714291*G0_1_0_13_1_0 + 0.0254464285714301*G0_1_0_13_1_1 + 0.0254464285714299*G0_1_0_14_1_0 + 0.0254464285714291*G0_1_0_14_1_1 - 0.459375000000002*G0_1_0_15_1_0 + 1.5669642857143*G0_1_0_15_1_1 - 0.02544642857143*G0_1_0_16_1_0 - 0.675000000000008*G0_1_0_16_1_1 + 1.5669642857143*G0_1_0_17_1_0 - 0.459375000000002*G0_1_0_17_1_1 - 0.675000000000007*G0_1_0_18_1_0 - 0.0254464285714304*G0_1_0_18_1_1 + 0.433928571428572*G0_1_0_19_1_0 + 0.433928571428574*G0_1_0_19_1_1 - 1.07455357142858*G0_1_1_0_0_0 - 1.07455357142858*G0_1_1_0_0_1 + 0.182589285714288*G0_1_1_1_0_0 + 0.182589285714288*G0_1_1_2_0_1 + 0.0254464285714292*G0_1_1_3_0_0 + 0.0254464285714302*G0_1_1_3_0_1 + 0.0254464285714299*G0_1_1_4_0_0 + 0.0254464285714292*G0_1_1_4_0_1 - 0.459375000000002*G0_1_1_5_0_0 + 1.5669642857143*G0_1_1_5_0_1 - 0.02544642857143*G0_1_1_6_0_0 - 0.675000000000009*G0_1_1_6_0_1 + 1.5669642857143*G0_1_1_7_0_0 - 0.459375000000002*G0_1_1_7_0_1 - 0.675000000000007*G0_1_1_8_0_0 - 0.0254464285714304*G0_1_1_8_0_1 + 0.433928571428572*G0_1_1_9_0_0 + 0.433928571428573*G0_1_1_9_0_1 - 1.07455357142858*G0_1_1_10_1_0 - 1.07455357142858*G0_1_1_10_1_1 + 0.182589285714288*G0_1_1_11_1_0 + 0.182589285714288*G0_1_1_12_1_1 + 0.0254464285714292*G0_1_1_13_1_0 + 0.0254464285714302*G0_1_1_13_1_1 + 0.0254464285714299*G0_1_1_14_1_0 + 0.0254464285714292*G0_1_1_14_1_1 - 0.459375000000002*G0_1_1_15_1_0 + 1.5669642857143*G0_1_1_15_1_1 - 0.02544642857143*G0_1_1_16_1_0 - 0.675000000000009*G0_1_1_16_1_1 + 1.5669642857143*G0_1_1_17_1_0 - 0.459375000000002*G0_1_1_17_1_1 - 0.675000000000007*G0_1_1_18_1_0 - 0.0254464285714304*G0_1_1_18_1_1 + 0.433928571428572*G0_1_1_19_1_0 + 0.433928571428573*G0_1_1_19_1_1;
    A[210] = A[0];
    A[90] = 0.0;
    A[46] = A[256];
    A[111] = 0.0;
    A[96] = 0.0;
    A[145] = 0.759375000000004*G0_0_0_0_0_0 + 0.759375000000004*G0_0_0_0_0_1 - 0.271205357142861*G0_0_0_1_0_0 + 0.054241071428575*G0_0_0_2_0_1 + 0.976339285714305*G0_0_0_3_0_0 + 0.379687500000005*G0_0_0_3_0_1 + 0.271205357142863*G0_0_0_4_0_0 + 0.542410714285726*G0_0_0_4_0_1 + 1.08482142857146*G0_0_0_5_0_0 - 0.542410714285702*G0_0_0_5_0_1 - 0.271205357142862*G0_0_0_6_0_0 - 0.271205357142877*G0_0_0_6_0_1 - 1.62723214285715*G0_0_0_7_0_0 + 1.13906250000001*G0_0_0_8_0_0 - 0.379687500000005*G0_0_0_8_0_1 - 2.06116071428577*G0_0_0_9_0_0 - 0.542410714285735*G0_0_0_9_0_1 + 0.759375000000004*G0_0_0_10_1_0 + 0.759375000000004*G0_0_0_10_1_1 - 0.271205357142861*G0_0_0_11_1_0 + 0.054241071428575*G0_0_0_12_1_1 + 0.976339285714305*G0_0_0_13_1_0 + 0.379687500000005*G0_0_0_13_1_1 + 0.271205357142863*G0_0_0_14_1_0 + 0.542410714285726*G0_0_0_14_1_1 + 1.08482142857146*G0_0_0_15_1_0 - 0.542410714285702*G0_0_0_15_1_1 - 0.271205357142862*G0_0_0_16_1_0 - 0.271205357142877*G0_0_0_16_1_1 - 1.62723214285715*G0_0_0_17_1_0 + 1.13906250000001*G0_0_0_18_1_0 - 0.379687500000005*G0_0_0_18_1_1 - 2.06116071428577*G0_0_0_19_1_0 - 0.542410714285735*G0_0_0_19_1_1 - 2.14553571428574*G0_0_1_0_0_0 - 2.14553571428574*G0_0_1_0_0_1 + 0.301339285714289*G0_0_1_1_0_0 + 0.301339285714289*G0_0_1_2_0_1 + 0.542410714285726*G0_0_1_3_0_0 + 0.108482142857147*G0_0_1_3_0_1 + 0.108482142857146*G0_0_1_4_0_0 + 0.542410714285726*G0_0_1_4_0_1 - 0.542410714285701*G0_0_1_5_0_0 + 3.25446428571432*G0_0_1_5_0_1 - 0.108482142857146*G0_0_1_6_0_0 - 1.41026785714288*G0_0_1_6_0_1 + 3.25446428571432*G0_0_1_7_0_0 - 0.5424107142857*G0_0_1_7_0_1 - 1.41026785714288*G0_0_1_8_0_0 - 0.108482142857148*G0_0_1_8_0_1 - 2.14553571428574*G0_0_1_10_1_0 - 2.14553571428574*G0_0_1_10_1_1 + 0.301339285714289*G0_0_1_11_1_0 + 0.301339285714289*G0_0_1_12_1_1 + 0.542410714285726*G0_0_1_13_1_0 + 0.108482142857147*G0_0_1_13_1_1 + 0.108482142857146*G0_0_1_14_1_0 + 0.542410714285726*G0_0_1_14_1_1 - 0.542410714285701*G0_0_1_15_1_0 + 3.25446428571432*G0_0_1_15_1_1 - 0.108482142857146*G0_0_1_16_1_0 - 1.41026785714288*G0_0_1_16_1_1 + 3.25446428571432*G0_0_1_17_1_0 - 0.5424107142857*G0_0_1_17_1_1 - 1.41026785714288*G0_0_1_18_1_0 - 0.108482142857148*G0_0_1_18_1_1 - 0.301339285714289*G0_1_0_0_0_0 - 0.301339285714289*G0_1_0_0_0_1 - 0.0241071428571411*G0_1_0_1_0_0 - 0.0241071428571407*G0_1_0_2_0_1 + 0.650892857142867*G0_1_0_3_0_0 + 0.216964285714292*G0_1_0_3_0_1 + 0.216964285714292*G0_1_0_4_0_0 + 0.650892857142868*G0_1_0_4_0_1 - 1.08482142857142*G0_1_0_5_0_0 - 0.216964285714292*G0_1_0_6_0_0 + 0.32544642857142*G0_1_0_6_0_1 - 1.08482142857142*G0_1_0_7_0_1 + 0.325446428571422*G0_1_0_8_0_0 - 0.216964285714291*G0_1_0_8_0_1 + 0.433928571428549*G0_1_0_9_0_0 + 0.43392857142855*G0_1_0_9_0_1 - 0.301339285714289*G0_1_0_10_1_0 - 0.301339285714289*G0_1_0_10_1_1 - 0.0241071428571411*G0_1_0_11_1_0 - 0.0241071428571407*G0_1_0_12_1_1 + 0.650892857142867*G0_1_0_13_1_0 + 0.216964285714292*G0_1_0_13_1_1 + 0.216964285714292*G0_1_0_14_1_0 + 0.650892857142868*G0_1_0_14_1_1 - 1.08482142857142*G0_1_0_15_1_0 - 0.216964285714292*G0_1_0_16_1_0 + 0.32544642857142*G0_1_0_16_1_1 - 1.08482142857142*G0_1_0_17_1_1 + 0.325446428571422*G0_1_0_18_1_0 - 0.216964285714291*G0_1_0_18_1_1 + 0.433928571428549*G0_1_0_19_1_0 + 0.43392857142855*G0_1_0_19_1_1 + 0.759375000000004*G0_1_1_0_0_0 + 0.759375000000004*G0_1_1_0_0_1 + 0.0542410714285751*G0_1_1_1_0_0 - 0.271205357142861*G0_1_1_2_0_1 + 0.542410714285725*G0_1_1_3_0_0 + 0.271205357142861*G0_1_1_3_0_1 + 0.379687500000007*G0_1_1_4_0_0 + 0.976339285714306*G0_1_1_4_0_1 - 1.62723214285715*G0_1_1_5_0_1 - 0.379687500000007*G0_1_1_6_0_0 + 1.13906250000001*G0_1_1_6_0_1 - 0.542410714285701*G0_1_1_7_0_0 + 1.08482142857146*G0_1_1_7_0_1 - 0.271205357142879*G0_1_1_8_0_0 - 0.271205357142862*G0_1_1_8_0_1 - 0.542410714285735*G0_1_1_9_0_0 - 2.06116071428577*G0_1_1_9_0_1 + 0.759375000000004*G0_1_1_10_1_0 + 0.759375000000004*G0_1_1_10_1_1 + 0.0542410714285751*G0_1_1_11_1_0 - 0.271205357142861*G0_1_1_12_1_1 + 0.542410714285725*G0_1_1_13_1_0 + 0.271205357142861*G0_1_1_13_1_1 + 0.379687500000007*G0_1_1_14_1_0 + 0.976339285714306*G0_1_1_14_1_1 - 1.62723214285715*G0_1_1_15_1_1 - 0.379687500000007*G0_1_1_16_1_0 + 1.13906250000001*G0_1_1_16_1_1 - 0.542410714285701*G0_1_1_17_1_0 + 1.08482142857146*G0_1_1_17_1_1 - 0.271205357142879*G0_1_1_18_1_0 - 0.271205357142862*G0_1_1_18_1_1 - 0.542410714285735*G0_1_1_19_1_0 - 2.06116071428577*G0_1_1_19_1_1;
    A[339] = A[129];
    A[260] = 0.0;
    A[236] = A[26];
    A[41] = -0.00781249999999977*G0_1_0_0_0_0 - 0.00781249999999973*G0_1_0_0_0_1 + 0.182589285714288*G0_1_0_1_0_0 + 0.182589285714289*G0_1_0_2_0_1 - 0.149330357142861*G0_1_0_3_0_0 + 0.26651785714286*G0_1_0_3_0_1 + 0.266517857142861*G0_1_0_4_0_0 - 0.14933035714286*G0_1_0_4_0_1 + 0.0408482142857151*G0_1_0_5_0_0 + 0.0120535714285713*G0_1_0_5_0_1 - 0.266517857142862*G0_1_0_6_0_0 - 0.18683035714286*G0_1_0_6_0_1 + 0.0120535714285706*G0_1_0_7_0_0 + 0.0408482142857145*G0_1_0_7_0_1 - 0.186830357142859*G0_1_0_8_0_0 - 0.26651785714286*G0_1_0_8_0_1 + 0.108482142857146*G0_1_0_9_0_0 + 0.108482142857145*G0_1_0_9_0_1 - 0.00781249999999977*G0_1_0_10_1_0 - 0.00781249999999973*G0_1_0_10_1_1 + 0.182589285714288*G0_1_0_11_1_0 + 0.182589285714289*G0_1_0_12_1_1 - 0.149330357142861*G0_1_0_13_1_0 + 0.26651785714286*G0_1_0_13_1_1 + 0.266517857142861*G0_1_0_14_1_0 - 0.14933035714286*G0_1_0_14_1_1 + 0.0408482142857151*G0_1_0_15_1_0 + 0.0120535714285713*G0_1_0_15_1_1 - 0.266517857142862*G0_1_0_16_1_0 - 0.18683035714286*G0_1_0_16_1_1 + 0.0120535714285706*G0_1_0_17_1_0 + 0.0408482142857145*G0_1_0_17_1_1 - 0.186830357142859*G0_1_0_18_1_0 - 0.26651785714286*G0_1_0_18_1_1 + 0.108482142857146*G0_1_0_19_1_0 + 0.108482142857145*G0_1_0_19_1_1;
    A[250] = -A[41] + 0.174776785714288*G0_1_0_0_0_0 + 0.174776785714288*G0_1_0_0_0_1 + 0.174776785714288*G0_1_0_1_0_0 - 0.108482142857146*G0_1_0_3_0_0 + 0.295312500000003*G0_1_0_3_0_1 - 0.229017857142861*G0_1_0_4_0_1 - 0.108482142857146*G0_1_0_5_0_0 - 0.403794642857149*G0_1_0_5_0_1 + 0.229017857142861*G0_1_0_6_0_1 - 0.174776785714288*G0_1_0_7_0_0 + 0.120535714285715*G0_1_0_7_0_1 - 0.174776785714288*G0_1_0_8_0_0 - 0.295312500000003*G0_1_0_8_0_1 + 0.216964285714291*G0_1_0_9_0_0 + 0.108482142857146*G0_1_0_9_0_1 + 0.174776785714288*G0_1_0_10_1_0 + 0.174776785714288*G0_1_0_10_1_1 + 0.174776785714288*G0_1_0_11_1_0 - 0.108482142857146*G0_1_0_13_1_0 + 0.295312500000003*G0_1_0_13_1_1 - 0.229017857142861*G0_1_0_14_1_1 - 0.108482142857146*G0_1_0_15_1_0 - 0.403794642857149*G0_1_0_15_1_1 + 0.229017857142861*G0_1_0_16_1_1 - 0.174776785714288*G0_1_0_17_1_0 + 0.120535714285715*G0_1_0_17_1_1 - 0.174776785714288*G0_1_0_18_1_0 - 0.295312500000003*G0_1_0_18_1_1 + 0.216964285714291*G0_1_0_19_1_0 + 0.108482142857146*G0_1_0_19_1_1 + 0.182589285714288*G0_1_1_0_0_0 + 0.182589285714288*G0_1_1_0_0_1 - 0.00781249999999973*G0_1_1_1_0_0 - 0.182589285714289*G0_1_1_2_0_1 + 0.0408482142857151*G0_1_1_3_0_0 + 0.0287946428571437*G0_1_1_3_0_1 - 0.266517857142862*G0_1_1_4_0_0 - 0.0796875000000014*G0_1_1_4_0_1 - 0.149330357142861*G0_1_1_5_0_0 - 0.415848214285721*G0_1_1_5_0_1 + 0.266517857142862*G0_1_1_6_0_0 + 0.415848214285722*G0_1_1_6_0_1 - 0.186830357142859*G0_1_1_7_0_0 + 0.079687500000001*G0_1_1_7_0_1 + 0.0120535714285707*G0_1_1_8_0_0 - 0.0287946428571436*G0_1_1_8_0_1 + 0.108482142857146*G0_1_1_9_0_0 + 0.182589285714288*G0_1_1_10_1_0 + 0.182589285714288*G0_1_1_10_1_1 - 0.00781249999999973*G0_1_1_11_1_0 - 0.182589285714289*G0_1_1_12_1_1 + 0.0408482142857151*G0_1_1_13_1_0 + 0.0287946428571437*G0_1_1_13_1_1 - 0.266517857142862*G0_1_1_14_1_0 - 0.0796875000000014*G0_1_1_14_1_1 - 0.149330357142861*G0_1_1_15_1_0 - 0.415848214285721*G0_1_1_15_1_1 + 0.266517857142862*G0_1_1_16_1_0 + 0.415848214285722*G0_1_1_16_1_1 - 0.186830357142859*G0_1_1_17_1_0 + 0.079687500000001*G0_1_1_17_1_1 + 0.0120535714285707*G0_1_1_18_1_0 - 0.0287946428571436*G0_1_1_18_1_1 + 0.108482142857146*G0_1_1_19_1_0;
    A[142] = A[162] - 0.19888392857143*G0_0_1_0_0_0 - 0.19888392857143*G0_0_1_0_0_1 + 0.198883928571429*G0_0_1_1_0_0 + 0.198883928571424*G0_0_1_3_0_1 + 0.198883928571429*G0_0_1_5_0_1 + 0.596651785714296*G0_0_1_7_0_0 + 0.397767857142871*G0_0_1_7_0_1 - 0.596651785714295*G0_0_1_8_0_0 - 0.198883928571424*G0_0_1_8_0_1 - 0.397767857142876*G0_0_1_9_0_1 - 0.19888392857143*G0_0_1_10_1_0 - 0.19888392857143*G0_0_1_10_1_1 + 0.198883928571429*G0_0_1_11_1_0 + 0.198883928571424*G0_0_1_13_1_1 + 0.198883928571429*G0_0_1_15_1_1 + 0.596651785714296*G0_0_1_17_1_0 + 0.397767857142871*G0_0_1_17_1_1 - 0.596651785714295*G0_0_1_18_1_0 - 0.198883928571424*G0_0_1_18_1_1 - 0.397767857142876*G0_0_1_19_1_1 + 0.108482142857144*G0_1_1_0_0_0 + 0.108482142857145*G0_1_1_0_0_1 + 0.307366071428574*G0_1_1_1_0_0 - 0.126562500000004*G0_1_1_3_0_0 + 0.45200892857143*G0_1_1_3_0_1 - 0.271205357142857*G0_1_1_4_0_1 - 0.126562499999999*G0_1_1_5_0_0 - 0.379687500000005*G0_1_1_5_0_1 + 0.271205357142859*G0_1_1_6_0_1 + 0.0904017857142886*G0_1_1_7_0_0 + 0.343526785714294*G0_1_1_7_0_1 - 0.506250000000007*G0_1_1_8_0_0 - 0.45200892857143*G0_1_1_8_0_1 + 0.253125000000003*G0_1_1_9_0_0 - 0.0723214285714371*G0_1_1_9_0_1 + 0.108482142857144*G0_1_1_10_1_0 + 0.108482142857145*G0_1_1_10_1_1 + 0.307366071428574*G0_1_1_11_1_0 - 0.126562500000004*G0_1_1_13_1_0 + 0.45200892857143*G0_1_1_13_1_1 - 0.271205357142857*G0_1_1_14_1_1 - 0.126562499999999*G0_1_1_15_1_0 - 0.379687500000005*G0_1_1_15_1_1 + 0.271205357142859*G0_1_1_16_1_1 + 0.0904017857142886*G0_1_1_17_1_0 + 0.343526785714294*G0_1_1_17_1_1 - 0.506250000000007*G0_1_1_18_1_0 - 0.45200892857143*G0_1_1_18_1_1 + 0.253125000000003*G0_1_1_19_1_0 - 0.0723214285714371*G0_1_1_19_1_1;
    A[387] = 0.0;
    A[351] = A[81] - 0.444642857142864*G0_0_0_0_0_0 - 0.444642857142863*G0_0_0_0_0_1 + 0.649553571428577*G0_0_0_1_0_0 - 0.254464285714291*G0_0_0_2_0_1 + 0.879910714285724*G0_0_0_3_0_0 + 1.3138392857143*G0_0_0_3_0_1 - 0.602678571428582*G0_0_0_4_0_0 - 0.132589285714286*G0_0_0_4_0_1 - 0.229017857142859*G0_0_0_5_0_0 + 0.349553571428577*G0_0_0_5_0_1 + 0.602678571428582*G0_0_0_6_0_0 + 0.349553571428577*G0_0_0_6_0_1 + 1.1450892857143*G0_0_0_7_0_0 + 0.566517857142867*G0_0_0_7_0_1 - 1.35000000000002*G0_0_0_8_0_0 - 1.3138392857143*G0_0_0_8_0_1 - 0.650892857142865*G0_0_0_9_0_0 - 0.43392857142858*G0_0_0_9_0_1 - 0.444642857142864*G0_0_0_10_1_0 - 0.444642857142863*G0_0_0_10_1_1 + 0.649553571428577*G0_0_0_11_1_0 - 0.254464285714291*G0_0_0_12_1_1 + 0.879910714285724*G0_0_0_13_1_0 + 1.3138392857143*G0_0_0_13_1_1 - 0.602678571428582*G0_0_0_14_1_0 - 0.132589285714286*G0_0_0_14_1_1 - 0.229017857142859*G0_0_0_15_1_0 + 0.349553571428577*G0_0_0_15_1_1 + 0.602678571428582*G0_0_0_16_1_0 + 0.349553571428577*G0_0_0_16_1_1 + 1.1450892857143*G0_0_0_17_1_0 + 0.566517857142867*G0_0_0_17_1_1 - 1.35000000000002*G0_0_0_18_1_0 - 1.3138392857143*G0_0_0_18_1_1 - 0.650892857142865*G0_0_0_19_1_0 - 0.43392857142858*G0_0_0_19_1_1 - 0.190178571428575*G0_1_0_0_0_0 - 0.190178571428575*G0_1_0_0_0_1 + 1.29910714285715*G0_1_0_1_0_0 + 0.190178571428574*G0_1_0_2_0_1 + 0.843750000000002*G0_1_0_3_0_0 + 2.62767857142859*G0_1_0_3_0_1 - 0.0241071428571433*G0_1_0_4_0_0 - 0.699107142857152*G0_1_0_4_0_1 + 0.0241071428571456*G0_1_0_5_0_0 + 0.0241071428571435*G0_1_0_6_0_0 + 0.675000000000009*G0_1_0_7_0_0 + 0.699107142857151*G0_1_0_7_0_1 - 1.78392857142859*G0_1_0_8_0_0 - 2.62767857142859*G0_1_0_8_0_1 - 0.867857142857148*G0_1_0_9_0_0 - 0.190178571428575*G0_1_0_10_1_0 - 0.190178571428575*G0_1_0_10_1_1 + 1.29910714285715*G0_1_0_11_1_0 + 0.190178571428574*G0_1_0_12_1_1 + 0.843750000000002*G0_1_0_13_1_0 + 2.62767857142859*G0_1_0_13_1_1 - 0.0241071428571433*G0_1_0_14_1_0 - 0.699107142857152*G0_1_0_14_1_1 + 0.0241071428571456*G0_1_0_15_1_0 + 0.0241071428571435*G0_1_0_16_1_0 + 0.675000000000009*G0_1_0_17_1_0 + 0.699107142857151*G0_1_0_17_1_1 - 1.78392857142859*G0_1_0_18_1_0 - 2.62767857142859*G0_1_0_18_1_1 - 0.867857142857148*G0_1_0_19_1_0;
    A[204] = 0.0;
    A[229] = 0.0;
    A[18] = 0.0;
    A[286] = 0.0;
    A[258] = A[48];
    A[39] = 0.0;
    A[307] = 0.0;
    A[279] = -A[379] + 0.723214285714303*G0_0_0_0_0_0 + 0.723214285714303*G0_0_0_0_0_1 - 0.289285714285732*G0_0_0_1_0_0 - 0.180803571428581*G0_0_0_2_0_1 - 1.84419642857141*G0_0_0_3_0_0 - 0.433928571428572*G0_0_0_3_0_1 - 2.49508928571434*G0_0_0_4_0_0 - 4.01383928571433*G0_0_0_4_0_1 + 1.84419642857148*G0_0_0_5_0_0 + 0.542410714285731*G0_0_0_5_0_1 + 2.49508928571434*G0_0_0_6_0_0 - 1.08482142857145*G0_0_0_6_0_1 - 1.84419642857148*G0_0_0_7_0_0 - 0.542410714285734*G0_0_0_7_0_1 + 1.41026785714291*G0_0_0_8_0_0 + 0.433928571428571*G0_0_0_8_0_1 + 4.55625000000006*G0_0_0_9_0_1 + 0.723214285714303*G0_0_0_10_1_0 + 0.723214285714303*G0_0_0_10_1_1 - 0.289285714285732*G0_0_0_11_1_0 - 0.180803571428581*G0_0_0_12_1_1 - 1.84419642857141*G0_0_0_13_1_0 - 0.433928571428572*G0_0_0_13_1_1 - 2.49508928571434*G0_0_0_14_1_0 - 4.01383928571433*G0_0_0_14_1_1 + 1.84419642857148*G0_0_0_15_1_0 + 0.542410714285731*G0_0_0_15_1_1 + 2.49508928571434*G0_0_0_16_1_0 - 1.08482142857145*G0_0_0_16_1_1 - 1.84419642857148*G0_0_0_17_1_0 - 0.542410714285734*G0_0_0_17_1_1 + 1.41026785714291*G0_0_0_18_1_0 + 0.433928571428571*G0_0_0_18_1_1 + 4.55625000000006*G0_0_0_19_1_1 + 0.542410714285724*G0_0_1_0_0_0 + 0.542410714285724*G0_0_1_0_0_1 + 0.542410714285724*G0_0_1_2_0_1 - 2.82053571428575*G0_0_1_3_0_0 - 1.19330357142859*G0_0_1_4_0_0 - 4.55625000000006*G0_0_1_4_0_1 - 1.73571428571431*G0_0_1_5_0_0 - 0.542410714285723*G0_0_1_5_0_1 + 1.19330357142859*G0_0_1_6_0_0 - 0.542410714285725*G0_0_1_6_0_1 - 3.36294642857149*G0_0_1_7_0_0 - 4.55625000000007*G0_0_1_7_0_1 + 2.82053571428577*G0_0_1_8_0_0 + 4.55625000000006*G0_0_1_9_0_0 + 9.11250000000014*G0_0_1_9_0_1 + 0.542410714285724*G0_0_1_10_1_0 + 0.542410714285724*G0_0_1_10_1_1 + 0.542410714285724*G0_0_1_12_1_1 - 2.82053571428575*G0_0_1_13_1_0 - 1.19330357142859*G0_0_1_14_1_0 - 4.55625000000006*G0_0_1_14_1_1 - 1.73571428571431*G0_0_1_15_1_0 - 0.542410714285723*G0_0_1_15_1_1 + 1.19330357142859*G0_0_1_16_1_0 - 0.542410714285725*G0_0_1_16_1_1 - 3.36294642857149*G0_0_1_17_1_0 - 4.55625000000007*G0_0_1_17_1_1 + 2.82053571428577*G0_0_1_18_1_0 + 4.55625000000006*G0_0_1_19_1_0 + 9.11250000000014*G0_0_1_19_1_1;
    A[393] = A[279] - 0.325446428571439*G0_0_1_0_0_0 - 0.325446428571439*G0_0_1_0_0_1 - 1.08482142857143*G0_0_1_1_0_0 - 0.216964285714284*G0_0_1_2_0_1 + 1.84419642857147*G0_0_1_3_0_0 - 1.51874999999999*G0_0_1_3_0_1 + 0.867857142857158*G0_0_1_4_0_0 + 3.36294642857147*G0_0_1_4_0_1 + 1.41026785714288*G0_0_1_5_0_0 + 1.08482142857145*G0_0_1_5_0_1 - 0.867857142857158*G0_0_1_6_0_0 - 0.54241071428573*G0_0_1_6_0_1 + 0.867857142857164*G0_0_1_7_0_0 + 1.19330357142859*G0_0_1_7_0_1 + 0.542410714285704*G0_0_1_8_0_0 + 1.51874999999999*G0_0_1_8_0_1 - 3.25446428571436*G0_0_1_9_0_0 - 4.55625000000007*G0_0_1_9_0_1 - 0.325446428571439*G0_0_1_10_1_0 - 0.325446428571439*G0_0_1_10_1_1 - 1.08482142857143*G0_0_1_11_1_0 - 0.216964285714284*G0_0_1_12_1_1 + 1.84419642857147*G0_0_1_13_1_0 - 1.51874999999999*G0_0_1_13_1_1 + 0.867857142857158*G0_0_1_14_1_0 + 3.36294642857147*G0_0_1_14_1_1 + 1.41026785714288*G0_0_1_15_1_0 + 1.08482142857145*G0_0_1_15_1_1 - 0.867857142857158*G0_0_1_16_1_0 - 0.54241071428573*G0_0_1_16_1_1 + 0.867857142857164*G0_0_1_17_1_0 + 1.19330357142859*G0_0_1_17_1_1 + 0.542410714285704*G0_0_1_18_1_0 + 1.51874999999999*G0_0_1_18_1_1 - 3.25446428571436*G0_0_1_19_1_0 - 4.55625000000007*G0_0_1_19_1_1 + 0.325446428571439*G0_1_0_0_0_0 + 0.325446428571439*G0_1_0_0_0_1 + 1.08482142857143*G0_1_0_1_0_0 + 0.216964285714284*G0_1_0_2_0_1 - 1.84419642857147*G0_1_0_3_0_0 + 1.51874999999999*G0_1_0_3_0_1 - 0.867857142857158*G0_1_0_4_0_0 - 3.36294642857147*G0_1_0_4_0_1 - 1.41026785714288*G0_1_0_5_0_0 - 1.08482142857145*G0_1_0_5_0_1 + 0.867857142857158*G0_1_0_6_0_0 + 0.54241071428573*G0_1_0_6_0_1 - 0.867857142857164*G0_1_0_7_0_0 - 1.19330357142859*G0_1_0_7_0_1 - 0.542410714285704*G0_1_0_8_0_0 - 1.51874999999999*G0_1_0_8_0_1 + 3.25446428571436*G0_1_0_9_0_0 + 4.55625000000007*G0_1_0_9_0_1 + 0.325446428571439*G0_1_0_10_1_0 + 0.325446428571439*G0_1_0_10_1_1 + 1.08482142857143*G0_1_0_11_1_0 + 0.216964285714284*G0_1_0_12_1_1 - 1.84419642857147*G0_1_0_13_1_0 + 1.51874999999999*G0_1_0_13_1_1 - 0.867857142857158*G0_1_0_14_1_0 - 3.36294642857147*G0_1_0_14_1_1 - 1.41026785714288*G0_1_0_15_1_0 - 1.08482142857145*G0_1_0_15_1_1 + 0.867857142857158*G0_1_0_16_1_0 + 0.54241071428573*G0_1_0_16_1_1 - 0.867857142857164*G0_1_0_17_1_0 - 1.19330357142859*G0_1_0_17_1_1 - 0.542410714285704*G0_1_0_18_1_0 - 1.51874999999999*G0_1_0_18_1_1 + 3.25446428571436*G0_1_0_19_1_0 + 4.55625000000007*G0_1_0_19_1_1;
    A[398] = -A[393] + 0.723214285714303*G0_0_0_0_0_0 + 0.723214285714304*G0_0_0_0_0_1 - 0.289285714285732*G0_0_0_1_0_0 - 0.180803571428581*G0_0_0_2_0_1 - 1.84419642857141*G0_0_0_3_0_0 - 0.433928571428572*G0_0_0_3_0_1 - 2.49508928571434*G0_0_0_4_0_0 - 4.01383928571433*G0_0_0_4_0_1 + 1.84419642857148*G0_0_0_5_0_0 + 0.542410714285731*G0_0_0_5_0_1 + 2.49508928571434*G0_0_0_6_0_0 - 1.08482142857145*G0_0_0_6_0_1 - 1.84419642857148*G0_0_0_7_0_0 - 0.542410714285735*G0_0_0_7_0_1 + 1.41026785714292*G0_0_0_8_0_0 + 0.433928571428571*G0_0_0_8_0_1 + 4.55625000000006*G0_0_0_9_0_1 + 0.723214285714303*G0_0_0_10_1_0 + 0.723214285714304*G0_0_0_10_1_1 - 0.289285714285732*G0_0_0_11_1_0 - 0.180803571428581*G0_0_0_12_1_1 - 1.84419642857141*G0_0_0_13_1_0 - 0.433928571428572*G0_0_0_13_1_1 - 2.49508928571434*G0_0_0_14_1_0 - 4.01383928571433*G0_0_0_14_1_1 + 1.84419642857148*G0_0_0_15_1_0 + 0.542410714285731*G0_0_0_15_1_1 + 2.49508928571434*G0_0_0_16_1_0 - 1.08482142857145*G0_0_0_16_1_1 - 1.84419642857148*G0_0_0_17_1_0 - 0.542410714285735*G0_0_0_17_1_1 + 1.41026785714292*G0_0_0_18_1_0 + 0.433928571428571*G0_0_0_18_1_1 + 4.55625000000006*G0_0_0_19_1_1 + 0.542410714285724*G0_1_0_0_0_0 + 0.542410714285724*G0_1_0_0_0_1 + 0.542410714285724*G0_1_0_2_0_1 - 2.82053571428575*G0_1_0_3_0_0 - 1.19330357142859*G0_1_0_4_0_0 - 4.55625000000006*G0_1_0_4_0_1 - 1.73571428571431*G0_1_0_5_0_0 - 0.542410714285723*G0_1_0_5_0_1 + 1.19330357142859*G0_1_0_6_0_0 - 0.542410714285725*G0_1_0_6_0_1 - 3.36294642857149*G0_1_0_7_0_0 - 4.55625000000007*G0_1_0_7_0_1 + 2.82053571428577*G0_1_0_8_0_0 + 4.55625000000006*G0_1_0_9_0_0 + 9.11250000000014*G0_1_0_9_0_1 + 0.542410714285724*G0_1_0_10_1_0 + 0.542410714285724*G0_1_0_10_1_1 + 0.542410714285724*G0_1_0_12_1_1 - 2.82053571428575*G0_1_0_13_1_0 - 1.19330357142859*G0_1_0_14_1_0 - 4.55625000000006*G0_1_0_14_1_1 - 1.73571428571431*G0_1_0_15_1_0 - 0.542410714285723*G0_1_0_15_1_1 + 1.19330357142859*G0_1_0_16_1_0 - 0.542410714285725*G0_1_0_16_1_1 - 3.36294642857149*G0_1_0_17_1_0 - 4.55625000000007*G0_1_0_17_1_1 + 2.82053571428577*G0_1_0_18_1_0 + 4.55625000000006*G0_1_0_19_1_0 + 9.11250000000014*G0_1_0_19_1_1;
    A[149] = A[398] - 0.650892857142856*G0_0_0_0_0_0 - 0.650892857142857*G0_0_0_0_0_1 - 0.650892857142854*G0_0_0_1_0_0 - 3.90535714285725*G0_0_0_3_0_0 - 3.25446428571433*G0_0_0_3_0_1 - 1.30178571428578*G0_0_0_4_0_1 - 3.90535714285725*G0_0_0_5_0_0 - 0.650892857142912*G0_0_0_5_0_1 + 1.30178571428577*G0_0_0_6_0_1 + 0.650892857142858*G0_0_0_7_0_0 - 2.60357142857148*G0_0_0_7_0_1 + 0.650892857142853*G0_0_0_8_0_0 + 3.25446428571433*G0_0_0_8_0_1 + 7.8107142857145*G0_0_0_9_0_0 + 3.90535714285725*G0_0_0_9_0_1 - 0.650892857142856*G0_0_0_10_1_0 - 0.650892857142857*G0_0_0_10_1_1 - 0.650892857142854*G0_0_0_11_1_0 - 3.90535714285725*G0_0_0_13_1_0 - 3.25446428571433*G0_0_0_13_1_1 - 1.30178571428578*G0_0_0_14_1_1 - 3.90535714285725*G0_0_0_15_1_0 - 0.650892857142912*G0_0_0_15_1_1 + 1.30178571428577*G0_0_0_16_1_1 + 0.650892857142858*G0_0_0_17_1_0 - 2.60357142857148*G0_0_0_17_1_1 + 0.650892857142853*G0_0_0_18_1_0 + 3.25446428571433*G0_0_0_18_1_1 + 7.8107142857145*G0_0_0_19_1_0 + 3.90535714285725*G0_0_0_19_1_1 - 0.0361607142857027*G0_0_1_0_0_0 - 0.0361607142857028*G0_0_1_0_0_1 - 1.4825892857143*G0_0_1_1_0_0 - 0.0723214285714363*G0_0_1_2_0_1 - 4.55625000000007*G0_0_1_3_0_0 - 5.09866071428577*G0_0_1_3_0_1 - 0.867857142857174*G0_0_1_4_0_1 - 0.650892857142887*G0_0_1_5_0_0 - 0.108482142857177*G0_0_1_5_0_1 + 0.216964285714315*G0_0_1_6_0_1 + 0.759374999999993*G0_0_1_7_0_0 + 0.216964285714283*G0_0_1_7_0_1 + 0.759375000000011*G0_0_1_8_0_0 + 5.09866071428577*G0_0_1_8_0_1 + 5.20714285714296*G0_0_1_9_0_0 + 0.650892857142889*G0_0_1_9_0_1 - 0.0361607142857027*G0_0_1_10_1_0 - 0.0361607142857028*G0_0_1_10_1_1 - 1.4825892857143*G0_0_1_11_1_0 - 0.0723214285714363*G0_0_1_12_1_1 - 4.55625000000007*G0_0_1_13_1_0 - 5.09866071428577*G0_0_1_13_1_1 - 0.867857142857174*G0_0_1_14_1_1 - 0.650892857142887*G0_0_1_15_1_0 - 0.108482142857177*G0_0_1_15_1_1 + 0.216964285714315*G0_0_1_16_1_1 + 0.759374999999993*G0_0_1_17_1_0 + 0.216964285714283*G0_0_1_17_1_1 + 0.759375000000011*G0_0_1_18_1_0 + 5.09866071428577*G0_0_1_18_1_1 + 5.20714285714296*G0_0_1_19_1_0 + 0.650892857142889*G0_0_1_19_1_1 + 0.831696428571447*G0_1_0_0_0_0 + 0.831696428571447*G0_1_0_0_0_1 - 0.614732142857154*G0_1_0_1_0_0 - 0.0723214285714365*G0_1_0_2_0_1 - 3.25446428571436*G0_1_0_3_0_0 - 2.71205357142863*G0_1_0_3_0_1 - 1.08482142857147*G0_1_0_4_0_1 + 0.650892857142824*G0_1_0_5_0_0 - 1.19330357142862*G0_1_0_5_0_1 + 0.43392857142861*G0_1_0_6_0_1 - 0.108482142857156*G0_1_0_7_0_0 + 1.73571428571429*G0_1_0_7_0_1 - 0.108482142857138*G0_1_0_8_0_0 + 2.71205357142863*G0_1_0_8_0_1 + 2.60357142857154*G0_1_0_9_0_0 - 0.650892857142822*G0_1_0_9_0_1 + 0.831696428571447*G0_1_0_10_1_0 + 0.831696428571447*G0_1_0_10_1_1 - 0.614732142857154*G0_1_0_11_1_0 - 0.0723214285714365*G0_1_0_12_1_1 - 3.25446428571436*G0_1_0_13_1_0 - 2.71205357142863*G0_1_0_13_1_1 - 1.08482142857147*G0_1_0_14_1_1 + 0.650892857142824*G0_1_0_15_1_0 - 1.19330357142862*G0_1_0_15_1_1 + 0.43392857142861*G0_1_0_16_1_1 - 0.108482142857156*G0_1_0_17_1_0 + 1.73571428571429*G0_1_0_17_1_1 - 0.108482142857138*G0_1_0_18_1_0 + 2.71205357142863*G0_1_0_18_1_1 + 2.60357142857154*G0_1_0_19_1_0 - 0.650892857142822*G0_1_0_19_1_1 + 1.37410714285717*G0_1_1_0_0_0 + 1.37410714285717*G0_1_1_0_0_1 - 0.0723214285714328*G0_1_1_1_0_0 - 0.0723214285714371*G0_1_1_2_0_1 - 3.90535714285721*G0_1_1_3_0_0 - 1.95267857142861*G0_1_1_3_0_1 - 1.95267857142861*G0_1_1_4_0_1 - 2.60357142857149*G0_1_1_5_0_1 + 1.30178571428576*G0_1_1_6_0_1 - 0.650892857142878*G0_1_1_7_0_0 + 1.95267857142858*G0_1_1_7_0_1 - 0.650892857142858*G0_1_1_8_0_0 + 1.95267857142861*G0_1_1_8_0_1 + 3.90535714285725*G0_1_1_9_0_0 + 1.37410714285717*G0_1_1_10_1_0 + 1.37410714285717*G0_1_1_10_1_1 - 0.0723214285714328*G0_1_1_11_1_0 - 0.0723214285714371*G0_1_1_12_1_1 - 3.90535714285721*G0_1_1_13_1_0 - 1.95267857142861*G0_1_1_13_1_1 - 1.95267857142861*G0_1_1_14_1_1 - 2.60357142857149*G0_1_1_15_1_1 + 1.30178571428576*G0_1_1_16_1_1 - 0.650892857142878*G0_1_1_17_1_0 + 1.95267857142858*G0_1_1_17_1_1 - 0.650892857142858*G0_1_1_18_1_0 + 1.95267857142861*G0_1_1_18_1_1 + 3.90535714285725*G0_1_1_19_1_0;
    A[183] = A[393];
    A[397] = A[149] + 1.08482142857143*G0_0_1_0_0_0 + 1.08482142857143*G0_0_1_0_0_1 - 0.216964285714285*G0_0_1_1_0_0 + 0.325446428571439*G0_0_1_2_0_1 + 0.32544642857143*G0_0_1_3_0_0 + 0.867857142857162*G0_0_1_3_0_1 - 0.325446428571427*G0_0_1_4_0_0 - 1.41026785714288*G0_0_1_4_0_1 + 0.976339285714284*G0_0_1_5_0_0 - 0.542410714285712*G0_0_1_5_0_1 + 0.325446428571427*G0_0_1_6_0_0 - 0.867857142857162*G0_0_1_6_0_1 - 3.36294642857147*G0_0_1_7_0_0 - 1.84419642857148*G0_0_1_7_0_1 + 2.49508928571432*G0_0_1_8_0_0 - 0.867857142857161*G0_0_1_8_0_1 - 1.30178571428571*G0_0_1_9_0_0 + 3.25446428571436*G0_0_1_9_0_1 + 1.08482142857143*G0_0_1_10_1_0 + 1.08482142857143*G0_0_1_10_1_1 - 0.216964285714285*G0_0_1_11_1_0 + 0.325446428571439*G0_0_1_12_1_1 + 0.32544642857143*G0_0_1_13_1_0 + 0.867857142857162*G0_0_1_13_1_1 - 0.325446428571427*G0_0_1_14_1_0 - 1.41026785714288*G0_0_1_14_1_1 + 0.976339285714284*G0_0_1_15_1_0 - 0.542410714285712*G0_0_1_15_1_1 + 0.325446428571427*G0_0_1_16_1_0 - 0.867857142857162*G0_0_1_16_1_1 - 3.36294642857147*G0_0_1_17_1_0 - 1.84419642857148*G0_0_1_17_1_1 + 2.49508928571432*G0_0_1_18_1_0 - 0.867857142857161*G0_0_1_18_1_1 - 1.30178571428571*G0_0_1_19_1_0 + 3.25446428571436*G0_0_1_19_1_1 - 1.08482142857143*G0_1_0_0_0_0 - 1.08482142857143*G0_1_0_0_0_1 + 0.216964285714285*G0_1_0_1_0_0 - 0.325446428571439*G0_1_0_2_0_1 - 0.325446428571431*G0_1_0_3_0_0 - 0.867857142857162*G0_1_0_3_0_1 + 0.325446428571427*G0_1_0_4_0_0 + 1.41026785714288*G0_1_0_4_0_1 - 0.976339285714284*G0_1_0_5_0_0 + 0.542410714285712*G0_1_0_5_0_1 - 0.325446428571427*G0_1_0_6_0_0 + 0.867857142857162*G0_1_0_6_0_1 + 3.36294642857147*G0_1_0_7_0_0 + 1.84419642857148*G0_1_0_7_0_1 - 2.49508928571432*G0_1_0_8_0_0 + 0.867857142857162*G0_1_0_8_0_1 + 1.30178571428571*G0_1_0_9_0_0 - 3.25446428571436*G0_1_0_9_0_1 - 1.08482142857143*G0_1_0_10_1_0 - 1.08482142857143*G0_1_0_10_1_1 + 0.216964285714285*G0_1_0_11_1_0 - 0.325446428571439*G0_1_0_12_1_1 - 0.325446428571431*G0_1_0_13_1_0 - 0.867857142857162*G0_1_0_13_1_1 + 0.325446428571427*G0_1_0_14_1_0 + 1.41026785714288*G0_1_0_14_1_1 - 0.976339285714284*G0_1_0_15_1_0 + 0.542410714285712*G0_1_0_15_1_1 - 0.325446428571427*G0_1_0_16_1_0 + 0.867857142857162*G0_1_0_16_1_1 + 3.36294642857147*G0_1_0_17_1_0 + 1.84419642857148*G0_1_0_17_1_1 - 2.49508928571432*G0_1_0_18_1_0 + 0.867857142857162*G0_1_0_18_1_1 + 1.30178571428571*G0_1_0_19_1_0 - 3.25446428571436*G0_1_0_19_1_1;
    A[187] = A[397];
    A[8] = A[218];
    A[107] = A[145] + 1.84419642857145*G0_0_1_0_0_0 + 1.84419642857145*G0_0_1_0_0_1 - 0.32544642857143*G0_0_1_1_0_0 - 0.32544642857143*G0_0_1_2_0_1 + 0.108482142857142*G0_0_1_3_0_0 + 0.108482142857144*G0_0_1_3_0_1 + 0.108482142857146*G0_0_1_4_0_0 + 0.108482142857142*G0_0_1_4_0_1 - 0.542410714285715*G0_0_1_5_0_0 - 3.25446428571431*G0_0_1_5_0_1 - 0.108482142857146*G0_0_1_6_0_0 + 1.7357142857143*G0_0_1_6_0_1 - 3.25446428571431*G0_0_1_7_0_0 - 0.542410714285718*G0_0_1_7_0_1 + 1.7357142857143*G0_0_1_8_0_0 - 0.108482142857143*G0_0_1_8_0_1 + 0.433928571428574*G0_0_1_9_0_0 + 0.433928571428574*G0_0_1_9_0_1 + 1.84419642857145*G0_0_1_10_1_0 + 1.84419642857145*G0_0_1_10_1_1 - 0.32544642857143*G0_0_1_11_1_0 - 0.32544642857143*G0_0_1_12_1_1 + 0.108482142857142*G0_0_1_13_1_0 + 0.108482142857144*G0_0_1_13_1_1 + 0.108482142857146*G0_0_1_14_1_0 + 0.108482142857142*G0_0_1_14_1_1 - 0.542410714285715*G0_0_1_15_1_0 - 3.25446428571431*G0_0_1_15_1_1 - 0.108482142857146*G0_0_1_16_1_0 + 1.7357142857143*G0_0_1_16_1_1 - 3.25446428571431*G0_0_1_17_1_0 - 0.542410714285718*G0_0_1_17_1_1 + 1.7357142857143*G0_0_1_18_1_0 - 0.108482142857143*G0_0_1_18_1_1 + 0.433928571428574*G0_0_1_19_1_0 + 0.433928571428574*G0_0_1_19_1_1 - 1.84419642857145*G0_1_0_0_0_0 - 1.84419642857145*G0_1_0_0_0_1 + 0.32544642857143*G0_1_0_1_0_0 + 0.32544642857143*G0_1_0_2_0_1 - 0.108482142857142*G0_1_0_3_0_0 - 0.108482142857144*G0_1_0_3_0_1 - 0.108482142857146*G0_1_0_4_0_0 - 0.108482142857142*G0_1_0_4_0_1 + 0.542410714285715*G0_1_0_5_0_0 + 3.25446428571431*G0_1_0_5_0_1 + 0.108482142857145*G0_1_0_6_0_0 - 1.7357142857143*G0_1_0_6_0_1 + 3.25446428571431*G0_1_0_7_0_0 + 0.542410714285718*G0_1_0_7_0_1 - 1.7357142857143*G0_1_0_8_0_0 + 0.108482142857143*G0_1_0_8_0_1 - 0.433928571428574*G0_1_0_9_0_0 - 0.433928571428574*G0_1_0_9_0_1 - 1.84419642857145*G0_1_0_10_1_0 - 1.84419642857145*G0_1_0_10_1_1 + 0.32544642857143*G0_1_0_11_1_0 + 0.32544642857143*G0_1_0_12_1_1 - 0.108482142857142*G0_1_0_13_1_0 - 0.108482142857144*G0_1_0_13_1_1 - 0.108482142857146*G0_1_0_14_1_0 - 0.108482142857142*G0_1_0_14_1_1 + 0.542410714285715*G0_1_0_15_1_0 + 3.25446428571431*G0_1_0_15_1_1 + 0.108482142857145*G0_1_0_16_1_0 - 1.7357142857143*G0_1_0_16_1_1 + 3.25446428571431*G0_1_0_17_1_0 + 0.542410714285718*G0_1_0_17_1_1 - 1.7357142857143*G0_1_0_18_1_0 + 0.108482142857143*G0_1_0_18_1_1 - 0.433928571428574*G0_1_0_19_1_0 - 0.433928571428574*G0_1_0_19_1_1;
    A[321] = 0.0;
    A[392] = A[259] + 0.108482142857146*G0_0_1_0_0_0 + 0.108482142857146*G0_0_1_0_0_1 + 0.108482142857146*G0_0_1_1_0_0 - 0.072321428571435*G0_0_1_3_0_0 + 0.180803571428574*G0_0_1_3_0_1 - 0.144642857142864*G0_0_1_4_0_1 - 0.0723214285714339*G0_0_1_5_0_0 - 0.253125000000008*G0_0_1_5_0_1 + 0.144642857142862*G0_0_1_6_0_1 - 0.108482142857146*G0_0_1_7_0_0 + 0.0723214285714288*G0_0_1_7_0_1 - 0.108482142857146*G0_0_1_8_0_0 - 0.180803571428574*G0_0_1_8_0_1 + 0.144642857142869*G0_0_1_9_0_0 + 0.0723214285714354*G0_0_1_9_0_1 + 0.108482142857146*G0_0_1_10_1_0 + 0.108482142857146*G0_0_1_10_1_1 + 0.108482142857146*G0_0_1_11_1_0 - 0.072321428571435*G0_0_1_13_1_0 + 0.180803571428574*G0_0_1_13_1_1 - 0.144642857142864*G0_0_1_14_1_1 - 0.0723214285714339*G0_0_1_15_1_0 - 0.253125000000008*G0_0_1_15_1_1 + 0.144642857142862*G0_0_1_16_1_1 - 0.108482142857146*G0_0_1_17_1_0 + 0.0723214285714288*G0_0_1_17_1_1 - 0.108482142857146*G0_0_1_18_1_0 - 0.180803571428574*G0_0_1_18_1_1 + 0.144642857142869*G0_0_1_19_1_0 + 0.0723214285714354*G0_0_1_19_1_1 - 0.108482142857146*G0_1_0_0_0_0 - 0.108482142857146*G0_1_0_0_0_1 - 0.108482142857146*G0_1_0_1_0_0 + 0.072321428571435*G0_1_0_3_0_0 - 0.180803571428574*G0_1_0_3_0_1 + 0.144642857142864*G0_1_0_4_0_1 + 0.0723214285714339*G0_1_0_5_0_0 + 0.253125000000008*G0_1_0_5_0_1 - 0.144642857142862*G0_1_0_6_0_1 + 0.108482142857146*G0_1_0_7_0_0 - 0.0723214285714288*G0_1_0_7_0_1 + 0.108482142857146*G0_1_0_8_0_0 + 0.180803571428574*G0_1_0_8_0_1 - 0.144642857142869*G0_1_0_9_0_0 - 0.0723214285714354*G0_1_0_9_0_1 - 0.108482142857146*G0_1_0_10_1_0 - 0.108482142857146*G0_1_0_10_1_1 - 0.108482142857146*G0_1_0_11_1_0 + 0.072321428571435*G0_1_0_13_1_0 - 0.180803571428574*G0_1_0_13_1_1 + 0.144642857142864*G0_1_0_14_1_1 + 0.0723214285714339*G0_1_0_15_1_0 + 0.253125000000008*G0_1_0_15_1_1 - 0.144642857142862*G0_1_0_16_1_1 + 0.108482142857146*G0_1_0_17_1_0 - 0.0723214285714288*G0_1_0_17_1_1 + 0.108482142857146*G0_1_0_18_1_0 + 0.180803571428574*G0_1_0_18_1_1 - 0.144642857142869*G0_1_0_19_1_0 - 0.0723214285714354*G0_1_0_19_1_1;
    A[352] = A[142];
    A[157] = 0.0;
    A[371] = -A[271] + 0.336160714285719*G0_0_0_0_0_0 + 0.336160714285719*G0_0_0_0_0_1 - 1.1075892857143*G0_0_0_1_0_0 - 0.33616071428572*G0_0_0_2_0_1 - 0.15669642857142*G0_0_0_3_0_0 - 1.84419642857144*G0_0_0_3_0_1 - 0.445982142857151*G0_0_0_4_0_0 + 0.470089285714293*G0_0_0_4_0_1 + 0.445982142857152*G0_0_0_5_0_0 + 0.445982142857151*G0_0_0_6_0_0 - 0.916071428571443*G0_0_0_7_0_0 - 0.470089285714292*G0_0_0_7_0_1 + 1.68750000000002*G0_0_0_8_0_0 + 1.84419642857145*G0_0_0_8_0_1 - 0.289285714285732*G0_0_0_9_0_0 + 0.336160714285719*G0_0_0_10_1_0 + 0.336160714285719*G0_0_0_10_1_1 - 1.1075892857143*G0_0_0_11_1_0 - 0.33616071428572*G0_0_0_12_1_1 - 0.15669642857142*G0_0_0_13_1_0 - 1.84419642857144*G0_0_0_13_1_1 - 0.445982142857151*G0_0_0_14_1_0 + 0.470089285714293*G0_0_0_14_1_1 + 0.445982142857152*G0_0_0_15_1_0 + 0.445982142857151*G0_0_0_16_1_0 - 0.916071428571443*G0_0_0_17_1_0 - 0.470089285714292*G0_0_0_17_1_1 + 1.68750000000002*G0_0_0_18_1_0 + 1.84419642857145*G0_0_0_18_1_1 - 0.289285714285732*G0_0_0_19_1_0;
    A[173] = 0.0;
    A[188] = A[398];
    A[179] = 0.0;
    A[234] = A[24];
    A[198] = 0.0;
    A[289] = 0.0;
    A[249] = 0.0;
    A[312] = A[102];
    A[272] = A[62];
    A[59] = 0.0;
    A[15] = 0.0;
    A[70] = 0.0;
    A[34] = 0.0;
    A[93] = 0.0;
    A[53] = 0.0;
    A[76] = 0.0;
    A[135] = 0.0;
    A[345] = 0.0;
    A[154] = 0.0;
    A[362] = 0.0;
    A[227] = 0.0;
    A[240] = 0.0;
    A[265] = 0.0;
    A[27] = A[24] - 0.444642857142864*G0_0_0_0_0_0 - 0.444642857142863*G0_0_0_0_0_1 + 0.649553571428577*G0_0_0_1_0_0 - 0.254464285714291*G0_0_0_2_0_1 + 0.879910714285724*G0_0_0_3_0_0 + 1.3138392857143*G0_0_0_3_0_1 - 0.602678571428582*G0_0_0_4_0_0 - 0.132589285714286*G0_0_0_4_0_1 - 0.229017857142859*G0_0_0_5_0_0 + 0.349553571428577*G0_0_0_5_0_1 + 0.602678571428582*G0_0_0_6_0_0 + 0.349553571428577*G0_0_0_6_0_1 + 1.1450892857143*G0_0_0_7_0_0 + 0.566517857142867*G0_0_0_7_0_1 - 1.35000000000002*G0_0_0_8_0_0 - 1.3138392857143*G0_0_0_8_0_1 - 0.650892857142865*G0_0_0_9_0_0 - 0.43392857142858*G0_0_0_9_0_1 - 0.444642857142864*G0_0_0_10_1_0 - 0.444642857142863*G0_0_0_10_1_1 + 0.649553571428577*G0_0_0_11_1_0 - 0.254464285714291*G0_0_0_12_1_1 + 0.879910714285724*G0_0_0_13_1_0 + 1.3138392857143*G0_0_0_13_1_1 - 0.602678571428582*G0_0_0_14_1_0 - 0.132589285714286*G0_0_0_14_1_1 - 0.229017857142859*G0_0_0_15_1_0 + 0.349553571428577*G0_0_0_15_1_1 + 0.602678571428582*G0_0_0_16_1_0 + 0.349553571428577*G0_0_0_16_1_1 + 1.1450892857143*G0_0_0_17_1_0 + 0.566517857142867*G0_0_0_17_1_1 - 1.35000000000002*G0_0_0_18_1_0 - 1.3138392857143*G0_0_0_18_1_1 - 0.650892857142865*G0_0_0_19_1_0 - 0.43392857142858*G0_0_0_19_1_1 - 0.190178571428575*G0_0_1_0_0_0 - 0.190178571428575*G0_0_1_0_0_1 + 1.29910714285715*G0_0_1_1_0_0 + 0.190178571428574*G0_0_1_2_0_1 + 0.843750000000002*G0_0_1_3_0_0 + 2.62767857142859*G0_0_1_3_0_1 - 0.0241071428571433*G0_0_1_4_0_0 - 0.699107142857152*G0_0_1_4_0_1 + 0.0241071428571456*G0_0_1_5_0_0 + 0.0241071428571435*G0_0_1_6_0_0 + 0.675000000000009*G0_0_1_7_0_0 + 0.699107142857151*G0_0_1_7_0_1 - 1.78392857142859*G0_0_1_8_0_0 - 2.62767857142859*G0_0_1_8_0_1 - 0.867857142857148*G0_0_1_9_0_0 - 0.190178571428575*G0_0_1_10_1_0 - 0.190178571428575*G0_0_1_10_1_1 + 1.29910714285715*G0_0_1_11_1_0 + 0.190178571428574*G0_0_1_12_1_1 + 0.843750000000002*G0_0_1_13_1_0 + 2.62767857142859*G0_0_1_13_1_1 - 0.0241071428571433*G0_0_1_14_1_0 - 0.699107142857152*G0_0_1_14_1_1 + 0.0241071428571456*G0_0_1_15_1_0 + 0.0241071428571435*G0_0_1_16_1_0 + 0.675000000000009*G0_0_1_17_1_0 + 0.699107142857151*G0_0_1_17_1_1 - 1.78392857142859*G0_0_1_18_1_0 - 2.62767857142859*G0_0_1_18_1_1 - 0.867857142857148*G0_0_1_19_1_0;
    A[44] = -A[256] + 0.33616071428572*G0_1_1_0_0_0 + 0.33616071428572*G0_1_1_0_0_1 - 0.33616071428572*G0_1_1_1_0_0 - 1.1075892857143*G0_1_1_2_0_1 + 0.470089285714298*G0_1_1_3_0_0 - 0.44598214285715*G0_1_1_3_0_1 - 1.84419642857145*G0_1_1_4_0_0 - 0.156696428571424*G0_1_1_4_0_1 - 0.470089285714296*G0_1_1_5_0_0 - 0.916071428571446*G0_1_1_5_0_1 + 1.84419642857145*G0_1_1_6_0_0 + 1.68750000000003*G0_1_1_6_0_1 + 0.445982142857152*G0_1_1_7_0_1 + 0.445982142857151*G0_1_1_8_0_1 - 0.289285714285729*G0_1_1_9_0_1 + 0.33616071428572*G0_1_1_10_1_0 + 0.33616071428572*G0_1_1_10_1_1 - 0.33616071428572*G0_1_1_11_1_0 - 1.1075892857143*G0_1_1_12_1_1 + 0.470089285714298*G0_1_1_13_1_0 - 0.44598214285715*G0_1_1_13_1_1 - 1.84419642857145*G0_1_1_14_1_0 - 0.156696428571424*G0_1_1_14_1_1 - 0.470089285714296*G0_1_1_15_1_0 - 0.916071428571446*G0_1_1_15_1_1 + 1.84419642857145*G0_1_1_16_1_0 + 1.68750000000003*G0_1_1_16_1_1 + 0.445982142857152*G0_1_1_17_1_1 + 0.445982142857151*G0_1_1_18_1_1 - 0.289285714285729*G0_1_1_19_1_1;
    A[109] = A[319];
    A[98] = 0.0;
    A[119] = 0.0;
    A[380] = 0.0;
    A[161] = A[371];
    A[238] = A[28];
    A[332] = A[122];
    A[139] = 0.0;
    A[389] = 0.0;
    A[349] = 0.0;
    A[185] = A[395];
    A[202] = 0.0;
    A[231] = A[21];
    A[284] = 0.0;
    A[252] = -0.182589285714289*G0_1_1_0_0_0 - 0.182589285714289*G0_1_1_0_0_1 + 0.182589285714289*G0_1_1_1_0_0 + 1.07455357142858*G0_1_1_2_0_1 - 0.64955357142858*G0_1_1_3_0_0 + 0.0254464285714305*G0_1_1_3_0_1 + 2.02633928571431*G0_1_1_4_0_0 + 0.459375000000002*G0_1_1_4_0_1 + 0.64955357142858*G0_1_1_5_0_0 + 0.67500000000001*G0_1_1_5_0_1 - 2.02633928571431*G0_1_1_6_0_0 - 1.56696428571431*G0_1_1_6_0_1 - 0.0254464285714294*G0_1_1_7_0_1 - 0.0254464285714305*G0_1_1_8_0_1 - 0.433928571428573*G0_1_1_9_0_1 - 0.182589285714289*G0_1_1_10_1_0 - 0.182589285714289*G0_1_1_10_1_1 + 0.182589285714289*G0_1_1_11_1_0 + 1.07455357142858*G0_1_1_12_1_1 - 0.64955357142858*G0_1_1_13_1_0 + 0.0254464285714305*G0_1_1_13_1_1 + 2.02633928571431*G0_1_1_14_1_0 + 0.459375000000002*G0_1_1_14_1_1 + 0.64955357142858*G0_1_1_15_1_0 + 0.67500000000001*G0_1_1_15_1_1 - 2.02633928571431*G0_1_1_16_1_0 - 1.56696428571431*G0_1_1_16_1_1 - 0.0254464285714294*G0_1_1_17_1_1 - 0.0254464285714305*G0_1_1_18_1_1 - 0.433928571428573*G0_1_1_19_1_1;
    A[37] = 0.0;
    A[301] = 0.0;
    A[277] = A[143] - 0.0542410714285714*G0_0_1_0_0_0 - 0.0542410714285717*G0_0_1_0_0_1 - 0.650892857142863*G0_0_1_1_0_0 + 0.271205357142872*G0_0_1_3_0_0 - 0.976339285714286*G0_0_1_3_0_1 + 0.216964285714291*G0_0_1_4_0_0 + 0.813616071428584*G0_0_1_4_0_1 + 0.271205357142862*G0_0_1_5_0_0 + 0.433928571428578*G0_0_1_5_0_1 - 0.216964285714291*G0_0_1_6_0_0 - 0.379687500000007*G0_0_1_6_0_1 - 0.325446428571438*G0_0_1_7_0_0 - 0.488169642857154*G0_0_1_7_0_1 + 1.03058035714287*G0_0_1_8_0_0 + 0.976339285714287*G0_0_1_8_0_1 - 0.542410714285734*G0_0_1_9_0_0 - 0.325446428571429*G0_0_1_9_0_1 - 0.0542410714285714*G0_0_1_10_1_0 - 0.0542410714285717*G0_0_1_10_1_1 - 0.650892857142863*G0_0_1_11_1_0 + 0.271205357142872*G0_0_1_13_1_0 - 0.976339285714286*G0_0_1_13_1_1 + 0.216964285714291*G0_0_1_14_1_0 + 0.813616071428584*G0_0_1_14_1_1 + 0.271205357142862*G0_0_1_15_1_0 + 0.433928571428578*G0_0_1_15_1_1 - 0.216964285714291*G0_0_1_16_1_0 - 0.379687500000007*G0_0_1_16_1_1 - 0.325446428571438*G0_0_1_17_1_0 - 0.488169642857154*G0_0_1_17_1_1 + 1.03058035714287*G0_0_1_18_1_0 + 0.976339285714287*G0_0_1_18_1_1 - 0.542410714285734*G0_0_1_19_1_0 - 0.325446428571429*G0_0_1_19_1_1 + 0.0542410714285713*G0_1_0_0_0_0 + 0.0542410714285717*G0_1_0_0_0_1 + 0.650892857142863*G0_1_0_1_0_0 - 0.271205357142872*G0_1_0_3_0_0 + 0.976339285714287*G0_1_0_3_0_1 - 0.216964285714291*G0_1_0_4_0_0 - 0.813616071428584*G0_1_0_4_0_1 - 0.271205357142862*G0_1_0_5_0_0 - 0.433928571428577*G0_1_0_5_0_1 + 0.216964285714291*G0_1_0_6_0_0 + 0.379687500000008*G0_1_0_6_0_1 + 0.325446428571438*G0_1_0_7_0_0 + 0.488169642857154*G0_1_0_7_0_1 - 1.03058035714287*G0_1_0_8_0_0 - 0.976339285714287*G0_1_0_8_0_1 + 0.542410714285734*G0_1_0_9_0_0 + 0.325446428571429*G0_1_0_9_0_1 + 0.0542410714285713*G0_1_0_10_1_0 + 0.0542410714285717*G0_1_0_10_1_1 + 0.650892857142863*G0_1_0_11_1_0 - 0.271205357142872*G0_1_0_13_1_0 + 0.976339285714287*G0_1_0_13_1_1 - 0.216964285714291*G0_1_0_14_1_0 - 0.813616071428584*G0_1_0_14_1_1 - 0.271205357142862*G0_1_0_15_1_0 - 0.433928571428577*G0_1_0_15_1_1 + 0.216964285714291*G0_1_0_16_1_0 + 0.379687500000008*G0_1_0_16_1_1 + 0.325446428571438*G0_1_0_17_1_0 + 0.488169642857154*G0_1_0_17_1_1 - 1.03058035714287*G0_1_0_18_1_0 - 0.976339285714287*G0_1_0_18_1_1 + 0.542410714285734*G0_1_0_19_1_0 + 0.325446428571429*G0_1_0_19_1_1;
    A[377] = -A[277] + 1.07879464285716*G0_0_0_0_0_0 + 1.07879464285716*G0_0_0_0_0_1 - 0.916071428571443*G0_0_0_1_0_0 - 0.156696428571433*G0_0_0_2_0_1 - 0.27120535714283*G0_0_0_3_0_0 - 1.7357142857143*G0_0_0_3_0_1 + 0.542410714285722*G0_0_0_4_0_0 + 1.24754464285718*G0_0_0_4_0_1 + 2.11540178571432*G0_0_0_5_0_0 - 0.867857142857152*G0_0_0_5_0_1 - 0.542410714285722*G0_0_0_6_0_0 - 0.0542410714285713*G0_0_0_6_0_1 - 0.86785714285716*G0_0_0_7_0_0 + 2.11540178571431*G0_0_0_7_0_1 + 0.705133928571446*G0_0_0_8_0_0 + 1.7357142857143*G0_0_0_8_0_1 - 1.84419642857148*G0_0_0_9_0_0 - 3.36294642857149*G0_0_0_9_0_1 + 1.07879464285716*G0_0_0_10_1_0 + 1.07879464285716*G0_0_0_10_1_1 - 0.916071428571443*G0_0_0_11_1_0 - 0.156696428571433*G0_0_0_12_1_1 - 0.27120535714283*G0_0_0_13_1_0 - 1.7357142857143*G0_0_0_13_1_1 + 0.542410714285722*G0_0_0_14_1_0 + 1.24754464285718*G0_0_0_14_1_1 + 2.11540178571432*G0_0_0_15_1_0 - 0.867857142857152*G0_0_0_15_1_1 - 0.542410714285722*G0_0_0_16_1_0 - 0.0542410714285713*G0_0_0_16_1_1 - 0.86785714285716*G0_0_0_17_1_0 + 2.11540178571431*G0_0_0_17_1_1 + 0.705133928571446*G0_0_0_18_1_0 + 1.7357142857143*G0_0_0_18_1_1 - 1.84419642857148*G0_0_0_19_1_0 - 3.36294642857149*G0_0_0_19_1_1 - 0.235044642857141*G0_0_1_0_0_0 - 0.235044642857141*G0_0_1_0_0_1 - 0.470089285714292*G0_0_1_1_0_0 - 0.307366071428582*G0_0_1_2_0_1 - 0.433928571428553*G0_0_1_3_0_0 - 1.84419642857144*G0_0_1_3_0_1 + 0.488169642857148*G0_0_1_4_0_0 + 1.73571428571433*G0_0_1_4_0_1 + 0.976339285714289*G0_0_1_5_0_0 + 0.271205357142846*G0_0_1_5_0_1 - 0.488169642857148*G0_0_1_6_0_0 + 0.271205357142877*G0_0_1_6_0_1 + 2.11540178571431*G0_0_1_7_0_0 + 2.82053571428575*G0_0_1_7_0_1 - 1.41026785714287*G0_0_1_8_0_0 + 1.84419642857144*G0_0_1_8_0_1 - 0.542410714285734*G0_0_1_9_0_0 - 4.55625000000007*G0_0_1_9_0_1 - 0.235044642857141*G0_0_1_10_1_0 - 0.235044642857141*G0_0_1_10_1_1 - 0.470089285714292*G0_0_1_11_1_0 - 0.307366071428582*G0_0_1_12_1_1 - 0.433928571428553*G0_0_1_13_1_0 - 1.84419642857144*G0_0_1_13_1_1 + 0.488169642857148*G0_0_1_14_1_0 + 1.73571428571433*G0_0_1_14_1_1 + 0.976339285714289*G0_0_1_15_1_0 + 0.271205357142846*G0_0_1_15_1_1 - 0.488169642857148*G0_0_1_16_1_0 + 0.271205357142877*G0_0_1_16_1_1 + 2.11540178571431*G0_0_1_17_1_0 + 2.82053571428575*G0_0_1_17_1_1 - 1.41026785714287*G0_0_1_18_1_0 + 1.84419642857144*G0_0_1_18_1_1 - 0.542410714285734*G0_0_1_19_1_0 - 4.55625000000007*G0_0_1_19_1_1;
    A[165] = A[377] - 1.67544642857145*G0_0_0_0_0_0 - 1.67544642857145*G0_0_0_0_0_1 + 1.51272321428574*G0_0_0_1_0_0 + 0.265178571428574*G0_0_0_2_0_1 + 0.162723214285705*G0_0_0_3_0_0 + 2.11540178571431*G0_0_0_3_0_1 - 0.705133928571441*G0_0_0_4_0_1 - 2.00691964285719*G0_0_0_5_0_0 + 1.35602678571429*G0_0_0_5_0_1 + 0.0542410714285854*G0_0_0_6_0_1 + 2.98325892857147*G0_0_0_7_0_0 - 0.37968750000001*G0_0_0_7_0_1 - 2.82053571428575*G0_0_0_8_0_0 - 2.11540178571431*G0_0_0_8_0_1 + 1.84419642857148*G0_0_0_9_0_0 + 1.08482142857145*G0_0_0_9_0_1 - 1.67544642857145*G0_0_0_10_1_0 - 1.67544642857145*G0_0_0_10_1_1 + 1.51272321428574*G0_0_0_11_1_0 + 0.265178571428574*G0_0_0_12_1_1 + 0.162723214285705*G0_0_0_13_1_0 + 2.11540178571431*G0_0_0_13_1_1 - 0.705133928571441*G0_0_0_14_1_1 - 2.00691964285719*G0_0_0_15_1_0 + 1.35602678571429*G0_0_0_15_1_1 + 0.0542410714285854*G0_0_0_16_1_1 + 2.98325892857147*G0_0_0_17_1_0 - 0.37968750000001*G0_0_0_17_1_1 - 2.82053571428575*G0_0_0_18_1_0 - 2.11540178571431*G0_0_0_18_1_1 + 1.84419642857148*G0_0_0_19_1_0 + 1.08482142857145*G0_0_0_19_1_1 + 0.614732142857142*G0_0_1_0_0_0 + 0.614732142857142*G0_0_1_0_0_1 + 0.849776785714295*G0_0_1_1_0_0 + 0.361607142857153*G0_0_1_2_0_1 + 0.922098214285717*G0_0_1_3_0_0 + 2.65781250000003*G0_0_1_3_0_1 - 1.24754464285716*G0_0_1_4_0_1 - 0.37968750000001*G0_0_1_5_0_0 - 0.922098214285709*G0_0_1_5_0_1 - 0.0542410714285853*G0_0_1_6_0_1 - 2.11540178571431*G0_0_1_7_0_0 - 1.57299107142861*G0_0_1_7_0_1 + 0.650892857142873*G0_0_1_8_0_0 - 2.65781250000003*G0_0_1_8_0_1 - 0.542410714285708*G0_0_1_9_0_0 + 2.82053571428577*G0_0_1_9_0_1 + 0.614732142857142*G0_0_1_10_1_0 + 0.614732142857142*G0_0_1_10_1_1 + 0.849776785714295*G0_0_1_11_1_0 + 0.361607142857153*G0_0_1_12_1_1 + 0.922098214285717*G0_0_1_13_1_0 + 2.65781250000003*G0_0_1_13_1_1 - 1.24754464285716*G0_0_1_14_1_1 - 0.37968750000001*G0_0_1_15_1_0 - 0.922098214285709*G0_0_1_15_1_1 - 0.0542410714285853*G0_0_1_16_1_1 - 2.11540178571431*G0_0_1_17_1_0 - 1.57299107142861*G0_0_1_17_1_1 + 0.650892857142873*G0_0_1_18_1_0 - 2.65781250000003*G0_0_1_18_1_1 - 0.542410714285708*G0_0_1_19_1_0 + 2.82053571428577*G0_0_1_19_1_1 - 0.216964285714291*G0_1_0_0_0_0 - 0.216964285714291*G0_1_0_0_0_1 + 0.976339285714295*G0_1_0_1_0_0 + 0.0542410714285688*G0_1_0_2_0_1 + 0.488169642857154*G0_1_0_3_0_0 + 1.62723214285716*G0_1_0_3_0_1 + 0.0542410714285706*G0_1_0_4_0_0 - 0.162723214285706*G0_1_0_4_0_1 + 0.596651785714289*G0_1_0_5_0_0 + 0.162723214285718*G0_1_0_5_0_1 - 0.0542410714285706*G0_1_0_6_0_0 + 1.35602678571431*G0_1_0_7_0_0 + 1.78995535714288*G0_1_0_7_0_1 - 2.11540178571431*G0_1_0_8_0_0 - 1.62723214285716*G0_1_0_8_0_1 - 1.08482142857144*G0_1_0_9_0_0 - 1.62723214285717*G0_1_0_9_0_1 - 0.216964285714291*G0_1_0_10_1_0 - 0.216964285714291*G0_1_0_10_1_1 + 0.976339285714295*G0_1_0_11_1_0 + 0.0542410714285688*G0_1_0_12_1_1 + 0.488169642857154*G0_1_0_13_1_0 + 1.62723214285716*G0_1_0_13_1_1 + 0.0542410714285706*G0_1_0_14_1_0 - 0.162723214285706*G0_1_0_14_1_1 + 0.596651785714289*G0_1_0_15_1_0 + 0.162723214285718*G0_1_0_15_1_1 - 0.0542410714285706*G0_1_0_16_1_0 + 1.35602678571431*G0_1_0_17_1_0 + 1.78995535714288*G0_1_0_17_1_1 - 2.11540178571431*G0_1_0_18_1_0 - 1.62723214285716*G0_1_0_18_1_1 - 1.08482142857144*G0_1_0_19_1_0 - 1.62723214285717*G0_1_0_19_1_1 - 0.55446428571429*G0_1_1_0_0_0 - 0.55446428571429*G0_1_1_0_0_1 + 1.31383928571429*G0_1_1_1_0_0 + 0.06629464285714*G0_1_1_2_0_1 + 0.81361607142858*G0_1_1_3_0_0 + 2.27812500000001*G0_1_1_3_0_1 - 0.0542410714285711*G0_1_1_4_0_0 - 0.271205357142848*G0_1_1_4_0_1 + 0.271205357142861*G0_1_1_5_0_0 + 0.488169642857144*G0_1_1_5_0_1 + 0.0542410714285713*G0_1_1_6_0_0 + 1.89843750000002*G0_1_1_7_0_0 + 1.68147321428574*G0_1_1_7_0_1 - 2.65781250000003*G0_1_1_8_0_0 - 2.27812500000001*G0_1_1_8_0_1 - 1.08482142857144*G0_1_1_9_0_0 - 1.41026785714289*G0_1_1_9_0_1 - 0.55446428571429*G0_1_1_10_1_0 - 0.55446428571429*G0_1_1_10_1_1 + 1.31383928571429*G0_1_1_11_1_0 + 0.06629464285714*G0_1_1_12_1_1 + 0.81361607142858*G0_1_1_13_1_0 + 2.27812500000001*G0_1_1_13_1_1 - 0.0542410714285711*G0_1_1_14_1_0 - 0.271205357142848*G0_1_1_14_1_1 + 0.271205357142861*G0_1_1_15_1_0 + 0.488169642857144*G0_1_1_15_1_1 + 0.0542410714285713*G0_1_1_16_1_0 + 1.89843750000002*G0_1_1_17_1_0 + 1.68147321428574*G0_1_1_17_1_1 - 2.65781250000003*G0_1_1_18_1_0 - 2.27812500000001*G0_1_1_18_1_1 - 1.08482142857144*G0_1_1_19_1_0 - 1.41026785714289*G0_1_1_19_1_1;
    A[189] = -A[377] - 0.150669642857159*G0_0_0_0_0_0 - 0.150669642857159*G0_0_0_0_0_1 + 0.150669642857159*G0_0_0_1_0_0 - 0.0662946428571354*G0_0_0_2_0_1 + 2.76629464285717*G0_0_0_3_0_0 + 0.0542410714285753*G0_0_0_3_0_1 + 4.17656250000009*G0_0_0_4_0_0 + 7.10558035714297*G0_0_0_4_0_1 - 2.76629464285718*G0_0_0_5_0_0 - 2.71205357142859*G0_0_0_5_0_1 - 4.17656250000009*G0_0_0_6_0_0 + 2.92901785714289*G0_0_0_6_0_1 + 2.0611607142858*G0_0_0_7_0_0 + 2.00691964285721*G0_0_0_7_0_1 - 2.0611607142858*G0_0_0_8_0_0 - 0.0542410714285739*G0_0_0_8_0_1 - 9.11250000000019*G0_0_0_9_0_1 - 0.150669642857159*G0_0_0_10_1_0 - 0.150669642857159*G0_0_0_10_1_1 + 0.150669642857159*G0_0_0_11_1_0 - 0.0662946428571354*G0_0_0_12_1_1 + 2.76629464285717*G0_0_0_13_1_0 + 0.0542410714285753*G0_0_0_13_1_1 + 4.17656250000009*G0_0_0_14_1_0 + 7.10558035714297*G0_0_0_14_1_1 - 2.76629464285718*G0_0_0_15_1_0 - 2.71205357142859*G0_0_0_15_1_1 - 4.17656250000009*G0_0_0_16_1_0 + 2.92901785714289*G0_0_0_16_1_1 + 2.0611607142858*G0_0_0_17_1_0 + 2.00691964285721*G0_0_0_17_1_1 - 2.0611607142858*G0_0_0_18_1_0 - 0.0542410714285739*G0_0_0_18_1_1 - 9.11250000000019*G0_0_0_19_1_1 - 1.22343750000002*G0_0_1_0_0_0 - 1.22343750000002*G0_0_1_0_0_1 - 0.89196428571429*G0_0_1_1_0_0 - 0.186830357142858*G0_0_1_2_0_1 + 4.3392857142858*G0_0_1_3_0_0 - 0.867857142857134*G0_0_1_3_0_1 + 2.22388392857147*G0_0_1_4_0_0 + 6.72589285714298*G0_0_1_4_0_1 + 2.27812500000006*G0_0_1_5_0_0 + 2.33236607142862*G0_0_1_5_0_1 - 2.22388392857147*G0_0_1_6_0_0 - 0.922098214285736*G0_0_1_6_0_1 + 3.30870535714293*G0_0_1_7_0_0 + 3.25446428571437*G0_0_1_7_0_1 - 1.19330357142862*G0_0_1_8_0_0 + 0.867857142857135*G0_0_1_8_0_1 - 6.61741071428586*G0_0_1_9_0_0 - 9.98035714285735*G0_0_1_9_0_1 - 1.22343750000002*G0_0_1_10_1_0 - 1.22343750000002*G0_0_1_10_1_1 - 0.89196428571429*G0_0_1_11_1_0 - 0.186830357142858*G0_0_1_12_1_1 + 4.3392857142858*G0_0_1_13_1_0 - 0.867857142857134*G0_0_1_13_1_1 + 2.22388392857147*G0_0_1_14_1_0 + 6.72589285714298*G0_0_1_14_1_1 + 2.27812500000006*G0_0_1_15_1_0 + 2.33236607142862*G0_0_1_15_1_1 - 2.22388392857147*G0_0_1_16_1_0 - 0.922098214285736*G0_0_1_16_1_1 + 3.30870535714293*G0_0_1_17_1_0 + 3.25446428571437*G0_0_1_17_1_1 - 1.19330357142862*G0_0_1_18_1_0 + 0.867857142857135*G0_0_1_18_1_1 - 6.61741071428586*G0_0_1_19_1_0 - 9.98035714285735*G0_0_1_19_1_1 - 1.04263392857145*G0_1_0_0_0_0 - 1.04263392857145*G0_1_0_0_0_1 - 1.07276785714286*G0_1_0_1_0_0 + 0.120535714285725*G0_1_0_2_0_1 + 5.04441964285723*G0_1_0_3_0_0 + 1.95267857142862*G0_1_0_4_0_0 + 5.80379464285724*G0_1_0_4_0_1 + 1.57299107142863*G0_1_0_5_0_0 + 2.49508928571435*G0_1_0_5_0_1 - 1.95267857142861*G0_1_0_6_0_0 - 1.57299107142862*G0_1_0_6_0_1 + 0.86785714285718*G0_1_0_7_0_0 - 0.0542410714285348*G0_1_0_7_0_1 + 1.24754464285713*G0_1_0_8_0_0 - 6.61741071428586*G0_1_0_9_0_0 - 5.7495535714287*G0_1_0_9_0_1 - 1.04263392857145*G0_1_0_10_1_0 - 1.04263392857145*G0_1_0_10_1_1 - 1.07276785714286*G0_1_0_11_1_0 + 0.120535714285725*G0_1_0_12_1_1 + 5.04441964285723*G0_1_0_13_1_0 + 1.95267857142862*G0_1_0_14_1_0 + 5.80379464285724*G0_1_0_14_1_1 + 1.57299107142863*G0_1_0_15_1_0 + 2.49508928571435*G0_1_0_15_1_1 - 1.95267857142861*G0_1_0_16_1_0 - 1.57299107142862*G0_1_0_16_1_1 + 0.86785714285718*G0_1_0_17_1_0 - 0.0542410714285348*G0_1_0_17_1_1 + 1.24754464285713*G0_1_0_18_1_0 - 6.61741071428586*G0_1_0_19_1_0 - 5.7495535714287*G0_1_0_19_1_1 - 0.946205357142886*G0_1_1_0_0_0 - 0.946205357142888*G0_1_1_0_0_1 - 1.16919642857143*G0_1_1_1_0_0 + 1.48861607142861*G0_1_1_2_0_1 + 5.53258928571438*G0_1_1_3_0_0 + 1.62723214285722*G0_1_1_3_0_1 + 2.65781250000004*G0_1_1_4_0_0 + 3.90535714285716*G0_1_1_4_0_1 + 1.08482142857149*G0_1_1_5_0_0 + 3.63415178571439*G0_1_1_5_0_1 - 2.65781250000004*G0_1_1_6_0_0 - 4.17656250000012*G0_1_1_6_0_1 - 3.30870535714289*G0_1_1_7_0_0 - 5.8580357142858*G0_1_1_7_0_1 + 5.42410714285721*G0_1_1_8_0_0 - 1.62723214285721*G0_1_1_8_0_1 - 6.61741071428586*G0_1_1_9_0_0 + 1.95267857142864*G0_1_1_9_0_1 - 0.946205357142886*G0_1_1_10_1_0 - 0.946205357142888*G0_1_1_10_1_1 - 1.16919642857143*G0_1_1_11_1_0 + 1.48861607142861*G0_1_1_12_1_1 + 5.53258928571438*G0_1_1_13_1_0 + 1.62723214285722*G0_1_1_13_1_1 + 2.65781250000004*G0_1_1_14_1_0 + 3.90535714285716*G0_1_1_14_1_1 + 1.08482142857149*G0_1_1_15_1_0 + 3.63415178571439*G0_1_1_15_1_1 - 2.65781250000004*G0_1_1_16_1_0 - 4.17656250000012*G0_1_1_16_1_1 - 3.30870535714289*G0_1_1_17_1_0 - 5.8580357142858*G0_1_1_17_1_1 + 5.42410714285721*G0_1_1_18_1_0 - 1.62723214285721*G0_1_1_18_1_1 - 6.61741071428586*G0_1_1_19_1_0 + 1.95267857142864*G0_1_1_19_1_1;
    A[167] = A[377];
    A[375] = A[165];
    A[399] = A[189];
    A[358] = A[377] + 0.18080357142857*G0_0_1_0_0_0 + 0.18080357142857*G0_0_1_0_0_1 - 0.180803571428571*G0_0_1_1_0_0 + 0.307366071428583*G0_0_1_2_0_1 + 0.705133928571426*G0_0_1_3_0_0 + 0.867857142857158*G0_0_1_3_0_1 - 0.271205357142857*G0_0_1_4_0_0 - 0.922098214285742*G0_0_1_4_0_1 - 0.705133928571427*G0_0_1_5_0_0 + 0.162723214285731*G0_0_1_5_0_1 + 0.271205357142858*G0_0_1_6_0_0 - 0.650892857142884*G0_0_1_6_0_1 - 2.44084821428575*G0_0_1_7_0_0 - 3.3087053571429*G0_0_1_7_0_1 + 2.44084821428575*G0_0_1_8_0_0 - 0.867857142857157*G0_0_1_8_0_1 + 4.23080357142864*G0_0_1_9_0_1 + 0.18080357142857*G0_0_1_10_1_0 + 0.18080357142857*G0_0_1_10_1_1 - 0.180803571428571*G0_0_1_11_1_0 + 0.307366071428583*G0_0_1_12_1_1 + 0.705133928571426*G0_0_1_13_1_0 + 0.867857142857158*G0_0_1_13_1_1 - 0.271205357142857*G0_0_1_14_1_0 - 0.922098214285742*G0_0_1_14_1_1 - 0.705133928571427*G0_0_1_15_1_0 + 0.162723214285731*G0_0_1_15_1_1 + 0.271205357142858*G0_0_1_16_1_0 - 0.650892857142884*G0_0_1_16_1_1 - 2.44084821428575*G0_0_1_17_1_0 - 3.3087053571429*G0_0_1_17_1_1 + 2.44084821428575*G0_0_1_18_1_0 - 0.867857142857157*G0_0_1_18_1_1 + 4.23080357142864*G0_0_1_19_1_1 - 0.180803571428571*G0_1_0_0_0_0 - 0.18080357142857*G0_1_0_0_0_1 + 0.180803571428571*G0_1_0_1_0_0 - 0.307366071428583*G0_1_0_2_0_1 - 0.705133928571426*G0_1_0_3_0_0 - 0.867857142857158*G0_1_0_3_0_1 + 0.271205357142857*G0_1_0_4_0_0 + 0.922098214285742*G0_1_0_4_0_1 + 0.705133928571427*G0_1_0_5_0_0 - 0.16272321428573*G0_1_0_5_0_1 - 0.271205357142858*G0_1_0_6_0_0 + 0.650892857142884*G0_1_0_6_0_1 + 2.44084821428575*G0_1_0_7_0_0 + 3.3087053571429*G0_1_0_7_0_1 - 2.44084821428575*G0_1_0_8_0_0 + 0.867857142857157*G0_1_0_8_0_1 - 4.23080357142864*G0_1_0_9_0_1 - 0.180803571428571*G0_1_0_10_1_0 - 0.18080357142857*G0_1_0_10_1_1 + 0.180803571428571*G0_1_0_11_1_0 - 0.307366071428583*G0_1_0_12_1_1 - 0.705133928571426*G0_1_0_13_1_0 - 0.867857142857158*G0_1_0_13_1_1 + 0.271205357142857*G0_1_0_14_1_0 + 0.922098214285742*G0_1_0_14_1_1 + 0.705133928571427*G0_1_0_15_1_0 - 0.16272321428573*G0_1_0_15_1_1 - 0.271205357142858*G0_1_0_16_1_0 + 0.650892857142884*G0_1_0_16_1_1 + 2.44084821428575*G0_1_0_17_1_0 + 3.3087053571429*G0_1_0_17_1_1 - 2.44084821428575*G0_1_0_18_1_0 + 0.867857142857157*G0_1_0_18_1_1 - 4.23080357142864*G0_1_0_19_1_1;
    A[65] = -A[165] - 0.608705357142865*G0_0_0_0_0_0 - 0.608705357142865*G0_0_0_0_0_1 + 0.445982142857152*G0_0_0_1_0_0 - 0.25915178571429*G0_0_0_2_0_1 - 0.325446428571431*G0_0_0_3_0_0 - 0.108482142857141*G0_0_0_3_0_1 + 0.27120535714287*G0_0_0_4_0_0 + 0.759375000000022*G0_0_0_4_0_1 - 1.51875000000005*G0_0_0_5_0_0 - 0.379687500000025*G0_0_0_5_0_1 - 0.27120535714287*G0_0_0_6_0_0 + 1.24754464285718*G0_0_0_6_0_1 + 2.11540178571432*G0_0_0_7_0_0 + 0.976339285714289*G0_0_0_7_0_1 - 1.9526785714286*G0_0_0_8_0_0 + 0.108482142857141*G0_0_0_8_0_1 + 1.84419642857148*G0_0_0_9_0_0 - 1.73571428571431*G0_0_0_9_0_1 - 0.608705357142865*G0_0_0_10_1_0 - 0.608705357142865*G0_0_0_10_1_1 + 0.445982142857152*G0_0_0_11_1_0 - 0.25915178571429*G0_0_0_12_1_1 - 0.325446428571431*G0_0_0_13_1_0 - 0.108482142857141*G0_0_0_13_1_1 + 0.27120535714287*G0_0_0_14_1_0 + 0.759375000000022*G0_0_0_14_1_1 - 1.51875000000005*G0_0_0_15_1_0 - 0.379687500000025*G0_0_0_15_1_1 - 0.27120535714287*G0_0_0_16_1_0 + 1.24754464285718*G0_0_0_16_1_1 + 2.11540178571432*G0_0_0_17_1_0 + 0.976339285714289*G0_0_0_17_1_1 - 1.9526785714286*G0_0_0_18_1_0 + 0.108482142857141*G0_0_0_18_1_1 + 1.84419642857148*G0_0_0_19_1_0 - 1.73571428571431*G0_0_0_19_1_1 + 0.705133928571434*G0_0_1_0_0_0 + 0.705133928571434*G0_0_1_0_0_1 - 0.108482142857143*G0_0_1_2_0_1 - 0.162723214285706*G0_0_1_3_0_0 + 0.325446428571444*G0_0_1_4_0_0 + 0.271205357142876*G0_0_1_4_0_1 - 0.379687500000025*G0_0_1_5_0_0 - 1.51875000000002*G0_0_1_5_0_1 - 0.325446428571444*G0_0_1_6_0_0 + 0.922098214285733*G0_0_1_6_0_1 - 0.867857142857152*G0_0_1_7_0_0 + 0.271205357142846*G0_0_1_7_0_1 + 0.162723214285717*G0_0_1_8_0_0 + 0.542410714285731*G0_0_1_9_0_0 - 0.542410714285723*G0_0_1_9_0_1 + 0.705133928571434*G0_0_1_10_1_0 + 0.705133928571434*G0_0_1_10_1_1 - 0.108482142857143*G0_0_1_12_1_1 - 0.162723214285706*G0_0_1_13_1_0 + 0.325446428571444*G0_0_1_14_1_0 + 0.271205357142876*G0_0_1_14_1_1 - 0.379687500000025*G0_0_1_15_1_0 - 1.51875000000002*G0_0_1_15_1_1 - 0.325446428571444*G0_0_1_16_1_0 + 0.922098214285733*G0_0_1_16_1_1 - 0.867857142857152*G0_0_1_17_1_0 + 0.271205357142846*G0_0_1_17_1_1 + 0.162723214285717*G0_0_1_18_1_0 + 0.542410714285731*G0_0_1_19_1_0 - 0.542410714285723*G0_0_1_19_1_1;
    A[313] = A[65] - 0.0542410714285711*G0_0_1_0_0_0 - 0.054241071428571*G0_0_1_0_0_1 + 0.0542410714285698*G0_0_1_1_0_0 + 0.108482142857144*G0_0_1_2_0_1 - 0.108482142857156*G0_0_1_3_0_0 + 0.16272321428571*G0_0_1_3_0_1 - 0.108482142857153*G0_0_1_4_0_0 - 0.433928571428592*G0_0_1_4_0_1 + 0.108482142857154*G0_0_1_5_0_0 + 0.271205357142867*G0_0_1_5_0_1 + 0.108482142857153*G0_0_1_6_0_0 - 0.32544642857144*G0_0_1_6_0_1 - 0.16272321428572*G0_0_1_7_0_0 - 0.325446428571433*G0_0_1_7_0_1 + 0.162723214285722*G0_0_1_8_0_0 - 0.16272321428571*G0_0_1_8_0_1 + 0.759375000000025*G0_0_1_9_0_1 - 0.0542410714285711*G0_0_1_10_1_0 - 0.054241071428571*G0_0_1_10_1_1 + 0.0542410714285698*G0_0_1_11_1_0 + 0.108482142857144*G0_0_1_12_1_1 - 0.108482142857156*G0_0_1_13_1_0 + 0.16272321428571*G0_0_1_13_1_1 - 0.108482142857153*G0_0_1_14_1_0 - 0.433928571428592*G0_0_1_14_1_1 + 0.108482142857154*G0_0_1_15_1_0 + 0.271205357142867*G0_0_1_15_1_1 + 0.108482142857153*G0_0_1_16_1_0 - 0.32544642857144*G0_0_1_16_1_1 - 0.16272321428572*G0_0_1_17_1_0 - 0.325446428571433*G0_0_1_17_1_1 + 0.162723214285722*G0_0_1_18_1_0 - 0.16272321428571*G0_0_1_18_1_1 + 0.759375000000025*G0_0_1_19_1_1 + 0.0542410714285711*G0_1_0_0_0_0 + 0.054241071428571*G0_1_0_0_0_1 - 0.0542410714285697*G0_1_0_1_0_0 - 0.108482142857144*G0_1_0_2_0_1 + 0.108482142857156*G0_1_0_3_0_0 - 0.16272321428571*G0_1_0_3_0_1 + 0.108482142857153*G0_1_0_4_0_0 + 0.433928571428592*G0_1_0_4_0_1 - 0.108482142857154*G0_1_0_5_0_0 - 0.271205357142866*G0_1_0_5_0_1 - 0.108482142857153*G0_1_0_6_0_0 + 0.32544642857144*G0_1_0_6_0_1 + 0.16272321428572*G0_1_0_7_0_0 + 0.325446428571433*G0_1_0_7_0_1 - 0.162723214285722*G0_1_0_8_0_0 + 0.16272321428571*G0_1_0_8_0_1 - 0.759375000000025*G0_1_0_9_0_1 + 0.0542410714285711*G0_1_0_10_1_0 + 0.054241071428571*G0_1_0_10_1_1 - 0.0542410714285697*G0_1_0_11_1_0 - 0.108482142857144*G0_1_0_12_1_1 + 0.108482142857156*G0_1_0_13_1_0 - 0.16272321428571*G0_1_0_13_1_1 + 0.108482142857153*G0_1_0_14_1_0 + 0.433928571428592*G0_1_0_14_1_1 - 0.108482142857154*G0_1_0_15_1_0 - 0.271205357142866*G0_1_0_15_1_1 - 0.108482142857153*G0_1_0_16_1_0 + 0.32544642857144*G0_1_0_16_1_1 + 0.16272321428572*G0_1_0_17_1_0 + 0.325446428571433*G0_1_0_17_1_1 - 0.162723214285722*G0_1_0_18_1_0 + 0.16272321428571*G0_1_0_18_1_1 - 0.759375000000025*G0_1_0_19_1_1;
    A[108] = -A[313] - 0.608705357142865*G0_0_0_0_0_0 - 0.608705357142865*G0_0_0_0_0_1 + 0.445982142857152*G0_0_0_1_0_0 - 0.25915178571429*G0_0_0_2_0_1 - 0.325446428571431*G0_0_0_3_0_0 - 0.108482142857141*G0_0_0_3_0_1 + 0.27120535714287*G0_0_0_4_0_0 + 0.759375000000022*G0_0_0_4_0_1 - 1.51875000000005*G0_0_0_5_0_0 - 0.379687500000025*G0_0_0_5_0_1 - 0.271205357142871*G0_0_0_6_0_0 + 1.24754464285718*G0_0_0_6_0_1 + 2.11540178571432*G0_0_0_7_0_0 + 0.976339285714289*G0_0_0_7_0_1 - 1.9526785714286*G0_0_0_8_0_0 + 0.108482142857141*G0_0_0_8_0_1 + 1.84419642857148*G0_0_0_9_0_0 - 1.73571428571431*G0_0_0_9_0_1 - 0.608705357142865*G0_0_0_10_1_0 - 0.608705357142865*G0_0_0_10_1_1 + 0.445982142857152*G0_0_0_11_1_0 - 0.25915178571429*G0_0_0_12_1_1 - 0.325446428571431*G0_0_0_13_1_0 - 0.108482142857141*G0_0_0_13_1_1 + 0.27120535714287*G0_0_0_14_1_0 + 0.759375000000022*G0_0_0_14_1_1 - 1.51875000000005*G0_0_0_15_1_0 - 0.379687500000025*G0_0_0_15_1_1 - 0.271205357142871*G0_0_0_16_1_0 + 1.24754464285718*G0_0_0_16_1_1 + 2.11540178571432*G0_0_0_17_1_0 + 0.976339285714289*G0_0_0_17_1_1 - 1.9526785714286*G0_0_0_18_1_0 + 0.108482142857141*G0_0_0_18_1_1 + 1.84419642857148*G0_0_0_19_1_0 - 1.73571428571431*G0_0_0_19_1_1 + 0.705133928571434*G0_1_0_0_0_0 + 0.705133928571434*G0_1_0_0_0_1 - 0.108482142857143*G0_1_0_2_0_1 - 0.162723214285706*G0_1_0_3_0_0 + 0.325446428571444*G0_1_0_4_0_0 + 0.271205357142876*G0_1_0_4_0_1 - 0.379687500000025*G0_1_0_5_0_0 - 1.51875000000002*G0_1_0_5_0_1 - 0.325446428571444*G0_1_0_6_0_0 + 0.922098214285733*G0_1_0_6_0_1 - 0.867857142857152*G0_1_0_7_0_0 + 0.271205357142846*G0_1_0_7_0_1 + 0.162723214285717*G0_1_0_8_0_0 + 0.542410714285731*G0_1_0_9_0_0 - 0.542410714285723*G0_1_0_9_0_1 + 0.705133928571434*G0_1_0_10_1_0 + 0.705133928571434*G0_1_0_10_1_1 - 0.108482142857143*G0_1_0_12_1_1 - 0.162723214285706*G0_1_0_13_1_0 + 0.325446428571444*G0_1_0_14_1_0 + 0.271205357142876*G0_1_0_14_1_1 - 0.379687500000025*G0_1_0_15_1_0 - 1.51875000000002*G0_1_0_15_1_1 - 0.325446428571444*G0_1_0_16_1_0 + 0.922098214285733*G0_1_0_16_1_1 - 0.867857142857152*G0_1_0_17_1_0 + 0.271205357142846*G0_1_0_17_1_1 + 0.162723214285717*G0_1_0_18_1_0 + 0.542410714285731*G0_1_0_19_1_0 - 0.542410714285723*G0_1_0_19_1_1;
    A[278] = A[108] + 0.650892857142863*G0_0_0_0_0_0 + 0.650892857142863*G0_0_0_0_0_1 - 0.976339285714293*G0_0_0_1_0_0 - 0.108482142857159*G0_0_0_3_0_0 - 1.19330357142858*G0_0_0_3_0_1 + 0.108482142857127*G0_0_0_4_0_1 - 0.108482142857126*G0_0_0_5_0_0 - 0.54241071428571*G0_0_0_5_0_1 - 0.108482142857159*G0_0_0_6_0_1 - 2.27812500000002*G0_0_0_7_0_0 - 1.84419642857144*G0_0_0_7_0_1 + 2.60357142857145*G0_0_0_8_0_0 + 1.19330357142858*G0_0_0_8_0_1 + 0.216964285714285*G0_0_0_9_0_0 + 1.73571428571431*G0_0_0_9_0_1 + 0.650892857142863*G0_0_0_10_1_0 + 0.650892857142863*G0_0_0_10_1_1 - 0.976339285714293*G0_0_0_11_1_0 - 0.108482142857159*G0_0_0_13_1_0 - 1.19330357142858*G0_0_0_13_1_1 + 0.108482142857127*G0_0_0_14_1_1 - 0.108482142857126*G0_0_0_15_1_0 - 0.54241071428571*G0_0_0_15_1_1 - 0.108482142857159*G0_0_0_16_1_1 - 2.27812500000002*G0_0_0_17_1_0 - 1.84419642857144*G0_0_0_17_1_1 + 2.60357142857145*G0_0_0_18_1_0 + 1.19330357142858*G0_0_0_18_1_1 + 0.216964285714285*G0_0_0_19_1_0 + 1.73571428571431*G0_0_0_19_1_1 + 0.13258928571429*G0_0_1_0_0_0 + 0.13258928571429*G0_0_1_0_0_1 - 0.891964285714291*G0_0_1_1_0_0 - 0.0241071428571424*G0_0_1_2_0_1 - 1.84419642857144*G0_0_1_3_0_0 - 2.38660714285715*G0_0_1_3_0_1 - 0.325446428571435*G0_0_1_4_0_1 - 0.54241071428572*G0_0_1_5_0_0 - 0.216964285714292*G0_0_1_5_0_1 + 0.108482142857145*G0_0_1_6_0_1 - 0.433928571428585*G0_0_1_7_0_0 - 0.759375000000012*G0_0_1_7_0_1 + 1.19330357142858*G0_0_1_8_0_0 + 2.38660714285715*G0_0_1_8_0_1 + 2.38660714285716*G0_0_1_9_0_0 + 1.08482142857145*G0_0_1_9_0_1 + 0.13258928571429*G0_0_1_10_1_0 + 0.13258928571429*G0_0_1_10_1_1 - 0.891964285714291*G0_0_1_11_1_0 - 0.0241071428571424*G0_0_1_12_1_1 - 1.84419642857144*G0_0_1_13_1_0 - 2.38660714285715*G0_0_1_13_1_1 - 0.325446428571435*G0_0_1_14_1_1 - 0.54241071428572*G0_0_1_15_1_0 - 0.216964285714292*G0_0_1_15_1_1 + 0.108482142857145*G0_0_1_16_1_1 - 0.433928571428585*G0_0_1_17_1_0 - 0.759375000000012*G0_0_1_17_1_1 + 1.19330357142858*G0_0_1_18_1_0 + 2.38660714285715*G0_0_1_18_1_1 + 2.38660714285716*G0_0_1_19_1_0 + 1.08482142857145*G0_0_1_19_1_1 - 0.192857142857142*G0_1_0_0_0_0 - 0.192857142857143*G0_1_0_0_0_1 - 2.79040178571431*G0_1_0_1_0_0 - 0.349553571428573*G0_1_0_2_0_1 - 1.03058035714286*G0_1_0_3_0_0 - 5.26138392857146*G0_1_0_3_0_1 - 0.108482142857147*G0_1_0_4_0_0 + 1.68147321428572*G0_1_0_4_0_1 - 0.379687499999988*G0_1_0_5_0_0 + 1.03058035714287*G0_1_0_5_0_1 + 0.108482142857147*G0_1_0_6_0_0 - 0.488169642857153*G0_1_0_6_0_1 - 1.13906250000001*G0_1_0_7_0_0 - 2.54933035714287*G0_1_0_7_0_1 + 4.12232142857146*G0_1_0_8_0_0 + 5.26138392857146*G0_1_0_8_0_1 + 1.41026785714285*G0_1_0_9_0_0 + 0.867857142857146*G0_1_0_9_0_1 - 0.192857142857142*G0_1_0_10_1_0 - 0.192857142857143*G0_1_0_10_1_1 - 2.79040178571431*G0_1_0_11_1_0 - 0.349553571428573*G0_1_0_12_1_1 - 1.03058035714286*G0_1_0_13_1_0 - 5.26138392857146*G0_1_0_13_1_1 - 0.108482142857147*G0_1_0_14_1_0 + 1.68147321428572*G0_1_0_14_1_1 - 0.379687499999988*G0_1_0_15_1_0 + 1.03058035714287*G0_1_0_15_1_1 + 0.108482142857147*G0_1_0_16_1_0 - 0.488169642857153*G0_1_0_16_1_1 - 1.13906250000001*G0_1_0_17_1_0 - 2.54933035714287*G0_1_0_17_1_1 + 4.12232142857146*G0_1_0_18_1_0 + 5.26138392857146*G0_1_0_18_1_1 + 1.41026785714285*G0_1_0_19_1_0 + 0.867857142857146*G0_1_0_19_1_1 + 0.548437500000005*G0_1_1_0_0_0 + 0.548437500000004*G0_1_1_0_0_1 - 3.96562500000003*G0_1_1_1_0_0 - 0.602678571428578*G0_1_1_2_0_1 - 2.54933035714286*G0_1_1_3_0_0 - 8.13616071428577*G0_1_1_3_0_1 + 0.325446428571429*G0_1_1_4_0_0 + 2.54933035714288*G0_1_1_4_0_1 - 0.379687500000002*G0_1_1_5_0_0 - 0.216964285714289*G0_1_1_5_0_1 - 0.32544642857143*G0_1_1_6_0_0 + 0.271205357142863*G0_1_1_6_0_1 - 1.84419642857144*G0_1_1_7_0_0 - 2.00691964285715*G0_1_1_7_0_1 + 5.26138392857146*G0_1_1_8_0_0 + 8.13616071428577*G0_1_1_8_0_1 + 2.92901785714286*G0_1_1_9_0_0 - 0.542410714285729*G0_1_1_9_0_1 + 0.548437500000005*G0_1_1_10_1_0 + 0.548437500000004*G0_1_1_10_1_1 - 3.96562500000003*G0_1_1_11_1_0 - 0.602678571428578*G0_1_1_12_1_1 - 2.54933035714286*G0_1_1_13_1_0 - 8.13616071428577*G0_1_1_13_1_1 + 0.325446428571429*G0_1_1_14_1_0 + 2.54933035714288*G0_1_1_14_1_1 - 0.379687500000002*G0_1_1_15_1_0 - 0.216964285714289*G0_1_1_15_1_1 - 0.32544642857143*G0_1_1_16_1_0 + 0.271205357142863*G0_1_1_16_1_1 - 1.84419642857144*G0_1_1_17_1_0 - 2.00691964285715*G0_1_1_17_1_1 + 5.26138392857146*G0_1_1_18_1_0 + 8.13616071428577*G0_1_1_18_1_1 + 2.92901785714286*G0_1_1_19_1_0 - 0.542410714285729*G0_1_1_19_1_1;
    A[273] = -A[278] - 0.114508928571438*G0_0_0_0_0_0 - 0.114508928571438*G0_0_0_0_0_1 - 0.156696428571421*G0_0_0_1_0_0 + 0.439955357142871*G0_0_0_2_0_1 + 2.16964285714284*G0_0_0_3_0_0 + 0.542410714285713*G0_0_0_3_0_1 + 2.22388392857147*G0_0_0_4_0_0 + 3.2544642857143*G0_0_0_4_0_1 - 0.325446428571431*G0_0_0_5_0_0 - 0.162723214285706*G0_0_0_5_0_1 - 2.22388392857147*G0_0_0_6_0_0 - 0.162723214285727*G0_0_0_6_0_1 - 0.27120535714283*G0_0_0_7_0_0 - 0.433928571428554*G0_0_0_7_0_1 + 0.542410714285688*G0_0_0_8_0_0 - 0.542410714285712*G0_0_0_8_0_1 - 1.84419642857141*G0_0_0_9_0_0 - 2.82053571428575*G0_0_0_9_0_1 - 0.114508928571438*G0_0_0_10_1_0 - 0.114508928571438*G0_0_0_10_1_1 - 0.156696428571421*G0_0_0_11_1_0 + 0.439955357142871*G0_0_0_12_1_1 + 2.16964285714284*G0_0_0_13_1_0 + 0.542410714285713*G0_0_0_13_1_1 + 2.22388392857147*G0_0_0_14_1_0 + 3.2544642857143*G0_0_0_14_1_1 - 0.325446428571431*G0_0_0_15_1_0 - 0.162723214285706*G0_0_0_15_1_1 - 2.22388392857147*G0_0_0_16_1_0 - 0.162723214285727*G0_0_0_16_1_1 - 0.27120535714283*G0_0_0_17_1_0 - 0.433928571428554*G0_0_0_17_1_1 + 0.542410714285688*G0_0_0_18_1_0 - 0.542410714285712*G0_0_0_18_1_1 - 1.84419642857141*G0_0_0_19_1_0 - 2.82053571428575*G0_0_0_19_1_1 + 0.32544642857143*G0_1_0_0_0_0 + 0.32544642857143*G0_1_0_0_0_1 - 1.84419642857145*G0_1_0_1_0_0 - 0.325446428571429*G0_1_0_2_0_1 + 0.542410714285712*G0_1_0_3_0_0 - 2.7120535714286*G0_1_0_3_0_1 + 0.108482142857145*G0_1_0_4_0_0 + 1.84419642857144*G0_1_0_4_0_1 - 0.10848214285714*G0_1_0_5_0_0 - 0.108482142857145*G0_1_0_6_0_0 - 1.7357142857143*G0_1_0_7_0_0 - 1.84419642857144*G0_1_0_7_0_1 + 3.25446428571431*G0_1_0_8_0_0 + 2.7120535714286*G0_1_0_8_0_1 - 0.433928571428572*G0_1_0_9_0_0 + 0.32544642857143*G0_1_0_10_1_0 + 0.32544642857143*G0_1_0_10_1_1 - 1.84419642857145*G0_1_0_11_1_0 - 0.325446428571429*G0_1_0_12_1_1 + 0.542410714285712*G0_1_0_13_1_0 - 2.7120535714286*G0_1_0_13_1_1 + 0.108482142857145*G0_1_0_14_1_0 + 1.84419642857144*G0_1_0_14_1_1 - 0.10848214285714*G0_1_0_15_1_0 - 0.108482142857145*G0_1_0_16_1_0 - 1.7357142857143*G0_1_0_17_1_0 - 1.84419642857144*G0_1_0_17_1_1 + 3.25446428571431*G0_1_0_18_1_0 + 2.7120535714286*G0_1_0_18_1_1 - 0.433928571428572*G0_1_0_19_1_0;
    A[357] = A[273] - 2.06116071428573*G0_0_0_0_0_0 - 2.06116071428573*G0_0_0_0_0_1 + 0.433928571428576*G0_0_0_1_0_0 - 2.27812500000001*G0_0_0_3_0_0 - 0.43392857142856*G0_0_0_3_0_1 - 2.16964285714289*G0_0_0_4_0_0 - 3.57991071428576*G0_0_0_4_0_1 - 2.27812500000003*G0_0_0_5_0_0 + 2.82053571428573*G0_0_0_5_0_1 + 2.16964285714289*G0_0_0_6_0_0 - 0.759375*G0_0_0_6_0_1 + 2.38660714285714*G0_0_0_7_0_0 - 2.71205357142861*G0_0_0_7_0_1 - 0.759374999999992*G0_0_0_8_0_0 + 0.433928571428559*G0_0_0_8_0_1 + 4.55625000000003*G0_0_0_9_0_0 + 6.29196428571437*G0_0_0_9_0_1 - 2.06116071428573*G0_0_0_10_1_0 - 2.06116071428573*G0_0_0_10_1_1 + 0.433928571428576*G0_0_0_11_1_0 - 2.27812500000001*G0_0_0_13_1_0 - 0.43392857142856*G0_0_0_13_1_1 - 2.16964285714289*G0_0_0_14_1_0 - 3.57991071428576*G0_0_0_14_1_1 - 2.27812500000003*G0_0_0_15_1_0 + 2.82053571428573*G0_0_0_15_1_1 + 2.16964285714289*G0_0_0_16_1_0 - 0.759375*G0_0_0_16_1_1 + 2.38660714285714*G0_0_0_17_1_0 - 2.71205357142861*G0_0_0_17_1_1 - 0.759374999999992*G0_0_0_18_1_0 + 0.433928571428559*G0_0_0_18_1_1 + 4.55625000000003*G0_0_0_19_1_0 + 6.29196428571437*G0_0_0_19_1_1 + 0.705133928571431*G0_0_1_0_0_0 + 0.705133928571431*G0_0_1_0_0_1 - 0.596651785714283*G0_0_1_1_0_0 + 0.216964285714294*G0_0_1_2_0_1 - 0.759374999999999*G0_0_1_3_0_0 - 0.705133928571412*G0_0_1_3_0_1 - 0.867857142857163*G0_0_1_4_0_1 - 0.325446428571427*G0_0_1_5_0_0 - 0.705133928571424*G0_0_1_5_0_1 - 0.216964285714301*G0_0_1_6_0_1 - 2.44084821428574*G0_0_1_7_0_0 - 2.06116071428574*G0_0_1_7_0_1 + 2.33236607142859*G0_0_1_8_0_0 + 0.705133928571412*G0_0_1_8_0_1 + 1.08482142857143*G0_0_1_9_0_0 + 2.92901785714291*G0_0_1_9_0_1 + 0.705133928571431*G0_0_1_10_1_0 + 0.705133928571431*G0_0_1_10_1_1 - 0.596651785714283*G0_0_1_11_1_0 + 0.216964285714294*G0_0_1_12_1_1 - 0.759374999999999*G0_0_1_13_1_0 - 0.705133928571412*G0_0_1_13_1_1 - 0.867857142857163*G0_0_1_14_1_1 - 0.325446428571427*G0_0_1_15_1_0 - 0.705133928571424*G0_0_1_15_1_1 - 0.216964285714301*G0_0_1_16_1_1 - 2.44084821428574*G0_0_1_17_1_0 - 2.06116071428574*G0_0_1_17_1_1 + 2.33236607142859*G0_0_1_18_1_0 + 0.705133928571412*G0_0_1_18_1_1 + 1.08482142857143*G0_0_1_19_1_0 + 2.92901785714291*G0_0_1_19_1_1 + 0.705133928571431*G0_1_0_0_0_0 + 0.705133928571431*G0_1_0_0_0_1 - 0.596651785714283*G0_1_0_1_0_0 + 0.216964285714294*G0_1_0_2_0_1 - 0.759374999999999*G0_1_0_3_0_0 - 0.705133928571412*G0_1_0_3_0_1 - 0.867857142857163*G0_1_0_4_0_1 - 0.325446428571427*G0_1_0_5_0_0 - 0.705133928571424*G0_1_0_5_0_1 - 0.216964285714301*G0_1_0_6_0_1 - 2.44084821428574*G0_1_0_7_0_0 - 2.06116071428574*G0_1_0_7_0_1 + 2.33236607142859*G0_1_0_8_0_0 + 0.705133928571413*G0_1_0_8_0_1 + 1.08482142857143*G0_1_0_9_0_0 + 2.92901785714291*G0_1_0_9_0_1 + 0.705133928571431*G0_1_0_10_1_0 + 0.705133928571431*G0_1_0_10_1_1 - 0.596651785714283*G0_1_0_11_1_0 + 0.216964285714294*G0_1_0_12_1_1 - 0.759374999999999*G0_1_0_13_1_0 - 0.705133928571412*G0_1_0_13_1_1 - 0.867857142857163*G0_1_0_14_1_1 - 0.325446428571427*G0_1_0_15_1_0 - 0.705133928571424*G0_1_0_15_1_1 - 0.216964285714301*G0_1_0_16_1_1 - 2.44084821428574*G0_1_0_17_1_0 - 2.06116071428574*G0_1_0_17_1_1 + 2.33236607142859*G0_1_0_18_1_0 + 0.705133928571413*G0_1_0_18_1_1 + 1.08482142857143*G0_1_0_19_1_0 + 2.92901785714291*G0_1_0_19_1_1 - 0.108482142857147*G0_1_1_0_0_0 - 0.108482142857147*G0_1_1_0_0_1 - 3.57991071428574*G0_1_1_1_0_0 - 0.108482142857136*G0_1_1_2_0_1 - 1.19330357142857*G0_1_1_3_0_0 - 6.18348214285717*G0_1_1_3_0_1 + 0.108482142857145*G0_1_1_4_0_0 + 1.62723214285714*G0_1_1_4_0_1 - 1.41026785714285*G0_1_1_5_0_0 + 1.08482142857146*G0_1_1_5_0_1 - 0.108482142857145*G0_1_1_6_0_0 - 0.867857142857173*G0_1_1_6_0_1 - 3.03750000000003*G0_1_1_7_0_0 - 5.53258928571434*G0_1_1_7_0_1 + 6.72589285714291*G0_1_1_8_0_0 + 6.18348214285717*G0_1_1_8_0_1 + 2.60357142857142*G0_1_1_9_0_0 + 3.90535714285719*G0_1_1_9_0_1 - 0.108482142857147*G0_1_1_10_1_0 - 0.108482142857147*G0_1_1_10_1_1 - 3.57991071428574*G0_1_1_11_1_0 - 0.108482142857136*G0_1_1_12_1_1 - 1.19330357142857*G0_1_1_13_1_0 - 6.18348214285717*G0_1_1_13_1_1 + 0.108482142857145*G0_1_1_14_1_0 + 1.62723214285714*G0_1_1_14_1_1 - 1.41026785714285*G0_1_1_15_1_0 + 1.08482142857146*G0_1_1_15_1_1 - 0.108482142857145*G0_1_1_16_1_0 - 0.867857142857173*G0_1_1_16_1_1 - 3.03750000000003*G0_1_1_17_1_0 - 5.53258928571434*G0_1_1_17_1_1 + 6.72589285714291*G0_1_1_18_1_0 + 6.18348214285717*G0_1_1_18_1_1 + 2.60357142857142*G0_1_1_19_1_0 + 3.90535714285719*G0_1_1_19_1_1;
    A[315] = A[357] + 1.84419642857144*G0_0_0_0_0_0 + 1.84419642857145*G0_0_0_0_0_1 - 0.65089285714286*G0_0_0_1_0_0 - 1.62723214285717*G0_0_0_3_0_0 - 1.9526785714286*G0_0_0_3_0_1 + 2.16964285714289*G0_0_0_4_0_0 + 1.84419642857145*G0_0_0_4_0_1 - 1.62723214285716*G0_0_0_5_0_0 - 4.33928571428576*G0_0_0_5_0_1 - 2.16964285714289*G0_0_0_6_0_0 + 2.49508928571431*G0_0_0_6_0_1 - 2.16964285714286*G0_0_0_7_0_0 + 0.542410714285734*G0_0_0_7_0_1 + 0.976339285714277*G0_0_0_8_0_0 + 1.9526785714286*G0_0_0_8_0_1 + 3.25446428571433*G0_0_0_9_0_0 - 2.38660714285719*G0_0_0_9_0_1 + 1.84419642857144*G0_0_0_10_1_0 + 1.84419642857145*G0_0_0_10_1_1 - 0.65089285714286*G0_0_0_11_1_0 - 1.62723214285717*G0_0_0_13_1_0 - 1.9526785714286*G0_0_0_13_1_1 + 2.16964285714289*G0_0_0_14_1_0 + 1.84419642857145*G0_0_0_14_1_1 - 1.62723214285716*G0_0_0_15_1_0 - 4.33928571428576*G0_0_0_15_1_1 - 2.16964285714289*G0_0_0_16_1_0 + 2.49508928571431*G0_0_0_16_1_1 - 2.16964285714286*G0_0_0_17_1_0 + 0.542410714285734*G0_0_0_17_1_1 + 0.976339285714277*G0_0_0_18_1_0 + 1.9526785714286*G0_0_0_18_1_1 + 3.25446428571433*G0_0_0_19_1_0 - 2.38660714285719*G0_0_0_19_1_1 - 0.325446428571431*G0_0_1_1_0_0 + 0.325446428571432*G0_0_1_2_0_1 - 1.73571428571431*G0_0_1_3_0_0 - 2.06116071428574*G0_0_1_3_0_1 + 2.06116071428574*G0_0_1_4_0_0 + 1.73571428571431*G0_0_1_4_0_1 - 1.08482142857145*G0_0_1_5_0_0 - 1.08482142857145*G0_0_1_5_0_1 - 2.06116071428575*G0_0_1_6_0_0 + 0.759375000000015*G0_0_1_6_0_1 + 1.08482142857145*G0_0_1_7_0_0 + 1.08482142857145*G0_0_1_7_0_1 - 0.75937500000002*G0_0_1_8_0_0 + 2.06116071428574*G0_0_1_8_0_1 + 2.82053571428576*G0_0_1_9_0_0 - 2.82053571428576*G0_0_1_9_0_1 - 0.325446428571431*G0_0_1_11_1_0 + 0.325446428571432*G0_0_1_12_1_1 - 1.73571428571431*G0_0_1_13_1_0 - 2.06116071428574*G0_0_1_13_1_1 + 2.06116071428574*G0_0_1_14_1_0 + 1.73571428571431*G0_0_1_14_1_1 - 1.08482142857145*G0_0_1_15_1_0 - 1.08482142857145*G0_0_1_15_1_1 - 2.06116071428575*G0_0_1_16_1_0 + 0.759375000000015*G0_0_1_16_1_1 + 1.08482142857145*G0_0_1_17_1_0 + 1.08482142857145*G0_0_1_17_1_1 - 0.75937500000002*G0_0_1_18_1_0 + 2.06116071428574*G0_0_1_18_1_1 + 2.82053571428576*G0_0_1_19_1_0 - 2.82053571428576*G0_0_1_19_1_1 - 0.325446428571431*G0_1_0_1_0_0 + 0.325446428571432*G0_1_0_2_0_1 - 1.73571428571431*G0_1_0_3_0_0 - 2.06116071428574*G0_1_0_3_0_1 + 2.06116071428574*G0_1_0_4_0_0 + 1.73571428571431*G0_1_0_4_0_1 - 1.08482142857145*G0_1_0_5_0_0 - 1.08482142857145*G0_1_0_5_0_1 - 2.06116071428575*G0_1_0_6_0_0 + 0.759375000000015*G0_1_0_6_0_1 + 1.08482142857145*G0_1_0_7_0_0 + 1.08482142857145*G0_1_0_7_0_1 - 0.75937500000002*G0_1_0_8_0_0 + 2.06116071428574*G0_1_0_8_0_1 + 2.82053571428576*G0_1_0_9_0_0 - 2.82053571428576*G0_1_0_9_0_1 - 0.325446428571431*G0_1_0_11_1_0 + 0.325446428571432*G0_1_0_12_1_1 - 1.73571428571431*G0_1_0_13_1_0 - 2.06116071428574*G0_1_0_13_1_1 + 2.06116071428574*G0_1_0_14_1_0 + 1.73571428571431*G0_1_0_14_1_1 - 1.08482142857145*G0_1_0_15_1_0 - 1.08482142857145*G0_1_0_15_1_1 - 2.06116071428575*G0_1_0_16_1_0 + 0.759375000000015*G0_1_0_16_1_1 + 1.08482142857145*G0_1_0_17_1_0 + 1.08482142857145*G0_1_0_17_1_1 - 0.75937500000002*G0_1_0_18_1_0 + 2.06116071428574*G0_1_0_18_1_1 + 2.82053571428576*G0_1_0_19_1_0 - 2.82053571428576*G0_1_0_19_1_1 - 1.84419642857145*G0_1_1_0_0_0 - 1.84419642857145*G0_1_1_0_0_1 + 0.650892857142862*G0_1_1_2_0_1 - 1.84419642857145*G0_1_1_3_0_0 - 2.16964285714289*G0_1_1_3_0_1 + 1.9526785714286*G0_1_1_4_0_0 + 1.62723214285717*G0_1_1_4_0_1 - 0.54241071428573*G0_1_1_5_0_0 + 2.16964285714287*G0_1_1_5_0_1 - 1.9526785714286*G0_1_1_6_0_0 - 0.976339285714286*G0_1_1_6_0_1 + 4.33928571428577*G0_1_1_7_0_0 + 1.62723214285717*G0_1_1_7_0_1 - 2.49508928571432*G0_1_1_8_0_0 + 2.16964285714289*G0_1_1_8_0_1 + 2.38660714285718*G0_1_1_9_0_0 - 3.25446428571434*G0_1_1_9_0_1 - 1.84419642857145*G0_1_1_10_1_0 - 1.84419642857145*G0_1_1_10_1_1 + 0.650892857142862*G0_1_1_12_1_1 - 1.84419642857145*G0_1_1_13_1_0 - 2.16964285714289*G0_1_1_13_1_1 + 1.9526785714286*G0_1_1_14_1_0 + 1.62723214285717*G0_1_1_14_1_1 - 0.54241071428573*G0_1_1_15_1_0 + 2.16964285714287*G0_1_1_15_1_1 - 1.9526785714286*G0_1_1_16_1_0 - 0.976339285714286*G0_1_1_16_1_1 + 4.33928571428577*G0_1_1_17_1_0 + 1.62723214285717*G0_1_1_17_1_1 - 2.49508928571432*G0_1_1_18_1_0 + 2.16964285714289*G0_1_1_18_1_1 + 2.38660714285718*G0_1_1_19_1_0 - 3.25446428571434*G0_1_1_19_1_1;
    A[294] = A[315] + 0.108482142857144*G0_0_0_0_0_0 + 0.108482142857144*G0_0_0_0_0_1 + 0.108482142857139*G0_0_0_1_0_0 + 3.57991071428575*G0_0_0_2_0_1 - 1.62723214285715*G0_0_0_3_0_0 - 0.108482142857144*G0_0_0_3_0_1 + 6.18348214285719*G0_0_0_4_0_0 + 1.19330357142857*G0_0_0_4_0_1 + 5.53258928571435*G0_0_0_5_0_0 + 3.03750000000004*G0_0_0_5_0_1 - 6.18348214285719*G0_0_0_6_0_0 - 6.72589285714293*G0_0_0_6_0_1 - 1.08482142857145*G0_0_0_7_0_0 + 1.41026785714285*G0_0_0_7_0_1 + 0.867857142857169*G0_0_0_8_0_0 + 0.108482142857143*G0_0_0_8_0_1 - 3.90535714285719*G0_0_0_9_0_0 - 2.60357142857143*G0_0_0_9_0_1 + 0.108482142857144*G0_0_0_10_1_0 + 0.108482142857144*G0_0_0_10_1_1 + 0.108482142857139*G0_0_0_11_1_0 + 3.57991071428575*G0_0_0_12_1_1 - 1.62723214285715*G0_0_0_13_1_0 - 0.108482142857144*G0_0_0_13_1_1 + 6.18348214285719*G0_0_0_14_1_0 + 1.19330357142857*G0_0_0_14_1_1 + 5.53258928571435*G0_0_0_15_1_0 + 3.03750000000004*G0_0_0_15_1_1 - 6.18348214285719*G0_0_0_16_1_0 - 6.72589285714293*G0_0_0_16_1_1 - 1.08482142857145*G0_0_0_17_1_0 + 1.41026785714285*G0_0_0_17_1_1 + 0.867857142857169*G0_0_0_18_1_0 + 0.108482142857143*G0_0_0_18_1_1 - 3.90535714285719*G0_0_0_19_1_0 - 2.60357142857143*G0_0_0_19_1_1 - 0.705133928571433*G0_0_1_0_0_0 - 0.705133928571433*G0_0_1_0_0_1 - 0.216964285714293*G0_0_1_1_0_0 + 0.596651785714284*G0_0_1_2_0_1 + 0.867857142857163*G0_0_1_3_0_0 + 0.705133928571415*G0_0_1_4_0_0 + 0.759375000000001*G0_0_1_4_0_1 + 2.06116071428574*G0_0_1_5_0_0 + 2.44084821428574*G0_0_1_5_0_1 - 0.705133928571415*G0_0_1_6_0_0 - 2.33236607142859*G0_0_1_6_0_1 + 0.705133928571426*G0_0_1_7_0_0 + 0.325446428571427*G0_0_1_7_0_1 + 0.216964285714299*G0_0_1_8_0_0 - 2.92901785714291*G0_0_1_9_0_0 - 1.08482142857143*G0_0_1_9_0_1 - 0.705133928571433*G0_0_1_10_1_0 - 0.705133928571433*G0_0_1_10_1_1 - 0.216964285714293*G0_0_1_11_1_0 + 0.596651785714284*G0_0_1_12_1_1 + 0.867857142857163*G0_0_1_13_1_0 + 0.705133928571415*G0_0_1_14_1_0 + 0.759375000000001*G0_0_1_14_1_1 + 2.06116071428574*G0_0_1_15_1_0 + 2.44084821428574*G0_0_1_15_1_1 - 0.705133928571415*G0_0_1_16_1_0 - 2.33236607142859*G0_0_1_16_1_1 + 0.705133928571426*G0_0_1_17_1_0 + 0.325446428571427*G0_0_1_17_1_1 + 0.216964285714299*G0_0_1_18_1_0 - 2.92901785714291*G0_0_1_19_1_0 - 1.08482142857143*G0_0_1_19_1_1 - 0.705133928571433*G0_1_0_0_0_0 - 0.705133928571433*G0_1_0_0_0_1 - 0.216964285714293*G0_1_0_1_0_0 + 0.596651785714284*G0_1_0_2_0_1 + 0.867857142857163*G0_1_0_3_0_0 + 0.705133928571415*G0_1_0_4_0_0 + 0.759375000000001*G0_1_0_4_0_1 + 2.06116071428574*G0_1_0_5_0_0 + 2.44084821428574*G0_1_0_5_0_1 - 0.705133928571415*G0_1_0_6_0_0 - 2.33236607142859*G0_1_0_6_0_1 + 0.705133928571426*G0_1_0_7_0_0 + 0.325446428571427*G0_1_0_7_0_1 + 0.2169642857143*G0_1_0_8_0_0 - 2.92901785714291*G0_1_0_9_0_0 - 1.08482142857143*G0_1_0_9_0_1 - 0.705133928571433*G0_1_0_10_1_0 - 0.705133928571433*G0_1_0_10_1_1 - 0.216964285714293*G0_1_0_11_1_0 + 0.596651785714284*G0_1_0_12_1_1 + 0.867857142857163*G0_1_0_13_1_0 + 0.705133928571415*G0_1_0_14_1_0 + 0.759375000000001*G0_1_0_14_1_1 + 2.06116071428574*G0_1_0_15_1_0 + 2.44084821428574*G0_1_0_15_1_1 - 0.705133928571415*G0_1_0_16_1_0 - 2.33236607142859*G0_1_0_16_1_1 + 0.705133928571426*G0_1_0_17_1_0 + 0.325446428571427*G0_1_0_17_1_1 + 0.2169642857143*G0_1_0_18_1_0 - 2.92901785714291*G0_1_0_19_1_0 - 1.08482142857143*G0_1_0_19_1_1 + 2.06116071428573*G0_1_1_0_0_0 + 2.06116071428573*G0_1_1_0_0_1 - 0.433928571428579*G0_1_1_2_0_1 + 3.57991071428576*G0_1_1_3_0_0 + 2.16964285714288*G0_1_1_3_0_1 + 0.433928571428562*G0_1_1_4_0_0 + 2.27812500000002*G0_1_1_4_0_1 + 2.71205357142861*G0_1_1_5_0_0 - 2.38660714285715*G0_1_1_5_0_1 - 0.433928571428561*G0_1_1_6_0_0 + 0.759375000000001*G0_1_1_6_0_1 - 2.82053571428573*G0_1_1_7_0_0 + 2.27812500000002*G0_1_1_7_0_1 + 0.759375000000003*G0_1_1_8_0_0 - 2.16964285714288*G0_1_1_8_0_1 - 6.29196428571437*G0_1_1_9_0_0 - 4.55625000000004*G0_1_1_9_0_1 + 2.06116071428573*G0_1_1_10_1_0 + 2.06116071428573*G0_1_1_10_1_1 - 0.433928571428579*G0_1_1_12_1_1 + 3.57991071428576*G0_1_1_13_1_0 + 2.16964285714288*G0_1_1_13_1_1 + 0.433928571428562*G0_1_1_14_1_0 + 2.27812500000002*G0_1_1_14_1_1 + 2.71205357142861*G0_1_1_15_1_0 - 2.38660714285715*G0_1_1_15_1_1 - 0.433928571428561*G0_1_1_16_1_0 + 0.759375000000001*G0_1_1_16_1_1 - 2.82053571428573*G0_1_1_17_1_0 + 2.27812500000002*G0_1_1_17_1_1 + 0.759375000000003*G0_1_1_18_1_0 - 2.16964285714288*G0_1_1_18_1_1 - 6.29196428571437*G0_1_1_19_1_0 - 4.55625000000004*G0_1_1_19_1_1;
    A[378] = -A[278] - 0.765401785714298*G0_0_0_0_0_0 - 0.765401785714298*G0_0_0_0_0_1 + 1.68750000000002*G0_0_0_1_0_0 + 0.439955357142867*G0_0_0_2_0_1 + 0.542410714285688*G0_0_0_3_0_0 + 3.25446428571431*G0_0_0_3_0_1 + 0.0542410714285764*G0_0_0_4_0_0 - 1.41026785714289*G0_0_0_4_0_1 - 1.9526785714286*G0_0_0_5_0_0 + 0.162723214285717*G0_0_0_5_0_1 - 0.0542410714285763*G0_0_0_6_0_0 + 0.162723214285713*G0_0_0_6_0_1 + 0.705133928571446*G0_0_0_7_0_0 - 1.41026785714287*G0_0_0_7_0_1 - 1.62723214285717*G0_0_0_8_0_0 - 3.25446428571431*G0_0_0_8_0_1 + 1.41026785714291*G0_0_0_9_0_0 + 2.82053571428577*G0_0_0_9_0_1 - 0.765401785714298*G0_0_0_10_1_0 - 0.765401785714298*G0_0_0_10_1_1 + 1.68750000000002*G0_0_0_11_1_0 + 0.439955357142867*G0_0_0_12_1_1 + 0.542410714285688*G0_0_0_13_1_0 + 3.25446428571431*G0_0_0_13_1_1 + 0.0542410714285764*G0_0_0_14_1_0 - 1.41026785714289*G0_0_0_14_1_1 - 1.9526785714286*G0_0_0_15_1_0 + 0.162723214285717*G0_0_0_15_1_1 - 0.0542410714285763*G0_0_0_16_1_0 + 0.162723214285713*G0_0_0_16_1_1 + 0.705133928571446*G0_0_0_17_1_0 - 1.41026785714287*G0_0_0_17_1_1 - 1.62723214285717*G0_0_0_18_1_0 - 3.25446428571431*G0_0_0_18_1_1 + 1.41026785714291*G0_0_0_19_1_0 + 2.82053571428577*G0_0_0_19_1_1 - 0.325446428571431*G0_0_1_0_0_0 - 0.32544642857143*G0_0_1_0_0_1 + 1.84419642857145*G0_0_1_1_0_0 + 0.32544642857143*G0_0_1_2_0_1 - 0.542410714285712*G0_0_1_3_0_0 + 2.7120535714286*G0_0_1_3_0_1 - 0.108482142857146*G0_0_1_4_0_0 - 1.84419642857144*G0_0_1_4_0_1 + 0.108482142857141*G0_0_1_5_0_0 + 0.108482142857145*G0_0_1_6_0_0 + 1.7357142857143*G0_0_1_7_0_0 + 1.84419642857144*G0_0_1_7_0_1 - 3.25446428571431*G0_0_1_8_0_0 - 2.7120535714286*G0_0_1_8_0_1 + 0.433928571428571*G0_0_1_9_0_0 - 0.325446428571431*G0_0_1_10_1_0 - 0.32544642857143*G0_0_1_10_1_1 + 1.84419642857145*G0_0_1_11_1_0 + 0.32544642857143*G0_0_1_12_1_1 - 0.542410714285712*G0_0_1_13_1_0 + 2.7120535714286*G0_0_1_13_1_1 - 0.108482142857146*G0_0_1_14_1_0 - 1.84419642857144*G0_0_1_14_1_1 + 0.108482142857141*G0_0_1_15_1_0 + 0.108482142857145*G0_0_1_16_1_0 + 1.7357142857143*G0_0_1_17_1_0 + 1.84419642857144*G0_0_1_17_1_1 - 3.25446428571431*G0_0_1_18_1_0 - 2.7120535714286*G0_0_1_18_1_1 + 0.433928571428571*G0_0_1_19_1_0;
    A[63] = A[273];
    A[84] = A[294];
    A[373] = A[278] + 0.32544642857143*G0_0_1_0_0_0 + 0.32544642857143*G0_0_1_0_0_1 - 1.84419642857144*G0_0_1_1_0_0 - 0.325446428571429*G0_0_1_2_0_1 + 0.542410714285712*G0_0_1_3_0_0 - 2.7120535714286*G0_0_1_3_0_1 + 0.108482142857145*G0_0_1_4_0_0 + 1.84419642857144*G0_0_1_4_0_1 - 0.108482142857141*G0_0_1_5_0_0 - 0.108482142857145*G0_0_1_6_0_0 - 1.7357142857143*G0_0_1_7_0_0 - 1.84419642857144*G0_0_1_7_0_1 + 3.25446428571431*G0_0_1_8_0_0 + 2.7120535714286*G0_0_1_8_0_1 - 0.433928571428572*G0_0_1_9_0_0 + 0.32544642857143*G0_0_1_10_1_0 + 0.32544642857143*G0_0_1_10_1_1 - 1.84419642857144*G0_0_1_11_1_0 - 0.325446428571429*G0_0_1_12_1_1 + 0.542410714285712*G0_0_1_13_1_0 - 2.7120535714286*G0_0_1_13_1_1 + 0.108482142857145*G0_0_1_14_1_0 + 1.84419642857144*G0_0_1_14_1_1 - 0.108482142857141*G0_0_1_15_1_0 - 0.108482142857145*G0_0_1_16_1_0 - 1.7357142857143*G0_0_1_17_1_0 - 1.84419642857144*G0_0_1_17_1_1 + 3.25446428571431*G0_0_1_18_1_0 + 2.7120535714286*G0_0_1_18_1_1 - 0.433928571428572*G0_0_1_19_1_0 - 0.32544642857143*G0_1_0_0_0_0 - 0.32544642857143*G0_1_0_0_0_1 + 1.84419642857144*G0_1_0_1_0_0 + 0.325446428571429*G0_1_0_2_0_1 - 0.542410714285712*G0_1_0_3_0_0 + 2.7120535714286*G0_1_0_3_0_1 - 0.108482142857145*G0_1_0_4_0_0 - 1.84419642857144*G0_1_0_4_0_1 + 0.108482142857141*G0_1_0_5_0_0 + 0.108482142857145*G0_1_0_6_0_0 + 1.7357142857143*G0_1_0_7_0_0 + 1.84419642857144*G0_1_0_7_0_1 - 3.25446428571431*G0_1_0_8_0_0 - 2.7120535714286*G0_1_0_8_0_1 + 0.433928571428572*G0_1_0_9_0_0 - 0.32544642857143*G0_1_0_10_1_0 - 0.32544642857143*G0_1_0_10_1_1 + 1.84419642857144*G0_1_0_11_1_0 + 0.325446428571429*G0_1_0_12_1_1 - 0.542410714285712*G0_1_0_13_1_0 + 2.7120535714286*G0_1_0_13_1_1 - 0.108482142857145*G0_1_0_14_1_0 - 1.84419642857144*G0_1_0_14_1_1 + 0.108482142857141*G0_1_0_15_1_0 + 0.108482142857145*G0_1_0_16_1_0 + 1.7357142857143*G0_1_0_17_1_0 + 1.84419642857144*G0_1_0_17_1_1 - 3.25446428571431*G0_1_0_18_1_0 - 2.7120535714286*G0_1_0_18_1_1 + 0.433928571428572*G0_1_0_19_1_0;
    A[68] = A[278];
    A[376] = -A[65] - 0.120535714285718*G0_0_0_0_0_0 - 0.120535714285718*G0_0_0_0_0_1 + 0.174776785714291*G0_0_0_1_0_0 - 0.313392857142857*G0_0_0_2_0_1 + 0.379687500000012*G0_0_0_3_0_0 + 0.162723214285721*G0_0_0_3_0_1 + 0.705133928571458*G0_0_0_4_0_1 - 0.922098214285735*G0_0_0_5_0_0 - 0.596651785714299*G0_0_0_5_0_1 + 1.03058035714287*G0_0_0_6_0_1 + 0.705133928571446*G0_0_0_7_0_0 + 0.379687500000009*G0_0_0_7_0_1 - 0.759375000000019*G0_0_0_8_0_0 - 0.16272321428572*G0_0_0_8_0_1 + 0.542410714285724*G0_0_0_9_0_0 - 1.08482142857147*G0_0_0_9_0_1 - 0.120535714285718*G0_0_0_10_1_0 - 0.120535714285718*G0_0_0_10_1_1 + 0.174776785714291*G0_0_0_11_1_0 - 0.313392857142857*G0_0_0_12_1_1 + 0.379687500000012*G0_0_0_13_1_0 + 0.162723214285721*G0_0_0_13_1_1 + 0.705133928571458*G0_0_0_14_1_1 - 0.922098214285735*G0_0_0_15_1_0 - 0.596651785714299*G0_0_0_15_1_1 + 1.03058035714287*G0_0_0_16_1_1 + 0.705133928571446*G0_0_0_17_1_0 + 0.379687500000009*G0_0_0_17_1_1 - 0.759375000000019*G0_0_0_18_1_0 - 0.16272321428572*G0_0_0_18_1_1 + 0.542410714285724*G0_0_0_19_1_0 - 1.08482142857147*G0_0_0_19_1_1 - 0.162723214285715*G0_0_1_0_0_0 - 0.162723214285715*G0_0_1_0_0_1 - 0.325446428571432*G0_0_1_2_0_1 + 0.705133928571454*G0_0_1_3_0_0 - 0.108482142857133*G0_0_1_4_0_0 + 0.922098214285748*G0_0_1_4_0_1 + 0.0542410714285849*G0_0_1_5_0_0 + 0.108482142857133*G0_0_1_6_0_0 + 0.488169642857148*G0_0_1_6_0_1 + 0.867857142857161*G0_0_1_7_0_0 + 0.922098214285746*G0_0_1_7_0_1 - 0.705133928571447*G0_0_1_8_0_0 - 0.759375000000039*G0_0_1_9_0_0 - 1.84419642857149*G0_0_1_9_0_1 - 0.162723214285715*G0_0_1_10_1_0 - 0.162723214285715*G0_0_1_10_1_1 - 0.325446428571432*G0_0_1_12_1_1 + 0.705133928571454*G0_0_1_13_1_0 - 0.108482142857133*G0_0_1_14_1_0 + 0.922098214285748*G0_0_1_14_1_1 + 0.0542410714285849*G0_0_1_15_1_0 + 0.108482142857133*G0_0_1_16_1_0 + 0.488169642857148*G0_0_1_16_1_1 + 0.867857142857161*G0_0_1_17_1_0 + 0.922098214285746*G0_0_1_17_1_1 - 0.705133928571447*G0_0_1_18_1_0 - 0.759375000000039*G0_0_1_19_1_0 - 1.84419642857149*G0_0_1_19_1_1 - 0.108482142857144*G0_1_0_0_0_0 - 0.108482142857144*G0_1_0_0_0_1 - 0.271205357142858*G0_1_0_2_0_1 + 0.271205357142866*G0_1_0_3_0_0 - 0.379687499999998*G0_1_0_4_0_0 + 0.162723214285723*G0_1_0_4_0_1 - 0.271205357142854*G0_1_0_5_0_0 - 0.0542410714285692*G0_1_0_5_0_1 + 0.379687499999998*G0_1_0_6_0_0 + 0.433928571428571*G0_1_0_6_0_1 + 0.379687500000005*G0_1_0_7_0_0 + 0.16272321428572*G0_1_0_7_0_1 - 0.271205357142861*G0_1_0_8_0_0 - 0.325446428571444*G0_1_0_9_0_1 - 0.108482142857144*G0_1_0_10_1_0 - 0.108482142857144*G0_1_0_10_1_1 - 0.271205357142858*G0_1_0_12_1_1 + 0.271205357142866*G0_1_0_13_1_0 - 0.379687499999998*G0_1_0_14_1_0 + 0.162723214285723*G0_1_0_14_1_1 - 0.271205357142854*G0_1_0_15_1_0 - 0.0542410714285692*G0_1_0_15_1_1 + 0.379687499999998*G0_1_0_16_1_0 + 0.433928571428571*G0_1_0_16_1_1 + 0.379687500000005*G0_1_0_17_1_0 + 0.16272321428572*G0_1_0_17_1_1 - 0.271205357142861*G0_1_0_18_1_0 - 0.325446428571444*G0_1_0_19_1_1 + 0.162723214285713*G0_1_1_0_0_0 + 0.162723214285713*G0_1_1_0_0_1 - 0.162723214285714*G0_1_1_2_0_1 - 0.162723214285714*G0_1_1_4_0_0 - 0.325446428571427*G0_1_1_5_0_0 - 0.488169642857141*G0_1_1_5_0_1 + 0.162723214285715*G0_1_1_6_0_0 + 0.488169642857141*G0_1_1_6_0_1 - 0.162723214285715*G0_1_1_7_0_0 + 0.325446428571417*G0_1_1_9_0_0 + 0.162723214285713*G0_1_1_10_1_0 + 0.162723214285713*G0_1_1_10_1_1 - 0.162723214285714*G0_1_1_12_1_1 - 0.162723214285714*G0_1_1_14_1_0 - 0.325446428571427*G0_1_1_15_1_0 - 0.488169642857141*G0_1_1_15_1_1 + 0.162723214285715*G0_1_1_16_1_0 + 0.488169642857141*G0_1_1_16_1_1 - 0.162723214285715*G0_1_1_17_1_0 + 0.325446428571417*G0_1_1_19_1_0;
    A[144] = -A[376] + 0.162723214285715*G0_0_0_0_0_0 + 0.162723214285715*G0_0_0_0_0_1 - 0.162723214285715*G0_0_0_1_0_0 - 0.162723214285716*G0_0_0_3_0_1 - 0.162723214285716*G0_0_0_5_0_1 - 0.488169642857144*G0_0_0_7_0_0 - 0.325446428571427*G0_0_0_7_0_1 + 0.488169642857144*G0_0_0_8_0_0 + 0.162723214285716*G0_0_0_8_0_1 + 0.325446428571413*G0_0_0_9_0_1 + 0.162723214285715*G0_0_0_10_1_0 + 0.162723214285715*G0_0_0_10_1_1 - 0.162723214285715*G0_0_0_11_1_0 - 0.162723214285716*G0_0_0_13_1_1 - 0.162723214285716*G0_0_0_15_1_1 - 0.488169642857144*G0_0_0_17_1_0 - 0.325446428571427*G0_0_0_17_1_1 + 0.488169642857144*G0_0_0_18_1_0 + 0.162723214285716*G0_0_0_18_1_1 + 0.325446428571413*G0_0_0_19_1_1 - 0.162723214285716*G0_0_1_0_0_0 - 0.162723214285716*G0_0_1_0_0_1 - 0.325446428571431*G0_0_1_1_0_0 + 0.922098214285747*G0_0_1_3_0_0 - 0.108482142857132*G0_0_1_3_0_1 + 0.705133928571455*G0_0_1_4_0_1 + 0.922098214285747*G0_0_1_5_0_0 + 0.867857142857162*G0_0_1_5_0_1 - 0.705133928571448*G0_0_1_6_0_1 + 0.0542410714285857*G0_0_1_7_0_1 + 0.488169642857146*G0_0_1_8_0_0 + 0.108482142857131*G0_0_1_8_0_1 - 1.84419642857149*G0_0_1_9_0_0 - 0.75937500000004*G0_0_1_9_0_1 - 0.162723214285716*G0_0_1_10_1_0 - 0.162723214285716*G0_0_1_10_1_1 - 0.325446428571431*G0_0_1_11_1_0 + 0.922098214285747*G0_0_1_13_1_0 - 0.108482142857132*G0_0_1_13_1_1 + 0.705133928571455*G0_0_1_14_1_1 + 0.922098214285747*G0_0_1_15_1_0 + 0.867857142857162*G0_0_1_15_1_1 - 0.705133928571448*G0_0_1_16_1_1 + 0.0542410714285857*G0_0_1_17_1_1 + 0.488169642857146*G0_0_1_18_1_0 + 0.108482142857131*G0_0_1_18_1_1 - 1.84419642857149*G0_0_1_19_1_0 - 0.75937500000004*G0_0_1_19_1_1 - 0.108482142857145*G0_1_0_0_0_0 - 0.108482142857145*G0_1_0_0_0_1 - 0.271205357142859*G0_1_0_1_0_0 + 0.16272321428572*G0_1_0_3_0_0 - 0.379687500000001*G0_1_0_3_0_1 + 0.271205357142869*G0_1_0_4_0_1 + 0.162723214285721*G0_1_0_5_0_0 + 0.379687500000007*G0_1_0_5_0_1 - 0.271205357142865*G0_1_0_6_0_1 - 0.0542410714285697*G0_1_0_7_0_0 - 0.271205357142855*G0_1_0_7_0_1 + 0.433928571428573*G0_1_0_8_0_0 + 0.379687500000002*G0_1_0_8_0_1 - 0.325446428571441*G0_1_0_9_0_0 - 0.108482142857145*G0_1_0_10_1_0 - 0.108482142857145*G0_1_0_10_1_1 - 0.271205357142859*G0_1_0_11_1_0 + 0.16272321428572*G0_1_0_13_1_0 - 0.379687500000001*G0_1_0_13_1_1 + 0.271205357142869*G0_1_0_14_1_1 + 0.162723214285721*G0_1_0_15_1_0 + 0.379687500000007*G0_1_0_15_1_1 - 0.271205357142865*G0_1_0_16_1_1 - 0.0542410714285697*G0_1_0_17_1_0 - 0.271205357142855*G0_1_0_17_1_1 + 0.433928571428573*G0_1_0_18_1_0 + 0.379687500000002*G0_1_0_18_1_1 - 0.325446428571441*G0_1_0_19_1_0 - 0.120535714285719*G0_1_1_0_0_0 - 0.12053571428572*G0_1_1_0_0_1 - 0.313392857142856*G0_1_1_1_0_0 + 0.174776785714293*G0_1_1_2_0_1 + 0.705133928571457*G0_1_1_3_0_0 + 0.162723214285723*G0_1_1_4_0_0 + 0.37968750000001*G0_1_1_4_0_1 + 0.37968750000001*G0_1_1_5_0_0 + 0.705133928571448*G0_1_1_5_0_1 - 0.162723214285723*G0_1_1_6_0_0 - 0.759375000000022*G0_1_1_6_0_1 - 0.596651785714298*G0_1_1_7_0_0 - 0.922098214285737*G0_1_1_7_0_1 + 1.03058035714287*G0_1_1_8_0_0 - 1.08482142857147*G0_1_1_9_0_0 + 0.542410714285728*G0_1_1_9_0_1 - 0.120535714285719*G0_1_1_10_1_0 - 0.12053571428572*G0_1_1_10_1_1 - 0.313392857142856*G0_1_1_11_1_0 + 0.174776785714293*G0_1_1_12_1_1 + 0.705133928571457*G0_1_1_13_1_0 + 0.162723214285723*G0_1_1_14_1_0 + 0.37968750000001*G0_1_1_14_1_1 + 0.37968750000001*G0_1_1_15_1_0 + 0.705133928571448*G0_1_1_15_1_1 - 0.162723214285723*G0_1_1_16_1_0 - 0.759375000000022*G0_1_1_16_1_1 - 0.596651785714298*G0_1_1_17_1_0 - 0.922098214285737*G0_1_1_17_1_1 + 1.03058035714287*G0_1_1_18_1_0 - 1.08482142857147*G0_1_1_19_1_0 + 0.542410714285728*G0_1_1_19_1_1;
    A[87] = A[144] - 0.0542410714285714*G0_0_1_0_0_0 - 0.0542410714285714*G0_0_1_0_0_1 + 0.108482142857143*G0_0_1_1_0_0 + 0.0542410714285709*G0_0_1_2_0_1 - 0.433928571428595*G0_0_1_3_0_0 - 0.108482142857157*G0_0_1_3_0_1 + 0.162723214285713*G0_0_1_4_0_0 - 0.108482142857153*G0_0_1_4_0_1 - 0.325446428571434*G0_0_1_5_0_0 - 0.162723214285719*G0_0_1_5_0_1 - 0.162723214285713*G0_0_1_6_0_0 + 0.162723214285719*G0_0_1_6_0_1 + 0.271205357142866*G0_0_1_7_0_0 + 0.108482142857152*G0_0_1_7_0_1 - 0.325446428571437*G0_0_1_8_0_0 + 0.108482142857157*G0_0_1_8_0_1 + 0.759375000000029*G0_0_1_9_0_0 - 0.0542410714285714*G0_0_1_10_1_0 - 0.0542410714285714*G0_0_1_10_1_1 + 0.108482142857143*G0_0_1_11_1_0 + 0.0542410714285709*G0_0_1_12_1_1 - 0.433928571428595*G0_0_1_13_1_0 - 0.108482142857157*G0_0_1_13_1_1 + 0.162723214285713*G0_0_1_14_1_0 - 0.108482142857153*G0_0_1_14_1_1 - 0.325446428571434*G0_0_1_15_1_0 - 0.162723214285719*G0_0_1_15_1_1 - 0.162723214285713*G0_0_1_16_1_0 + 0.162723214285719*G0_0_1_16_1_1 + 0.271205357142866*G0_0_1_17_1_0 + 0.108482142857152*G0_0_1_17_1_1 - 0.325446428571437*G0_0_1_18_1_0 + 0.108482142857157*G0_0_1_18_1_1 + 0.759375000000029*G0_0_1_19_1_0 + 0.0542410714285714*G0_1_0_0_0_0 + 0.0542410714285714*G0_1_0_0_0_1 - 0.108482142857143*G0_1_0_1_0_0 - 0.0542410714285709*G0_1_0_2_0_1 + 0.433928571428595*G0_1_0_3_0_0 + 0.108482142857157*G0_1_0_3_0_1 - 0.162723214285713*G0_1_0_4_0_0 + 0.108482142857153*G0_1_0_4_0_1 + 0.325446428571434*G0_1_0_5_0_0 + 0.162723214285719*G0_1_0_5_0_1 + 0.162723214285713*G0_1_0_6_0_0 - 0.162723214285719*G0_1_0_6_0_1 - 0.271205357142866*G0_1_0_7_0_0 - 0.108482142857152*G0_1_0_7_0_1 + 0.325446428571437*G0_1_0_8_0_0 - 0.108482142857157*G0_1_0_8_0_1 - 0.759375000000028*G0_1_0_9_0_0 + 0.0542410714285714*G0_1_0_10_1_0 + 0.0542410714285714*G0_1_0_10_1_1 - 0.108482142857143*G0_1_0_11_1_0 - 0.0542410714285709*G0_1_0_12_1_1 + 0.433928571428595*G0_1_0_13_1_0 + 0.108482142857157*G0_1_0_13_1_1 - 0.162723214285713*G0_1_0_14_1_0 + 0.108482142857153*G0_1_0_14_1_1 + 0.325446428571434*G0_1_0_15_1_0 + 0.162723214285719*G0_1_0_15_1_1 + 0.162723214285713*G0_1_0_16_1_0 - 0.162723214285719*G0_1_0_16_1_1 - 0.271205357142866*G0_1_0_17_1_0 - 0.108482142857152*G0_1_0_17_1_1 + 0.325446428571437*G0_1_0_18_1_0 - 0.108482142857157*G0_1_0_18_1_1 - 0.759375000000028*G0_1_0_19_1_0;
    A[297] = A[87];
    A[127] = -A[87] + 0.705133928571434*G0_1_0_0_0_0 + 0.705133928571434*G0_1_0_0_0_1 - 0.10848214285714*G0_1_0_1_0_0 + 0.271205357142878*G0_1_0_3_0_0 + 0.325446428571449*G0_1_0_3_0_1 - 0.162723214285709*G0_1_0_4_0_1 + 0.271205357142849*G0_1_0_5_0_0 - 0.867857142857153*G0_1_0_5_0_1 + 0.162723214285716*G0_1_0_6_0_1 - 1.51875000000002*G0_1_0_7_0_0 - 0.379687500000024*G0_1_0_7_0_1 + 0.92209821428573*G0_1_0_8_0_0 - 0.325446428571448*G0_1_0_8_0_1 - 0.542410714285726*G0_1_0_9_0_0 + 0.542410714285732*G0_1_0_9_0_1 + 0.705133928571434*G0_1_0_10_1_0 + 0.705133928571434*G0_1_0_10_1_1 - 0.10848214285714*G0_1_0_11_1_0 + 0.271205357142878*G0_1_0_13_1_0 + 0.325446428571449*G0_1_0_13_1_1 - 0.162723214285709*G0_1_0_14_1_1 + 0.271205357142849*G0_1_0_15_1_0 - 0.867857142857153*G0_1_0_15_1_1 + 0.162723214285716*G0_1_0_16_1_1 - 1.51875000000002*G0_1_0_17_1_0 - 0.379687500000024*G0_1_0_17_1_1 + 0.92209821428573*G0_1_0_18_1_0 - 0.325446428571448*G0_1_0_18_1_1 - 0.542410714285726*G0_1_0_19_1_0 + 0.542410714285732*G0_1_0_19_1_1 - 0.608705357142866*G0_1_1_0_0_0 - 0.608705357142867*G0_1_1_0_0_1 - 0.259151785714288*G0_1_1_1_0_0 + 0.445982142857153*G0_1_1_2_0_1 + 0.759375000000025*G0_1_1_3_0_0 + 0.271205357142878*G0_1_1_3_0_1 - 0.108482142857142*G0_1_1_4_0_0 - 0.325446428571435*G0_1_1_4_0_1 + 0.976339285714288*G0_1_1_5_0_0 + 2.11540178571432*G0_1_1_5_0_1 + 0.108482142857143*G0_1_1_6_0_0 - 1.9526785714286*G0_1_1_6_0_1 - 0.379687500000024*G0_1_1_7_0_0 - 1.51875000000005*G0_1_1_7_0_1 + 1.24754464285718*G0_1_1_8_0_0 - 0.271205357142877*G0_1_1_8_0_1 - 1.73571428571431*G0_1_1_9_0_0 + 1.84419642857149*G0_1_1_9_0_1 - 0.608705357142866*G0_1_1_10_1_0 - 0.608705357142867*G0_1_1_10_1_1 - 0.259151785714288*G0_1_1_11_1_0 + 0.445982142857153*G0_1_1_12_1_1 + 0.759375000000025*G0_1_1_13_1_0 + 0.271205357142878*G0_1_1_13_1_1 - 0.108482142857142*G0_1_1_14_1_0 - 0.325446428571435*G0_1_1_14_1_1 + 0.976339285714288*G0_1_1_15_1_0 + 2.11540178571432*G0_1_1_15_1_1 + 0.108482142857143*G0_1_1_16_1_0 - 1.9526785714286*G0_1_1_16_1_1 - 0.379687500000024*G0_1_1_17_1_0 - 1.51875000000005*G0_1_1_17_1_1 + 1.24754464285718*G0_1_1_18_1_0 - 0.271205357142877*G0_1_1_18_1_1 - 1.73571428571431*G0_1_1_19_1_0 + 1.84419642857149*G0_1_1_19_1_1;
    A[146] = -A[144] + 0.705133928571434*G0_0_1_0_0_0 + 0.705133928571434*G0_0_1_0_0_1 - 0.10848214285714*G0_0_1_1_0_0 + 0.271205357142878*G0_0_1_3_0_0 + 0.325446428571449*G0_0_1_3_0_1 - 0.162723214285708*G0_0_1_4_0_1 + 0.271205357142849*G0_0_1_5_0_0 - 0.867857142857152*G0_0_1_5_0_1 + 0.162723214285717*G0_0_1_6_0_1 - 1.51875000000002*G0_0_1_7_0_0 - 0.379687500000024*G0_0_1_7_0_1 + 0.92209821428573*G0_0_1_8_0_0 - 0.325446428571448*G0_0_1_8_0_1 - 0.542410714285727*G0_0_1_9_0_0 + 0.542410714285732*G0_0_1_9_0_1 + 0.705133928571434*G0_0_1_10_1_0 + 0.705133928571434*G0_0_1_10_1_1 - 0.10848214285714*G0_0_1_11_1_0 + 0.271205357142878*G0_0_1_13_1_0 + 0.325446428571449*G0_0_1_13_1_1 - 0.162723214285708*G0_0_1_14_1_1 + 0.271205357142849*G0_0_1_15_1_0 - 0.867857142857152*G0_0_1_15_1_1 + 0.162723214285717*G0_0_1_16_1_1 - 1.51875000000002*G0_0_1_17_1_0 - 0.379687500000024*G0_0_1_17_1_1 + 0.92209821428573*G0_0_1_18_1_0 - 0.325446428571448*G0_0_1_18_1_1 - 0.542410714285727*G0_0_1_19_1_0 + 0.542410714285732*G0_0_1_19_1_1 - 0.608705357142866*G0_1_1_0_0_0 - 0.608705357142867*G0_1_1_0_0_1 - 0.259151785714288*G0_1_1_1_0_0 + 0.445982142857153*G0_1_1_2_0_1 + 0.759375000000025*G0_1_1_3_0_0 + 0.271205357142878*G0_1_1_3_0_1 - 0.108482142857142*G0_1_1_4_0_0 - 0.325446428571435*G0_1_1_4_0_1 + 0.976339285714288*G0_1_1_5_0_0 + 2.11540178571432*G0_1_1_5_0_1 + 0.108482142857143*G0_1_1_6_0_0 - 1.9526785714286*G0_1_1_6_0_1 - 0.379687500000024*G0_1_1_7_0_0 - 1.51875000000005*G0_1_1_7_0_1 + 1.24754464285718*G0_1_1_8_0_0 - 0.271205357142877*G0_1_1_8_0_1 - 1.73571428571431*G0_1_1_9_0_0 + 1.84419642857149*G0_1_1_9_0_1 - 0.608705357142866*G0_1_1_10_1_0 - 0.608705357142867*G0_1_1_10_1_1 - 0.259151785714288*G0_1_1_11_1_0 + 0.445982142857153*G0_1_1_12_1_1 + 0.759375000000025*G0_1_1_13_1_0 + 0.271205357142878*G0_1_1_13_1_1 - 0.108482142857142*G0_1_1_14_1_0 - 0.325446428571435*G0_1_1_14_1_1 + 0.976339285714288*G0_1_1_15_1_0 + 2.11540178571432*G0_1_1_15_1_1 + 0.108482142857143*G0_1_1_16_1_0 - 1.9526785714286*G0_1_1_16_1_1 - 0.379687500000024*G0_1_1_17_1_0 - 1.51875000000005*G0_1_1_17_1_1 + 1.24754464285718*G0_1_1_18_1_0 - 0.271205357142877*G0_1_1_18_1_1 - 1.73571428571431*G0_1_1_19_1_0 + 1.84419642857149*G0_1_1_19_1_1;
    A[276] = -A[376] + 0.150669642857147*G0_0_0_0_0_0 + 0.150669642857147*G0_0_0_0_0_1 + 0.445982142857151*G0_0_0_1_0_0 + 1.3138392857143*G0_0_0_2_0_1 - 2.22388392857147*G0_0_0_3_0_0 - 0.108482142857145*G0_0_0_3_0_1 + 2.27812500000004*G0_0_0_4_0_0 - 0.705133928571437*G0_0_0_4_0_1 - 0.271205357142871*G0_0_0_5_0_0 - 0.325446428571444*G0_0_0_5_0_1 - 2.27812500000004*G0_0_0_6_0_0 - 1.13906250000001*G0_0_0_6_0_1 - 0.542410714285722*G0_0_0_7_0_0 - 0.488169642857148*G0_0_0_7_0_1 - 0.0542410714285762*G0_0_0_8_0_0 + 0.108482142857145*G0_0_0_8_0_1 + 2.49508928571434*G0_0_0_9_0_0 + 1.19330357142859*G0_0_0_9_0_1 + 0.150669642857147*G0_0_0_10_1_0 + 0.150669642857147*G0_0_0_10_1_1 + 0.445982142857151*G0_0_0_11_1_0 + 1.3138392857143*G0_0_0_12_1_1 - 2.22388392857147*G0_0_0_13_1_0 - 0.108482142857145*G0_0_0_13_1_1 + 2.27812500000004*G0_0_0_14_1_0 - 0.705133928571437*G0_0_0_14_1_1 - 0.271205357142871*G0_0_0_15_1_0 - 0.325446428571444*G0_0_0_15_1_1 - 2.27812500000004*G0_0_0_16_1_0 - 1.13906250000001*G0_0_0_16_1_1 - 0.542410714285722*G0_0_0_17_1_0 - 0.488169642857148*G0_0_0_17_1_1 - 0.0542410714285762*G0_0_0_18_1_0 + 0.108482142857145*G0_0_0_18_1_1 + 2.49508928571434*G0_0_0_19_1_0 + 1.19330357142859*G0_0_0_19_1_1 - 0.108482142857142*G0_0_1_0_0_0 - 0.108482142857142*G0_0_1_0_0_1 + 0.705133928571438*G0_0_1_2_0_1 - 0.162723214285726*G0_0_1_3_0_0 + 1.13906250000001*G0_0_1_4_0_0 + 0.271205357142849*G0_0_1_4_0_1 + 1.24754464285718*G0_0_1_5_0_0 + 0.922098214285733*G0_0_1_5_0_1 - 1.13906250000001*G0_0_1_6_0_0 - 1.51875000000003*G0_0_1_6_0_1 - 0.0542410714285714*G0_0_1_7_0_0 + 0.271205357142877*G0_0_1_7_0_1 + 0.162723214285713*G0_0_1_8_0_0 - 1.08482142857145*G0_0_1_9_0_0 - 0.542410714285725*G0_0_1_9_0_1 - 0.108482142857142*G0_0_1_10_1_0 - 0.108482142857142*G0_0_1_10_1_1 + 0.705133928571438*G0_0_1_12_1_1 - 0.162723214285726*G0_0_1_13_1_0 + 1.13906250000001*G0_0_1_14_1_0 + 0.271205357142849*G0_0_1_14_1_1 + 1.24754464285718*G0_0_1_15_1_0 + 0.922098214285733*G0_0_1_15_1_1 - 1.13906250000001*G0_0_1_16_1_0 - 1.51875000000003*G0_0_1_16_1_1 - 0.0542410714285714*G0_0_1_17_1_0 + 0.271205357142877*G0_0_1_17_1_1 + 0.162723214285713*G0_0_1_18_1_0 - 1.08482142857145*G0_0_1_19_1_0 - 0.542410714285725*G0_0_1_19_1_1;
    A[85] = -A[276] - 0.45803571428572*G0_0_0_0_0_0 - 0.45803571428572*G0_0_0_0_0_1 + 0.45803571428572*G0_0_0_1_0_0 + 2.6276785714286*G0_0_0_2_0_1 - 1.9526785714286*G0_0_0_3_0_0 + 4.55625000000006*G0_0_0_4_0_0 + 0.43392857142858*G0_0_0_4_0_1 + 1.9526785714286*G0_0_0_5_0_0 + 1.95267857142859*G0_0_0_5_0_1 - 4.55625000000006*G0_0_0_6_0_0 - 4.12232142857148*G0_0_0_6_0_1 - 0.433928571428581*G0_0_0_9_0_1 - 0.45803571428572*G0_0_0_10_1_0 - 0.45803571428572*G0_0_0_10_1_1 + 0.45803571428572*G0_0_0_11_1_0 + 2.6276785714286*G0_0_0_12_1_1 - 1.9526785714286*G0_0_0_13_1_0 + 4.55625000000006*G0_0_0_14_1_0 + 0.43392857142858*G0_0_0_14_1_1 + 1.9526785714286*G0_0_0_15_1_0 + 1.95267857142859*G0_0_0_15_1_1 - 4.55625000000006*G0_0_0_16_1_0 - 4.12232142857148*G0_0_0_16_1_1 - 0.433928571428581*G0_0_0_19_1_1 - 0.337500000000006*G0_0_1_0_0_0 - 0.337500000000006*G0_0_1_0_0_1 + 0.0662946428571418*G0_0_1_1_0_0 + 1.96473214285717*G0_0_1_2_0_1 - 0.379687500000007*G0_0_1_3_0_0 + 0.162723214285713*G0_0_1_3_0_1 + 3.25446428571432*G0_0_1_4_0_0 + 0.813616071428579*G0_0_1_4_0_1 + 2.87477678571434*G0_0_1_5_0_0 + 2.33236607142861*G0_0_1_5_0_1 - 3.25446428571432*G0_0_1_6_0_0 - 3.95959821428578*G0_0_1_6_0_1 - 0.271205357142861*G0_0_1_7_0_0 + 0.271205357142862*G0_0_1_7_0_1 + 0.542410714285724*G0_0_1_8_0_0 - 0.162723214285713*G0_0_1_8_0_1 - 2.49508928571433*G0_0_1_9_0_0 - 1.08482142857144*G0_0_1_9_0_1 - 0.337500000000006*G0_0_1_10_1_0 - 0.337500000000006*G0_0_1_10_1_1 + 0.0662946428571418*G0_0_1_11_1_0 + 1.96473214285717*G0_0_1_12_1_1 - 0.379687500000007*G0_0_1_13_1_0 + 0.162723214285713*G0_0_1_13_1_1 + 3.25446428571432*G0_0_1_14_1_0 + 0.813616071428579*G0_0_1_14_1_1 + 2.87477678571434*G0_0_1_15_1_0 + 2.33236607142861*G0_0_1_15_1_1 - 3.25446428571432*G0_0_1_16_1_0 - 3.95959821428578*G0_0_1_16_1_1 - 0.271205357142861*G0_0_1_17_1_0 + 0.271205357142862*G0_0_1_17_1_1 + 0.542410714285724*G0_0_1_18_1_0 - 0.162723214285713*G0_0_1_18_1_1 - 2.49508928571433*G0_0_1_19_1_0 - 1.08482142857144*G0_0_1_19_1_1 - 0.391741071428579*G0_1_0_0_0_0 - 0.391741071428579*G0_1_0_0_0_1 + 0.120535714285714*G0_1_0_1_0_0 + 0.662946428571434*G0_1_0_2_0_1 + 0.922098214285739*G0_1_0_3_0_0 + 0.542410714285722*G0_1_0_3_0_1 + 1.30178571428573*G0_1_0_4_0_0 + 1.13906250000003*G0_1_0_4_0_1 + 1.57299107142859*G0_1_0_5_0_0 + 1.41026785714288*G0_1_0_5_0_1 - 1.30178571428573*G0_1_0_6_0_0 - 1.68147321428573*G0_1_0_6_0_1 + 0.542410714285726*G0_1_0_7_0_0 + 0.705133928571439*G0_1_0_7_0_1 - 0.271205357142862*G0_1_0_8_0_0 - 0.542410714285722*G0_1_0_8_0_1 - 2.49508928571433*G0_1_0_9_0_0 - 1.84419642857147*G0_1_0_9_0_1 - 0.391741071428579*G0_1_0_10_1_0 - 0.391741071428579*G0_1_0_10_1_1 + 0.120535714285714*G0_1_0_11_1_0 + 0.662946428571434*G0_1_0_12_1_1 + 0.922098214285739*G0_1_0_13_1_0 + 0.542410714285722*G0_1_0_13_1_1 + 1.30178571428573*G0_1_0_14_1_0 + 1.13906250000003*G0_1_0_14_1_1 + 1.57299107142859*G0_1_0_15_1_0 + 1.41026785714288*G0_1_0_15_1_1 - 1.30178571428573*G0_1_0_16_1_0 - 1.68147321428573*G0_1_0_16_1_1 + 0.542410714285726*G0_1_0_17_1_0 + 0.705133928571439*G0_1_0_17_1_1 - 0.271205357142862*G0_1_0_18_1_0 - 0.542410714285722*G0_1_0_18_1_1 - 2.49508928571433*G0_1_0_19_1_0 - 1.84419642857147*G0_1_0_19_1_1 - 0.325446428571433*G0_1_1_0_0_0 - 0.325446428571433*G0_1_1_0_0_1 + 0.0542410714285691*G0_1_1_1_0_0 + 0.433928571428574*G0_1_1_2_0_1 + 0.813616071428597*G0_1_1_3_0_0 + 0.271205357142857*G0_1_1_3_0_1 + 0.976339285714308*G0_1_1_4_0_0 + 1.13906250000004*G0_1_1_4_0_1 + 1.68147321428573*G0_1_1_5_0_0 + 1.24754464285715*G0_1_1_5_0_1 - 0.976339285714308*G0_1_1_6_0_0 - 1.35602678571429*G0_1_1_6_0_1 + 0.813616071428588*G0_1_1_7_0_0 + 1.24754464285717*G0_1_1_7_0_1 - 0.542410714285725*G0_1_1_8_0_0 - 0.271205357142857*G0_1_1_8_0_1 - 2.49508928571433*G0_1_1_9_0_0 - 2.38660714285721*G0_1_1_9_0_1 - 0.325446428571433*G0_1_1_10_1_0 - 0.325446428571433*G0_1_1_10_1_1 + 0.0542410714285691*G0_1_1_11_1_0 + 0.433928571428574*G0_1_1_12_1_1 + 0.813616071428597*G0_1_1_13_1_0 + 0.271205357142857*G0_1_1_13_1_1 + 0.976339285714308*G0_1_1_14_1_0 + 1.13906250000004*G0_1_1_14_1_1 + 1.68147321428573*G0_1_1_15_1_0 + 1.24754464285715*G0_1_1_15_1_1 - 0.976339285714308*G0_1_1_16_1_0 - 1.35602678571429*G0_1_1_16_1_1 + 0.813616071428588*G0_1_1_17_1_0 + 1.24754464285717*G0_1_1_17_1_1 - 0.542410714285725*G0_1_1_18_1_0 - 0.271205357142857*G0_1_1_18_1_1 - 2.49508928571433*G0_1_1_19_1_0 - 2.38660714285721*G0_1_1_19_1_1;
    A[64] = -A[276] - 0.307366071428583*G0_0_1_0_0_0 - 0.307366071428583*G0_0_1_0_0_1 - 0.235044642857139*G0_0_1_1_0_0 + 0.470089285714298*G0_0_1_2_0_1 + 2.82053571428573*G0_0_1_3_0_0 + 0.70513392857144*G0_0_1_3_0_1 + 1.84419642857145*G0_0_1_4_0_0 + 3.25446428571431*G0_0_1_4_0_1 + 1.73571428571433*G0_0_1_5_0_0 + 1.24754464285718*G0_0_1_5_0_1 - 1.84419642857145*G0_0_1_6_0_0 - 1.4102678571429*G0_0_1_6_0_1 + 0.271205357142878*G0_0_1_7_0_0 + 0.759375000000025*G0_0_1_7_0_1 + 0.271205357142843*G0_0_1_8_0_0 - 0.70513392857144*G0_0_1_8_0_1 - 4.55625000000006*G0_0_1_9_0_0 - 4.01383928571433*G0_0_1_9_0_1 - 0.307366071428583*G0_0_1_10_1_0 - 0.307366071428583*G0_0_1_10_1_1 - 0.235044642857139*G0_0_1_11_1_0 + 0.470089285714298*G0_0_1_12_1_1 + 2.82053571428573*G0_0_1_13_1_0 + 0.70513392857144*G0_0_1_13_1_1 + 1.84419642857145*G0_0_1_14_1_0 + 3.25446428571431*G0_0_1_14_1_1 + 1.73571428571433*G0_0_1_15_1_0 + 1.24754464285718*G0_0_1_15_1_1 - 1.84419642857145*G0_0_1_16_1_0 - 1.4102678571429*G0_0_1_16_1_1 + 0.271205357142878*G0_0_1_17_1_0 + 0.759375000000025*G0_0_1_17_1_1 + 0.271205357142843*G0_0_1_18_1_0 - 0.70513392857144*G0_0_1_18_1_1 - 4.55625000000006*G0_0_1_19_1_0 - 4.01383928571433*G0_0_1_19_1_1 - 0.150669642857147*G0_1_1_0_0_0 - 0.150669642857147*G0_1_1_0_0_1 - 1.3138392857143*G0_1_1_1_0_0 - 0.44598214285715*G0_1_1_2_0_1 + 0.70513392857144*G0_1_1_3_0_0 - 2.27812500000002*G0_1_1_3_0_1 + 0.108482142857146*G0_1_1_4_0_0 + 2.22388392857146*G0_1_1_4_0_1 + 0.488169642857149*G0_1_1_5_0_0 + 0.54241071428572*G0_1_1_5_0_1 - 0.108482142857146*G0_1_1_6_0_0 + 0.0542410714285783*G0_1_1_6_0_1 + 0.325446428571449*G0_1_1_7_0_0 + 0.271205357142878*G0_1_1_7_0_1 + 1.13906249999999*G0_1_1_8_0_0 + 2.27812500000002*G0_1_1_8_0_1 - 1.19330357142859*G0_1_1_9_0_0 - 2.49508928571434*G0_1_1_9_0_1 - 0.150669642857147*G0_1_1_10_1_0 - 0.150669642857147*G0_1_1_10_1_1 - 1.3138392857143*G0_1_1_11_1_0 - 0.44598214285715*G0_1_1_12_1_1 + 0.70513392857144*G0_1_1_13_1_0 - 2.27812500000002*G0_1_1_13_1_1 + 0.108482142857146*G0_1_1_14_1_0 + 2.22388392857146*G0_1_1_14_1_1 + 0.488169642857149*G0_1_1_15_1_0 + 0.54241071428572*G0_1_1_15_1_1 - 0.108482142857146*G0_1_1_16_1_0 + 0.0542410714285783*G0_1_1_16_1_1 + 0.325446428571449*G0_1_1_17_1_0 + 0.271205357142878*G0_1_1_17_1_1 + 1.13906249999999*G0_1_1_18_1_0 + 2.27812500000002*G0_1_1_18_1_1 - 1.19330357142859*G0_1_1_19_1_0 - 2.49508928571434*G0_1_1_19_1_1;
    A[333] = A[276] + 0.054241071428571*G0_0_1_1_0_0 - 0.650892857142868*G0_0_1_2_0_1 + 0.488169642857159*G0_0_1_3_0_0 + 0.162723214285717*G0_0_1_3_0_1 - 0.976339285714297*G0_0_1_4_0_0 + 0.0542410714285835*G0_0_1_4_0_1 - 0.813616071428588*G0_0_1_5_0_0 - 0.596651785714297*G0_0_1_5_0_1 + 0.976339285714297*G0_0_1_6_0_0 + 1.24754464285717*G0_0_1_6_0_1 + 0.379687500000008*G0_0_1_7_0_0 + 0.162723214285716*G0_0_1_7_0_1 - 0.433928571428578*G0_0_1_8_0_0 - 0.162723214285717*G0_0_1_8_0_1 + 0.32544642857143*G0_0_1_9_0_0 - 0.2169642857143*G0_0_1_9_0_1 + 0.054241071428571*G0_0_1_11_1_0 - 0.650892857142868*G0_0_1_12_1_1 + 0.488169642857159*G0_0_1_13_1_0 + 0.162723214285717*G0_0_1_13_1_1 - 0.976339285714297*G0_0_1_14_1_0 + 0.0542410714285835*G0_0_1_14_1_1 - 0.813616071428588*G0_0_1_15_1_0 - 0.596651785714297*G0_0_1_15_1_1 + 0.976339285714297*G0_0_1_16_1_0 + 1.24754464285717*G0_0_1_16_1_1 + 0.379687500000008*G0_0_1_17_1_0 + 0.162723214285716*G0_0_1_17_1_1 - 0.433928571428578*G0_0_1_18_1_0 - 0.162723214285717*G0_0_1_18_1_1 + 0.32544642857143*G0_0_1_19_1_0 - 0.2169642857143*G0_0_1_19_1_1 - 0.0542410714285709*G0_1_0_1_0_0 + 0.650892857142868*G0_1_0_2_0_1 - 0.488169642857159*G0_1_0_3_0_0 - 0.162723214285717*G0_1_0_3_0_1 + 0.976339285714297*G0_1_0_4_0_0 - 0.0542410714285836*G0_1_0_4_0_1 + 0.813616071428589*G0_1_0_5_0_0 + 0.596651785714297*G0_1_0_5_0_1 - 0.976339285714297*G0_1_0_6_0_0 - 1.24754464285717*G0_1_0_6_0_1 - 0.379687500000008*G0_1_0_7_0_0 - 0.162723214285716*G0_1_0_7_0_1 + 0.433928571428578*G0_1_0_8_0_0 + 0.162723214285717*G0_1_0_8_0_1 - 0.32544642857143*G0_1_0_9_0_0 + 0.2169642857143*G0_1_0_9_0_1 - 0.0542410714285709*G0_1_0_11_1_0 + 0.650892857142868*G0_1_0_12_1_1 - 0.488169642857159*G0_1_0_13_1_0 - 0.162723214285717*G0_1_0_13_1_1 + 0.976339285714297*G0_1_0_14_1_0 - 0.0542410714285836*G0_1_0_14_1_1 + 0.813616071428589*G0_1_0_15_1_0 + 0.596651785714297*G0_1_0_15_1_1 - 0.976339285714297*G0_1_0_16_1_0 - 1.24754464285717*G0_1_0_16_1_1 - 0.379687500000008*G0_1_0_17_1_0 - 0.162723214285716*G0_1_0_17_1_1 + 0.433928571428578*G0_1_0_18_1_0 + 0.162723214285717*G0_1_0_18_1_1 - 0.32544642857143*G0_1_0_19_1_0 + 0.2169642857143*G0_1_0_19_1_1;
    A[66] = A[276];
    A[104] = A[85] - 0.054241071428572*G0_0_1_0_0_0 - 0.0542410714285722*G0_0_1_0_0_1 - 0.650892857142867*G0_0_1_2_0_1 + 0.813616071428587*G0_0_1_3_0_0 + 0.216964285714292*G0_0_1_3_0_1 - 0.976339285714295*G0_0_1_4_0_0 + 0.271205357142867*G0_0_1_4_0_1 - 0.488169642857158*G0_0_1_5_0_0 - 0.325446428571439*G0_0_1_5_0_1 + 0.976339285714296*G0_0_1_6_0_0 + 1.03058035714288*G0_0_1_6_0_1 + 0.433928571428579*G0_0_1_7_0_0 + 0.271205357142861*G0_0_1_7_0_1 - 0.379687500000009*G0_0_1_8_0_0 - 0.216964285714292*G0_0_1_8_0_1 - 0.32544642857143*G0_0_1_9_0_0 - 0.542410714285728*G0_0_1_9_0_1 - 0.054241071428572*G0_0_1_10_1_0 - 0.0542410714285722*G0_0_1_10_1_1 - 0.650892857142867*G0_0_1_12_1_1 + 0.813616071428587*G0_0_1_13_1_0 + 0.216964285714292*G0_0_1_13_1_1 - 0.976339285714295*G0_0_1_14_1_0 + 0.271205357142867*G0_0_1_14_1_1 - 0.488169642857158*G0_0_1_15_1_0 - 0.325446428571439*G0_0_1_15_1_1 + 0.976339285714296*G0_0_1_16_1_0 + 1.03058035714288*G0_0_1_16_1_1 + 0.433928571428579*G0_0_1_17_1_0 + 0.271205357142861*G0_0_1_17_1_1 - 0.379687500000009*G0_0_1_18_1_0 - 0.216964285714292*G0_0_1_18_1_1 - 0.32544642857143*G0_0_1_19_1_0 - 0.542410714285728*G0_0_1_19_1_1 + 0.054241071428572*G0_1_0_0_0_0 + 0.0542410714285722*G0_1_0_0_0_1 + 0.650892857142867*G0_1_0_2_0_1 - 0.813616071428587*G0_1_0_3_0_0 - 0.216964285714292*G0_1_0_3_0_1 + 0.976339285714295*G0_1_0_4_0_0 - 0.271205357142867*G0_1_0_4_0_1 + 0.488169642857158*G0_1_0_5_0_0 + 0.325446428571439*G0_1_0_5_0_1 - 0.976339285714296*G0_1_0_6_0_0 - 1.03058035714288*G0_1_0_6_0_1 - 0.433928571428579*G0_1_0_7_0_0 - 0.271205357142861*G0_1_0_7_0_1 + 0.379687500000009*G0_1_0_8_0_0 + 0.216964285714292*G0_1_0_8_0_1 + 0.32544642857143*G0_1_0_9_0_0 + 0.542410714285728*G0_1_0_9_0_1 + 0.054241071428572*G0_1_0_10_1_0 + 0.0542410714285722*G0_1_0_10_1_1 + 0.650892857142867*G0_1_0_12_1_1 - 0.813616071428587*G0_1_0_13_1_0 - 0.216964285714292*G0_1_0_13_1_1 + 0.976339285714295*G0_1_0_14_1_0 - 0.271205357142867*G0_1_0_14_1_1 + 0.488169642857158*G0_1_0_15_1_0 + 0.325446428571439*G0_1_0_15_1_1 - 0.976339285714296*G0_1_0_16_1_0 - 1.03058035714288*G0_1_0_16_1_1 - 0.433928571428579*G0_1_0_17_1_0 - 0.271205357142861*G0_1_0_17_1_1 + 0.379687500000009*G0_1_0_18_1_0 + 0.216964285714292*G0_1_0_18_1_1 + 0.32544642857143*G0_1_0_19_1_0 + 0.542410714285728*G0_1_0_19_1_1;
    A[106] = -A[104] - 0.235044642857142*G0_0_1_0_0_0 - 0.235044642857142*G0_0_1_0_0_1 - 0.307366071428581*G0_0_1_1_0_0 - 0.470089285714296*G0_0_1_2_0_1 + 1.73571428571433*G0_0_1_3_0_0 + 0.488169642857149*G0_0_1_3_0_1 - 1.84419642857145*G0_0_1_4_0_0 - 0.433928571428557*G0_0_1_4_0_1 + 2.82053571428574*G0_0_1_5_0_0 + 2.1154017857143*G0_0_1_5_0_1 + 1.84419642857145*G0_0_1_6_0_0 - 1.41026785714286*G0_0_1_6_0_1 + 0.271205357142849*G0_0_1_7_0_0 + 0.976339285714288*G0_0_1_7_0_1 + 0.271205357142875*G0_0_1_8_0_0 - 0.48816964285715*G0_0_1_8_0_1 - 4.55625000000007*G0_0_1_9_0_0 - 0.54241071428573*G0_0_1_9_0_1 - 0.235044642857142*G0_0_1_10_1_0 - 0.235044642857142*G0_0_1_10_1_1 - 0.307366071428581*G0_0_1_11_1_0 - 0.470089285714296*G0_0_1_12_1_1 + 1.73571428571433*G0_0_1_13_1_0 + 0.488169642857149*G0_0_1_13_1_1 - 1.84419642857145*G0_0_1_14_1_0 - 0.433928571428557*G0_0_1_14_1_1 + 2.82053571428574*G0_0_1_15_1_0 + 2.1154017857143*G0_0_1_15_1_1 + 1.84419642857145*G0_0_1_16_1_0 - 1.41026785714286*G0_0_1_16_1_1 + 0.271205357142849*G0_0_1_17_1_0 + 0.976339285714288*G0_0_1_17_1_1 + 0.271205357142875*G0_0_1_18_1_0 - 0.48816964285715*G0_0_1_18_1_1 - 4.55625000000007*G0_0_1_19_1_0 - 0.54241071428573*G0_0_1_19_1_1 + 1.07879464285716*G0_1_1_0_0_0 + 1.07879464285716*G0_1_1_0_0_1 - 0.156696428571434*G0_1_1_1_0_0 - 0.916071428571446*G0_1_1_2_0_1 + 1.24754464285718*G0_1_1_3_0_0 + 0.54241071428572*G0_1_1_3_0_1 - 1.7357142857143*G0_1_1_4_0_0 - 0.271205357142829*G0_1_1_4_0_1 + 2.1154017857143*G0_1_1_5_0_0 - 0.867857142857168*G0_1_1_5_0_1 + 1.7357142857143*G0_1_1_6_0_0 + 0.705133928571457*G0_1_1_6_0_1 - 0.867857142857152*G0_1_1_7_0_0 + 2.11540178571432*G0_1_1_7_0_1 - 0.0542410714285718*G0_1_1_8_0_0 - 0.54241071428572*G0_1_1_8_0_1 - 3.36294642857148*G0_1_1_9_0_0 - 1.84419642857149*G0_1_1_9_0_1 + 1.07879464285716*G0_1_1_10_1_0 + 1.07879464285716*G0_1_1_10_1_1 - 0.156696428571434*G0_1_1_11_1_0 - 0.916071428571446*G0_1_1_12_1_1 + 1.24754464285718*G0_1_1_13_1_0 + 0.54241071428572*G0_1_1_13_1_1 - 1.7357142857143*G0_1_1_14_1_0 - 0.271205357142829*G0_1_1_14_1_1 + 2.1154017857143*G0_1_1_15_1_0 - 0.867857142857168*G0_1_1_15_1_1 + 1.7357142857143*G0_1_1_16_1_0 + 0.705133928571457*G0_1_1_16_1_1 - 0.867857142857152*G0_1_1_17_1_0 + 2.11540178571432*G0_1_1_17_1_1 - 0.0542410714285718*G0_1_1_18_1_0 - 0.54241071428572*G0_1_1_18_1_1 - 3.36294642857148*G0_1_1_19_1_0 - 1.84419642857149*G0_1_1_19_1_1;
    A[337] = A[127];
    A[125] = A[106] + 0.18080357142857*G0_0_1_0_0_0 + 0.18080357142857*G0_0_1_0_0_1 + 0.307366071428583*G0_0_1_1_0_0 - 0.180803571428571*G0_0_1_2_0_1 - 0.922098214285741*G0_0_1_3_0_0 - 0.271205357142857*G0_0_1_3_0_1 + 0.867857142857155*G0_0_1_4_0_0 + 0.705133928571424*G0_0_1_4_0_1 - 3.3087053571429*G0_0_1_5_0_0 - 2.44084821428574*G0_0_1_5_0_1 - 0.867857142857156*G0_0_1_6_0_0 + 2.44084821428574*G0_0_1_6_0_1 + 0.162723214285731*G0_0_1_7_0_0 - 0.705133928571427*G0_0_1_7_0_1 - 0.650892857142883*G0_0_1_8_0_0 + 0.271205357142858*G0_0_1_8_0_1 + 4.23080357142864*G0_0_1_9_0_0 + 0.18080357142857*G0_0_1_10_1_0 + 0.18080357142857*G0_0_1_10_1_1 + 0.307366071428583*G0_0_1_11_1_0 - 0.180803571428571*G0_0_1_12_1_1 - 0.922098214285741*G0_0_1_13_1_0 - 0.271205357142857*G0_0_1_13_1_1 + 0.867857142857155*G0_0_1_14_1_0 + 0.705133928571424*G0_0_1_14_1_1 - 3.3087053571429*G0_0_1_15_1_0 - 2.44084821428574*G0_0_1_15_1_1 - 0.867857142857156*G0_0_1_16_1_0 + 2.44084821428574*G0_0_1_16_1_1 + 0.162723214285731*G0_0_1_17_1_0 - 0.705133928571427*G0_0_1_17_1_1 - 0.650892857142883*G0_0_1_18_1_0 + 0.271205357142858*G0_0_1_18_1_1 + 4.23080357142864*G0_0_1_19_1_0 - 0.18080357142857*G0_1_0_0_0_0 - 0.18080357142857*G0_1_0_0_0_1 - 0.307366071428583*G0_1_0_1_0_0 + 0.180803571428571*G0_1_0_2_0_1 + 0.922098214285741*G0_1_0_3_0_0 + 0.271205357142857*G0_1_0_3_0_1 - 0.867857142857155*G0_1_0_4_0_0 - 0.705133928571424*G0_1_0_4_0_1 + 3.3087053571429*G0_1_0_5_0_0 + 2.44084821428574*G0_1_0_5_0_1 + 0.867857142857156*G0_1_0_6_0_0 - 2.44084821428574*G0_1_0_6_0_1 - 0.162723214285731*G0_1_0_7_0_0 + 0.705133928571427*G0_1_0_7_0_1 + 0.650892857142884*G0_1_0_8_0_0 - 0.271205357142858*G0_1_0_8_0_1 - 4.23080357142864*G0_1_0_9_0_0 - 0.18080357142857*G0_1_0_10_1_0 - 0.18080357142857*G0_1_0_10_1_1 - 0.307366071428583*G0_1_0_11_1_0 + 0.180803571428571*G0_1_0_12_1_1 + 0.922098214285741*G0_1_0_13_1_0 + 0.271205357142857*G0_1_0_13_1_1 - 0.867857142857155*G0_1_0_14_1_0 - 0.705133928571424*G0_1_0_14_1_1 + 3.3087053571429*G0_1_0_15_1_0 + 2.44084821428574*G0_1_0_15_1_1 + 0.867857142857156*G0_1_0_16_1_0 - 2.44084821428574*G0_1_0_16_1_1 - 0.162723214285731*G0_1_0_17_1_0 + 0.705133928571427*G0_1_0_17_1_1 + 0.650892857142884*G0_1_0_18_1_0 - 0.271205357142858*G0_1_0_18_1_1 - 4.23080357142864*G0_1_0_19_1_0;
    A[164] = -A[376] - 0.108482142857141*G0_0_1_0_0_0 - 0.108482142857141*G0_0_1_0_0_1 + 0.705133928571432*G0_0_1_1_0_0 + 0.271205357142843*G0_0_1_3_0_0 + 1.13906249999999*G0_0_1_3_0_1 - 0.162723214285721*G0_0_1_4_0_1 + 0.271205357142875*G0_0_1_5_0_0 - 0.0542410714285719*G0_0_1_5_0_1 + 0.162723214285714*G0_0_1_6_0_1 + 0.92209821428573*G0_0_1_7_0_0 + 1.24754464285718*G0_0_1_7_0_1 - 1.51875000000002*G0_0_1_8_0_0 - 1.1390625*G0_0_1_8_0_1 - 0.542410714285717*G0_0_1_9_0_0 - 1.08482142857146*G0_0_1_9_0_1 - 0.108482142857141*G0_0_1_10_1_0 - 0.108482142857141*G0_0_1_10_1_1 + 0.705133928571432*G0_0_1_11_1_0 + 0.271205357142843*G0_0_1_13_1_0 + 1.13906249999999*G0_0_1_13_1_1 - 0.162723214285721*G0_0_1_14_1_1 + 0.271205357142875*G0_0_1_15_1_0 - 0.0542410714285719*G0_0_1_15_1_1 + 0.162723214285714*G0_0_1_16_1_1 + 0.92209821428573*G0_0_1_17_1_0 + 1.24754464285718*G0_0_1_17_1_1 - 1.51875000000002*G0_0_1_18_1_0 - 1.1390625*G0_0_1_18_1_1 - 0.542410714285717*G0_0_1_19_1_0 - 1.08482142857146*G0_0_1_19_1_1 + 0.150669642857147*G0_1_1_0_0_0 + 0.150669642857147*G0_1_1_0_0_1 + 1.3138392857143*G0_1_1_1_0_0 + 0.44598214285715*G0_1_1_2_0_1 - 0.70513392857144*G0_1_1_3_0_0 + 2.27812500000002*G0_1_1_3_0_1 - 0.108482142857146*G0_1_1_4_0_0 - 2.22388392857146*G0_1_1_4_0_1 - 0.48816964285715*G0_1_1_5_0_0 - 0.54241071428572*G0_1_1_5_0_1 + 0.108482142857146*G0_1_1_6_0_0 - 0.0542410714285776*G0_1_1_6_0_1 - 0.325446428571448*G0_1_1_7_0_0 - 0.271205357142877*G0_1_1_7_0_1 - 1.1390625*G0_1_1_8_0_0 - 2.27812500000002*G0_1_1_8_0_1 + 1.19330357142859*G0_1_1_9_0_0 + 2.49508928571434*G0_1_1_9_0_1 + 0.150669642857147*G0_1_1_10_1_0 + 0.150669642857147*G0_1_1_10_1_1 + 1.3138392857143*G0_1_1_11_1_0 + 0.44598214285715*G0_1_1_12_1_1 - 0.70513392857144*G0_1_1_13_1_0 + 2.27812500000002*G0_1_1_13_1_1 - 0.108482142857146*G0_1_1_14_1_0 - 2.22388392857146*G0_1_1_14_1_1 - 0.48816964285715*G0_1_1_15_1_0 - 0.54241071428572*G0_1_1_15_1_1 + 0.108482142857146*G0_1_1_16_1_0 - 0.0542410714285776*G0_1_1_16_1_1 - 0.325446428571448*G0_1_1_17_1_0 - 0.271205357142877*G0_1_1_17_1_1 - 1.1390625*G0_1_1_18_1_0 - 2.27812500000002*G0_1_1_18_1_1 + 1.19330357142859*G0_1_1_19_1_0 + 2.49508928571434*G0_1_1_19_1_1;
    A[88] = A[164] - 0.650892857142862*G0_0_1_1_0_0 + 0.0542410714285717*G0_0_1_2_0_1 + 0.054241071428589*G0_0_1_3_0_0 - 0.976339285714283*G0_0_1_3_0_1 + 0.162723214285716*G0_0_1_4_0_0 + 0.488169642857154*G0_0_1_4_0_1 + 0.162723214285718*G0_0_1_5_0_0 + 0.379687500000008*G0_0_1_5_0_1 - 0.162723214285716*G0_0_1_6_0_0 - 0.433928571428578*G0_0_1_6_0_1 - 0.596651785714294*G0_0_1_7_0_0 - 0.813616071428585*G0_0_1_7_0_1 + 1.24754464285716*G0_0_1_8_0_0 + 0.976339285714284*G0_0_1_8_0_1 - 0.216964285714307*G0_0_1_9_0_0 + 0.32544642857143*G0_0_1_9_0_1 - 0.650892857142862*G0_0_1_11_1_0 + 0.0542410714285717*G0_0_1_12_1_1 + 0.054241071428589*G0_0_1_13_1_0 - 0.976339285714283*G0_0_1_13_1_1 + 0.162723214285716*G0_0_1_14_1_0 + 0.488169642857154*G0_0_1_14_1_1 + 0.162723214285718*G0_0_1_15_1_0 + 0.379687500000008*G0_0_1_15_1_1 - 0.162723214285716*G0_0_1_16_1_0 - 0.433928571428578*G0_0_1_16_1_1 - 0.596651785714294*G0_0_1_17_1_0 - 0.813616071428585*G0_0_1_17_1_1 + 1.24754464285716*G0_0_1_18_1_0 + 0.976339285714284*G0_0_1_18_1_1 - 0.216964285714307*G0_0_1_19_1_0 + 0.32544642857143*G0_0_1_19_1_1 + 0.650892857142862*G0_1_0_1_0_0 - 0.0542410714285718*G0_1_0_2_0_1 - 0.0542410714285889*G0_1_0_3_0_0 + 0.976339285714283*G0_1_0_3_0_1 - 0.162723214285716*G0_1_0_4_0_0 - 0.488169642857154*G0_1_0_4_0_1 - 0.162723214285718*G0_1_0_5_0_0 - 0.379687500000008*G0_1_0_5_0_1 + 0.162723214285716*G0_1_0_6_0_0 + 0.433928571428578*G0_1_0_6_0_1 + 0.596651785714294*G0_1_0_7_0_0 + 0.813616071428585*G0_1_0_7_0_1 - 1.24754464285716*G0_1_0_8_0_0 - 0.976339285714284*G0_1_0_8_0_1 + 0.216964285714306*G0_1_0_9_0_0 - 0.325446428571431*G0_1_0_9_0_1 + 0.650892857142862*G0_1_0_11_1_0 - 0.0542410714285718*G0_1_0_12_1_1 - 0.0542410714285889*G0_1_0_13_1_0 + 0.976339285714283*G0_1_0_13_1_1 - 0.162723214285716*G0_1_0_14_1_0 - 0.488169642857154*G0_1_0_14_1_1 - 0.162723214285718*G0_1_0_15_1_0 - 0.379687500000008*G0_1_0_15_1_1 + 0.162723214285716*G0_1_0_16_1_0 + 0.433928571428578*G0_1_0_16_1_1 + 0.596651785714294*G0_1_0_17_1_0 + 0.813616071428585*G0_1_0_17_1_1 - 1.24754464285716*G0_1_0_18_1_0 - 0.976339285714284*G0_1_0_18_1_1 + 0.216964285714306*G0_1_0_19_1_0 - 0.325446428571431*G0_1_0_19_1_1;
    A[335] = A[125];
    A[354] = A[144];
    A[274] = A[64];
    A[83] = -A[333] - 0.307366071428583*G0_1_0_0_0_0 - 0.307366071428583*G0_1_0_0_0_1 - 0.235044642857139*G0_1_0_1_0_0 + 0.470089285714298*G0_1_0_2_0_1 + 2.82053571428573*G0_1_0_3_0_0 + 0.70513392857144*G0_1_0_3_0_1 + 1.84419642857145*G0_1_0_4_0_0 + 3.25446428571431*G0_1_0_4_0_1 + 1.73571428571433*G0_1_0_5_0_0 + 1.24754464285718*G0_1_0_5_0_1 - 1.84419642857145*G0_1_0_6_0_0 - 1.4102678571429*G0_1_0_6_0_1 + 0.271205357142878*G0_1_0_7_0_0 + 0.759375000000025*G0_1_0_7_0_1 + 0.271205357142843*G0_1_0_8_0_0 - 0.70513392857144*G0_1_0_8_0_1 - 4.55625000000006*G0_1_0_9_0_0 - 4.01383928571433*G0_1_0_9_0_1 - 0.307366071428583*G0_1_0_10_1_0 - 0.307366071428583*G0_1_0_10_1_1 - 0.235044642857139*G0_1_0_11_1_0 + 0.470089285714298*G0_1_0_12_1_1 + 2.82053571428573*G0_1_0_13_1_0 + 0.70513392857144*G0_1_0_13_1_1 + 1.84419642857145*G0_1_0_14_1_0 + 3.25446428571431*G0_1_0_14_1_1 + 1.73571428571433*G0_1_0_15_1_0 + 1.24754464285718*G0_1_0_15_1_1 - 1.84419642857145*G0_1_0_16_1_0 - 1.4102678571429*G0_1_0_16_1_1 + 0.271205357142878*G0_1_0_17_1_0 + 0.759375000000025*G0_1_0_17_1_1 + 0.271205357142843*G0_1_0_18_1_0 - 0.70513392857144*G0_1_0_18_1_1 - 4.55625000000006*G0_1_0_19_1_0 - 4.01383928571433*G0_1_0_19_1_1 - 0.150669642857147*G0_1_1_0_0_0 - 0.150669642857147*G0_1_1_0_0_1 - 1.3138392857143*G0_1_1_1_0_0 - 0.44598214285715*G0_1_1_2_0_1 + 0.70513392857144*G0_1_1_3_0_0 - 2.27812500000002*G0_1_1_3_0_1 + 0.108482142857146*G0_1_1_4_0_0 + 2.22388392857146*G0_1_1_4_0_1 + 0.488169642857149*G0_1_1_5_0_0 + 0.54241071428572*G0_1_1_5_0_1 - 0.108482142857146*G0_1_1_6_0_0 + 0.0542410714285783*G0_1_1_6_0_1 + 0.325446428571449*G0_1_1_7_0_0 + 0.271205357142878*G0_1_1_7_0_1 + 1.13906249999999*G0_1_1_8_0_0 + 2.27812500000002*G0_1_1_8_0_1 - 1.19330357142859*G0_1_1_9_0_0 - 2.49508928571434*G0_1_1_9_0_1 - 0.150669642857147*G0_1_1_10_1_0 - 0.150669642857147*G0_1_1_10_1_1 - 1.3138392857143*G0_1_1_11_1_0 - 0.44598214285715*G0_1_1_12_1_1 + 0.70513392857144*G0_1_1_13_1_0 - 2.27812500000002*G0_1_1_13_1_1 + 0.108482142857146*G0_1_1_14_1_0 + 2.22388392857146*G0_1_1_14_1_1 + 0.488169642857149*G0_1_1_15_1_0 + 0.54241071428572*G0_1_1_15_1_1 - 0.108482142857146*G0_1_1_16_1_0 + 0.0542410714285783*G0_1_1_16_1_1 + 0.325446428571449*G0_1_1_17_1_0 + 0.271205357142878*G0_1_1_17_1_1 + 1.13906249999999*G0_1_1_18_1_0 + 2.27812500000002*G0_1_1_18_1_1 - 1.19330357142859*G0_1_1_19_1_0 - 2.49508928571434*G0_1_1_19_1_1;
    A[298] = A[88];
    A[316] = A[106];
    A[166] = A[376];
    A[86] = -A[294] + 0.325446428571431*G0_0_1_0_0_0 + 0.325446428571431*G0_0_1_0_0_1 - 0.325446428571432*G0_0_1_1_0_0 - 1.84419642857145*G0_0_1_2_0_1 + 1.84419642857145*G0_0_1_3_0_0 + 0.108482142857146*G0_0_1_3_0_1 - 2.71205357142862*G0_0_1_4_0_0 + 0.542410714285711*G0_0_1_4_0_1 - 1.84419642857145*G0_0_1_5_0_0 - 1.7357142857143*G0_0_1_5_0_1 + 2.71205357142862*G0_0_1_6_0_0 + 3.25446428571433*G0_0_1_6_0_1 - 0.108482142857142*G0_0_1_7_0_1 - 0.108482142857146*G0_0_1_8_0_1 - 0.433928571428568*G0_0_1_9_0_1 + 0.325446428571431*G0_0_1_10_1_0 + 0.325446428571431*G0_0_1_10_1_1 - 0.325446428571432*G0_0_1_11_1_0 - 1.84419642857145*G0_0_1_12_1_1 + 1.84419642857145*G0_0_1_13_1_0 + 0.108482142857146*G0_0_1_13_1_1 - 2.71205357142862*G0_0_1_14_1_0 + 0.542410714285711*G0_0_1_14_1_1 - 1.84419642857145*G0_0_1_15_1_0 - 1.7357142857143*G0_0_1_15_1_1 + 2.71205357142862*G0_0_1_16_1_0 + 3.25446428571433*G0_0_1_16_1_1 - 0.108482142857142*G0_0_1_17_1_1 - 0.108482142857146*G0_0_1_18_1_1 - 0.433928571428568*G0_0_1_19_1_1 - 0.114508928571438*G0_1_1_0_0_0 - 0.114508928571438*G0_1_1_0_0_1 + 0.439955357142868*G0_1_1_1_0_0 - 0.156696428571423*G0_1_1_2_0_1 + 3.25446428571431*G0_1_1_3_0_0 + 2.22388392857146*G0_1_1_3_0_1 + 0.542410714285711*G0_1_1_4_0_0 + 2.16964285714285*G0_1_1_4_0_1 - 0.433928571428557*G0_1_1_5_0_0 - 0.27120535714283*G0_1_1_5_0_1 - 0.54241071428571*G0_1_1_6_0_0 + 0.542410714285692*G0_1_1_6_0_1 - 0.162723214285709*G0_1_1_7_0_0 - 0.325446428571435*G0_1_1_7_0_1 - 0.162723214285721*G0_1_1_8_0_0 - 2.22388392857146*G0_1_1_8_0_1 - 2.82053571428575*G0_1_1_9_0_0 - 1.84419642857141*G0_1_1_9_0_1 - 0.114508928571438*G0_1_1_10_1_0 - 0.114508928571438*G0_1_1_10_1_1 + 0.439955357142868*G0_1_1_11_1_0 - 0.156696428571423*G0_1_1_12_1_1 + 3.25446428571431*G0_1_1_13_1_0 + 2.22388392857146*G0_1_1_13_1_1 + 0.542410714285711*G0_1_1_14_1_0 + 2.16964285714285*G0_1_1_14_1_1 - 0.433928571428557*G0_1_1_15_1_0 - 0.27120535714283*G0_1_1_15_1_1 - 0.54241071428571*G0_1_1_16_1_0 + 0.542410714285692*G0_1_1_16_1_1 - 0.162723214285709*G0_1_1_17_1_0 - 0.325446428571435*G0_1_1_17_1_1 - 0.162723214285721*G0_1_1_18_1_0 - 2.22388392857146*G0_1_1_18_1_1 - 2.82053571428575*G0_1_1_19_1_0 - 1.84419642857141*G0_1_1_19_1_1;
    A[296] = A[86];
    A[126] = -A[86] - 0.325446428571431*G0_1_0_0_0_0 - 0.325446428571431*G0_1_0_0_0_1 + 0.325446428571432*G0_1_0_1_0_0 + 1.84419642857145*G0_1_0_2_0_1 - 1.84419642857145*G0_1_0_3_0_0 - 0.108482142857146*G0_1_0_3_0_1 + 2.71205357142862*G0_1_0_4_0_0 - 0.54241071428571*G0_1_0_4_0_1 + 1.84419642857145*G0_1_0_5_0_0 + 1.7357142857143*G0_1_0_5_0_1 - 2.71205357142862*G0_1_0_6_0_0 - 3.25446428571433*G0_1_0_6_0_1 + 0.108482142857143*G0_1_0_7_0_1 + 0.108482142857146*G0_1_0_8_0_1 + 0.433928571428567*G0_1_0_9_0_1 - 0.325446428571431*G0_1_0_10_1_0 - 0.325446428571431*G0_1_0_10_1_1 + 0.325446428571432*G0_1_0_11_1_0 + 1.84419642857145*G0_1_0_12_1_1 - 1.84419642857145*G0_1_0_13_1_0 - 0.108482142857146*G0_1_0_13_1_1 + 2.71205357142862*G0_1_0_14_1_0 - 0.54241071428571*G0_1_0_14_1_1 + 1.84419642857145*G0_1_0_15_1_0 + 1.7357142857143*G0_1_0_15_1_1 - 2.71205357142862*G0_1_0_16_1_0 - 3.25446428571433*G0_1_0_16_1_1 + 0.108482142857143*G0_1_0_17_1_1 + 0.108482142857146*G0_1_0_18_1_1 + 0.433928571428567*G0_1_0_19_1_1 - 0.765401785714301*G0_1_1_0_0_0 - 0.765401785714301*G0_1_1_0_0_1 + 0.439955357142869*G0_1_1_1_0_0 + 1.68750000000003*G0_1_1_2_0_1 - 1.4102678571429*G0_1_1_3_0_0 + 0.0542410714285783*G0_1_1_3_0_1 + 3.25446428571433*G0_1_1_4_0_0 + 0.542410714285692*G0_1_1_4_0_1 - 1.41026785714286*G0_1_1_5_0_0 + 0.705133928571457*G0_1_1_5_0_1 - 3.25446428571433*G0_1_1_6_0_0 - 1.62723214285719*G0_1_1_6_0_1 + 0.162723214285717*G0_1_1_7_0_0 - 1.9526785714286*G0_1_1_7_0_1 + 0.162723214285714*G0_1_1_8_0_0 - 0.0542410714285776*G0_1_1_8_0_1 + 2.82053571428576*G0_1_1_9_0_0 + 1.41026785714291*G0_1_1_9_0_1 - 0.765401785714301*G0_1_1_10_1_0 - 0.765401785714301*G0_1_1_10_1_1 + 0.439955357142869*G0_1_1_11_1_0 + 1.68750000000003*G0_1_1_12_1_1 - 1.4102678571429*G0_1_1_13_1_0 + 0.0542410714285783*G0_1_1_13_1_1 + 3.25446428571433*G0_1_1_14_1_0 + 0.542410714285692*G0_1_1_14_1_1 - 1.41026785714286*G0_1_1_15_1_0 + 0.705133928571457*G0_1_1_15_1_1 - 3.25446428571433*G0_1_1_16_1_0 - 1.62723214285719*G0_1_1_16_1_1 + 0.162723214285717*G0_1_1_17_1_0 - 1.9526785714286*G0_1_1_17_1_1 + 0.162723214285714*G0_1_1_18_1_0 - 0.0542410714285776*G0_1_1_18_1_1 + 2.82053571428576*G0_1_1_19_1_0 + 1.41026785714291*G0_1_1_19_1_1;
    A[147] = A[357];
    A[356] = A[146];
    A[318] = A[108];
    A[374] = A[164];
    A[168] = A[378];
    A[10] = 0.0;
    A[67] = A[277];
    A[31] = 0.0;
    A[105] = A[315];
    A[323] = 0.0;
    A[130] = 0.0;
    A[394] = A[184];
    A[342] = 0.0;
    A[159] = 0.0;
    A[369] = 0.0;
    A[175] = 0.0;
    A[194] = 0.0;
    A[213] = -A[218] - 0.649553571428578*G0_0_0_0_0_0 - 0.649553571428578*G0_0_0_0_0_1 + 0.336160714285719*G0_0_0_1_0_0 + 0.0529017857142859*G0_0_0_2_0_1 - 0.114508928571438*G0_0_0_3_0_0 + 0.32544642857143*G0_0_0_3_0_1 - 0.150669642857147*G0_0_0_4_0_0 - 0.307366071428582*G0_0_0_4_0_1 - 0.608705357142865*G0_0_0_5_0_0 + 0.705133928571434*G0_0_0_5_0_1 + 0.150669642857147*G0_0_0_6_0_0 - 0.108482142857142*G0_0_0_6_0_1 + 1.07879464285716*G0_0_0_7_0_0 - 0.235044642857141*G0_0_0_7_0_1 - 0.765401785714298*G0_0_0_8_0_0 - 0.325446428571431*G0_0_0_8_0_1 + 0.723214285714303*G0_0_0_9_0_0 + 0.542410714285724*G0_0_0_9_0_1 - 0.649553571428578*G0_0_0_10_1_0 - 0.649553571428578*G0_0_0_10_1_1 + 0.336160714285719*G0_0_0_11_1_0 + 0.0529017857142859*G0_0_0_12_1_1 - 0.114508928571438*G0_0_0_13_1_0 + 0.32544642857143*G0_0_0_13_1_1 - 0.150669642857147*G0_0_0_14_1_0 - 0.307366071428582*G0_0_0_14_1_1 - 0.608705357142865*G0_0_0_15_1_0 + 0.705133928571434*G0_0_0_15_1_1 + 0.150669642857147*G0_0_0_16_1_0 - 0.108482142857142*G0_0_0_16_1_1 + 1.07879464285716*G0_0_0_17_1_0 - 0.235044642857141*G0_0_0_17_1_1 - 0.765401785714298*G0_0_0_18_1_0 - 0.325446428571431*G0_0_0_18_1_1 + 0.723214285714303*G0_0_0_19_1_0 + 0.542410714285724*G0_0_0_19_1_1 - 0.649553571428578*G0_1_0_0_0_0 - 0.649553571428578*G0_1_0_0_0_1 + 0.336160714285719*G0_1_0_1_0_0 + 0.0529017857142857*G0_1_0_2_0_1 - 0.114508928571438*G0_1_0_3_0_0 + 0.32544642857143*G0_1_0_3_0_1 - 0.150669642857147*G0_1_0_4_0_0 - 0.307366071428581*G0_1_0_4_0_1 - 0.608705357142865*G0_1_0_5_0_0 + 0.705133928571434*G0_1_0_5_0_1 + 0.150669642857147*G0_1_0_6_0_0 - 0.108482142857142*G0_1_0_6_0_1 + 1.07879464285716*G0_1_0_7_0_0 - 0.235044642857141*G0_1_0_7_0_1 - 0.765401785714298*G0_1_0_8_0_0 - 0.32544642857143*G0_1_0_8_0_1 + 0.723214285714303*G0_1_0_9_0_0 + 0.542410714285724*G0_1_0_9_0_1 - 0.649553571428578*G0_1_0_10_1_0 - 0.649553571428578*G0_1_0_10_1_1 + 0.336160714285719*G0_1_0_11_1_0 + 0.0529017857142857*G0_1_0_12_1_1 - 0.114508928571438*G0_1_0_13_1_0 + 0.32544642857143*G0_1_0_13_1_1 - 0.150669642857147*G0_1_0_14_1_0 - 0.307366071428581*G0_1_0_14_1_1 - 0.608705357142865*G0_1_0_15_1_0 + 0.705133928571434*G0_1_0_15_1_1 + 0.150669642857147*G0_1_0_16_1_0 - 0.108482142857142*G0_1_0_16_1_1 + 1.07879464285716*G0_1_0_17_1_0 - 0.235044642857141*G0_1_0_17_1_1 - 0.765401785714298*G0_1_0_18_1_0 - 0.32544642857143*G0_1_0_18_1_1 + 0.723214285714303*G0_1_0_19_1_0 + 0.542410714285724*G0_1_0_19_1_1;
    A[214] = A[213] + 0.108482142857144*G0_0_0_1_0_0 - 0.307366071428577*G0_0_0_2_0_1 + 0.343526785714296*G0_0_0_3_0_0 + 0.253125000000006*G0_0_0_3_0_1 - 0.452008928571435*G0_0_0_4_0_0 + 0.0542410714285756*G0_0_0_4_0_1 - 0.27120535714286*G0_0_0_5_0_0 - 0.271205357142862*G0_0_0_5_0_1 + 0.452008928571435*G0_0_0_6_0_0 + 0.578571428571438*G0_0_0_6_0_1 + 0.27120535714286*G0_0_0_7_0_0 + 0.271205357142862*G0_0_0_7_0_1 - 0.379687500000005*G0_0_0_8_0_0 - 0.253125000000006*G0_0_0_8_0_1 - 0.0723214285714362*G0_0_0_9_0_0 - 0.325446428571437*G0_0_0_9_0_1 + 0.108482142857144*G0_0_0_11_1_0 - 0.307366071428577*G0_0_0_12_1_1 + 0.343526785714296*G0_0_0_13_1_0 + 0.253125000000006*G0_0_0_13_1_1 - 0.452008928571435*G0_0_0_14_1_0 + 0.0542410714285756*G0_0_0_14_1_1 - 0.27120535714286*G0_0_0_15_1_0 - 0.271205357142862*G0_0_0_15_1_1 + 0.452008928571435*G0_0_0_16_1_0 + 0.578571428571438*G0_0_0_16_1_1 + 0.27120535714286*G0_0_0_17_1_0 + 0.271205357142862*G0_0_0_17_1_1 - 0.379687500000005*G0_0_0_18_1_0 - 0.253125000000006*G0_0_0_18_1_1 - 0.0723214285714362*G0_0_0_19_1_0 - 0.325446428571437*G0_0_0_19_1_1 + 0.307366071428575*G0_0_1_1_0_0 - 0.108482142857145*G0_0_1_2_0_1 - 0.0542410714285768*G0_0_1_3_0_0 + 0.452008928571432*G0_0_1_3_0_1 - 0.253125000000008*G0_0_1_4_0_0 - 0.343526785714296*G0_0_1_4_0_1 - 0.271205357142863*G0_0_1_5_0_0 - 0.271205357142859*G0_0_1_5_0_1 + 0.253125000000008*G0_0_1_6_0_0 + 0.379687500000005*G0_0_1_6_0_1 + 0.271205357142862*G0_0_1_7_0_0 + 0.271205357142858*G0_0_1_7_0_1 - 0.578571428571435*G0_0_1_8_0_0 - 0.452008928571432*G0_0_1_8_0_1 + 0.325446428571439*G0_0_1_9_0_0 + 0.0723214285714384*G0_0_1_9_0_1 + 0.307366071428575*G0_0_1_11_1_0 - 0.108482142857145*G0_0_1_12_1_1 - 0.0542410714285768*G0_0_1_13_1_0 + 0.452008928571432*G0_0_1_13_1_1 - 0.253125000000008*G0_0_1_14_1_0 - 0.343526785714296*G0_0_1_14_1_1 - 0.271205357142863*G0_0_1_15_1_0 - 0.271205357142859*G0_0_1_15_1_1 + 0.253125000000008*G0_0_1_16_1_0 + 0.379687500000005*G0_0_1_16_1_1 + 0.271205357142862*G0_0_1_17_1_0 + 0.271205357142858*G0_0_1_17_1_1 - 0.578571428571435*G0_0_1_18_1_0 - 0.452008928571432*G0_0_1_18_1_1 + 0.325446428571439*G0_0_1_19_1_0 + 0.0723214285714384*G0_0_1_19_1_1 + 0.108482142857144*G0_1_0_1_0_0 - 0.307366071428577*G0_1_0_2_0_1 + 0.343526785714296*G0_1_0_3_0_0 + 0.253125000000006*G0_1_0_3_0_1 - 0.452008928571435*G0_1_0_4_0_0 + 0.0542410714285756*G0_1_0_4_0_1 - 0.27120535714286*G0_1_0_5_0_0 - 0.271205357142862*G0_1_0_5_0_1 + 0.452008928571435*G0_1_0_6_0_0 + 0.578571428571438*G0_1_0_6_0_1 + 0.27120535714286*G0_1_0_7_0_0 + 0.271205357142861*G0_1_0_7_0_1 - 0.379687500000005*G0_1_0_8_0_0 - 0.253125000000006*G0_1_0_8_0_1 - 0.072321428571436*G0_1_0_9_0_0 - 0.325446428571437*G0_1_0_9_0_1 + 0.108482142857144*G0_1_0_11_1_0 - 0.307366071428577*G0_1_0_12_1_1 + 0.343526785714296*G0_1_0_13_1_0 + 0.253125000000006*G0_1_0_13_1_1 - 0.452008928571435*G0_1_0_14_1_0 + 0.0542410714285756*G0_1_0_14_1_1 - 0.27120535714286*G0_1_0_15_1_0 - 0.271205357142862*G0_1_0_15_1_1 + 0.452008928571435*G0_1_0_16_1_0 + 0.578571428571438*G0_1_0_16_1_1 + 0.27120535714286*G0_1_0_17_1_0 + 0.271205357142861*G0_1_0_17_1_1 - 0.379687500000005*G0_1_0_18_1_0 - 0.253125000000006*G0_1_0_18_1_1 - 0.072321428571436*G0_1_0_19_1_0 - 0.325446428571437*G0_1_0_19_1_1 + 0.307366071428575*G0_1_1_1_0_0 - 0.108482142857145*G0_1_1_2_0_1 - 0.0542410714285771*G0_1_1_3_0_0 + 0.452008928571431*G0_1_1_3_0_1 - 0.253125000000008*G0_1_1_4_0_0 - 0.343526785714296*G0_1_1_4_0_1 - 0.271205357142863*G0_1_1_5_0_0 - 0.271205357142859*G0_1_1_5_0_1 + 0.253125000000008*G0_1_1_6_0_0 + 0.379687500000005*G0_1_1_6_0_1 + 0.271205357142861*G0_1_1_7_0_0 + 0.271205357142857*G0_1_1_7_0_1 - 0.578571428571434*G0_1_1_8_0_0 - 0.452008928571431*G0_1_1_8_0_1 + 0.32544642857144*G0_1_1_9_0_0 + 0.072321428571439*G0_1_1_9_0_1 + 0.307366071428575*G0_1_1_11_1_0 - 0.108482142857145*G0_1_1_12_1_1 - 0.0542410714285771*G0_1_1_13_1_0 + 0.452008928571431*G0_1_1_13_1_1 - 0.253125000000008*G0_1_1_14_1_0 - 0.343526785714296*G0_1_1_14_1_1 - 0.271205357142863*G0_1_1_15_1_0 - 0.271205357142859*G0_1_1_15_1_1 + 0.253125000000008*G0_1_1_16_1_0 + 0.379687500000005*G0_1_1_16_1_1 + 0.271205357142861*G0_1_1_17_1_0 + 0.271205357142857*G0_1_1_17_1_1 - 0.578571428571434*G0_1_1_18_1_0 - 0.452008928571431*G0_1_1_18_1_1 + 0.32544642857144*G0_1_1_19_1_0 + 0.072321428571439*G0_1_1_19_1_1;
    A[4] = A[214];
    A[216] = -A[214] - 0.649553571428579*G0_0_1_0_0_0 - 0.649553571428579*G0_0_1_0_0_1 + 0.0529017857142856*G0_0_1_1_0_0 + 0.33616071428572*G0_0_1_2_0_1 - 0.307366071428583*G0_0_1_3_0_0 - 0.150669642857147*G0_0_1_3_0_1 + 0.325446428571431*G0_0_1_4_0_0 - 0.114508928571438*G0_0_1_4_0_1 - 0.235044642857142*G0_0_1_5_0_0 + 1.07879464285716*G0_0_1_5_0_1 - 0.325446428571431*G0_0_1_6_0_0 - 0.765401785714301*G0_0_1_6_0_1 + 0.705133928571434*G0_0_1_7_0_0 - 0.608705357142866*G0_0_1_7_0_1 - 0.108482142857141*G0_0_1_8_0_0 + 0.150669642857147*G0_0_1_8_0_1 + 0.542410714285724*G0_0_1_9_0_0 + 0.723214285714305*G0_0_1_9_0_1 - 0.649553571428579*G0_0_1_10_1_0 - 0.649553571428579*G0_0_1_10_1_1 + 0.0529017857142856*G0_0_1_11_1_0 + 0.33616071428572*G0_0_1_12_1_1 - 0.307366071428583*G0_0_1_13_1_0 - 0.150669642857147*G0_0_1_13_1_1 + 0.325446428571431*G0_0_1_14_1_0 - 0.114508928571438*G0_0_1_14_1_1 - 0.235044642857142*G0_0_1_15_1_0 + 1.07879464285716*G0_0_1_15_1_1 - 0.325446428571431*G0_0_1_16_1_0 - 0.765401785714301*G0_0_1_16_1_1 + 0.705133928571434*G0_0_1_17_1_0 - 0.608705357142866*G0_0_1_17_1_1 - 0.108482142857141*G0_0_1_18_1_0 + 0.150669642857147*G0_0_1_18_1_1 + 0.542410714285724*G0_0_1_19_1_0 + 0.723214285714305*G0_0_1_19_1_1 - 0.649553571428579*G0_1_1_0_0_0 - 0.64955357142858*G0_1_1_0_0_1 + 0.0529017857142855*G0_1_1_1_0_0 + 0.33616071428572*G0_1_1_2_0_1 - 0.307366071428583*G0_1_1_3_0_0 - 0.150669642857147*G0_1_1_3_0_1 + 0.325446428571431*G0_1_1_4_0_0 - 0.114508928571438*G0_1_1_4_0_1 - 0.235044642857142*G0_1_1_5_0_0 + 1.07879464285716*G0_1_1_5_0_1 - 0.325446428571431*G0_1_1_6_0_0 - 0.765401785714301*G0_1_1_6_0_1 + 0.705133928571434*G0_1_1_7_0_0 - 0.608705357142867*G0_1_1_7_0_1 - 0.108482142857141*G0_1_1_8_0_0 + 0.150669642857147*G0_1_1_8_0_1 + 0.542410714285725*G0_1_1_9_0_0 + 0.723214285714306*G0_1_1_9_0_1 - 0.649553571428579*G0_1_1_10_1_0 - 0.64955357142858*G0_1_1_10_1_1 + 0.0529017857142855*G0_1_1_11_1_0 + 0.33616071428572*G0_1_1_12_1_1 - 0.307366071428583*G0_1_1_13_1_0 - 0.150669642857147*G0_1_1_13_1_1 + 0.325446428571431*G0_1_1_14_1_0 - 0.114508928571438*G0_1_1_14_1_1 - 0.235044642857142*G0_1_1_15_1_0 + 1.07879464285716*G0_1_1_15_1_1 - 0.325446428571431*G0_1_1_16_1_0 - 0.765401785714301*G0_1_1_16_1_1 + 0.705133928571434*G0_1_1_17_1_0 - 0.608705357142867*G0_1_1_17_1_1 - 0.108482142857141*G0_1_1_18_1_0 + 0.150669642857147*G0_1_1_18_1_1 + 0.542410714285725*G0_1_1_19_1_0 + 0.723214285714306*G0_1_1_19_1_1;
    A[6] = A[216];
    A[80] = A[214] - 0.0120535714285711*G0_0_1_1_0_0 - 0.18683035714286*G0_0_1_2_0_1 + 0.259151785714294*G0_0_1_3_0_0 + 0.0482142857142891*G0_0_1_3_0_1 - 0.247098214285716*G0_0_1_4_0_0 + 0.138616071428578*G0_0_1_4_0_1 - 0.11450892857143*G0_0_1_5_0_0 - 0.114508928571432*G0_0_1_5_0_1 + 0.247098214285716*G0_0_1_6_0_0 + 0.301339285714292*G0_0_1_6_0_1 + 0.11450892857143*G0_0_1_7_0_0 + 0.114508928571432*G0_0_1_7_0_1 - 0.10245535714286*G0_0_1_8_0_0 - 0.048214285714289*G0_0_1_8_0_1 - 0.144642857142865*G0_0_1_9_0_0 - 0.25312500000001*G0_0_1_9_0_1 - 0.0120535714285711*G0_0_1_11_1_0 - 0.18683035714286*G0_0_1_12_1_1 + 0.259151785714294*G0_0_1_13_1_0 + 0.0482142857142891*G0_0_1_13_1_1 - 0.247098214285716*G0_0_1_14_1_0 + 0.138616071428578*G0_0_1_14_1_1 - 0.11450892857143*G0_0_1_15_1_0 - 0.114508928571432*G0_0_1_15_1_1 + 0.247098214285716*G0_0_1_16_1_0 + 0.301339285714292*G0_0_1_16_1_1 + 0.11450892857143*G0_0_1_17_1_0 + 0.114508928571432*G0_0_1_17_1_1 - 0.10245535714286*G0_0_1_18_1_0 - 0.048214285714289*G0_0_1_18_1_1 - 0.144642857142865*G0_0_1_19_1_0 - 0.25312500000001*G0_0_1_19_1_1 + 0.0120535714285711*G0_1_0_1_0_0 + 0.18683035714286*G0_1_0_2_0_1 - 0.259151785714294*G0_1_0_3_0_0 - 0.0482142857142891*G0_1_0_3_0_1 + 0.247098214285717*G0_1_0_4_0_0 - 0.138616071428578*G0_1_0_4_0_1 + 0.11450892857143*G0_1_0_5_0_0 + 0.114508928571432*G0_1_0_5_0_1 - 0.247098214285716*G0_1_0_6_0_0 - 0.301339285714292*G0_1_0_6_0_1 - 0.11450892857143*G0_1_0_7_0_0 - 0.114508928571432*G0_1_0_7_0_1 + 0.10245535714286*G0_1_0_8_0_0 + 0.048214285714289*G0_1_0_8_0_1 + 0.144642857142865*G0_1_0_9_0_0 + 0.25312500000001*G0_1_0_9_0_1 + 0.0120535714285711*G0_1_0_11_1_0 + 0.18683035714286*G0_1_0_12_1_1 - 0.259151785714294*G0_1_0_13_1_0 - 0.0482142857142891*G0_1_0_13_1_1 + 0.247098214285717*G0_1_0_14_1_0 - 0.138616071428578*G0_1_0_14_1_1 + 0.11450892857143*G0_1_0_15_1_0 + 0.114508928571432*G0_1_0_15_1_1 - 0.247098214285716*G0_1_0_16_1_0 - 0.301339285714292*G0_1_0_16_1_1 - 0.11450892857143*G0_1_0_17_1_0 - 0.114508928571432*G0_1_0_17_1_1 + 0.10245535714286*G0_1_0_18_1_0 + 0.048214285714289*G0_1_0_18_1_1 + 0.144642857142865*G0_1_0_19_1_0 + 0.25312500000001*G0_1_0_19_1_1;
    A[350] = -A[80] + 1.59241071428573*G0_0_0_0_0_0 + 1.59241071428573*G0_0_0_0_0_1 - 0.387053571428576*G0_0_0_1_0_0 - 0.45334821428572*G0_0_0_2_0_1 - 0.259151785714292*G0_0_0_3_0_0 - 0.325446428571435*G0_0_0_3_0_1 - 0.439955357142867*G0_0_0_4_0_0 - 0.307366071428581*G0_0_0_4_0_1 + 0.259151785714281*G0_0_0_5_0_0 - 2.47700892857146*G0_0_0_5_0_1 + 0.439955357142867*G0_0_0_6_0_0 + 1.33794642857145*G0_0_0_6_0_1 - 2.39263392857146*G0_0_0_7_0_0 + 0.34352678571428*G0_0_0_7_0_1 + 1.1872767857143*G0_0_0_8_0_0 + 0.325446428571435*G0_0_0_8_0_1 - 0.036160714285701*G0_0_0_9_0_1 + 1.59241071428573*G0_0_0_10_1_0 + 1.59241071428573*G0_0_0_10_1_1 - 0.387053571428576*G0_0_0_11_1_0 - 0.45334821428572*G0_0_0_12_1_1 - 0.259151785714292*G0_0_0_13_1_0 - 0.325446428571435*G0_0_0_13_1_1 - 0.439955357142867*G0_0_0_14_1_0 - 0.307366071428581*G0_0_0_14_1_1 + 0.259151785714281*G0_0_0_15_1_0 - 2.47700892857146*G0_0_0_15_1_1 + 0.439955357142867*G0_0_0_16_1_0 + 1.33794642857145*G0_0_0_16_1_1 - 2.39263392857146*G0_0_0_17_1_0 + 0.34352678571428*G0_0_0_17_1_1 + 1.1872767857143*G0_0_0_18_1_0 + 0.325446428571435*G0_0_0_18_1_1 - 0.036160714285701*G0_0_0_19_1_1 + 1.59241071428573*G0_0_1_0_0_0 + 1.59241071428573*G0_0_1_0_0_1 - 0.387053571428576*G0_0_1_1_0_0 - 0.45334821428572*G0_0_1_2_0_1 - 0.259151785714292*G0_0_1_3_0_0 - 0.325446428571435*G0_0_1_3_0_1 - 0.439955357142867*G0_0_1_4_0_0 - 0.307366071428581*G0_0_1_4_0_1 + 0.259151785714281*G0_0_1_5_0_0 - 2.47700892857146*G0_0_1_5_0_1 + 0.439955357142867*G0_0_1_6_0_0 + 1.33794642857145*G0_0_1_6_0_1 - 2.39263392857146*G0_0_1_7_0_0 + 0.34352678571428*G0_0_1_7_0_1 + 1.1872767857143*G0_0_1_8_0_0 + 0.325446428571435*G0_0_1_8_0_1 - 0.0361607142857007*G0_0_1_9_0_1 + 1.59241071428573*G0_0_1_10_1_0 + 1.59241071428573*G0_0_1_10_1_1 - 0.387053571428576*G0_0_1_11_1_0 - 0.45334821428572*G0_0_1_12_1_1 - 0.259151785714292*G0_0_1_13_1_0 - 0.325446428571435*G0_0_1_13_1_1 - 0.439955357142867*G0_0_1_14_1_0 - 0.307366071428581*G0_0_1_14_1_1 + 0.259151785714281*G0_0_1_15_1_0 - 2.47700892857146*G0_0_1_15_1_1 + 0.439955357142867*G0_0_1_16_1_0 + 1.33794642857145*G0_0_1_16_1_1 - 2.39263392857146*G0_0_1_17_1_0 + 0.34352678571428*G0_0_1_17_1_1 + 1.1872767857143*G0_0_1_18_1_0 + 0.325446428571435*G0_0_1_18_1_1 - 0.0361607142857007*G0_0_1_19_1_1 - 0.433928571428572*G0_1_0_0_0_0 - 0.433928571428573*G0_1_0_0_0_1 - 0.108482142857146*G0_1_0_1_0_0 - 0.687053571428589*G0_1_0_3_0_0 - 0.542410714285724*G0_1_0_3_0_1 - 0.361607142857152*G0_1_0_4_0_0 - 0.614732142857162*G0_1_0_4_0_1 - 0.687053571428582*G0_1_0_5_0_0 + 0.542410714285715*G0_1_0_5_0_1 + 0.361607142857152*G0_1_0_6_0_0 - 0.108482142857142*G0_1_0_6_0_1 + 0.397767857142852*G0_1_0_7_0_0 - 0.831696428571445*G0_1_0_7_0_1 + 0.144642857142866*G0_1_0_8_0_0 + 0.542410714285724*G0_1_0_8_0_1 + 1.37410714285717*G0_1_0_9_0_0 + 1.44642857142861*G0_1_0_9_0_1 - 0.433928571428572*G0_1_0_10_1_0 - 0.433928571428573*G0_1_0_10_1_1 - 0.108482142857146*G0_1_0_11_1_0 - 0.687053571428589*G0_1_0_13_1_0 - 0.542410714285724*G0_1_0_13_1_1 - 0.361607142857152*G0_1_0_14_1_0 - 0.614732142857162*G0_1_0_14_1_1 - 0.687053571428582*G0_1_0_15_1_0 + 0.542410714285715*G0_1_0_15_1_1 + 0.361607142857152*G0_1_0_16_1_0 - 0.108482142857142*G0_1_0_16_1_1 + 0.397767857142852*G0_1_0_17_1_0 - 0.831696428571445*G0_1_0_17_1_1 + 0.144642857142866*G0_1_0_18_1_0 + 0.542410714285724*G0_1_0_18_1_1 + 1.37410714285717*G0_1_0_19_1_0 + 1.44642857142861*G0_1_0_19_1_1 - 0.433928571428573*G0_1_1_0_0_0 - 0.433928571428573*G0_1_1_0_0_1 - 0.108482142857146*G0_1_1_1_0_0 - 0.687053571428589*G0_1_1_3_0_0 - 0.542410714285724*G0_1_1_3_0_1 - 0.361607142857152*G0_1_1_4_0_0 - 0.614732142857163*G0_1_1_4_0_1 - 0.687053571428582*G0_1_1_5_0_0 + 0.542410714285715*G0_1_1_5_0_1 + 0.361607142857152*G0_1_1_6_0_0 - 0.108482142857142*G0_1_1_6_0_1 + 0.397767857142852*G0_1_1_7_0_0 - 0.831696428571445*G0_1_1_7_0_1 + 0.144642857142867*G0_1_1_8_0_0 + 0.542410714285724*G0_1_1_8_0_1 + 1.37410714285717*G0_1_1_9_0_0 + 1.44642857142861*G0_1_1_9_0_1 - 0.433928571428573*G0_1_1_10_1_0 - 0.433928571428573*G0_1_1_10_1_1 - 0.108482142857146*G0_1_1_11_1_0 - 0.687053571428589*G0_1_1_13_1_0 - 0.542410714285724*G0_1_1_13_1_1 - 0.361607142857152*G0_1_1_14_1_0 - 0.614732142857163*G0_1_1_14_1_1 - 0.687053571428582*G0_1_1_15_1_0 + 0.542410714285715*G0_1_1_15_1_1 + 0.361607142857152*G0_1_1_16_1_0 - 0.108482142857142*G0_1_1_16_1_1 + 0.397767857142852*G0_1_1_17_1_0 - 0.831696428571445*G0_1_1_17_1_1 + 0.144642857142867*G0_1_1_18_1_0 + 0.542410714285724*G0_1_1_18_1_1 + 1.37410714285717*G0_1_1_19_1_0 + 1.44642857142861*G0_1_1_19_1_1;
    A[217] = A[350] - 2.0263392857143*G0_0_1_0_0_0 - 2.0263392857143*G0_0_1_0_0_1 + 0.26651785714286*G0_0_1_1_0_0 + 0.26651785714286*G0_0_1_2_0_1 - 0.168750000000003*G0_0_1_3_0_0 - 0.16875*G0_0_1_3_0_1 - 0.168750000000001*G0_0_1_4_0_0 - 0.168750000000004*G0_0_1_4_0_1 - 1.06071428571429*G0_0_1_5_0_0 + 2.90491071428574*G0_0_1_5_0_1 + 0.168750000000001*G0_0_1_6_0_0 - 1.1450892857143*G0_0_1_6_0_1 + 2.90491071428574*G0_0_1_7_0_0 - 1.06071428571429*G0_0_1_7_0_1 - 1.14508928571429*G0_0_1_8_0_0 + 0.16875*G0_0_1_8_0_1 + 1.2294642857143*G0_0_1_9_0_0 + 1.2294642857143*G0_0_1_9_0_1 - 2.0263392857143*G0_0_1_10_1_0 - 2.0263392857143*G0_0_1_10_1_1 + 0.26651785714286*G0_0_1_11_1_0 + 0.26651785714286*G0_0_1_12_1_1 - 0.168750000000003*G0_0_1_13_1_0 - 0.16875*G0_0_1_13_1_1 - 0.168750000000001*G0_0_1_14_1_0 - 0.168750000000004*G0_0_1_14_1_1 - 1.06071428571429*G0_0_1_15_1_0 + 2.90491071428574*G0_0_1_15_1_1 + 0.168750000000001*G0_0_1_16_1_0 - 1.1450892857143*G0_0_1_16_1_1 + 2.90491071428574*G0_0_1_17_1_0 - 1.06071428571429*G0_0_1_17_1_1 - 1.14508928571429*G0_0_1_18_1_0 + 0.16875*G0_0_1_18_1_1 + 1.2294642857143*G0_0_1_19_1_0 + 1.2294642857143*G0_0_1_19_1_1 + 2.0263392857143*G0_1_0_0_0_0 + 2.0263392857143*G0_1_0_0_0_1 - 0.26651785714286*G0_1_0_1_0_0 - 0.26651785714286*G0_1_0_2_0_1 + 0.168750000000003*G0_1_0_3_0_0 + 0.16875*G0_1_0_3_0_1 + 0.168750000000001*G0_1_0_4_0_0 + 0.168750000000004*G0_1_0_4_0_1 + 1.06071428571429*G0_1_0_5_0_0 - 2.90491071428574*G0_1_0_5_0_1 - 0.168750000000001*G0_1_0_6_0_0 + 1.1450892857143*G0_1_0_6_0_1 - 2.90491071428574*G0_1_0_7_0_0 + 1.06071428571429*G0_1_0_7_0_1 + 1.14508928571429*G0_1_0_8_0_0 - 0.16875*G0_1_0_8_0_1 - 1.2294642857143*G0_1_0_9_0_0 - 1.2294642857143*G0_1_0_9_0_1 + 2.0263392857143*G0_1_0_10_1_0 + 2.0263392857143*G0_1_0_10_1_1 - 0.26651785714286*G0_1_0_11_1_0 - 0.26651785714286*G0_1_0_12_1_1 + 0.168750000000003*G0_1_0_13_1_0 + 0.16875*G0_1_0_13_1_1 + 0.168750000000001*G0_1_0_14_1_0 + 0.168750000000004*G0_1_0_14_1_1 + 1.06071428571429*G0_1_0_15_1_0 - 2.90491071428574*G0_1_0_15_1_1 - 0.168750000000001*G0_1_0_16_1_0 + 1.1450892857143*G0_1_0_16_1_1 - 2.90491071428574*G0_1_0_17_1_0 + 1.06071428571429*G0_1_0_17_1_1 + 1.14508928571429*G0_1_0_18_1_0 - 0.16875*G0_1_0_18_1_1 - 1.2294642857143*G0_1_0_19_1_0 - 1.2294642857143*G0_1_0_19_1_1;
    A[7] = A[217];
    A[140] = A[350];
    A[120] = -A[80] - 0.649553571428579*G0_1_0_0_0_0 - 0.649553571428579*G0_1_0_0_0_1 + 0.0529017857142857*G0_1_0_1_0_0 + 0.33616071428572*G0_1_0_2_0_1 - 0.307366071428583*G0_1_0_3_0_0 - 0.150669642857147*G0_1_0_3_0_1 + 0.325446428571431*G0_1_0_4_0_0 - 0.114508928571438*G0_1_0_4_0_1 - 0.235044642857142*G0_1_0_5_0_0 + 1.07879464285716*G0_1_0_5_0_1 - 0.325446428571431*G0_1_0_6_0_0 - 0.765401785714301*G0_1_0_6_0_1 + 0.705133928571434*G0_1_0_7_0_0 - 0.608705357142866*G0_1_0_7_0_1 - 0.108482142857141*G0_1_0_8_0_0 + 0.150669642857147*G0_1_0_8_0_1 + 0.542410714285724*G0_1_0_9_0_0 + 0.723214285714305*G0_1_0_9_0_1 - 0.649553571428579*G0_1_0_10_1_0 - 0.649553571428579*G0_1_0_10_1_1 + 0.0529017857142857*G0_1_0_11_1_0 + 0.33616071428572*G0_1_0_12_1_1 - 0.307366071428583*G0_1_0_13_1_0 - 0.150669642857147*G0_1_0_13_1_1 + 0.325446428571431*G0_1_0_14_1_0 - 0.114508928571438*G0_1_0_14_1_1 - 0.235044642857142*G0_1_0_15_1_0 + 1.07879464285716*G0_1_0_15_1_1 - 0.325446428571431*G0_1_0_16_1_0 - 0.765401785714301*G0_1_0_16_1_1 + 0.705133928571434*G0_1_0_17_1_0 - 0.608705357142866*G0_1_0_17_1_1 - 0.108482142857141*G0_1_0_18_1_0 + 0.150669642857147*G0_1_0_18_1_1 + 0.542410714285724*G0_1_0_19_1_0 + 0.723214285714305*G0_1_0_19_1_1 - 0.649553571428579*G0_1_1_0_0_0 - 0.64955357142858*G0_1_1_0_0_1 + 0.0529017857142855*G0_1_1_1_0_0 + 0.33616071428572*G0_1_1_2_0_1 - 0.307366071428583*G0_1_1_3_0_0 - 0.150669642857147*G0_1_1_3_0_1 + 0.325446428571431*G0_1_1_4_0_0 - 0.114508928571438*G0_1_1_4_0_1 - 0.235044642857142*G0_1_1_5_0_0 + 1.07879464285716*G0_1_1_5_0_1 - 0.325446428571431*G0_1_1_6_0_0 - 0.765401785714301*G0_1_1_6_0_1 + 0.705133928571434*G0_1_1_7_0_0 - 0.608705357142867*G0_1_1_7_0_1 - 0.108482142857141*G0_1_1_8_0_0 + 0.150669642857147*G0_1_1_8_0_1 + 0.542410714285725*G0_1_1_9_0_0 + 0.723214285714306*G0_1_1_9_0_1 - 0.649553571428579*G0_1_1_10_1_0 - 0.64955357142858*G0_1_1_10_1_1 + 0.0529017857142855*G0_1_1_11_1_0 + 0.33616071428572*G0_1_1_12_1_1 - 0.307366071428583*G0_1_1_13_1_0 - 0.150669642857147*G0_1_1_13_1_1 + 0.325446428571431*G0_1_1_14_1_0 - 0.114508928571438*G0_1_1_14_1_1 - 0.235044642857142*G0_1_1_15_1_0 + 1.07879464285716*G0_1_1_15_1_1 - 0.325446428571431*G0_1_1_16_1_0 - 0.765401785714301*G0_1_1_16_1_1 + 0.705133928571434*G0_1_1_17_1_0 - 0.608705357142867*G0_1_1_17_1_1 - 0.108482142857141*G0_1_1_18_1_0 + 0.150669642857147*G0_1_1_18_1_1 + 0.542410714285725*G0_1_1_19_1_0 + 0.723214285714306*G0_1_1_19_1_1;
    A[330] = A[120];
    A[220] = 0.0;
    A[196] = 0.0;
    A[295] = A[85];
    A[251] = A[41];
    A[314] = A[104];
    A[270] = A[213] + 0.18683035714286*G0_0_1_1_0_0 + 0.0120535714285714*G0_0_1_2_0_1 - 0.138616071428579*G0_0_1_3_0_0 + 0.247098214285715*G0_0_1_3_0_1 - 0.0482142857142888*G0_0_1_4_0_0 - 0.259151785714294*G0_0_1_4_0_1 - 0.114508928571432*G0_0_1_5_0_0 - 0.114508928571429*G0_0_1_5_0_1 + 0.0482142857142888*G0_0_1_6_0_0 + 0.102455357142858*G0_0_1_6_0_1 + 0.114508928571432*G0_0_1_7_0_0 + 0.114508928571429*G0_0_1_7_0_1 - 0.30133928571429*G0_0_1_8_0_0 - 0.247098214285715*G0_0_1_8_0_1 + 0.253125000000011*G0_0_1_9_0_0 + 0.144642857142865*G0_0_1_9_0_1 + 0.18683035714286*G0_0_1_11_1_0 + 0.0120535714285714*G0_0_1_12_1_1 - 0.138616071428579*G0_0_1_13_1_0 + 0.247098214285715*G0_0_1_13_1_1 - 0.0482142857142888*G0_0_1_14_1_0 - 0.259151785714294*G0_0_1_14_1_1 - 0.114508928571432*G0_0_1_15_1_0 - 0.114508928571429*G0_0_1_15_1_1 + 0.0482142857142888*G0_0_1_16_1_0 + 0.102455357142858*G0_0_1_16_1_1 + 0.114508928571432*G0_0_1_17_1_0 + 0.114508928571429*G0_0_1_17_1_1 - 0.30133928571429*G0_0_1_18_1_0 - 0.247098214285715*G0_0_1_18_1_1 + 0.253125000000011*G0_0_1_19_1_0 + 0.144642857142865*G0_0_1_19_1_1 - 0.18683035714286*G0_1_0_1_0_0 - 0.0120535714285714*G0_1_0_2_0_1 + 0.138616071428579*G0_1_0_3_0_0 - 0.247098214285715*G0_1_0_3_0_1 + 0.0482142857142888*G0_1_0_4_0_0 + 0.259151785714294*G0_1_0_4_0_1 + 0.114508928571432*G0_1_0_5_0_0 + 0.114508928571429*G0_1_0_5_0_1 - 0.0482142857142888*G0_1_0_6_0_0 - 0.102455357142858*G0_1_0_6_0_1 - 0.114508928571432*G0_1_0_7_0_0 - 0.114508928571429*G0_1_0_7_0_1 + 0.30133928571429*G0_1_0_8_0_0 + 0.247098214285715*G0_1_0_8_0_1 - 0.253125000000011*G0_1_0_9_0_0 - 0.144642857142865*G0_1_0_9_0_1 - 0.18683035714286*G0_1_0_11_1_0 - 0.0120535714285714*G0_1_0_12_1_1 + 0.138616071428579*G0_1_0_13_1_0 - 0.247098214285715*G0_1_0_13_1_1 + 0.0482142857142888*G0_1_0_14_1_0 + 0.259151785714294*G0_1_0_14_1_1 + 0.114508928571432*G0_1_0_15_1_0 + 0.114508928571429*G0_1_0_15_1_1 - 0.0482142857142888*G0_1_0_16_1_0 - 0.102455357142858*G0_1_0_16_1_1 - 0.114508928571432*G0_1_0_17_1_0 - 0.114508928571429*G0_1_0_17_1_1 + 0.30133928571429*G0_1_0_18_1_0 + 0.247098214285715*G0_1_0_18_1_1 - 0.253125000000011*G0_1_0_19_1_0 - 0.144642857142865*G0_1_0_19_1_1;
    A[310] = -A[270] - 0.433928571428572*G0_0_0_0_0_0 - 0.433928571428573*G0_0_0_0_0_1 - 0.108482142857145*G0_0_0_2_0_1 - 0.614732142857161*G0_0_0_3_0_0 - 0.36160714285715*G0_0_0_3_0_1 - 0.542410714285725*G0_0_0_4_0_0 - 0.68705357142859*G0_0_0_4_0_1 - 0.831696428571444*G0_0_0_5_0_0 + 0.397767857142852*G0_0_0_5_0_1 + 0.542410714285725*G0_0_0_6_0_0 + 0.144642857142866*G0_0_0_6_0_1 + 0.542410714285715*G0_0_0_7_0_0 - 0.687053571428581*G0_0_0_7_0_1 - 0.108482142857142*G0_0_0_8_0_0 + 0.36160714285715*G0_0_0_8_0_1 + 1.44642857142861*G0_0_0_9_0_0 + 1.37410714285717*G0_0_0_9_0_1 - 0.433928571428572*G0_0_0_10_1_0 - 0.433928571428573*G0_0_0_10_1_1 - 0.108482142857145*G0_0_0_12_1_1 - 0.614732142857161*G0_0_0_13_1_0 - 0.36160714285715*G0_0_0_13_1_1 - 0.542410714285725*G0_0_0_14_1_0 - 0.68705357142859*G0_0_0_14_1_1 - 0.831696428571444*G0_0_0_15_1_0 + 0.397767857142852*G0_0_0_15_1_1 + 0.542410714285725*G0_0_0_16_1_0 + 0.144642857142866*G0_0_0_16_1_1 + 0.542410714285715*G0_0_0_17_1_0 - 0.687053571428581*G0_0_0_17_1_1 - 0.108482142857142*G0_0_0_18_1_0 + 0.36160714285715*G0_0_0_18_1_1 + 1.44642857142861*G0_0_0_19_1_0 + 1.37410714285717*G0_0_0_19_1_1 - 0.433928571428573*G0_0_1_0_0_0 - 0.433928571428573*G0_0_1_0_0_1 - 0.108482142857146*G0_0_1_2_0_1 - 0.614732142857161*G0_0_1_3_0_0 - 0.36160714285715*G0_0_1_3_0_1 - 0.542410714285725*G0_0_1_4_0_0 - 0.68705357142859*G0_0_1_4_0_1 - 0.831696428571444*G0_0_1_5_0_0 + 0.397767857142852*G0_0_1_5_0_1 + 0.542410714285725*G0_0_1_6_0_0 + 0.144642857142865*G0_0_1_6_0_1 + 0.542410714285715*G0_0_1_7_0_0 - 0.687053571428581*G0_0_1_7_0_1 - 0.108482142857142*G0_0_1_8_0_0 + 0.36160714285715*G0_0_1_8_0_1 + 1.44642857142861*G0_0_1_9_0_0 + 1.37410714285717*G0_0_1_9_0_1 - 0.433928571428573*G0_0_1_10_1_0 - 0.433928571428573*G0_0_1_10_1_1 - 0.108482142857146*G0_0_1_12_1_1 - 0.614732142857161*G0_0_1_13_1_0 - 0.36160714285715*G0_0_1_13_1_1 - 0.542410714285725*G0_0_1_14_1_0 - 0.68705357142859*G0_0_1_14_1_1 - 0.831696428571444*G0_0_1_15_1_0 + 0.397767857142852*G0_0_1_15_1_1 + 0.542410714285725*G0_0_1_16_1_0 + 0.144642857142865*G0_0_1_16_1_1 + 0.542410714285715*G0_0_1_17_1_0 - 0.687053571428581*G0_0_1_17_1_1 - 0.108482142857142*G0_0_1_18_1_0 + 0.36160714285715*G0_0_1_18_1_1 + 1.44642857142861*G0_0_1_19_1_0 + 1.37410714285717*G0_0_1_19_1_1 + 1.59241071428573*G0_1_0_0_0_0 + 1.59241071428573*G0_1_0_0_0_1 - 0.45334821428572*G0_1_0_1_0_0 - 0.387053571428577*G0_1_0_2_0_1 - 0.307366071428579*G0_1_0_3_0_0 - 0.439955357142865*G0_1_0_3_0_1 - 0.325446428571435*G0_1_0_4_0_0 - 0.259151785714292*G0_1_0_4_0_1 + 0.343526785714281*G0_1_0_5_0_0 - 2.39263392857146*G0_1_0_5_0_1 + 0.325446428571435*G0_1_0_6_0_0 + 1.1872767857143*G0_1_0_6_0_1 - 2.47700892857146*G0_1_0_7_0_0 + 0.259151785714283*G0_1_0_7_0_1 + 1.33794642857144*G0_1_0_8_0_0 + 0.439955357142866*G0_1_0_8_0_1 - 0.0361607142857013*G0_1_0_9_0_0 + 1.59241071428573*G0_1_0_10_1_0 + 1.59241071428573*G0_1_0_10_1_1 - 0.45334821428572*G0_1_0_11_1_0 - 0.387053571428577*G0_1_0_12_1_1 - 0.307366071428579*G0_1_0_13_1_0 - 0.439955357142865*G0_1_0_13_1_1 - 0.325446428571435*G0_1_0_14_1_0 - 0.259151785714292*G0_1_0_14_1_1 + 0.343526785714281*G0_1_0_15_1_0 - 2.39263392857146*G0_1_0_15_1_1 + 0.325446428571435*G0_1_0_16_1_0 + 1.1872767857143*G0_1_0_16_1_1 - 2.47700892857146*G0_1_0_17_1_0 + 0.259151785714283*G0_1_0_17_1_1 + 1.33794642857144*G0_1_0_18_1_0 + 0.439955357142866*G0_1_0_18_1_1 - 0.0361607142857013*G0_1_0_19_1_0 + 1.59241071428573*G0_1_1_0_0_0 + 1.59241071428573*G0_1_1_0_0_1 - 0.453348214285719*G0_1_1_1_0_0 - 0.387053571428577*G0_1_1_2_0_1 - 0.307366071428579*G0_1_1_3_0_0 - 0.439955357142865*G0_1_1_3_0_1 - 0.325446428571435*G0_1_1_4_0_0 - 0.259151785714292*G0_1_1_4_0_1 + 0.343526785714281*G0_1_1_5_0_0 - 2.39263392857146*G0_1_1_5_0_1 + 0.325446428571435*G0_1_1_6_0_0 + 1.1872767857143*G0_1_1_6_0_1 - 2.47700892857146*G0_1_1_7_0_0 + 0.259151785714284*G0_1_1_7_0_1 + 1.33794642857144*G0_1_1_8_0_0 + 0.439955357142865*G0_1_1_8_0_1 - 0.0361607142857018*G0_1_1_9_0_0 + 1.59241071428573*G0_1_1_10_1_0 + 1.59241071428573*G0_1_1_10_1_1 - 0.453348214285719*G0_1_1_11_1_0 - 0.387053571428577*G0_1_1_12_1_1 - 0.307366071428579*G0_1_1_13_1_0 - 0.439955357142865*G0_1_1_13_1_1 - 0.325446428571435*G0_1_1_14_1_0 - 0.259151785714292*G0_1_1_14_1_1 + 0.343526785714281*G0_1_1_15_1_0 - 2.39263392857146*G0_1_1_15_1_1 + 0.325446428571435*G0_1_1_16_1_0 + 1.1872767857143*G0_1_1_16_1_1 - 2.47700892857146*G0_1_1_17_1_0 + 0.259151785714284*G0_1_1_17_1_1 + 1.33794642857144*G0_1_1_18_1_0 + 0.439955357142865*G0_1_1_18_1_1 - 0.0361607142857018*G0_1_1_19_1_0;
    A[5] = A[310] + 2.0263392857143*G0_0_1_0_0_0 + 2.0263392857143*G0_0_1_0_0_1 - 0.26651785714286*G0_0_1_1_0_0 - 0.26651785714286*G0_0_1_2_0_1 + 0.168750000000003*G0_0_1_3_0_0 + 0.16875*G0_0_1_3_0_1 + 0.168750000000002*G0_0_1_4_0_0 + 0.168750000000004*G0_0_1_4_0_1 + 1.06071428571429*G0_0_1_5_0_0 - 2.90491071428574*G0_0_1_5_0_1 - 0.168750000000001*G0_0_1_6_0_0 + 1.1450892857143*G0_0_1_6_0_1 - 2.90491071428574*G0_0_1_7_0_0 + 1.06071428571429*G0_0_1_7_0_1 + 1.1450892857143*G0_0_1_8_0_0 - 0.16875*G0_0_1_8_0_1 - 1.2294642857143*G0_0_1_9_0_0 - 1.2294642857143*G0_0_1_9_0_1 + 2.0263392857143*G0_0_1_10_1_0 + 2.0263392857143*G0_0_1_10_1_1 - 0.26651785714286*G0_0_1_11_1_0 - 0.26651785714286*G0_0_1_12_1_1 + 0.168750000000003*G0_0_1_13_1_0 + 0.16875*G0_0_1_13_1_1 + 0.168750000000002*G0_0_1_14_1_0 + 0.168750000000004*G0_0_1_14_1_1 + 1.06071428571429*G0_0_1_15_1_0 - 2.90491071428574*G0_0_1_15_1_1 - 0.168750000000001*G0_0_1_16_1_0 + 1.1450892857143*G0_0_1_16_1_1 - 2.90491071428574*G0_0_1_17_1_0 + 1.06071428571429*G0_0_1_17_1_1 + 1.1450892857143*G0_0_1_18_1_0 - 0.16875*G0_0_1_18_1_1 - 1.2294642857143*G0_0_1_19_1_0 - 1.2294642857143*G0_0_1_19_1_1 - 2.0263392857143*G0_1_0_0_0_0 - 2.0263392857143*G0_1_0_0_0_1 + 0.26651785714286*G0_1_0_1_0_0 + 0.26651785714286*G0_1_0_2_0_1 - 0.168750000000003*G0_1_0_3_0_0 - 0.16875*G0_1_0_3_0_1 - 0.168750000000002*G0_1_0_4_0_0 - 0.168750000000004*G0_1_0_4_0_1 - 1.06071428571429*G0_1_0_5_0_0 + 2.90491071428574*G0_1_0_5_0_1 + 0.168750000000002*G0_1_0_6_0_0 - 1.1450892857143*G0_1_0_6_0_1 + 2.90491071428574*G0_1_0_7_0_0 - 1.06071428571429*G0_1_0_7_0_1 - 1.1450892857143*G0_1_0_8_0_0 + 0.16875*G0_1_0_8_0_1 + 1.2294642857143*G0_1_0_9_0_0 + 1.2294642857143*G0_1_0_9_0_1 - 2.0263392857143*G0_1_0_10_1_0 - 2.0263392857143*G0_1_0_10_1_1 + 0.26651785714286*G0_1_0_11_1_0 + 0.26651785714286*G0_1_0_12_1_1 - 0.168750000000003*G0_1_0_13_1_0 - 0.16875*G0_1_0_13_1_1 - 0.168750000000002*G0_1_0_14_1_0 - 0.168750000000004*G0_1_0_14_1_1 - 1.06071428571429*G0_1_0_15_1_0 + 2.90491071428574*G0_1_0_15_1_1 + 0.168750000000002*G0_1_0_16_1_0 - 1.1450892857143*G0_1_0_16_1_1 + 2.90491071428574*G0_1_0_17_1_0 - 1.06071428571429*G0_1_0_17_1_1 - 1.1450892857143*G0_1_0_18_1_0 + 0.16875*G0_1_0_18_1_1 + 1.2294642857143*G0_1_0_19_1_0 + 1.2294642857143*G0_1_0_19_1_1;
    A[215] = A[5];
    A[100] = A[310];
    A[57] = 0.0;
    A[1] = -A[41] + 0.182589285714288*G0_0_0_0_0_0 + 0.182589285714288*G0_0_0_0_0_1 - 0.182589285714288*G0_0_0_1_0_0 - 0.00781249999999974*G0_0_0_2_0_1 - 0.0796875000000009*G0_0_0_3_0_0 - 0.266517857142861*G0_0_0_3_0_1 + 0.0287946428571436*G0_0_0_4_0_0 + 0.0408482142857147*G0_0_0_4_0_1 + 0.0796875000000008*G0_0_0_5_0_0 - 0.186830357142859*G0_0_0_5_0_1 - 0.0287946428571436*G0_0_0_6_0_0 + 0.0120535714285709*G0_0_0_6_0_1 - 0.41584821428572*G0_0_0_7_0_0 - 0.14933035714286*G0_0_0_7_0_1 + 0.41584821428572*G0_0_0_8_0_0 + 0.266517857142861*G0_0_0_8_0_1 + 0.108482142857145*G0_0_0_9_0_1 + 0.182589285714288*G0_0_0_10_1_0 + 0.182589285714288*G0_0_0_10_1_1 - 0.182589285714288*G0_0_0_11_1_0 - 0.00781249999999974*G0_0_0_12_1_1 - 0.0796875000000009*G0_0_0_13_1_0 - 0.266517857142861*G0_0_0_13_1_1 + 0.0287946428571436*G0_0_0_14_1_0 + 0.0408482142857147*G0_0_0_14_1_1 + 0.0796875000000008*G0_0_0_15_1_0 - 0.186830357142859*G0_0_0_15_1_1 - 0.0287946428571436*G0_0_0_16_1_0 + 0.0120535714285709*G0_0_0_16_1_1 - 0.41584821428572*G0_0_0_17_1_0 - 0.14933035714286*G0_0_0_17_1_1 + 0.41584821428572*G0_0_0_18_1_0 + 0.266517857142861*G0_0_0_18_1_1 + 0.108482142857145*G0_0_0_19_1_1 + 0.174776785714288*G0_1_0_0_0_0 + 0.174776785714288*G0_1_0_0_0_1 + 0.174776785714289*G0_1_0_2_0_1 - 0.229017857142862*G0_1_0_3_0_0 + 0.295312500000005*G0_1_0_4_0_0 - 0.108482142857145*G0_1_0_4_0_1 + 0.120535714285716*G0_1_0_5_0_0 - 0.174776785714288*G0_1_0_5_0_1 - 0.295312500000005*G0_1_0_6_0_0 - 0.174776785714289*G0_1_0_6_0_1 - 0.403794642857149*G0_1_0_7_0_0 - 0.108482142857146*G0_1_0_7_0_1 + 0.229017857142861*G0_1_0_8_0_0 + 0.108482142857146*G0_1_0_9_0_0 + 0.216964285714291*G0_1_0_9_0_1 + 0.174776785714288*G0_1_0_10_1_0 + 0.174776785714288*G0_1_0_10_1_1 + 0.174776785714289*G0_1_0_12_1_1 - 0.229017857142862*G0_1_0_13_1_0 + 0.295312500000005*G0_1_0_14_1_0 - 0.108482142857145*G0_1_0_14_1_1 + 0.120535714285716*G0_1_0_15_1_0 - 0.174776785714288*G0_1_0_15_1_1 - 0.295312500000005*G0_1_0_16_1_0 - 0.174776785714289*G0_1_0_16_1_1 - 0.403794642857149*G0_1_0_17_1_0 - 0.108482142857146*G0_1_0_17_1_1 + 0.229017857142861*G0_1_0_18_1_0 + 0.108482142857146*G0_1_0_19_1_0 + 0.216964285714291*G0_1_0_19_1_1;
    A[72] = 0.0;
    A[32] = 0.0;
    A[95] = 0.0;
    A[51] = 0.0;
    A[114] = 0.0;
    A[78] = 0.0;
    A[133] = 0.0;
    A[148] = A[358];
    A[360] = 0.0;
    A[336] = A[126];
    A[242] = 0.0;
    A[263] = 0.0;
    A[25] = A[235];
    A[42] = A[252];
    A[124] = A[86] - 0.325446428571431*G0_0_1_0_0_0 - 0.325446428571431*G0_0_1_0_0_1 + 0.325446428571432*G0_0_1_1_0_0 + 1.84419642857145*G0_0_1_2_0_1 - 1.84419642857145*G0_0_1_3_0_0 - 0.108482142857146*G0_0_1_3_0_1 + 2.71205357142862*G0_0_1_4_0_0 - 0.54241071428571*G0_0_1_4_0_1 + 1.84419642857145*G0_0_1_5_0_0 + 1.7357142857143*G0_0_1_5_0_1 - 2.71205357142862*G0_0_1_6_0_0 - 3.25446428571433*G0_0_1_6_0_1 + 0.108482142857143*G0_0_1_7_0_1 + 0.108482142857146*G0_0_1_8_0_1 + 0.433928571428567*G0_0_1_9_0_1 - 0.325446428571431*G0_0_1_10_1_0 - 0.325446428571431*G0_0_1_10_1_1 + 0.325446428571432*G0_0_1_11_1_0 + 1.84419642857145*G0_0_1_12_1_1 - 1.84419642857145*G0_0_1_13_1_0 - 0.108482142857146*G0_0_1_13_1_1 + 2.71205357142862*G0_0_1_14_1_0 - 0.54241071428571*G0_0_1_14_1_1 + 1.84419642857145*G0_0_1_15_1_0 + 1.7357142857143*G0_0_1_15_1_1 - 2.71205357142862*G0_0_1_16_1_0 - 3.25446428571433*G0_0_1_16_1_1 + 0.108482142857143*G0_0_1_17_1_1 + 0.108482142857146*G0_0_1_18_1_1 + 0.433928571428567*G0_0_1_19_1_1 + 0.325446428571431*G0_1_0_0_0_0 + 0.325446428571431*G0_1_0_0_0_1 - 0.325446428571432*G0_1_0_1_0_0 - 1.84419642857145*G0_1_0_2_0_1 + 1.84419642857145*G0_1_0_3_0_0 + 0.108482142857146*G0_1_0_3_0_1 - 2.71205357142862*G0_1_0_4_0_0 + 0.54241071428571*G0_1_0_4_0_1 - 1.84419642857145*G0_1_0_5_0_0 - 1.7357142857143*G0_1_0_5_0_1 + 2.71205357142862*G0_1_0_6_0_0 + 3.25446428571433*G0_1_0_6_0_1 - 0.108482142857143*G0_1_0_7_0_1 - 0.108482142857146*G0_1_0_8_0_1 - 0.433928571428567*G0_1_0_9_0_1 + 0.325446428571431*G0_1_0_10_1_0 + 0.325446428571431*G0_1_0_10_1_1 - 0.325446428571432*G0_1_0_11_1_0 - 1.84419642857145*G0_1_0_12_1_1 + 1.84419642857145*G0_1_0_13_1_0 + 0.108482142857146*G0_1_0_13_1_1 - 2.71205357142862*G0_1_0_14_1_0 + 0.54241071428571*G0_1_0_14_1_1 - 1.84419642857145*G0_1_0_15_1_0 - 1.7357142857143*G0_1_0_15_1_1 + 2.71205357142862*G0_1_0_16_1_0 + 3.25446428571433*G0_1_0_16_1_1 - 0.108482142857143*G0_1_0_17_1_1 - 0.108482142857146*G0_1_0_18_1_1 - 0.433928571428567*G0_1_0_19_1_1;
    A[141] = A[351];
    A[117] = 0.0;
    A[382] = 0.0;
    A[163] = A[373];
    A[182] = A[392];
    A[283] = 0.0;
    A[60] = A[270];
    A[334] = A[124];
    A[137] = 0.0;
    A[391] = A[181];
    A[355] = A[145];
    A[372] = A[162];
    A[170] = 0.0;
    A[191] = 0.0;
    A[200] = 0.0;
    A[176] = 0.0;
    A[233] = A[23];
    A[290] = A[80];
    A[254] = A[44];
    A[303] = 0.0;
    A[275] = A[65];
    A[12] = 0.0;
    A[69] = A[279];
    A[29] = A[239];
    A[82] = A[292];
    A[54] = 0.0;
    A[103] = A[313];
    A[325] = 0.0;
    A[128] = -A[333] + 0.150669642857147*G0_0_0_0_0_0 + 0.150669642857147*G0_0_0_0_0_1 + 0.445982142857151*G0_0_0_1_0_0 + 1.3138392857143*G0_0_0_2_0_1 - 2.22388392857147*G0_0_0_3_0_0 - 0.108482142857145*G0_0_0_3_0_1 + 2.27812500000004*G0_0_0_4_0_0 - 0.705133928571437*G0_0_0_4_0_1 - 0.271205357142871*G0_0_0_5_0_0 - 0.325446428571444*G0_0_0_5_0_1 - 2.27812500000004*G0_0_0_6_0_0 - 1.13906250000001*G0_0_0_6_0_1 - 0.542410714285722*G0_0_0_7_0_0 - 0.488169642857148*G0_0_0_7_0_1 - 0.0542410714285762*G0_0_0_8_0_0 + 0.108482142857145*G0_0_0_8_0_1 + 2.49508928571434*G0_0_0_9_0_0 + 1.19330357142859*G0_0_0_9_0_1 + 0.150669642857147*G0_0_0_10_1_0 + 0.150669642857147*G0_0_0_10_1_1 + 0.445982142857151*G0_0_0_11_1_0 + 1.3138392857143*G0_0_0_12_1_1 - 2.22388392857147*G0_0_0_13_1_0 - 0.108482142857145*G0_0_0_13_1_1 + 2.27812500000004*G0_0_0_14_1_0 - 0.705133928571437*G0_0_0_14_1_1 - 0.271205357142871*G0_0_0_15_1_0 - 0.325446428571444*G0_0_0_15_1_1 - 2.27812500000004*G0_0_0_16_1_0 - 1.13906250000001*G0_0_0_16_1_1 - 0.542410714285722*G0_0_0_17_1_0 - 0.488169642857148*G0_0_0_17_1_1 - 0.0542410714285762*G0_0_0_18_1_0 + 0.108482142857145*G0_0_0_18_1_1 + 2.49508928571434*G0_0_0_19_1_0 + 1.19330357142859*G0_0_0_19_1_1 - 0.108482142857142*G0_1_0_0_0_0 - 0.108482142857142*G0_1_0_0_0_1 + 0.705133928571438*G0_1_0_2_0_1 - 0.162723214285726*G0_1_0_3_0_0 + 1.13906250000001*G0_1_0_4_0_0 + 0.271205357142849*G0_1_0_4_0_1 + 1.24754464285718*G0_1_0_5_0_0 + 0.922098214285733*G0_1_0_5_0_1 - 1.13906250000001*G0_1_0_6_0_0 - 1.51875000000003*G0_1_0_6_0_1 - 0.0542410714285712*G0_1_0_7_0_0 + 0.271205357142877*G0_1_0_7_0_1 + 0.162723214285713*G0_1_0_8_0_0 - 1.08482142857145*G0_1_0_9_0_0 - 0.542410714285726*G0_1_0_9_0_1 - 0.108482142857142*G0_1_0_10_1_0 - 0.108482142857142*G0_1_0_10_1_1 + 0.705133928571438*G0_1_0_12_1_1 - 0.162723214285726*G0_1_0_13_1_0 + 1.13906250000001*G0_1_0_14_1_0 + 0.271205357142849*G0_1_0_14_1_1 + 1.24754464285718*G0_1_0_15_1_0 + 0.922098214285733*G0_1_0_15_1_1 - 1.13906250000001*G0_1_0_16_1_0 - 1.51875000000003*G0_1_0_16_1_1 - 0.0542410714285712*G0_1_0_17_1_0 + 0.271205357142877*G0_1_0_17_1_1 + 0.162723214285713*G0_1_0_18_1_0 - 1.08482142857145*G0_1_0_19_1_0 - 0.542410714285726*G0_1_0_19_1_1;
    A[396] = A[186];
    A[340] = 0.0;
    A[153] = 0.0;
    A[367] = 0.0;
    A[192] = 0.0;
    A[211] = A[1];
    A[222] = 0.0;
    A[293] = A[83];
    A[245] = 0.0;
    A[308] = 0.0;
    A[268] = 0.0;
    A[3] = A[213];
    A[74] = 0.0;
    A[22] = A[232];
    A[89] = A[299];
    A[49] = A[259];
    A[112] = 0.0;
    A[123] = A[333];
    A[150] = 0.0;
    A[338] = A[128];
    A[359] = A[149];
    A[317] = A[107];
    A[261] = 0.0;
    A[237] = A[27];
    A[40] = A[250];
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    throw std::runtime_error("Quadrature version of tabulate_tensor not available when using the FFC tensor representation.");
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class vector_laplacian_f1_p3_q3_tensor_form_0: public ufc::form
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q3_tensor_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q3_tensor_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Product(IndexSum(IndexSum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('triangle', Space(2)), 3, 2, None), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), MultiIndex((Index(1), Index(0)), {Index(0): 2, Index(1): 2})), MultiIndex((Index(2), Index(3)), {Index(2): 2, Index(3): 2})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('triangle', Space(2)), 3, 2, None), 1), MultiIndex((Index(4),), {Index(4): 2})), MultiIndex((Index(5),), {Index(5): 2})), MultiIndex((Index(5), Index(4)), {Index(4): 2, Index(5): 2})), MultiIndex((Index(2), Index(3)), {Index(2): 2, Index(3): 2}))), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(3),), {Index(3): 2})), IndexSum(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('triangle', Space(2)), 3, 2, None), 0), MultiIndex((Index(6),), {Index(6): 2})), MultiIndex((Index(6),), {Index(6): 2})), MultiIndex((Index(6),), {Index(6): 2}))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p3_q3_tensor_finite_element_1();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p3_q3_tensor_finite_element_1();
        break;
      }
    case 2:
      {
        return new vector_laplacian_f1_p3_q3_tensor_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p3_q3_tensor_dofmap_1();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p3_q3_tensor_dofmap_1();
        break;
      }
    case 2:
      {
        return new vector_laplacian_f1_p3_q3_tensor_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p3_q3_tensor_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
