// This code conforms with the UFC specification version 2.0.5
// and was automatically generated by FFC version 1.0.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'tensor'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __VECTOR_LAPLACIAN_F1_P3_Q4_TENSOR_H
#define __VECTOR_LAPLACIAN_F1_P3_Q4_TENSOR_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p3_q4_tensor_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q4_tensor_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q4_tensor_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 10;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 10; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p3_q4_tensor_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p3_q4_tensor_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q4_tensor_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q4_tensor_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('triangle', Space(2)), 3, 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 20;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 10; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791033, -0.0288675134594813, -0.0166666666666666, 0.0782460796435952, 0.0606091526731326, 0.0349927106111883, -0.0601337794302955, -0.0508223195384204, -0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0288675134594813, -0.0166666666666666, 0.0782460796435952, -0.0606091526731327, 0.0349927106111883, 0.0601337794302955, -0.0508223195384204, 0.0393667994375868, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.0471404520791032, 0.0, 0.0333333333333334, 0.0, 0.0, 0.104978131833565, 0.0, 0.0, 0.0, 0.0909137290096989};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, 0.117369119465393, 0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, -0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, 0.151522881682832, 0.0262445329583912, 0.0, 0.0, 0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, 0.117369119465393, -0.0606091526731326, -0.0787335988751736, 0.0, 0.101644639076841, 0.131222664791956, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.0, 0.3, 0.0, -0.151522881682832, 0.0262445329583912, 0.0, 0.0, -0.131222664791956, -0.136370593514548};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, -0.259807621135332, -0.15, -0.0782460796435952, 0.090913729009699, 0.0962299541807677, 0.180401338290886, 0.0508223195384204, -0.0131222664791956, -0.0227284322524247};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.106066017177982, 0.259807621135332, -0.15, -0.0782460796435952, -0.090913729009699, 0.0962299541807678, -0.180401338290886, 0.0508223195384204, 0.0131222664791956, -0.0227284322524248};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[10] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[6] *= std::sqrt(14.0);
      
      // Table(s) of coefficients.
      static const double coefficients0[10] = \
      {0.636396103067893, 0.0, 0.0, -0.234738238930785, 0.0, -0.262445329583912, 0.0, -0.203289278153682, 0.0, 0.090913729009699};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556636, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.611010092660779, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[10][10] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470957, 6.83130051063973, -1.05830052442584, 0.305505046330389, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865476, 6.26099033699941, -1.80739222823013, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238571, 4.2, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.82842712474619, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[10][10] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 10; t++)
        {
          for (unsigned int u = 0; u < 10; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 10; t++)
          {
            for (unsigned int u = 0; u < 10; u++)
            {
              for (unsigned int tu = 0; tu < 10; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 10; s++)
        {
          for (unsigned int t = 0; t < 10; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[2*num_derivatives];
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 20; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2*num_derivatives; s++)
      {
        values[r*2*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 11:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 12:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 13:
      {
        y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 14:
      {
        y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 15:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 16:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 17:
      {
        y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
      y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 18:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
      y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 19:
      {
        y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
      y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[2];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[10] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[1];
    y[0] = 0.666666666666667*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[1];
    y[0] = 0.333333333333333*x[1][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[1][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[1];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[2][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[15] = vals[1];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[2][1];
    f.evaluate(vals, y, c);
    values[16] = vals[1];
    y[0] = 0.666666666666667*x[0][0] + 0.333333333333333*x[1][0];
    y[1] = 0.666666666666667*x[0][1] + 0.333333333333333*x[1][1];
    f.evaluate(vals, y, c);
    values[17] = vals[1];
    y[0] = 0.333333333333333*x[0][0] + 0.666666666666667*x[1][0];
    y[1] = 0.333333333333333*x[0][1] + 0.666666666666667*x[1][1];
    f.evaluate(vals, y, c);
    values[18] = vals[1];
    y[0] = 0.333333333333333*x[0][0] + 0.333333333333333*x[1][0] + 0.333333333333333*x[2][0];
    y[1] = 0.333333333333333*x[0][1] + 0.333333333333333*x[1][1] + 0.333333333333333*x[2][1];
    f.evaluate(vals, y, c);
    values[19] = vals[1];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[2] = dof_values[1];
    vertex_values[4] = dof_values[2];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[10];
    vertex_values[3] = dof_values[11];
    vertex_values[5] = dof_values[12];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new vector_laplacian_f1_p3_q4_tensor_finite_element_0();
        break;
      }
    case 1:
      {
        return new vector_laplacian_f1_p3_q4_tensor_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p3_q4_tensor_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p3_q4_tensor_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q4_tensor_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q4_tensor_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', Space(2)), 4, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 15;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 15; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.75*x[1][0] + 0.25*x[2][0];
      y[1] = 0.75*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*x[1][0] + 0.5*x[2][0];
      y[1] = 0.5*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.25*x[1][0] + 0.75*x[2][0];
      y[1] = 0.25*x[1][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 6:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[2][0];
      y[1] = 0.75*x[0][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 7:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[2][0];
      y[1] = 0.5*x[0][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 8:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[2][0];
      y[1] = 0.25*x[0][1] + 0.75*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 9:
      {
        y[0] = 0.75*x[0][0] + 0.25*x[1][0];
      y[1] = 0.75*x[0][1] + 0.25*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 10:
      {
        y[0] = 0.5*x[0][0] + 0.5*x[1][0];
      y[1] = 0.5*x[0][1] + 0.5*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 11:
      {
        y[0] = 0.25*x[0][0] + 0.75*x[1][0];
      y[1] = 0.25*x[0][1] + 0.75*x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 12:
      {
        y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
      y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 13:
      {
        y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
      y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 14:
      {
        y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
      y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.75*x[1][0] + 0.25*x[2][0];
    y[1] = 0.75*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*x[1][0] + 0.5*x[2][0];
    y[1] = 0.5*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.25*x[1][0] + 0.75*x[2][0];
    y[1] = 0.25*x[1][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[2][0];
    y[1] = 0.75*x[0][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[6] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[2][0];
    y[1] = 0.5*x[0][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[7] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[2][0];
    y[1] = 0.25*x[0][1] + 0.75*x[2][1];
    f.evaluate(vals, y, c);
    values[8] = vals[0];
    y[0] = 0.75*x[0][0] + 0.25*x[1][0];
    y[1] = 0.75*x[0][1] + 0.25*x[1][1];
    f.evaluate(vals, y, c);
    values[9] = vals[0];
    y[0] = 0.5*x[0][0] + 0.5*x[1][0];
    y[1] = 0.5*x[0][1] + 0.5*x[1][1];
    f.evaluate(vals, y, c);
    values[10] = vals[0];
    y[0] = 0.25*x[0][0] + 0.75*x[1][0];
    y[1] = 0.25*x[0][1] + 0.75*x[1][1];
    f.evaluate(vals, y, c);
    values[11] = vals[0];
    y[0] = 0.5*x[0][0] + 0.25*x[1][0] + 0.25*x[2][0];
    y[1] = 0.5*x[0][1] + 0.25*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[12] = vals[0];
    y[0] = 0.25*x[0][0] + 0.5*x[1][0] + 0.25*x[2][0];
    y[1] = 0.25*x[0][1] + 0.5*x[1][1] + 0.25*x[2][1];
    f.evaluate(vals, y, c);
    values[13] = vals[0];
    y[0] = 0.25*x[0][0] + 0.25*x[1][0] + 0.5*x[2][0];
    y[1] = 0.25*x[0][1] + 0.25*x[1][1] + 0.5*x[2][1];
    f.evaluate(vals, y, c);
    values[14] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented (introduced in UFC 2.0).");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new vector_laplacian_f1_p3_q4_tensor_finite_element_2();
  }

};

/// This class defines the interface for a finite element.

class vector_laplacian_f1_p3_q4_tensor_finite_element_3: public ufc::finite_element
{
public:

  /// Constructor
  vector_laplacian_f1_p3_q4_tensor_finite_element_3() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~vector_laplacian_f1_p3_q4_tensor_finite_element_3()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('triangle', Space(2)), 4, 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 30;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 2;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 15; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[2] = {0.0, 0.0};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 30; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 2; s++)
      {
        values[r*2 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 2*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421884, 0.351908735506058, -0.203174603174603, -0.139104141588614, 0.107749604752236, -0.0622092633087792, -0.19005243869328, -0.0267706045305259, -0.124418526617558, 0.155638317975452, 0.0, -0.169988068883114, 0.0838052481406278, 0.0278208283177227, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, 0.0, 0.406349206349206, 0.0, 0.0, -0.186627789926337, 0.0, -0.187394231713682, 0.0, -0.203527031198668, 0.0, 0.0, -0.167610496281256, 0.0, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, -0.0412393049421161, -0.0238095238095238, 0.0289800294976278, 0.0224478343233825, 0.012960263189329, -0.0395942580610999, -0.0334632556631574, -0.025920526378658, -0.014965222882255, 0.0321247254366312, 0.0283313448138523, 0.023944356611608, 0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0412393049421161, -0.0238095238095238, 0.0289800294976278, -0.0224478343233825, 0.012960263189329, 0.0395942580610999, -0.0334632556631574, 0.025920526378658, -0.014965222882255, 0.0321247254366312, -0.0283313448138523, 0.023944356611608, -0.0185472188784818, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.0, 0.0, 0.0476190476190476, 0.0, 0.0, 0.038880789567987, 0.0, 0.0, 0.0, 0.0598608915290199, 0.0, 0.0, 0.0, 0.0, 0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.131965775814772, -0.0253968253968253, 0.139104141588614, -0.0718330698348239, 0.0311046316543896, 0.0633508128977599, 0.0267706045305259, -0.0622092633087791, 0.0478887132232159, 0.0, 0.0566626896277046, -0.0838052481406279, 0.0834624849531682, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527355, 0.0109971479845642, 0.00634920634920636, 0.0, 0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.0, 0.0, 0.0838052481406279, -0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, 0.0439885919382572, 0.126984126984127, 0.0, 0.035916534917412, 0.155523158271948, 0.0, 0.0, 0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, 0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, -0.131965775814772, -0.0253968253968254, 0.139104141588614, 0.0718330698348239, 0.0311046316543895, -0.0633508128977599, 0.0267706045305259, 0.0622092633087791, 0.0478887132232159, 0.0, -0.0566626896277046, -0.0838052481406278, -0.0834624849531681, -0.0535412090610519};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527353, -0.0109971479845644, 0.00634920634920625, 0.0, -0.188561808316413, -0.163299316185545, 0.0, 0.0936971158568409, 0.0, -0.0419026240703138, 0.0, 0.0, 0.0838052481406278, 0.139104141588614, 0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0439885919382572, 0.126984126984127, 0.0, -0.0359165349174119, 0.155523158271948, 0.0, 0.0, -0.103682105514632, -0.011972178305804, 0.0, 0.0, 0.0, -0.0927360943924091, -0.107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210942, -0.0879771838765144, -0.101587301587302, 0.0927360943924091, 0.107749604752236, 0.0725774738602423, 0.0791885161221998, -0.013385302265263, -0.0518410527573159, -0.0419026240703139, -0.128498901746525, -0.0566626896277046, -0.011972178305804, 0.00927360943924089, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {-0.0314269680527354, 0.0, -0.0126984126984126, -0.243432247780074, 0.0, 0.0544331053951817, 0.0, 0.0936971158568408, 0.0, -0.0419026240703139, 0.192748352619787, 0.0, -0.023944356611608, 0.0, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.125707872210941, 0.0879771838765144, -0.101587301587302, 0.0927360943924091, -0.107749604752236, 0.0725774738602423, -0.0791885161221998, -0.013385302265263, 0.051841052757316, -0.0419026240703139, -0.128498901746525, 0.0566626896277046, -0.011972178305804, -0.00927360943924091, 0.0107082418122104};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 15; t++)
          {
            for (unsigned int u = 0; u < 15; u++)
            {
              for (unsigned int tu = 0; tu < 15; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 15; s++)
        {
          for (unsigned int t = 0; t < 15; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[15] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables.
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues.
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[6] = basisvalues[3]*1.66666666666667*tmp0 - basisvalues[1]*0.666666666666667*tmp2;
      basisvalues[10] = basisvalues[6]*1.75*tmp0 - basisvalues[3]*0.75*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[7] = basisvalues[3]*(2.5 + 3.5*Y);
      basisvalues[11] = basisvalues[6]*(3.5 + 4.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[9] = basisvalues[5]*(0.05 + Y*1.75) - basisvalues[2]*0.7;
      basisvalues[14] = basisvalues[9]*(0.0285714285714286 + Y*1.8) - basisvalues[5]*0.771428571428571;
      basisvalues[8] = basisvalues[4]*(0.54 + Y*2.1) - basisvalues[1]*0.56;
      basisvalues[13] = basisvalues[8]*(0.285714285714286 + Y*2.0) - basisvalues[4]*0.714285714285714;
      basisvalues[12] = basisvalues[7]*(1.02040816326531 + Y*2.57142857142857) - basisvalues[3]*0.551020408163265;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[9] *= std::sqrt(2.0);
      basisvalues[14] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[8] *= std::sqrt(6.0);
      basisvalues[13] *= std::sqrt(7.5);
      basisvalues[3] *= std::sqrt(7.5);
      basisvalues[7] *= std::sqrt(10.0);
      basisvalues[12] *= std::sqrt(12.5);
      basisvalues[6] *= std::sqrt(14.0);
      basisvalues[11] *= std::sqrt(17.5);
      basisvalues[10] *= std::sqrt(22.5);
      
      // Table(s) of coefficients.
      static const double coefficients0[15] = \
      {0.251415744421883, -0.351908735506058, -0.203174603174603, -0.139104141588614, -0.107749604752236, -0.0622092633087791, 0.19005243869328, -0.0267706045305259, 0.124418526617558, 0.155638317975452, 0.0, 0.169988068883114, 0.0838052481406278, -0.0278208283177227, -0.053541209061052};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.0, 0.0, 7.07106781186548, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.29150262212918, 0.0, -2.99332590941915, 13.6626010212795, 0.0, 0.61101009266078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.38178046004133, 0.0, 0.0, 12.5219806739988, 1.36319883402694e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.46410161513776, 0.0, 7.83836717690617, 0.0, 0.0, 8.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 10.9544511501033, 0.0, 0.0, -3.83325938999965, 0.0, 17.7482393492989, 0.0, 0.553283335172492, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.73286382647969, 0.0, 3.3466401061363, 4.36435780471985, 0.0, -5.07468037933237, 0.0, 17.0084012854152, 0.0, 1.52127765851133, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.44948974278318, 0.0, 0.0, 9.14285714285714, 0.0, 0.0, 0.0, 14.8461497791618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.09838667696593, 0.0, 7.66811580507233, 0.0, 0.0, 10.733126291999, 0.0, 0.0, 0.0, 9.2951600308978, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[15][15] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.64575131106459, 5.18459255872629, -1.49666295470958, 6.83130051063974, -1.05830052442584, 0.305505046330393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.23606797749979, 2.19089023002067, 2.52982212813471, 8.08290376865477, 6.26099033699942, -1.80739222823013, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.73205080756888, -5.09116882454314, 3.91918358845309, 0.0, 9.69948452238572, 4.2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5, 0.0, -2.8284271247462, 0.0, 0.0, 12.1243556529821, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.68328157299975, 5.47722557505166, -1.89736659610103, 7.4230748895809, -1.91662969499982, 0.663940002206988, 8.87411967464942, -1.07142857142857, 0.276641667586246, -0.0958314847499898, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.36643191323985, 2.89827534923789, 1.67332005306816, 2.18217890235992, 5.74704893215391, -2.53734018966618, 10.0623058987491, 8.50420064270762, -2.1957751641342, 0.760638829255666, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2, 1.22474487139159, 3.53553390593274, -7.37711113563318, 4.57142857142858, 1.64957219768465, 0.0, 11.4997781699989, 7.42307488958091, -2.57142857142857, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.54919333848296, 6.64078308635359, 3.83405790253616, 0.0, -6.19677335393187, 5.36656314599949, 0.0, 0.0, 13.4164078649987, 4.6475800154489, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.57770876399967, 0.0, 8.85437744847147, 0.0, 0.0, -3.09838667696593, 0.0, 0.0, 0.0, 16.0996894379985, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[15][15] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 15; t++)
        {
          for (unsigned int u = 0; u < 15; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
