/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.AnimationMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.Relation;

public class ControlActionRegistry {
    Hashtable actionNumber = new Hashtable();
    Hashtable controlNumber = new Hashtable();
    Relation actionsToControls;
    Relation controlsToActions;
    int[][] controlMap;
    int[][] actionMap;
    String[] actionAlphabet;
    String[] controlAlphabet;
    boolean[] controlState;
    AnimationMessage msg;

    public ControlActionRegistry(Relation relation, AnimationMessage animationMessage) {
        this.actionsToControls = relation;
        this.msg = animationMessage;
    }

    void getAnimatorControls() {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.controlsToActions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.controlNumber.put(string, new Integer(n));
            vector.addElement(string);
            ++n;
        }
        this.controlAlphabet = new String[n];
        vector.copyInto(this.controlAlphabet);
    }

    public Vector getControls() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.actionsToControls.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    public int controlled(String string) {
        Integer n = (Integer)this.actionNumber.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    void initMap(String[] stringArray) {
        this.actionAlphabet = stringArray;
        for (int i = 1; i < stringArray.length; ++i) {
            this.actionNumber.put(stringArray[i], new Integer(i));
        }
        Enumeration<Object> enumeration = this.actionsToControls.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.actionNumber.get(string) != null) continue;
            vector.addElement(string);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.actionsToControls.remove(enumeration.nextElement());
        }
        this.controlsToActions = this.actionsToControls.inverse();
        this.getAnimatorControls();
        this.controlMap = new int[this.controlAlphabet.length][];
        this.controlState = new boolean[this.controlAlphabet.length];
        for (int i = 0; i < this.controlState.length; ++i) {
            this.controlState[i] = true;
        }
        this.initControlMap();
        this.initActionMap();
    }

    protected void initControlMap() {
        Enumeration enumeration = this.controlsToActions.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray;
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.controlNumber.get(string);
            Object v = this.controlsToActions.get(string);
            if (v instanceof String) {
                int n2 = (Integer)this.actionNumber.get((String)v);
                nArray = new int[]{n2};
                this.controlMap[n] = nArray;
                continue;
            }
            Vector vector = (Vector)v;
            nArray = new int[vector.size()];
            Enumeration enumeration2 = vector.elements();
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                int n4;
                String string2 = (String)enumeration2.nextElement();
                nArray[n3] = n4 = ((Integer)this.actionNumber.get(string2)).intValue();
                ++n3;
            }
            this.controlMap[n] = nArray;
        }
    }

    protected void initActionMap() {
        this.actionMap = new int[this.actionAlphabet.length][];
        Enumeration enumeration = this.actionsToControls.keys();
        while (enumeration.hasMoreElements()) {
            int[] nArray;
            String string = (String)enumeration.nextElement();
            int n = (Integer)this.actionNumber.get(string);
            Object v = this.actionsToControls.get(string);
            if (v instanceof String) {
                int n2 = (Integer)this.controlNumber.get((String)v);
                nArray = new int[]{n2};
                this.actionMap[n] = nArray;
                continue;
            }
            Vector vector = (Vector)v;
            nArray = new int[vector.size()];
            Enumeration enumeration2 = vector.elements();
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                int n4;
                String string2 = (String)enumeration2.nextElement();
                nArray[n3] = n4 = ((Integer)this.controlNumber.get(string2)).intValue();
                ++n3;
            }
            this.actionMap[n] = nArray;
        }
    }

    void print() {
        for (int i = 0; i < this.controlMap.length; ++i) {
            System.out.println(this.controlAlphabet[i]);
            for (int j = 0; j < this.controlMap[i].length; ++j) {
                System.out.print(" " + this.actionAlphabet[this.controlMap[i][j]]);
            }
            System.out.println();
        }
    }

    void mapControl(String string, boolean[] blArray, boolean bl) {
        String string2 = bl ? "-enable-" : "-disabl-";
        this.msg.debugMsg("-control" + string2 + string);
        Integer n = (Integer)this.controlNumber.get(string);
        if (n == null) {
            return;
        }
        int n2 = n;
        this.controlState[n2] = bl;
        if (this.controlMap[n2] == null) {
            return;
        }
        for (int i = 0; i < this.controlMap[n2].length; ++i) {
            int n3 = this.controlMap[n2][i];
            if (this.actionMap[n3].length == 1) {
                blArray[n3] = bl;
                continue;
            }
            boolean bl2 = bl;
            for (int j = 0; j < this.actionMap[n3].length; ++j) {
                bl2 = bl2 && this.controlState[this.actionMap[n3][j]];
            }
            blArray[n3] = bl2;
        }
    }
}

