/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.AnimationAction;
import custom.AnimationMessage;
import custom.ControlActionRegistry;
import custom.OutputActionRegistry;
import java.util.BitSet;
import lts.Animator;
import lts.Relation;
import uk.ac.ic.doc.scenebeans.event.AnimationEvent;
import uk.ac.ic.doc.scenebeans.event.AnimationListener;

public class SceneAnimationController
implements Runnable,
AnimationMessage,
AnimationListener {
    Animator animator;
    OutputActionRegistry actions;
    ControlActionRegistry controls;
    String[] controlNames;
    volatile BitSet eligible;
    volatile boolean[] signalled;
    Thread ticker;
    boolean debug = false;
    boolean trace = false;
    boolean replayMode = false;
    Object canvas;
    public static int LIMIT = 300;

    public SceneAnimationController(Animator animator, Relation relation, Relation relation2, boolean bl, Object object) {
        this.animator = animator;
        this.replayMode = bl;
        this.canvas = object;
        this.actions = new OutputActionRegistry(relation, this);
        this.controls = new ControlActionRegistry(relation2, this);
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void registerAction(String string, AnimationAction animationAction) {
        this.actions.register(string, animationAction);
    }

    public void start() {
        this.eligible = this.animator.initialise(this.controls.getControls());
        this.trace = this.replayMode;
        this.controlNames = this.animator.getMenuNames();
        this.signalled = new boolean[this.controlNames.length];
        for (int i = 0; i < this.signalled.length; ++i) {
            this.signalled[i] = true;
        }
        this.controls.initMap(this.controlNames);
    }

    public void stop() {
        if (this.ticker != null) {
            this.ticker.interrupt();
        }
    }

    public void restart() {
        if (this.ticker == null) {
            this.ticker = new Thread(this);
            this.ticker.start();
        }
    }

    void doReplay() throws InterruptedException {
        while (this.animator.traceChoice()) {
            this.eligible = this.animator.traceStep();
            String string = this.animator.actionNameChosen();
            int n = this.controls.controlled(string);
            if (n > 0) {
                while (!this.signalled[n]) {
                    this.canvas.wait();
                }
            }
            this.actions.doAction(this.animator.actionNameChosen());
            if (!this.animator.isError()) continue;
            this.animator.message("Animation - ERROR state reached");
            return;
        }
        this.animator.message("Animation - end of Replay");
    }

    void doActions() throws InterruptedException {
        try {
            while (true) {
                this.doNonControlActions();
                if (this.empty(this.eligible)) {
                    this.animator.message("Animation - STOP state reached");
                    return;
                }
                int n = -1;
                while ((n = this.getValidControl()) < 0) {
                    this.canvas.wait();
                }
                this.doMenuStep(n);
            }
        }
        catch (AnimationException animationException) {
            this.animator.message("Animation - ERROR state reached " + animationException);
            return;
        }
    }

    int getValidControl() {
        for (int i = 0; i < this.signalled.length; ++i) {
            if (!this.signalled[i] || !this.eligible.get(i)) continue;
            return i;
        }
        return -1;
    }

    void doMenuStep(int n) throws AnimationException {
        this.eligible = this.animator.menuStep(n);
        this.actions.doAction(this.animator.actionNameChosen());
        if (this.animator.isError()) {
            throw new AnimationException();
        }
    }

    void doNonControlActions() throws AnimationException {
        int n = 0;
        while (this.animator.nonMenuChoice()) {
            this.eligible = this.animator.singleStep();
            this.actions.doAction(this.animator.actionNameChosen());
            if (this.animator.isError()) {
                throw new AnimationException();
            }
            if (++n <= LIMIT) continue;
            throw new AnimationException("immediate action LIMIT exceeded");
        }
    }

    private boolean empty(BitSet bitSet) {
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i)) continue;
            return false;
        }
        return true;
    }

    public void traceMsg(String string) {
        if (this.trace) {
            this.animator.message(string);
        }
    }

    public void debugMsg(String string) {
        if (this.debug) {
            this.animator.message(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalControl(String string) {
        Object object = this.canvas;
        synchronized (object) {
            if (string.charAt(0) != '~') {
                this.controls.mapControl(string, this.signalled, true);
                this.canvas.notifyAll();
            } else {
                this.controls.mapControl(string.substring(1), this.signalled, false);
            }
        }
    }

    public void clearControl(String string) {
        this.controls.mapControl(string, this.signalled, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object = this.canvas;
            synchronized (object) {
                if (!this.replayMode) {
                    this.doActions();
                } else {
                    this.doReplay();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ticker = null;
    }

    public void animationEvent(AnimationEvent animationEvent) {
        this.signalControl(animationEvent.getName());
    }

    public class AnimationException
    extends Exception {
        public AnimationException() {
        }

        public AnimationException(String string) {
            super(string);
        }
    }
}

