/*
 * Decompiled with CFR 0.152.
 */
package dclap;

import dclap.QD;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;

public class Gr2PICT
extends Graphics {
    public static final int CLONE = 49;
    protected static final int PAGEHEIGHT = 792;
    protected static final int PAGEWIDTH = 612;
    protected DataOutputStream os;
    protected Color clr = Color.black;
    protected Font font = new Font("Serif", 0, 12);
    protected Rectangle clipr = new Rectangle(-30000, -30000, 60000, 60000);
    protected Point origin = new Point(0, 0);
    protected boolean trouble = false;
    protected Graphics g;
    private int fAlign = 0;

    public Gr2PICT(OutputStream outputStream, Graphics graphics, Rectangle rectangle) {
        this.os = new DataOutputStream(outputStream);
        this.trouble = false;
        this.g = graphics;
        this.emitHeader(rectangle.width, rectangle.height);
    }

    public Gr2PICT(OutputStream outputStream, Graphics graphics, int n) {
        this.os = new DataOutputStream(outputStream);
        this.trouble = false;
        this.g = graphics;
        Rectangle rectangle = graphics.getClipRect();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 612, 792);
        }
        if (n != 49) {
            this.emitHeader(rectangle.width, rectangle.height);
        }
    }

    protected void emitbyte(int n) {
        try {
            this.os.writeByte(n);
            ++this.fAlign;
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void emitword(int n) {
        try {
            this.os.writeShort(n);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void emitint(int n) {
        try {
            this.os.writeInt(n);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected void emitstring(String string) {
        try {
            this.os.writeBytes(string);
            this.fAlign += string.length();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    protected final void emitop(int n) {
        if ((this.fAlign & 1) == 1) {
            this.emitbyte(0);
        }
        this.emitword(n);
    }

    protected final void emitcolor(Color color) {
        this.emitword(color.getRed() << 8);
        this.emitword(color.getGreen() << 8);
        this.emitword(color.getBlue() << 8);
    }

    protected final void emitrect(int n, int n2, int n3, int n4) {
        this.emitword(n2);
        this.emitword(n);
        this.emitword(n2 + n4);
        this.emitword(n + n3);
    }

    protected final void emitroundrect(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.emitop(11);
        this.emitword(n7);
        this.emitword(n6);
        this.emitop(n);
        this.emitrect(n2, n3, n4, n5);
    }

    protected void emitpolygon(Polygon polygon) {
        int n = 10 + polygon.npoints * 4;
        this.emitword(n);
        Rectangle rectangle = polygon.getBounds();
        this.emitrect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (int i = 0; i < polygon.npoints; ++i) {
            this.emitword(polygon.ypoints[i]);
            this.emitword(polygon.xpoints[i]);
        }
    }

    protected void emitcomment(int n, int n2, String string) {
        if (n2 == 0) {
            this.emitop(160);
            this.emitword(n);
        } else {
            this.emitop(161);
            this.emitword(n);
            this.emitword(string.length());
            this.emitstring(string);
        }
    }

    public final void beginPicGroup() {
        this.emitcomment(140, 0, null);
    }

    public final void endPicGroup() {
        this.emitcomment(141, 0, null);
    }

    public void laserLine(int n, int n2) {
        this.emitop(161);
        this.emitword(182);
        this.emitword(4);
        this.emitword(n);
        this.emitword(n2);
    }

    protected void emitHeader(int n, int n2) {
        int n3;
        try {
            n3 = 512;
            byte[] byArray = new byte[n3];
            this.os.write(byArray, 0, n3);
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        n3 = 0;
        this.emitword(n3);
        this.emitrect(0, 0, n, n2);
        this.emitop(17);
        this.emitword(767);
        this.emitop(3072);
        this.emitint(-1);
        for (int i = 0; i < 4; ++i) {
            this.emitword(-1);
            this.emitword(0);
        }
        this.emitint(-1);
        this.emitop(30);
        this.clipRect(this.clipr.x, this.clipr.y, this.clipr.width, this.clipr.height);
        this.beginPicGroup();
    }

    public Graphics create() {
        Gr2PICT gr2PICT = new Gr2PICT((OutputStream)this.os, this.g, 49);
        gr2PICT.font = this.font;
        gr2PICT.clipr = this.clipr;
        gr2PICT.clr = this.clr;
        return gr2PICT;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    public void translate(int n, int n2) {
        this.origin.x = n;
        this.origin.y = n2;
        this.emitop(12);
        this.emitword(-n);
        this.emitword(-n2);
    }

    public Color getColor() {
        return this.clr;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.clr = color;
        }
        this.emitop(26);
        this.emitcolor(this.clr);
    }

    public void setPaintMode() {
        this.emitop(8);
        this.emitword(8);
    }

    public void setXORMode(Color color) {
        this.emitop(8);
        this.emitword(10);
        if (color != null) {
            this.emitop(28);
            this.emitop(29);
            this.emitcolor(color);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            int n;
            this.font = font;
            String string = this.font.getName();
            int n2 = QD.getQuickDrawFontNum(string);
            if (n2 >= 0) {
                this.emitop(3);
                this.emitword(n2);
            } else {
                this.emitop(44);
                n = string.length() + 1 + 2 + 2;
                this.emitword(n);
                this.emitword(QD.fontnum++);
                this.emitstring(string);
            }
            n = 0;
            int n3 = this.font.getStyle();
            if ((n3 & 1) != 0) {
                n |= 1;
            }
            if ((n3 & 2) != 0) {
                n |= 2;
            }
            this.emitop(4);
            this.emitbyte(n);
            this.emitop(13);
            this.emitword(this.font.getSize());
        }
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    public Rectangle getClipRect() {
        return this.clipr;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clipr = new Rectangle(n, n2, n3, n4);
        this.emitop(1);
        int n5 = 10;
        this.emitword(n5);
        this.emitrect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.emitop(32);
        this.emitword(n2);
        this.emitword(n);
        this.emitword(n4);
        this.emitword(n3);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.emitop(49);
        this.emitrect(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.emitop(48);
        this.emitrect(n, n2, n3, n4);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.emitop(50);
        this.emitrect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.emitroundrect(64, n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.emitroundrect(65, n, n2, n3, n4, n5, n6);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + 1, n2, n + n3 - 1, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4);
        this.setColor(color);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            this.setColor(color3);
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n, n2 + n4 - 1);
        this.drawLine(n + 1, n2, n + n3 - 2, n2);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        this.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        this.setColor(color);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.emitop(80);
        this.emitrect(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.emitop(81);
        this.emitrect(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.emitop(96);
        this.emitrect(n, n2, n3, n4);
        this.emitword(n5 - 90);
        this.emitword(n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.emitop(97);
        this.emitrect(n, n2, n3, n4);
        this.emitword(n5 + 90);
        this.emitword(n6);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolygon(new Polygon(nArray, nArray2, n));
    }

    public void drawPolygon(Polygon polygon) {
        this.emitop(112);
        this.emitpolygon(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fillPolygon(new Polygon(nArray, nArray2, n));
    }

    public void fillPolygon(Polygon polygon) {
        this.emitop(113);
        this.emitpolygon(polygon);
    }

    public void drawString(String string, int n, int n2) {
        this.emitop(40);
        this.emitword(n2);
        this.emitword(n);
        this.emitbyte(string.length());
        this.emitstring(string);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, 0, n, n2), n3, n4);
    }

    public boolean doImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, imageObserver, null);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, 0, 0, imageObserver, color);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.doImage(image, n, n2, n3, n4, imageObserver, color);
    }

    public void dispose() {
        this.endPicGroup();
        this.emitop(255);
        try {
            this.os.flush();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void finalize() {
        super.finalize();
        this.dispose();
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public boolean checkError() {
        return this.trouble;
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public Shape getClip() {
        return null;
    }

    public void setClip(Shape shape) {
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }
}

