/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.Enumeration;
import java.util.Vector;
import lts.CompactState;
import lts.LTSOutput;
import lts.PrefixTree;

public class Alphabet {
    PrefixTree root = null;
    String[] myAlpha;
    CompactState sm;
    public int maxLevel = 0;

    public Alphabet(CompactState compactState) {
        int n;
        this.sm = compactState;
        this.myAlpha = new String[compactState.alphabet.length];
        for (n = 0; n < compactState.alphabet.length; ++n) {
            this.myAlpha[n] = compactState.alphabet[n];
        }
        this.sort(this.myAlpha, 1);
        for (n = 1; n < this.myAlpha.length; ++n) {
            this.root = PrefixTree.addName(this.root, this.myAlpha[n]);
        }
        if (this.root != null) {
            this.maxLevel = this.root.maxDepth();
        }
    }

    public Alphabet(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = stringArray[n];
        }
        if (stringArray2.length > 1) {
            this.sort(stringArray2, 0);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            this.root = PrefixTree.addName(this.root, stringArray2[n]);
        }
    }

    public Alphabet(Vector vector) {
        this(vector.toArray(new String[vector.size()]));
    }

    public String toString() {
        if (this.root == null) {
            return "{}";
        }
        return this.root.toString();
    }

    public void print(LTSOutput lTSOutput, int n) {
        lTSOutput.outln("Process:\n\t" + this.sm.name);
        lTSOutput.outln("Alphabet:");
        if (this.root == null) {
            lTSOutput.outln("\t{}");
            return;
        }
        if (n == 0) {
            lTSOutput.outln("\t" + this.root.toString());
        } else {
            lTSOutput.out("\t{ ");
            Vector vector = new Vector();
            this.root.getStrings(vector, n - 1, null);
            Enumeration enumeration = vector.elements();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!bl) {
                    lTSOutput.out("\t  ");
                }
                if (enumeration.hasMoreElements()) {
                    lTSOutput.outln(string + ",");
                } else {
                    lTSOutput.outln(string);
                }
                bl = false;
            }
            lTSOutput.outln("\t}");
        }
    }

    private void sort(String[] stringArray, int n) {
        for (int i = n; i < stringArray.length - 1; ++i) {
            int n2 = i;
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (stringArray[j].compareTo(stringArray[n2]) >= 0) continue;
                n2 = j;
            }
            String string = stringArray[i];
            stringArray[i] = stringArray[n2];
            stringArray[n2] = string;
        }
    }
}

