/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import lts.Alphabet;
import lts.Animator;
import lts.Automata;
import lts.CompactState;
import lts.CompositeState;
import lts.Counter;
import lts.EventManager;
import lts.EventState;
import lts.LTSEvent;
import lts.LTSOutput;
import lts.MyHashQueue;
import lts.MyHashQueueEntry;
import lts.MyHashStack;
import lts.MyList;
import lts.PartialOrder;
import lts.StackCheck;
import lts.StackChecker;
import lts.StateCodec;
import lts.ltl.FluentTrace;

public class Analyser
implements Animator,
Automata {
    private CompositeState cs;
    private CompactState[] sm;
    private LTSOutput output;
    private Hashtable alphabet = new Hashtable();
    private Hashtable actionMap = new Hashtable();
    private int[] actionCount;
    private String[] actionName;
    private int Nmach;
    private int[] Mbase;
    private MyHashStack analysed;
    private int stateNo = 0;
    private int stateCount = 0;
    private boolean[] violated;
    private boolean deadlockDetected = false;
    private static final int SUCCESS = 0;
    private static final int DEADLOCK = 1;
    private static final int ERROR = 2;
    private static final int FOUND = 3;
    private EventManager eman;
    private boolean lowpriority = true;
    private Vector priorLabels = null;
    private BitSet highAction = null;
    private int acceptEvent = -1;
    private int asteriskEvent = -1;
    private BitSet visible;
    private StateCodec coder;
    private boolean canTerminate = false;
    public static boolean partialOrderReduction = false;
    public static boolean preserveObsEquiv = true;
    private PartialOrder partial = null;
    private MyList compTrans;
    private int endSequence = -99999;
    LinkedList trace;
    int errorMachine;
    PartialOrder savedPartial = null;
    private String[] menuAlpha;
    private Hashtable actionToIndex;
    private Hashtable indexToAction;
    private int[] currentA;
    private volatile List choices;
    private boolean errorState = false;
    private Enumeration _replay = null;
    private String _replayAction = null;
    int theChoice = 0;
    Random rand = new Random();

    public Analyser(CompositeState compositeState, LTSOutput lTSOutput, EventManager eventManager) {
        this(compositeState, lTSOutput, eventManager, false);
    }

    public Analyser(CompositeState compositeState, LTSOutput lTSOutput, EventManager eventManager, boolean bl) {
        Object object;
        int n;
        this.cs = compositeState;
        this.output = lTSOutput;
        this.eman = eventManager;
        if (compositeState.priorityLabels != null) {
            this.lowpriority = compositeState.priorityIsLow;
            this.priorLabels = compositeState.priorityLabels;
            this.highAction = new BitSet();
        }
        this.sm = new CompactState[compositeState.machines.size()];
        this.violated = new boolean[compositeState.machines.size()];
        Enumeration<Object> enumeration = compositeState.machines.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            this.sm[n2] = ((CompactState)enumeration.nextElement()).myclone();
            ++n2;
        }
        this.Nmach = this.sm.length;
        lTSOutput.outln("Composition:");
        lTSOutput.out(compositeState.name + " = ");
        for (n2 = 0; n2 < this.sm.length; ++n2) {
            lTSOutput.out(this.sm[n2].name);
            if (n2 >= this.sm.length - 1) continue;
            lTSOutput.out(" || ");
        }
        lTSOutput.outln("");
        if (this.priorLabels != null) {
            if (this.lowpriority) {
                lTSOutput.out("\t>> ");
            } else {
                lTSOutput.out("\t<< ");
            }
            lTSOutput.outln(new Alphabet(compositeState.priorityLabels).toString());
        }
        this.Mbase = new int[this.Nmach];
        lTSOutput.outln("State Space:");
        for (n2 = 0; n2 < this.sm.length; ++n2) {
            lTSOutput.out(" " + this.sm[n2].maxStates + " ");
            if (n2 < this.sm.length - 1) {
                lTSOutput.out("*");
            }
            this.Mbase[n2] = this.sm[n2].maxStates;
        }
        this.coder = new StateCodec(this.Mbase);
        lTSOutput.outln("= 2 ** " + this.coder.bits());
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Counter counter = new Counter(0);
        for (n = 0; n < this.sm.length; ++n) {
            for (int i = 0; i < this.sm[n].alphabet.length; ++i) {
                if (this.sm[n].endseq > 0) {
                    hashSet.add(this.sm[n].alphabet[i]);
                } else {
                    hashSet2.add(this.sm[n].alphabet[i]);
                }
                BitSet bitSet = (BitSet)this.alphabet.get(this.sm[n].alphabet[i]);
                if (bitSet == null) {
                    bitSet = new BitSet();
                    bitSet.set(n);
                    object = this.sm[n].alphabet[i];
                    this.alphabet.put(object, bitSet);
                    this.actionMap.put(object, counter.label());
                    continue;
                }
                bitSet.set(n);
            }
        }
        this.canTerminate = hashSet.containsAll(hashSet2);
        this.actionName = new String[this.alphabet.size()];
        this.actionCount = new int[this.alphabet.size()];
        enumeration = this.alphabet.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            BitSet bitSet = (BitSet)this.alphabet.get(string);
            int n3 = (Integer)this.actionMap.get(string);
            this.actionName[n3] = string;
            this.actionCount[n3] = this.countSet(bitSet);
            if (string.charAt(0) == '@') {
                this.acceptEvent = n3;
            } else if (string.equals("*") && !bl) {
                this.asteriskEvent = n3;
            }
            if (this.highAction == null) continue;
            if (!this.lowpriority) {
                if (!CompactState.contains(string, this.priorLabels)) continue;
                this.highAction.set(n3);
                continue;
            }
            if (CompactState.contains(string, this.priorLabels)) continue;
            this.highAction.set(n3);
        }
        if (this.highAction != null) {
            if (this.lowpriority) {
                this.highAction.set(0);
            } else {
                this.highAction.clear(0);
            }
            if (this.acceptEvent > 0) {
                this.highAction.clear(this.acceptEvent);
            }
        }
        this.actionCount[0] = 0;
        for (n = 0; n < this.sm.length; ++n) {
            for (int i = 0; i < this.sm[n].maxStates; ++i) {
                EventState eventState = this.sm[n].states[i];
                while (eventState != null) {
                    object = eventState;
                    ((EventState)object).machine = n;
                    ((EventState)object).event = (Integer)this.actionMap.get(this.sm[n].alphabet[((EventState)object).event]);
                    while (((EventState)object).nondet != null) {
                        ((EventState)object).nondet.event = ((EventState)object).event;
                        ((EventState)object).nondet.machine = ((EventState)object).machine;
                        object = ((EventState)object).nondet;
                    }
                    eventState = eventState.list;
                }
            }
        }
        this.visible = new BitSet(this.actionName.length);
        for (n = 1; n < this.actionName.length; ++n) {
            if (compositeState.hidden == null) {
                this.visible.set(n);
                continue;
            }
            if (compositeState.exposeNotHide) {
                if (!CompactState.contains(this.actionName[n], compositeState.hidden)) continue;
                this.visible.set(n);
                continue;
            }
            if (CompactState.contains(this.actionName[n], compositeState.hidden)) continue;
            this.visible.set(n);
        }
    }

    public CompactState compose() {
        return this.private_compose(true);
    }

    public CompactState composeNoHide() {
        return this.private_compose(false);
    }

    private CompactState private_compose(boolean bl) {
        this.output.outln("Composing...");
        long l = System.currentTimeMillis();
        int n = this.newState_compose();
        CompactState compactState = new CompactState(this.stateCount, this.cs.name, this.analysed, this.compTrans, this.actionName, this.endSequence);
        if (bl && this.cs.hidden != null) {
            if (!this.cs.exposeNotHide) {
                compactState.conceal(this.cs.hidden);
            } else {
                compactState.expose(this.cs.hidden);
            }
        }
        long l2 = System.currentTimeMillis();
        this.outStatistics(this.stateCount, this.compTrans.size());
        this.output.outln("Composed in " + (l2 - l) + "ms");
        this.analysed = null;
        this.compTrans = null;
        return compactState;
    }

    public void analyse(FluentTrace fluentTrace) {
        this.output.outln("Analysing...");
        System.gc();
        long l = System.currentTimeMillis();
        int n = this.newState_analyse(this.coder.zero(), null);
        long l2 = System.currentTimeMillis();
        if (n == 1) {
            this.output.outln("Trace to DEADLOCK:");
            fluentTrace.print(this.output, this.trace, true);
        } else if (n == 2) {
            this.output.outln("Trace to property violation in " + this.sm[this.errorMachine].name + ":");
            fluentTrace.print(this.output, this.trace, true);
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed in: " + (l2 - l) + "ms");
    }

    public void analyse() {
        this.output.outln("Analysing...");
        System.gc();
        long l = System.currentTimeMillis();
        int n = this.newState_analyse(this.coder.zero(), null);
        long l2 = System.currentTimeMillis();
        if (n == 1) {
            this.output.outln("Trace to DEADLOCK:");
            this.printPath(this.trace);
        } else if (n == 2) {
            this.output.outln("Trace to property violation in " + this.sm[this.errorMachine].name + ":");
            this.printPath(this.trace);
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed in: " + (l2 - l) + "ms");
    }

    public List getErrorTrace() {
        return this.trace;
    }

    private int countSet(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private boolean isEND(int[] nArray) {
        if (!this.canTerminate) {
            return false;
        }
        for (int i = 0; i < this.Nmach; ++i) {
            if (this.sm[i].endseq < 0 || this.sm[i].endseq == nArray[i]) continue;
            return false;
        }
        return true;
    }

    private void printState(int[] nArray) {
        this.output.out("[");
        for (int i = 0; i < nArray.length; ++i) {
            this.output.out("" + nArray[i]);
            if (i >= nArray.length - 1) continue;
            this.output.out(",");
        }
        this.output.out("]");
    }

    private int[] myclone(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    List eligibleTransitions(int[] nArray) {
        Object object;
        int n;
        Object object2;
        ArrayList<int[]> arrayList = null;
        if (!(this.partial == null || this.asteriskEvent > 0 && EventState.hasEvent(this.sm[this.Nmach - 1].states[nArray[this.Nmach - 1]], this.asteriskEvent) || (object2 = (Object)this.partial.transitions(nArray)) == null)) {
            return object2;
        }
        object2 = this.myclone(this.actionCount);
        EventState[] eventStateArray = new EventState[this.actionCount.length];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.Nmach; ++n) {
            object = this.sm[n].states[nArray[n]];
            while (object != null) {
                Object object3 = object;
                ((EventState)object3).path = eventStateArray[((EventState)object3).event];
                eventStateArray[((EventState)object3).event] = object3;
                int n4 = ((EventState)object3).event;
                object2[n4] = object2[n4] - 1;
                if (((EventState)object3).event != 0 && object2[((EventState)object3).event] == 0) {
                    ++n2;
                    if (this.highAction != null && this.highAction.get(((EventState)object3).event) && ((EventState)object3).event != this.asteriskEvent) {
                        ++n3;
                    }
                }
                object = ((EventState)object).list;
            }
        }
        if (n2 == 0 && eventStateArray[0] == null) {
            return null;
        }
        n = 1;
        object = new ArrayList(8);
        if (eventStateArray[0] != null) {
            boolean bl;
            boolean bl2 = bl = this.highAction != null && this.highAction.get(0);
            if (bl || n3 == 0) {
                this.computeTauTransitions(eventStateArray[0], nArray, (List)object);
            }
            if (bl) {
                ++n3;
            }
        }
        while (n2 > 0) {
            --n2;
            while (object2[n] > 0) {
                ++n;
            }
            if (n3 <= 0 || this.highAction.get(n) || n == this.acceptEvent) {
                EventState eventState = eventStateArray[n];
                boolean bl = false;
                while (eventState != null) {
                    if (eventState.nondet != null) {
                        bl = true;
                        break;
                    }
                    eventState = eventState.path;
                }
                eventState = eventStateArray[n];
                if (!bl) {
                    int[] nArray2 = this.myclone(nArray);
                    nArray2[this.Nmach] = n;
                    while (eventState != null) {
                        nArray2[eventState.machine] = eventState.next;
                        eventState = eventState.path;
                    }
                    if (n != this.asteriskEvent) {
                        object.add(nArray2);
                    } else {
                        arrayList = new ArrayList(1);
                        arrayList.add(nArray2);
                    }
                } else if (n != this.asteriskEvent) {
                    this.computeNonDetTransitions(eventState, nArray, (List)object);
                } else {
                    arrayList = new ArrayList<int[]>(4);
                    this.computeNonDetTransitions(eventState, nArray, arrayList);
                }
            }
            int n5 = n;
            object2[n5] = object2[n5] + 1;
        }
        if (this.asteriskEvent < 0) {
            return object;
        }
        return this.mergeAsterisk((List)object, arrayList);
    }

    private void computeTauTransitions(EventState eventState, int[] nArray, List list) {
        EventState eventState2 = eventState;
        while (eventState2 != null) {
            EventState eventState3 = eventState2;
            while (eventState3 != null) {
                int[] nArray2 = this.myclone(nArray);
                nArray2[eventState3.machine] = eventState3.next;
                nArray2[this.Nmach] = 0;
                list.add(nArray2);
                eventState3 = eventState3.nondet;
            }
            eventState2 = eventState2.path;
        }
    }

    private void computeNonDetTransitions(EventState eventState, int[] nArray, List list) {
        EventState eventState2 = eventState;
        while (eventState2 != null) {
            int[] nArray2 = this.myclone(nArray);
            nArray2[eventState2.machine] = eventState2.next;
            if (eventState.path != null) {
                this.computeNonDetTransitions(eventState.path, nArray2, list);
            } else {
                nArray2[this.Nmach] = eventState.event;
                list.add(nArray2);
            }
            eventState2 = eventState2.nondet;
        }
    }

    List mergeAsterisk(List list, List list2) {
        if (list == null || list2 == null) {
            return list;
        }
        if (list.size() == 0) {
            return null;
        }
        if (list2.size() == 1) {
            int[] nArray = (int[])list2.get(0);
            for (int[] nArray2 : list) {
                if (this.visible.get(nArray2[this.Nmach])) continue;
                nArray2[this.Nmach - 1] = nArray[this.Nmach - 1];
            }
            return list;
        }
        Iterator iterator = list2.iterator();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        while (iterator.hasNext()) {
            int[] nArray = (int[])iterator.next();
            for (int[] nArray3 : list) {
                if (!this.visible.get(nArray3[this.Nmach])) {
                    nArray3[this.Nmach - 1] = nArray[this.Nmach - 1];
                }
                arrayList.add(this.myclone(nArray3));
            }
        }
        return arrayList;
    }

    private void outStatistics(int n, int n2) {
        Runtime runtime = Runtime.getRuntime();
        this.output.outln("-- States: " + n + " Transitions: " + n2 + " Memory used: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000L + "K");
    }

    private int newState_compose() {
        System.gc();
        this.analysed = new MyHashStack(100001);
        if (partialOrderReduction) {
            this.partial = new PartialOrder(this.alphabet, this.actionName, this.sm, new StackChecker(this.coder, this.analysed), this.cs.hidden, this.cs.exposeNotHide, preserveObsEquiv, this.highAction);
        }
        this.compTrans = new MyList();
        this.stateCount = 0;
        this.analysed.pushPut(this.coder.zero());
        while (!this.analysed.empty()) {
            List list;
            if (this.analysed.marked()) {
                this.analysed.pop();
                continue;
            }
            int[] nArray = this.coder.decode(this.analysed.peek());
            this.analysed.mark(this.stateCount++);
            if (this.stateCount % 10000 == 0) {
                this.output.out("Depth " + this.analysed.getDepth() + " ");
                this.outStatistics(this.stateCount, this.compTrans.size());
            }
            if ((list = this.eligibleTransitions(nArray)) == null) {
                if (!this.isEND(nArray)) {
                    if (!this.deadlockDetected) {
                        this.output.outln("  potential DEADLOCK");
                    }
                    this.deadlockDetected = true;
                    continue;
                }
                if (this.endSequence < 0) {
                    this.endSequence = this.stateCount - 1;
                    continue;
                }
                this.analysed.mark(this.endSequence);
                --this.stateCount;
                continue;
            }
            for (int[] nArray2 : list) {
                byte[] byArray = this.coder.encode(nArray2);
                this.compTrans.add(this.stateCount - 1, byArray, nArray2[this.Nmach]);
                if (byArray == null) {
                    int n = 0;
                    while (nArray2[n] >= 0) {
                        ++n;
                    }
                    if (!this.violated[n]) {
                        this.output.outln("  property " + this.sm[n].name + " violation.");
                    }
                    this.violated[n] = true;
                    continue;
                }
                if (this.analysed.containsKey(byArray)) continue;
                this.analysed.pushPut(byArray);
            }
        }
        return 0;
    }

    private void printPath(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.output.outln("\t" + (String)iterator.next());
        }
    }

    private int newState_analyse(byte[] byArray, byte[] byArray2) {
        this.stateCount = 0;
        int n = 0;
        MyHashQueue myHashQueue = new MyHashQueue(100001);
        if (partialOrderReduction) {
            this.partial = new PartialOrder(this.alphabet, this.actionName, this.sm, new StackChecker(this.coder, myHashQueue), this.cs.hidden, this.cs.exposeNotHide, false, this.highAction);
        }
        myHashQueue.addPut(byArray, 0, null);
        Integer n2 = new Integer(-1);
        Runtime runtime = Runtime.getRuntime();
        MyHashQueueEntry myHashQueueEntry = null;
        while (!myHashQueue.empty()) {
            myHashQueueEntry = myHashQueue.peek();
            byArray = myHashQueueEntry.key;
            int[] nArray = this.coder.decode(byArray);
            ++this.stateCount;
            if (this.stateCount % 10000 == 0) {
                this.output.out("Depth " + myHashQueue.depth(myHashQueueEntry) + " ");
                this.outStatistics(this.stateCount, n);
            }
            List list = this.eligibleTransitions(nArray);
            myHashQueue.pop();
            if (list == null) {
                if (this.isEND(nArray)) continue;
                this.output.out("Depth " + myHashQueue.depth(myHashQueueEntry) + " ");
                this.outStatistics(this.stateCount, n);
                this.trace = myHashQueue.getPath(myHashQueueEntry, this.actionName);
                return 1;
            }
            for (int[] nArray2 : list) {
                byte[] byArray3 = this.coder.encode(nArray2);
                ++n;
                if (byArray3 == null || StateCodec.equals(byArray3, byArray2)) {
                    this.output.out("Depth " + myHashQueue.depth(myHashQueueEntry) + " ");
                    this.outStatistics(this.stateCount, n);
                    if (byArray3 == null) {
                        int n3 = 0;
                        while (nArray2[n3] >= 0) {
                            ++n3;
                        }
                        this.errorMachine = n3;
                    }
                    this.trace = myHashQueue.getPath(myHashQueueEntry, this.actionName);
                    this.trace.add(this.actionName[nArray2[this.Nmach]]);
                    if (byArray3 == null) {
                        return 2;
                    }
                    return 3;
                }
                if (myHashQueue.containsKey(byArray3)) continue;
                myHashQueue.addPut(byArray3, nArray2[this.Nmach], myHashQueueEntry);
            }
        }
        this.output.out("Depth " + myHashQueue.depth(myHashQueueEntry) + " ");
        this.outStatistics(this.stateCount, n);
        return 0;
    }

    public String[] getAlphabet() {
        return this.actionName;
    }

    public MyList getTransitions(byte[] byArray) {
        List list = this.eligibleTransitions(this.coder.decode(byArray));
        MyList myList = new MyList();
        if (list == null) {
            return myList;
        }
        for (int[] nArray : list) {
            byte[] byArray2 = this.coder.encode(nArray);
            if (byArray2 == null) {
                int n = 0;
                while (nArray[n] >= 0) {
                    ++n;
                }
                this.errorMachine = n;
            }
            myList.add(0, byArray2, nArray[this.Nmach]);
        }
        return myList;
    }

    public boolean isAccepting(byte[] byArray) {
        if (this.acceptEvent < 0) {
            return false;
        }
        int[] nArray = this.coder.decode(byArray);
        return EventState.hasEvent(this.sm[this.Nmach - 1].states[nArray[this.Nmach - 1]], this.acceptEvent);
    }

    public String getViolatedProperty() {
        return this.sm[this.errorMachine].name;
    }

    public Vector getTraceToState(byte[] byArray, byte[] byArray2) {
        if (StateCodec.equals(byArray, byArray2)) {
            return new Vector();
        }
        int n = this.newState_analyse(byArray, byArray2);
        if (n == 3) {
            Vector vector = new Vector();
            vector.addAll(this.trace);
            return vector;
        }
        return null;
    }

    public boolean END(byte[] byArray) {
        return this.isEND(this.coder.decode(byArray));
    }

    public byte[] START() {
        return this.coder.zero();
    }

    public void setStackChecker(StackCheck stackCheck) {
        if (partialOrderReduction) {
            this.partial = new PartialOrder(this.alphabet, this.actionName, this.sm, new StackChecker(this.coder, stackCheck), this.cs.hidden, this.cs.exposeNotHide, false, this.highAction);
        }
    }

    public boolean isPartialOrder() {
        return partialOrderReduction;
    }

    public void disablePartialOrder() {
        this.savedPartial = this.partial;
        this.partial = null;
    }

    public void enablePartialOrder() {
        this.partial = this.savedPartial;
    }

    private void getMenuHash() {
        this.actionToIndex = new Hashtable();
        this.indexToAction = new Hashtable();
        for (int i = 1; i < this.menuAlpha.length; ++i) {
            Integer n = new Integer(i);
            Integer n2 = (Integer)this.actionMap.get(this.menuAlpha[i]);
            this.actionToIndex.put(n2, n);
            this.indexToAction.put(n, n2);
        }
    }

    private void getMenu(Vector vector) {
        if (vector != null) {
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.alphabet.containsKey(string)) continue;
                vector2.addElement(string);
            }
            this.menuAlpha = new String[vector2.size() + 1];
            this.menuAlpha[0] = "tau";
            for (int i = 1; i < this.menuAlpha.length; ++i) {
                this.menuAlpha[i] = (String)vector2.elementAt(i - 1);
            }
        } else {
            this.menuAlpha = this.actionName;
        }
        this.getMenuHash();
    }

    private BitSet menuActions() {
        BitSet bitSet = new BitSet(this.menuAlpha.length);
        if (this.choices != null) {
            for (int[] nArray : this.choices) {
                Integer n = new Integer(nArray[this.Nmach]);
                Integer n2 = (Integer)this.actionToIndex.get(n);
                if (n2 == null) continue;
                bitSet.set(n2);
            }
        }
        return bitSet;
    }

    private BitSet allActions() {
        BitSet bitSet = new BitSet(this.actionCount.length);
        if (this.choices != null) {
            for (int[] nArray : this.choices) {
                bitSet.set(nArray[this.Nmach]);
            }
        }
        return bitSet;
    }

    public BitSet initialise(Vector vector) {
        this.currentA = this.coder.decode(this.coder.zero());
        this.choices = this.eligibleTransitions(this.currentA);
        if (this.eman != null) {
            this.eman.post(new LTSEvent(0, this.currentA));
        }
        this.getMenu(vector);
        if (this.cs.getErrorTrace() != null) {
            this._replay = this.cs.getErrorTrace().elements();
            if (this._replay.hasMoreElements()) {
                this._replayAction = (String)this._replay.nextElement();
            }
        }
        return this.menuActions();
    }

    public BitSet singleStep() {
        if (this.errorState) {
            return null;
        }
        if (this.nonMenuChoice()) {
            this.currentA = this.step(this.randomNonMenuChoice());
            if (this.errorState) {
                return null;
            }
            this.choices = this.eligibleTransitions(this.currentA);
        }
        return this.menuActions();
    }

    public BitSet menuStep(int n) {
        if (this.errorState) {
            return null;
        }
        this.theChoice = (Integer)this.indexToAction.get(new Integer(n));
        this.currentA = this.step(this.theChoice);
        if (this.errorState) {
            return null;
        }
        this.choices = this.eligibleTransitions(this.currentA);
        return this.menuActions();
    }

    public int actionChosen() {
        return this.theChoice;
    }

    public String actionNameChosen() {
        return this.actionName[this.theChoice];
    }

    public boolean nonMenuChoice() {
        if (this.errorState) {
            return false;
        }
        BitSet bitSet = this.allActions();
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i) || this.actionToIndex.containsKey(new Integer(i))) continue;
            this.theChoice = i;
            return true;
        }
        return false;
    }

    private int randomNonMenuChoice() {
        int n;
        BitSet bitSet = this.allActions();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(8);
        for (n = 0; n < bitSet.size(); ++n) {
            Integer n2 = new Integer(n);
            if (!bitSet.get(n) || this.actionToIndex.containsKey(n2)) continue;
            arrayList.add(n2);
        }
        n = Math.abs(this.rand.nextInt()) % arrayList.size();
        this.theChoice = (Integer)arrayList.get(n);
        return this.theChoice;
    }

    public boolean traceChoice() {
        if (this.errorState) {
            return false;
        }
        if (this._replay == null) {
            return false;
        }
        if (this._replayAction != null) {
            int n = (Integer)this.actionMap.get(this._replayAction);
            BitSet bitSet = this.allActions();
            if (bitSet.get(n)) {
                this.theChoice = n;
                return true;
            }
        }
        return false;
    }

    public boolean hasErrorTrace() {
        return this.cs.getErrorTrace() != null;
    }

    public BitSet traceStep() {
        if (this.errorState) {
            return null;
        }
        if (this.traceChoice()) {
            this.currentA = this.step(this.theChoice);
            if (this.errorState) {
                return null;
            }
            this.choices = this.eligibleTransitions(this.currentA);
            this._replayAction = this._replay.hasMoreElements() ? (String)this._replay.nextElement() : null;
        }
        return this.menuActions();
    }

    public boolean isError() {
        return this.errorState;
    }

    public boolean isEnd() {
        return this.isEND(this.currentA);
    }

    private int[] thestep(int n) {
        if (this.errorState) {
            return this.currentA;
        }
        if (this.choices == null) {
            this.output.outln("DEADLOCK");
            this.errorState = true;
            return this.currentA;
        }
        for (int[] nArray : this.choices) {
            if (nArray[this.Nmach] != n) continue;
            boolean bl = this.errorState = this.coder.encode(nArray = this.nonDetSelect(nArray)) == null;
            if (this.errorState) {
                return nArray;
            }
            this.currentA = nArray;
            return nArray;
        }
        return this.currentA;
    }

    private int[] step(int n) {
        int[] nArray = this.thestep(n);
        if (this.eman != null) {
            this.eman.post(new LTSEvent(0, nArray, this.actionName[n]));
        }
        return nArray;
    }

    int[] nonDetSelect(int[] nArray) {
        int n;
        int n2 = this.choices.indexOf(nArray);
        for (n = n2 + 1; n < this.choices.size() && nArray[this.Nmach] == ((int[])this.choices.get(n))[this.Nmach]; ++n) {
        }
        if (n2 + 1 == n) {
            return nArray;
        }
        int n3 = n2 + Math.abs(this.rand.nextInt()) % (n - n2);
        return (int[])this.choices.get(n3);
    }

    public String[] getMenuNames() {
        return this.menuAlpha;
    }

    public String[] getAllNames() {
        return this.actionName;
    }

    public boolean getPriority() {
        return this.lowpriority;
    }

    public BitSet getPriorityActions() {
        if (this.priorLabels == null) {
            return null;
        }
        BitSet bitSet = new BitSet();
        for (int i = 1; i < this.actionName.length; ++i) {
            Integer n = (Integer)this.actionToIndex.get(new Integer(i));
            if (n == null || (!this.lowpriority || this.highAction.get(i)) && (this.lowpriority || !this.highAction.get(i))) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    public void message(String string) {
        this.output.outln(string);
    }
}

