/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.io.PrintStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.Automata;
import lts.Counter;
import lts.EventState;
import lts.MyHashStack;
import lts.MyIntHash;
import lts.MyList;
import lts.Relation;
import lts.StackCheck;

public class CompactState
implements Automata {
    public String name;
    public int maxStates;
    public String[] alphabet;
    public EventState[] states;
    int endseq = -9999;
    private boolean hasduplicates = false;
    private boolean prop = false;

    public CompactState() {
    }

    public CompactState(int n, String string, MyHashStack myHashStack, MyList myList, String[] stringArray, int n2) {
        this.alphabet = stringArray;
        this.name = string;
        this.maxStates = n;
        this.states = new EventState[this.maxStates];
        while (!myList.empty()) {
            int n3 = myList.getFrom();
            int n4 = myList.getTo() == null ? -1 : myHashStack.get(myList.getTo());
            this.states[n3] = EventState.add(this.states[n3], new EventState(myList.getAction(), n4));
            myList.next();
        }
        this.endseq = n2;
    }

    public void reachable() {
        MyIntHash myIntHash = EventState.reachable(this.states);
        EventState[] eventStateArray = this.states;
        this.maxStates = myIntHash.size();
        this.states = new EventState[this.maxStates];
        for (int i = 0; i < eventStateArray.length; ++i) {
            int n = myIntHash.get(i);
            if (n <= -2) continue;
            this.states[n] = EventState.renumberStates(eventStateArray[i], myIntHash);
        }
        if (this.endseq > 0) {
            this.endseq = myIntHash.get(this.endseq);
        }
    }

    public void removeNonDetTau() {
        int n;
        if (!this.hasTau()) {
            return;
        }
        do {
            boolean bl = false;
            for (int i = 0; i < this.maxStates; ++i) {
                this.states[i] = EventState.remove(this.states[i], new EventState(0, i));
            }
            BitSet bitSet = new BitSet(this.maxStates);
            for (n = 1; n < this.maxStates; ++n) {
                if (!EventState.hasOnlyTauAndAccept(this.states[n], this.alphabet)) continue;
                bitSet.set(n);
                bl = true;
            }
            if (!bl) {
                return;
            }
            for (n = 0; n < this.maxStates; ++n) {
                if (bitSet.get(n)) continue;
                this.states[n] = EventState.addNonDetTau(this.states[n], this.states, bitSet);
            }
            n = this.maxStates;
            this.reachable();
        } while (n != this.maxStates);
    }

    public void removeDetCycles(String string) {
        int n = this.eventNo(string);
        if (n >= this.alphabet.length) {
            return;
        }
        for (int i = 0; i < this.states.length; ++i) {
            if (EventState.hasNonDetEvent(this.states[i], n)) continue;
            this.states[i] = EventState.remove(this.states[i], new EventState(n, i));
        }
    }

    public boolean isSafetyOnly() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.maxStates; ++i) {
            if (!EventState.isAccepting(this.states[i], this.alphabet)) continue;
            ++n2;
            if (!EventState.isTerminal(i, this.states[i])) continue;
            ++n;
        }
        return n == 1 && n2 == 1 || n2 == 0;
    }

    public void makeSafety() {
        int n;
        int n2 = -1;
        for (n = 0; n < this.maxStates; ++n) {
            if (!EventState.isAccepting(this.states[n], this.alphabet)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            this.states[n2] = EventState.removeAccept(this.states[n2]);
        }
        for (n = 0; n < this.maxStates; ++n) {
            EventState.replaceWithError(this.states[n], n2);
        }
        this.reachable();
    }

    public void removeAcceptTau() {
        for (int i = 1; i < this.maxStates; ++i) {
            if (!EventState.hasOnlyTauAndAccept(this.states[i], this.alphabet)) continue;
            this.states[i] = EventState.removeAccept(this.states[i]);
        }
    }

    public boolean hasERROR() {
        for (int i = 0; i < this.maxStates; ++i) {
            if (!EventState.hasState(this.states[i], -1)) continue;
            return true;
        }
        return false;
    }

    public void prefixLabels(String string) {
        this.name = string + ":" + this.name;
        for (int i = 1; i < this.alphabet.length; ++i) {
            String string2 = this.alphabet[i];
            this.alphabet[i] = string + "." + string2;
        }
    }

    public boolean relabelDuplicates() {
        return this.hasduplicates;
    }

    public void relabel(Relation relation) {
        this.hasduplicates = false;
        if (relation.isRelation()) {
            this.relational_relabel(relation);
        } else {
            this.functional_relabel(relation);
        }
    }

    private void relational_relabel(Relation relation) {
        Vector<String> vector = new Vector<String>();
        Relation relation2 = new Relation();
        vector.setSize(this.alphabet.length);
        int n = this.alphabet.length;
        vector.setElementAt(this.alphabet[0], 0);
        for (int i = 1; i < this.alphabet.length; ++i) {
            Object object;
            int n2 = -1;
            Object v = relation.get(this.alphabet[i]);
            if (v != null) {
                if (v instanceof String) {
                    vector.setElementAt((String)v, i);
                    continue;
                }
                object = (Vector)v;
                vector.setElementAt((String)((Vector)object).firstElement(), i);
                for (int j = 1; j < ((Vector)object).size(); ++j) {
                    vector.addElement((String)((Vector)object).elementAt(j));
                    relation2.put(new Integer(i), new Integer(n));
                    ++n;
                }
                continue;
            }
            n2 = this.maximalPrefix(this.alphabet[i], relation);
            if (n2 >= 0) {
                object = this.alphabet[i].substring(0, n2);
                v = relation.get(object);
                if (v != null) {
                    if (v instanceof String) {
                        vector.setElementAt((String)v + this.alphabet[i].substring(n2), i);
                        continue;
                    }
                    Vector vector2 = (Vector)v;
                    vector.setElementAt((String)vector2.firstElement() + this.alphabet[i].substring(n2), i);
                    for (int j = 1; j < vector2.size(); ++j) {
                        vector.addElement((String)vector2.elementAt(j) + this.alphabet[i].substring(n2));
                        relation2.put(new Integer(i), new Integer(n));
                        ++n;
                    }
                    continue;
                }
                vector.setElementAt(this.alphabet[i], i);
                continue;
            }
            vector.setElementAt(this.alphabet[i], i);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.alphabet = objectArray;
        this.addtransitions(relation2);
        this.checkDuplicates();
    }

    private void functional_relabel(Hashtable hashtable) {
        for (int i = 1; i < this.alphabet.length; ++i) {
            String string = (String)hashtable.get(this.alphabet[i]);
            this.alphabet[i] = string != null ? string : this.prefixLabelReplace(i, hashtable);
        }
        this.checkDuplicates();
    }

    private void checkDuplicates() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 1; i < this.alphabet.length; ++i) {
            if (hashtable.put(this.alphabet[i], this.alphabet[i]) == null) continue;
            this.hasduplicates = true;
            this.crunchDuplicates();
        }
    }

    private void crunchDuplicates() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Hashtable hashtable2 = new Hashtable();
        int n = 0;
        for (int i = 0; i < this.alphabet.length; ++i) {
            if (hashtable.containsKey(this.alphabet[i])) {
                hashtable2.put(new Integer(i), hashtable.get(this.alphabet[i]));
                continue;
            }
            hashtable.put(this.alphabet[i], new Integer(n));
            hashtable2.put(new Integer(i), new Integer(n));
            ++n;
        }
        this.alphabet = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n2 = (Integer)hashtable.get(string);
            this.alphabet[n2] = string;
        }
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = EventState.renumberEvents(this.states[i], hashtable2);
        }
    }

    public Vector hide(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        for (int i = 1; i < this.alphabet.length; ++i) {
            if (CompactState.contains(this.alphabet[i], vector)) continue;
            vector2.addElement(this.alphabet[i]);
        }
        return vector2;
    }

    public void expose(Vector vector) {
        BitSet bitSet = new BitSet(this.alphabet.length);
        for (int i = 1; i < this.alphabet.length; ++i) {
            if (!CompactState.contains(this.alphabet[i], vector)) continue;
            bitSet.set(i);
        }
        bitSet.set(0);
        this.dohiding(bitSet);
    }

    public void conceal(Vector vector) {
        BitSet bitSet = new BitSet(this.alphabet.length);
        for (int i = 1; i < this.alphabet.length; ++i) {
            if (CompactState.contains(this.alphabet[i], vector)) continue;
            bitSet.set(i);
        }
        bitSet.set(0);
        this.dohiding(bitSet);
    }

    private void dohiding(BitSet bitSet) {
        int n;
        Integer n2 = new Integer(0);
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        for (n = 0; n < this.alphabet.length; ++n) {
            if (!bitSet.get(n)) {
                hashtable.put(new Integer(n), n2);
                continue;
            }
            vector.addElement(this.alphabet[n]);
            hashtable.put(new Integer(n), new Integer(n3));
            ++n3;
        }
        this.alphabet = new String[vector.size()];
        vector.copyInto(this.alphabet);
        for (n = 0; n < this.states.length; ++n) {
            this.states[n] = EventState.renumberEvents(this.states[n], hashtable);
        }
    }

    static boolean contains(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equals(string) && !CompactState.isPrefix(string2, string)) continue;
            return true;
        }
        return false;
    }

    public boolean isProperty() {
        return this.prop;
    }

    public void makeProperty() {
        this.endseq = -9999;
        this.prop = true;
        for (int i = 0; i < this.maxStates; ++i) {
            this.states[i] = EventState.addTransToError(this.states[i], this.alphabet.length);
        }
    }

    public void unMakeProperty() {
        this.endseq = -9999;
        this.prop = false;
        for (int i = 0; i < this.maxStates; ++i) {
            this.states[i] = EventState.removeTransToError(this.states[i]);
        }
    }

    public boolean isNonDeterministic() {
        for (int i = 0; i < this.maxStates; ++i) {
            if (!EventState.hasNonDet(this.states[i])) continue;
            return true;
        }
        return false;
    }

    public void printAUT(PrintStream printStream) {
        printStream.print("des(0," + this.ntransitions() + "," + this.maxStates + ")\n");
        for (int i = 0; i < this.states.length; ++i) {
            EventState.printAUT(this.states[i], i, this.alphabet, printStream);
        }
    }

    public CompactState myclone() {
        int n;
        CompactState compactState = new CompactState();
        compactState.name = this.name;
        compactState.endseq = this.endseq;
        compactState.prop = this.prop;
        compactState.alphabet = new String[this.alphabet.length];
        for (n = 0; n < this.alphabet.length; ++n) {
            compactState.alphabet[n] = this.alphabet[n];
        }
        compactState.maxStates = this.maxStates;
        compactState.states = new EventState[this.maxStates];
        for (n = 0; n < this.maxStates; ++n) {
            compactState.states[n] = EventState.union(compactState.states[n], this.states[n]);
        }
        return compactState;
    }

    public int ntransitions() {
        int n = 0;
        for (int i = 0; i < this.states.length; ++i) {
            n += EventState.count(this.states[i]);
        }
        return n;
    }

    public boolean hasTau() {
        for (int i = 0; i < this.states.length; ++i) {
            if (!EventState.hasTau(this.states[i])) continue;
            return true;
        }
        return false;
    }

    private String prefixLabelReplace(int n, Hashtable hashtable) {
        int n2 = this.maximalPrefix(this.alphabet[n], hashtable);
        if (n2 < 0) {
            return this.alphabet[n];
        }
        String string = this.alphabet[n].substring(0, n2);
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return this.alphabet[n];
        }
        return string2 + this.alphabet[n].substring(n2);
    }

    private int maximalPrefix(String string, Hashtable hashtable) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return n;
        }
        if (hashtable.containsKey(string.substring(0, n))) {
            return n;
        }
        return this.maximalPrefix(string.substring(0, n), hashtable);
    }

    private static boolean isPrefix(String string, String string2) {
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return false;
        }
        if (string.equals(string2.substring(0, n))) {
            return true;
        }
        return CompactState.isPrefix(string, string2.substring(0, n));
    }

    public boolean isErrorTrace(Vector vector) {
        boolean bl = false;
        for (int i = 0; i < this.maxStates && !bl; ++i) {
            if (!EventState.hasState(this.states[i], -1)) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        return this.isTrace(vector, 0, 0);
    }

    private boolean isTrace(Vector vector, int n, int n2) {
        if (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            int n3 = this.eventNo(string);
            if (n3 < this.alphabet.length) {
                if (EventState.hasEvent(this.states[n2], n3)) {
                    int[] nArray = EventState.nextState(this.states[n2], n3);
                    for (int i = 0; i < nArray.length; ++i) {
                        if (!this.isTrace(vector, n + 1, nArray[i])) continue;
                        return true;
                    }
                    return false;
                }
                if (n3 != 0) {
                    return false;
                }
            }
            return this.isTrace(vector, n + 1, n2);
        }
        return n2 == -1;
    }

    private int eventNo(String string) {
        int n;
        for (n = 0; n < this.alphabet.length && !string.equals(this.alphabet[n]); ++n) {
        }
        return n;
    }

    public void addAccess(Vector vector) {
        int n;
        int n2;
        int n3 = vector.size();
        if (n3 == 0) {
            return;
        }
        String string = "{";
        CompactState[] compactStateArray = new CompactState[n3];
        Enumeration enumeration = vector.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + string2;
            compactStateArray[n4] = this.myclone();
            compactStateArray[n4].prefixLabels(string2);
            if (++n4 >= n3) continue;
            string = string + ",";
        }
        this.name = string + "}::" + this.name;
        int n5 = this.alphabet.length - 1;
        this.alphabet = new String[n5 * n3 + 1];
        this.alphabet[0] = "tau";
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 1; n < compactStateArray[n2].alphabet.length; ++n) {
                this.alphabet[n5 * n2 + n] = compactStateArray[n2].alphabet[n];
            }
        }
        for (n2 = 1; n2 < n3; ++n2) {
            for (n = 0; n < this.maxStates; ++n) {
                EventState.offsetEvents(compactStateArray[n2].states[n], n5 * n2);
                this.states[n] = EventState.union(this.states[n], compactStateArray[n2].states[n]);
            }
        }
    }

    private void addtransitions(Relation relation) {
        for (int i = 0; i < this.states.length; ++i) {
            EventState eventState = EventState.newTransitions(this.states[i], relation);
            if (eventState == null) continue;
            this.states[i] = EventState.union(this.states[i], eventState);
        }
    }

    public boolean hasLabel(String string) {
        for (int i = 0; i < this.alphabet.length; ++i) {
            if (!string.equals(this.alphabet[i])) continue;
            return true;
        }
        return false;
    }

    public boolean usesLabel(String string) {
        if (!this.hasLabel(string)) {
            return false;
        }
        int n = this.eventNo(string);
        for (int i = 0; i < this.states.length; ++i) {
            if (!EventState.hasEvent(this.states[i], n)) continue;
            return true;
        }
        return false;
    }

    public boolean isSequential() {
        return this.endseq >= 0;
    }

    public boolean isEnd() {
        return this.maxStates == 1 && this.endseq == 0;
    }

    public static CompactState sequentialCompose(Vector vector) {
        if (vector == null) {
            return null;
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (CompactState)vector.elementAt(0);
        }
        CompactState[] compactStateArray = new CompactState[vector.size()];
        compactStateArray = vector.toArray(compactStateArray);
        CompactState compactState = new CompactState();
        compactState.alphabet = CompactState.sharedAlphabet(compactStateArray);
        compactState.maxStates = CompactState.seqSize(compactStateArray);
        compactState.states = new EventState[compactState.maxStates];
        int n = 0;
        for (int i = 0; i < compactStateArray.length; ++i) {
            boolean bl = i == compactStateArray.length - 1;
            CompactState.copyOffset(n, compactState.states, compactStateArray[i], bl);
            if (bl) {
                compactState.endseq = compactStateArray[i].endseq + n;
            }
            n += compactStateArray[i].states.length;
        }
        return compactState;
    }

    public void expandSequential(Hashtable hashtable) {
        int n = hashtable.size();
        CompactState[] compactStateArray = new CompactState[n + 1];
        int[] nArray = new int[n + 1];
        compactStateArray[0] = this;
        int n2 = 1;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            CompactState compactState;
            Integer n3 = (Integer)enumeration.nextElement();
            compactStateArray[n2] = compactState = (CompactState)hashtable.get(n3);
            nArray[n2] = n3;
            ++n2;
        }
        this.alphabet = CompactState.sharedAlphabet(compactStateArray);
        for (int i = 1; i < compactStateArray.length; ++i) {
            int n4 = nArray[i];
            for (int j = 0; j < compactStateArray[i].states.length; ++j) {
                this.states[n4 + j] = compactStateArray[i].states[j];
            }
        }
    }

    private static int seqSize(CompactState[] compactStateArray) {
        int n = 0;
        for (int i = 0; i < compactStateArray.length; ++i) {
            n += compactStateArray[i].states.length;
        }
        return n;
    }

    private static void copyOffset(int n, EventState[] eventStateArray, CompactState compactState, boolean bl) {
        for (int i = 0; i < compactState.states.length; ++i) {
            eventStateArray[i + n] = !bl ? EventState.offsetSeq(n, compactState.endseq, compactState.maxStates + n, compactState.states[i]) : EventState.offsetSeq(n, compactState.endseq, compactState.endseq + n, compactState.states[i]);
        }
    }

    public void offsetSeq(int n, int n2) {
        for (int i = 0; i < this.states.length; ++i) {
            EventState.offsetSeq(n, this.endseq, n2, this.states[i]);
        }
    }

    private static String[] sharedAlphabet(CompactState[] compactStateArray) {
        int n;
        Counter counter = new Counter(0);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < compactStateArray.length; ++i) {
            for (int j = 0; j < compactStateArray[i].alphabet.length; ++j) {
                if (hashtable.containsKey(compactStateArray[i].alphabet[j])) continue;
                hashtable.put(compactStateArray[i].alphabet[j], counter.label());
            }
        }
        String[] stringArray = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n = (Integer)hashtable.get(string);
            stringArray[n] = string;
        }
        for (int i = 0; i < compactStateArray.length; ++i) {
            for (n = 0; n < compactStateArray[i].maxStates; ++n) {
                EventState eventState = compactStateArray[i].states[n];
                while (eventState != null) {
                    EventState eventState2 = eventState;
                    eventState2.event = (Integer)hashtable.get(compactStateArray[i].alphabet[eventState2.event]);
                    while (eventState2.nondet != null) {
                        eventState2.nondet.event = eventState2.event;
                        eventState2 = eventState2.nondet;
                    }
                    eventState = eventState.list;
                }
            }
        }
        return stringArray;
    }

    private byte[] encode(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] | (byte)n);
            n >>>= 8;
        }
        return byArray;
    }

    private int decode(byte[] byArray) {
        int n = 0;
        for (int i = 3; i >= 0; --i) {
            n |= byArray[i] & 0xFF;
            if (i <= 0) continue;
            n <<= 8;
        }
        return n;
    }

    public String[] getAlphabet() {
        return this.alphabet;
    }

    public Vector getAlphabetV() {
        Vector<String> vector = new Vector<String>(this.alphabet.length - 1);
        for (int i = 1; i < this.alphabet.length; ++i) {
            vector.add(this.alphabet[i]);
        }
        return vector;
    }

    public MyList getTransitions(byte[] byArray) {
        MyList myList = new MyList();
        int n = byArray == null ? -1 : this.decode(byArray);
        if (n < 0 || n >= this.maxStates) {
            return myList;
        }
        if (this.states[n] != null) {
            Enumeration enumeration = this.states[n].elements();
            while (enumeration.hasMoreElements()) {
                EventState eventState = (EventState)enumeration.nextElement();
                myList.add(n, this.encode(eventState.next), eventState.event);
            }
        }
        return myList;
    }

    public String getViolatedProperty() {
        return null;
    }

    public Vector getTraceToState(byte[] byArray, byte[] byArray2) {
        EventState eventState = new EventState(0, 0);
        int n = EventState.search(eventState, this.states, this.decode(byArray), this.decode(byArray2), -123456);
        return EventState.getPath(eventState.path, this.alphabet);
    }

    public boolean END(byte[] byArray) {
        return this.decode(byArray) == this.endseq;
    }

    public boolean isAccepting(byte[] byArray) {
        return this.isAccepting(this.decode(byArray));
    }

    public byte[] START() {
        return this.encode(0);
    }

    public void setStackChecker(StackCheck stackCheck) {
    }

    public boolean isPartialOrder() {
        return false;
    }

    public void disablePartialOrder() {
    }

    public void enablePartialOrder() {
    }

    public boolean isAccepting(int n) {
        if (n < 0 || n >= this.maxStates) {
            return false;
        }
        return EventState.isAccepting(this.states[n], this.alphabet);
    }

    public BitSet accepting() {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.maxStates; ++i) {
            if (!this.isAccepting(i)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }
}

