/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.CompactState;
import lts.CompositeBody;
import lts.CompositeState;
import lts.LTSOutput;
import lts.LabelSet;
import lts.StateMachine;
import lts.Symbol;

class CompositionExpression {
    Symbol name;
    CompositeBody body;
    Hashtable constants;
    Hashtable init_constants = new Hashtable();
    Vector parameters = new Vector();
    Hashtable processes;
    Hashtable compiledProcesses;
    Hashtable composites;
    LTSOutput output;
    boolean priorityIsLow = true;
    LabelSet priorityActions;
    LabelSet alphaHidden;
    boolean exposeNotHide = false;
    boolean makeDeterministic = false;
    boolean makeMinimal = false;
    boolean makeProperty = false;
    boolean makeCompose = false;

    CompositionExpression() {
    }

    CompositeState compose(Vector vector) {
        Object object;
        Vector vector2 = new Vector();
        Hashtable hashtable = new Hashtable();
        this.constants = (Hashtable)this.init_constants.clone();
        if (vector != null) {
            this.doParams(vector);
        }
        this.body.compose(this, vector2, hashtable);
        Vector vector3 = new Vector();
        Object object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (object instanceof CompactState) {
                vector3.addElement(object);
                continue;
            }
            CompositeState compositeState = (CompositeState)object;
            Enumeration enumeration = compositeState.machines.elements();
            while (enumeration.hasMoreElements()) {
                vector3.addElement(enumeration.nextElement());
            }
        }
        object2 = vector == null ? this.name.toString() : this.name.toString() + StateMachine.paramString(vector);
        object = new CompositeState((String)object2, vector3);
        ((CompositeState)object).priorityIsLow = this.priorityIsLow;
        ((CompositeState)object).priorityLabels = this.computeAlphabet(this.priorityActions);
        ((CompositeState)object).hidden = this.computeAlphabet(this.alphaHidden);
        ((CompositeState)object).exposeNotHide = this.exposeNotHide;
        ((CompositeState)object).makeDeterministic = this.makeDeterministic;
        ((CompositeState)object).makeMinimal = this.makeMinimal;
        ((CompositeState)object).makeCompose = this.makeCompose;
        if (this.makeProperty) {
            ((CompositeState)object).makeDeterministic = true;
            ((CompositeState)object).isProperty = true;
        }
        return object;
    }

    private void doParams(Vector vector) {
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = this.parameters.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            this.constants.put(enumeration2.nextElement(), enumeration.nextElement());
        }
    }

    private Vector computeAlphabet(LabelSet labelSet) {
        if (labelSet == null) {
            return null;
        }
        return labelSet.getActions(this.constants);
    }
}

