/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import lts.CompactState;
import lts.EventState;
import lts.LTSOutput;

public class Determinizer {
    static final int TAU = 0;
    CompactState machine;
    LTSOutput output;
    Vector newStates;
    Vector stateSets;
    Hashtable map;
    int nextState;
    int currentState;

    public Determinizer(CompactState compactState, LTSOutput lTSOutput) {
        this.machine = compactState;
        this.output = lTSOutput;
    }

    public CompactState determine() {
        this.output.outln("make DFA(" + this.machine.name + ")");
        this.newStates = new Vector(this.machine.maxStates * 2);
        this.stateSets = new Vector(this.machine.maxStates * 2);
        this.map = new Hashtable(this.machine.maxStates * 2);
        this.nextState = 0;
        this.currentState = 0;
        BitSet bitSet = new BitSet();
        bitSet.set(0);
        this.addState(bitSet);
        while (this.currentState < this.nextState) {
            this.compute(this.currentState);
            ++this.currentState;
        }
        return this.makeNewMachine();
    }

    protected void compute(int n) {
        BitSet bitSet = (BitSet)this.stateSets.elementAt(n);
        EventState eventState = null;
        EventState eventState2 = null;
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i)) continue;
            eventState = EventState.union(eventState, this.machine.states[i]);
        }
        EventState eventState3 = eventState;
        while (eventState3 != null) {
            boolean bl = false;
            BitSet bitSet2 = new BitSet();
            if (eventState3.next != -1) {
                bitSet2.set(eventState3.next);
            } else {
                bl = true;
            }
            EventState eventState4 = eventState3.nondet;
            while (eventState4 != null) {
                if (eventState4.next != -1) {
                    bitSet2.set(eventState4.next);
                } else {
                    bl = true;
                }
                eventState4 = eventState4.nondet;
            }
            int n2 = bl ? -1 : this.addState(bitSet2);
            eventState2 = EventState.add(eventState2, new EventState(eventState3.event, n2));
            eventState3 = eventState3.list;
        }
        this.newStates.addElement(eventState2);
    }

    protected int addState(BitSet bitSet) {
        Integer n = (Integer)this.map.get(bitSet);
        if (n != null) {
            return n;
        }
        this.map.put(bitSet, new Integer(this.nextState));
        this.stateSets.addElement(bitSet);
        ++this.nextState;
        return this.nextState - 1;
    }

    protected CompactState makeNewMachine() {
        int n;
        CompactState compactState = new CompactState();
        compactState.name = this.machine.name;
        compactState.alphabet = new String[this.machine.alphabet.length];
        for (n = 0; n < this.machine.alphabet.length; ++n) {
            compactState.alphabet[n] = this.machine.alphabet[n];
        }
        compactState.maxStates = this.nextState;
        compactState.states = new EventState[compactState.maxStates];
        for (n = 0; n < compactState.maxStates; ++n) {
            compactState.states[n] = (EventState)this.newStates.elementAt(n);
        }
        if (this.machine.endseq >= 0) {
            BitSet bitSet = new BitSet();
            bitSet.set(this.machine.endseq);
            Integer n2 = (Integer)this.map.get(bitSet);
            if (n2 != null) {
                compactState.endseq = n2;
            }
        }
        this.output.outln("DFA(" + this.machine.name + ") has " + compactState.maxStates + " states.");
        return compactState;
    }
}

