/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.BitSet;
import java.util.Hashtable;
import lts.CompactState;
import lts.Counter;
import lts.Determinizer;
import lts.EventState;
import lts.LTSOutput;

public class Minimiser {
    static final int TAU = 0;
    BitSet[] E;
    BitSet[] A;
    EventState[] T;
    CompactState machine;
    LTSOutput output;

    public Minimiser(CompactState compactState, LTSOutput lTSOutput) {
        this.machine = compactState;
        this.output = lTSOutput;
    }

    private void initTau() {
        this.T = new EventState[this.machine.states.length];
        for (int i = 0; i < this.T.length; ++i) {
            this.T[i] = EventState.reachableTau(this.machine.states, i);
        }
    }

    private CompactState machTau(CompactState compactState) {
        int n;
        for (n = 0; n < compactState.states.length; ++n) {
            compactState.states[n] = EventState.tauAdd(compactState.states[n], this.T);
        }
        for (n = 0; n < compactState.states.length; ++n) {
            compactState.states[n] = EventState.union(compactState.states[n], this.T[n]);
            compactState.states[n] = EventState.actionAdd(compactState.states[n], compactState.states);
        }
        for (n = 0; n < compactState.states.length; ++n) {
            compactState.states[n] = EventState.add(compactState.states[n], new EventState(0, n));
        }
        this.output.out(".");
        return compactState;
    }

    private CompactState removeTau(CompactState compactState) {
        for (int i = 0; i < compactState.states.length; ++i) {
            compactState.states[i] = EventState.removeTau(compactState.states[i]);
        }
        return compactState;
    }

    private void initialise() {
        int n;
        this.A = new BitSet[this.machine.maxStates];
        for (n = 0; n < this.A.length; ++n) {
            this.A[n] = new BitSet(this.machine.alphabet.length);
            EventState.setActions(this.machine.states[n], this.A[n]);
        }
        this.E = new BitSet[this.machine.maxStates];
        for (n = 0; n < this.E.length; ++n) {
            this.E[n] = new BitSet(this.E.length);
        }
        for (n = 0; n < this.E.length; ++n) {
            this.E[n].set(n);
            for (int i = 0; i < n; ++i) {
                if (!this.A[n].equals(this.A[i])) continue;
                this.E[n].set(i);
                this.E[i].set(n);
            }
        }
        this.output.out(".");
    }

    private void dominimise() {
        boolean bl = true;
        while (bl) {
            this.output.out(".");
            bl = false;
            for (int i = 0; i < this.E.length; ++i) {
                Thread.yield();
                for (int j = 0; j < i; ++j) {
                    boolean bl2;
                    if (!this.E[i].get(j)) continue;
                    boolean bl3 = bl2 = this.is_equivalent(i, j) && this.is_equivalent(j, i);
                    if (bl2) continue;
                    bl = true;
                    this.E[i].clear(j);
                    this.E[j].clear(i);
                }
            }
        }
    }

    public CompactState minimise() {
        this.output.out(this.machine.name + " minimising");
        long l = System.currentTimeMillis();
        CompactState compactState = this.machine.myclone();
        if (this.machine.endseq >= 0) {
            int n = this.machine.endseq;
            this.machine.states[n] = EventState.add(this.machine.states[n], new EventState(this.machine.alphabet.length, n));
        }
        if (this.machine.hasTau()) {
            this.initTau();
            this.machine = this.machTau(this.machine);
            this.T = null;
        }
        this.initialise();
        this.dominimise();
        this.machine = compactState;
        CompactState compactState2 = this.makeNewMachine();
        long l2 = System.currentTimeMillis();
        this.output.outln("");
        this.output.outln("Minimised States: " + compactState2.maxStates + " in " + (l2 - l) + "ms");
        return compactState2;
    }

    public CompactState trace_minimise() {
        boolean bl = false;
        if (this.machine.hasTau()) {
            bl = true;
            this.output.out("Eliminating tau");
            this.initTau();
            this.machine = this.machTau(this.machine);
            this.machine = this.removeTau(this.machine);
            this.T = null;
        }
        if (bl || this.machine.isNonDeterministic()) {
            bl = true;
            Determinizer determinizer = new Determinizer(this.machine, this.output);
            this.machine = determinizer.determine();
        }
        if (bl) {
            return this.minimise();
        }
        return this.machine;
    }

    private boolean is_equivalent(int n, int n2) {
        EventState eventState = this.machine.states[n];
        while (eventState != null) {
            EventState eventState2 = eventState;
            while (eventState2 != null) {
                if (!this.findSuccessor(n2, eventState2)) {
                    return false;
                }
                eventState2 = eventState2.nondet;
            }
            eventState = eventState.list;
        }
        return true;
    }

    private boolean findSuccessor(int n, EventState eventState) {
        EventState eventState2 = this.machine.states[n];
        while (eventState2.event != eventState.event) {
            eventState2 = eventState2.list;
        }
        while (eventState2 != null) {
            if (eventState.next < 0 ? eventState2.next < 0 : eventState2.next >= 0 && this.E[eventState.next].get(eventState2.next)) {
                return true;
            }
            eventState2 = eventState2.nondet;
        }
        return false;
    }

    private CompactState makeNewMachine() {
        int n;
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        Counter counter = new Counter(0);
        for (int i = 0; i < this.E.length; ++i) {
            Integer n2 = new Integer(i);
            Integer n3 = (Integer)hashtable.get(n2);
            if (n3 == null) {
                n3 = counter.label();
                hashtable.put(n2, n3);
                hashtable2.put(n3, n2);
            }
            for (int j = 0; j < this.E.length; ++j) {
                if (!this.E[i].get(j)) continue;
                hashtable.put(new Integer(j), n3);
            }
        }
        CompactState compactState = new CompactState();
        compactState.name = this.machine.name;
        compactState.maxStates = hashtable2.size();
        compactState.alphabet = this.machine.alphabet;
        compactState.states = new EventState[compactState.maxStates];
        if (this.machine.endseq < 0) {
            compactState.endseq = this.machine.endseq;
        } else {
            compactState.endseq = (Integer)hashtable.get(new Integer(this.machine.endseq));
            compactState.states[compactState.endseq] = EventState.remove(compactState.states[compactState.endseq], new EventState(compactState.alphabet.length, compactState.endseq));
        }
        for (n = 0; n < this.machine.maxStates; ++n) {
            int n4 = (Integer)hashtable.get(new Integer(n));
            EventState eventState = EventState.renumberStates(this.machine.states[n], hashtable);
            compactState.states[n4] = EventState.union(compactState.states[n4], eventState);
        }
        for (n = 0; n < compactState.maxStates; ++n) {
            compactState.states[n] = EventState.remove(compactState.states[n], new EventState(0, n));
        }
        return compactState;
    }

    public void print(LTSOutput lTSOutput) {
        this.privPrint(lTSOutput, this.E);
    }

    private void privPrint(LTSOutput lTSOutput, BitSet[] bitSetArray) {
        int n;
        if (bitSetArray.length > 20) {
            return;
        }
        char[] cArray = new char[bitSetArray.length * 2];
        for (n = 0; n < bitSetArray.length * 2; ++n) {
            cArray[n] = 32;
        }
        lTSOutput.outln("E:");
        lTSOutput.out("       ");
        for (n = 0; n < bitSetArray.length; ++n) {
            lTSOutput.out(" " + n);
        }
        lTSOutput.outln("");
        for (n = 0; n < bitSetArray.length; ++n) {
            lTSOutput.out("State " + n + " ");
            for (int i = 0; i < bitSetArray.length; ++i) {
                cArray[i * 2] = bitSetArray[n].get(i) ? 49 : 32;
            }
            lTSOutput.outln(new String(cArray));
        }
    }
}

