/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import lts.CompactState;
import lts.EventState;
import lts.StackChecker;

public class PartialOrder {
    private CompactState[] machines;
    private int[][] actionSharedBy;
    private StackChecker checker;
    private int[][] candidates;
    private int[][] partners;
    private int Nactions;
    private String[] names;
    private BitSet visible;
    private boolean preserveOE;
    private BitSet high;

    public PartialOrder(Hashtable hashtable, String[] stringArray, CompactState[] compactStateArray, StackChecker stackChecker, Vector vector, boolean bl, boolean bl2, BitSet bitSet) {
        int n;
        this.machines = compactStateArray;
        this.names = stringArray;
        this.Nactions = stringArray.length;
        this.checker = stackChecker;
        this.preserveOE = bl2;
        this.high = bitSet;
        this.actionSharedBy = new int[this.Nactions][];
        for (n = 1; n < stringArray.length; ++n) {
            BitSet bitSet2 = (BitSet)hashtable.get(stringArray[n]);
            this.actionSharedBy[n] = this.bitsToArray(bitSet2);
        }
        this.visible = new BitSet(this.Nactions);
        for (n = 1; n < stringArray.length; ++n) {
            if (vector == null) {
                this.visible.set(n);
                continue;
            }
            if (bl) {
                if (!CompactState.contains(stringArray[n], vector)) continue;
                this.visible.set(n);
                continue;
            }
            if (CompactState.contains(stringArray[n], vector)) continue;
            this.visible.set(n);
        }
        this.initPartners();
        this.candidates = this.computeCandidates();
    }

    public List transitions(int[] nArray) {
        int n;
        for (n = 0; n < this.machines.length; ++n) {
            ArrayList arrayList;
            boolean bl;
            if (this.candidates[n][nArray[n]] != 1 || !(bl = this.getMachTransitions(arrayList = new ArrayList(8), n, nArray, null))) continue;
            return arrayList;
        }
        for (n = 0; n < this.machines.length; ++n) {
            List list;
            int n2;
            if (this.candidates[n][nArray[n]] != 2 || n != this.partners[n2 = this.partners[n][nArray[n]]][nArray[n2]] || (list = this.getPairTransitions(n, n2, nArray)) == null) continue;
            return list;
        }
        return null;
    }

    private boolean addTransitions(List list, int[] nArray, int n, int n2) {
        int[] nArray2 = null;
        int n3 = this.actionSharedBy[n][n2];
        EventState eventState = this.machines[n3].states[nArray[n3]];
        if (eventState != null) {
            nArray2 = this.myclone(nArray, n);
        }
        eventState = EventState.firstCompState(eventState, n, nArray);
        if (n2 < this.actionSharedBy[n].length - 1) {
            if (!this.addTransitions(list, nArray, n, n2 + 1)) {
                return false;
            }
        } else {
            if (this.checker.onStack(nArray)) {
                return false;
            }
            list.add(nArray);
        }
        while (eventState != null) {
            int[] nArray3 = this.myclone(nArray2, n);
            eventState = EventState.moreCompState(eventState, nArray3);
            if (n2 < this.actionSharedBy[n].length - 1) {
                if (this.addTransitions(list, nArray3, n, n2 + 1)) continue;
                return false;
            }
            if (this.checker.onStack(nArray3)) {
                return false;
            }
            list.add(nArray3);
        }
        return true;
    }

    private List getPairTransitions(int n, int n2, int[] nArray) {
        BitSet bitSet;
        ArrayList arrayList = new ArrayList(8);
        boolean bl = true;
        if (!this.preserveOE) {
            bitSet = this.getUnshared(n, nArray);
            if (bitSet != null) {
                bl = this.getMachTransitions(arrayList, n, nArray, bitSet);
            }
            if (!bl) {
                return null;
            }
            bitSet = this.getUnshared(n2, nArray);
            if (bitSet != null) {
                bl = this.getMachTransitions(arrayList, n2, nArray, bitSet);
            }
            if (!bl) {
                return null;
            }
        }
        bitSet = new BitSet(this.Nactions);
        EventState.hasEvents(this.machines[n].states[nArray[n]], bitSet);
        BitSet bitSet2 = new BitSet(this.Nactions);
        EventState.hasEvents(this.machines[n2].states[nArray[n2]], bitSet2);
        bitSet.and(bitSet2);
        if (this.preserveOE && this.countSet(bitSet) != 1) {
            return null;
        }
        bitSet.clear(0);
        int[] nArray2 = this.bitsToArray(bitSet);
        for (int i = 0; i < nArray2.length; ++i) {
            bl = this.addTransitions(arrayList, this.myclone(nArray, nArray2[i]), nArray2[i], 0);
            if (bl) continue;
            return null;
        }
        return arrayList;
    }

    private BitSet getUnshared(int n, int[] nArray) {
        BitSet bitSet = new BitSet(this.Nactions);
        Enumeration enumeration = this.machines[n].states[nArray[n]].elements();
        while (enumeration.hasMoreElements()) {
            EventState eventState = (EventState)enumeration.nextElement();
            if (eventState.event == 0) {
                bitSet.set(eventState.event);
                continue;
            }
            if (this.actionSharedBy[eventState.event].length != 1) continue;
            bitSet.set(eventState.event);
        }
        if (bitSet.length() == 0) {
            return null;
        }
        return bitSet;
    }

    private boolean getMachTransitions(List list, int n, int[] nArray, BitSet bitSet) {
        Enumeration enumeration = this.machines[n].states[nArray[n]].elements();
        while (enumeration.hasMoreElements()) {
            EventState eventState = (EventState)enumeration.nextElement();
            if (bitSet != null && !bitSet.get(eventState.event)) continue;
            int[] nArray2 = this.myclone(nArray, eventState.event);
            nArray2[n] = eventState.next;
            if (this.checker.onStack(nArray2)) {
                return false;
            }
            list.add(nArray2);
        }
        return true;
    }

    private int[] bitsToArray(BitSet bitSet) {
        int n = this.countSet(bitSet);
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = bitSet.length();
        for (int i = 0; i < n3; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n2] = i;
            ++n2;
        }
        return nArray;
    }

    private int countSet(BitSet bitSet) {
        int n = 0;
        int n2 = bitSet.length();
        for (int i = 0; i < n2; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private int[] myclone(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length - 1; ++i) {
            nArray2[i] = nArray[i];
        }
        nArray2[nArray.length - 1] = n;
        return nArray2;
    }

    private void printArray(String string, int[][] nArray) {
        System.out.println(string);
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print("Mach " + i + " --");
            for (int j = 0; j < nArray[i].length; ++j) {
                System.out.print(" " + nArray[i][j]);
            }
            System.out.println(".");
        }
    }

    private void initPartners() {
        this.partners = new int[this.machines.length][];
        for (int i = 0; i < this.machines.length; ++i) {
            this.partners[i] = new int[this.machines[i].states.length];
            for (int j = 0; j < this.machines[i].states.length; ++j) {
                this.partners[i][j] = -1;
            }
        }
    }

    private int[][] computeCandidates() {
        int[][] nArrayArray = new int[this.machines.length][];
        for (int i = 0; i < this.machines.length; ++i) {
            nArrayArray[i] = new int[this.machines[i].states.length];
            for (int j = 0; j < this.machines[i].states.length; ++j) {
                int[] nArray = EventState.localEnabled(this.machines[i].states[j]);
                nArrayArray[i][j] = this.candidateNumber(i, j, nArray);
            }
        }
        return nArrayArray;
    }

    private int candidateNumber(int n, int n2, int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        if (this.preserveOE && EventState.hasNonDet(this.machines[n].states[n2])) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n6 = 0;
            int n7 = nArray[i];
            if (this.visible.get(n7)) {
                return 0;
            }
            if (this.high != null && !this.high.get(n7)) {
                return 0;
            }
            n6 = n7 == 0 ? 1 : this.actionSharedBy[n7].length;
            if (n6 == 1) {
                ++n4;
            }
            if (n6 > n3) {
                n3 = n6;
            }
            if (n3 > 2) {
                return 0;
            }
            if (n6 != 2) continue;
            if (n5 < 0) {
                n5 = this.getPartner(n, n7);
                continue;
            }
            if (n5 == this.getPartner(n, n7)) continue;
            return 0;
        }
        if (this.preserveOE && (n4 > 1 || n3 == 2 && n4 > 0)) {
            return 0;
        }
        if (n3 == 2) {
            this.partners[n][n2] = n5;
        }
        return n3;
    }

    private int getPartner(int n, int n2) {
        if (this.actionSharedBy[n2][0] == n) {
            return this.actionSharedBy[n2][1];
        }
        return this.actionSharedBy[n2][0];
    }
}

