/*
 * Decompiled with CFR 0.152.
 */
package lts;

public class StateCodec {
    int[] bitSize;
    int NBIT;
    int NBYTE;
    static int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE};
    int[] boundaries;

    public StateCodec(int[] nArray) {
        int n;
        this.bitSize = new int[nArray.length];
        this.NBIT = 0;
        int n2 = 1;
        for (n = nArray.length - 1; n >= 0; --n) {
            this.bitSize[n] = this.nbits(nArray[n] - 1);
            if (this.NBIT + this.bitSize[n] > n2 * 64) {
                this.NBIT = n2 * 64;
                ++n2;
            }
            this.NBIT += this.bitSize[n];
        }
        this.NBYTE = this.NBIT / 8;
        if (this.NBIT % 8 > 0) {
            ++this.NBYTE;
        }
        this.boundaries = new int[n2];
        n = 0;
        int n3 = 0;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (n + this.bitSize[i] <= 64) {
                n += this.bitSize[i];
                continue;
            }
            this.boundaries[n3] = i + 1;
            n = this.bitSize[i];
            ++n3;
        }
        this.boundaries[n3] = 0;
    }

    private void longToBytes(byte[] byArray, long l, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] | (byte)l);
            l >>>= 8;
        }
    }

    private long bytesToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n2 - 1; i >= n; --i) {
            l |= (long)byArray[i] & 0xFFL;
            if (i <= n) continue;
            l <<= 8;
        }
        return l;
    }

    public int bits() {
        int n = 0;
        for (int i = 0; i < this.bitSize.length; ++i) {
            n += this.bitSize[i];
        }
        return n;
    }

    public byte[] zero() {
        return new byte[this.NBYTE];
    }

    public byte[] encode(int[] nArray) {
        byte[] byArray = new byte[this.NBYTE];
        int n = this.bitSize.length - 1;
        int n2 = this.NBYTE;
        for (int i = 0; i < this.boundaries.length; ++i) {
            int n3;
            long l = 0L;
            for (n3 = n; n3 >= this.boundaries[i]; --n3) {
                if (nArray[n3] < 0) {
                    return null;
                }
                l |= (long)nArray[n3];
                if (n3 <= this.boundaries[i]) continue;
                l <<= this.bitSize[n3 - 1];
            }
            n3 = n2 - 8;
            if (n3 < 0) {
                n3 = 0;
            }
            this.longToBytes(byArray, l, n3, n2);
            n2 = n3;
            n = this.boundaries[i] - 1;
        }
        return byArray;
    }

    public int[] decode(byte[] byArray) {
        int[] nArray = new int[this.bitSize.length + 1];
        int n = this.bitSize.length;
        int n2 = this.NBYTE;
        for (int i = 0; i < this.boundaries.length; ++i) {
            int n3 = n2 - 8;
            if (n3 < 0) {
                n3 = 0;
            }
            long l = this.bytesToLong(byArray, n3, n2);
            for (int j = this.boundaries[i]; j < n; ++j) {
                nArray[j] = (int)l & masks[this.bitSize[j]];
                l >>>= this.bitSize[j];
            }
            n2 = n3;
            n = this.boundaries[i];
        }
        return nArray;
    }

    public static int hash(byte[] byArray) {
        int n;
        long l = 0L;
        for (n = 0; n < byArray.length; ++n) {
            l = l * 127L + (long)byArray[n];
        }
        n = (int)(l ^ l >>> 32);
        return n & Integer.MAX_VALUE;
    }

    public static long hashLong(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l = l * 255L + (long)byArray[i];
        }
        return l;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return true;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int nbits(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }
}

