/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.Hashtable;
import lts.ActionLabels;
import lts.CompactState;
import lts.Declaration;
import lts.Diagnostics;
import lts.Expression;
import lts.StateExpr;
import lts.StateMachine;
import lts.Symbol;
import lts.Transition;

class StateDefn
extends Declaration {
    Symbol name;
    boolean accept = false;
    ActionLabels range;
    StateExpr stateExpr;

    StateDefn() {
    }

    private void check_put(String string, StateMachine stateMachine) {
        if (stateMachine.explicit_states.containsKey(string)) {
            Diagnostics.fatal("duplicate definition -" + this.name, this.name);
        } else {
            stateMachine.explicit_states.put(string, stateMachine.stateLabel.label());
        }
    }

    public void explicitStates(StateMachine stateMachine) {
        if (this.range == null) {
            String string = this.name.toString();
            if (string.equals("STOP") || string.equals("ERROR") || string.equals("END")) {
                Diagnostics.fatal("reserved local process name -" + this.name, this.name);
            }
            this.check_put(string, stateMachine);
        } else {
            Hashtable hashtable = new Hashtable();
            this.range.initContext(hashtable, stateMachine.constants);
            while (this.range.hasMoreNames()) {
                this.check_put(this.name.toString() + "." + this.range.nextName(), stateMachine);
            }
            this.range.clearContext();
        }
    }

    private void crunchAlias(StateExpr stateExpr, String string, Hashtable hashtable, StateMachine stateMachine) {
        String string2 = stateExpr.evalName(hashtable, stateMachine);
        Integer n = (Integer)stateMachine.explicit_states.get(string2);
        if (n == null) {
            if (string2.equals("STOP")) {
                n = stateMachine.stateLabel.label();
                stateMachine.explicit_states.put("STOP", n);
            } else if (string2.equals("ERROR")) {
                n = new Integer(-1);
                stateMachine.explicit_states.put("ERROR", n);
            } else if (string2.equals("END")) {
                n = stateMachine.stateLabel.label();
                stateMachine.explicit_states.put("END", n);
            } else {
                n = new Integer(-1);
                stateMachine.explicit_states.put("ERROR", n);
                Diagnostics.warning(string2 + " defined to be ERROR", "definition not found- " + string2, stateExpr.name);
            }
        }
        CompactState compactState = null;
        if (stateExpr.processes != null) {
            compactState = stateExpr.makeInserts(hashtable, stateMachine);
        }
        if (compactState != null) {
            stateMachine.preAddSequential((Integer)stateMachine.explicit_states.get(string), n, compactState);
        } else {
            stateMachine.aliases.put(stateMachine.explicit_states.get(string), n);
        }
    }

    public void crunch(StateMachine stateMachine) {
        if (this.stateExpr.name == null && this.stateExpr.boolexpr == null) {
            return;
        }
        Hashtable hashtable = new Hashtable();
        if (this.range == null) {
            this.crunchit(stateMachine, hashtable, this.stateExpr, this.name.toString());
        } else {
            this.range.initContext(hashtable, stateMachine.constants);
            while (this.range.hasMoreNames()) {
                String string = "" + this.name + "." + this.range.nextName();
                this.crunchit(stateMachine, hashtable, this.stateExpr, string);
            }
            this.range.clearContext();
        }
    }

    private void crunchit(StateMachine stateMachine, Hashtable hashtable, StateExpr stateExpr, String string) {
        if (stateExpr.name != null) {
            this.crunchAlias(stateExpr, string, hashtable, stateMachine);
        } else if (stateExpr.boolexpr != null && (stateExpr = Expression.evaluate(stateExpr.boolexpr, hashtable, stateMachine.constants) != 0 ? stateExpr.thenpart : stateExpr.elsepart) != null) {
            this.crunchit(stateMachine, hashtable, stateExpr, string);
        }
    }

    public void transition(StateMachine stateMachine) {
        if (this.stateExpr.name != null) {
            return;
        }
        Hashtable hashtable = new Hashtable();
        if (this.range == null) {
            int n = (Integer)stateMachine.explicit_states.get("" + this.name);
            this.stateExpr.firstTransition(n, hashtable, stateMachine);
            if (this.accept) {
                if (!stateMachine.alphabet.containsKey("@")) {
                    stateMachine.alphabet.put("@", stateMachine.eventLabel.label());
                }
                Symbol symbol = new Symbol(124, "@");
                stateMachine.transitions.addElement(new Transition(n, symbol, n));
            }
        } else {
            this.range.initContext(hashtable, stateMachine.constants);
            while (this.range.hasMoreNames()) {
                int n = (Integer)stateMachine.explicit_states.get("" + this.name + "." + this.range.nextName());
                this.stateExpr.firstTransition(n, hashtable, stateMachine);
            }
            this.range.clearContext();
        }
    }

    public StateDefn myclone() {
        StateDefn stateDefn = new StateDefn();
        stateDefn.name = this.name;
        stateDefn.accept = this.accept;
        if (this.range != null) {
            stateDefn.range = this.range.myclone();
        }
        if (this.stateExpr != null) {
            stateDefn.stateExpr = this.stateExpr.myclone();
        }
        return stateDefn;
    }
}

