/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.CompactState;
import lts.Counter;
import lts.Diagnostics;
import lts.EventState;
import lts.LTSOutput;
import lts.Minimiser;
import lts.ProcessSpec;
import lts.Relation;
import lts.Transition;

class StateMachine {
    String name;
    String kludgeName;
    Hashtable alphabet = new Hashtable();
    Vector hidden;
    Relation relabels;
    Hashtable explicit_states = new Hashtable();
    Hashtable constants;
    Counter eventLabel = new Counter(0);
    Counter stateLabel = new Counter(0);
    Vector transitions = new Vector();
    boolean isProperty = false;
    boolean isMinimal = false;
    boolean isDeterministic = false;
    boolean exposeNotHide = false;
    Hashtable sequentialInserts;
    Hashtable preInsertsLast;
    Hashtable preInsertsMach;
    Hashtable aliases = new Hashtable();
    public static LTSOutput output;

    public StateMachine(ProcessSpec processSpec, Vector vector) {
        this.name = processSpec.getname();
        if (vector != null) {
            processSpec.doParams(vector);
            this.kludgeName = this.name + StateMachine.paramString(vector);
        } else {
            this.kludgeName = this.name;
        }
        this.make(processSpec);
    }

    public StateMachine(ProcessSpec processSpec) {
        this.kludgeName = this.name = processSpec.getname();
        this.make(processSpec);
    }

    private void make(ProcessSpec processSpec) {
        this.constants = processSpec.constants;
        this.alphabet.put("tau", this.eventLabel.label());
        processSpec.explicitStates(this);
        processSpec.crunch(this);
        this.renumber();
        processSpec.transition(this);
        processSpec.addAlphabet(this);
        processSpec.relabelAlphabet(this);
        processSpec.hideAlphabet(this);
        this.isProperty = processSpec.isProperty;
        this.isMinimal = processSpec.isMinimal;
        this.isDeterministic = processSpec.isDeterministic;
        this.exposeNotHide = processSpec.exposeNotHide;
    }

    public CompactState makeCompactState() {
        int n;
        Object object;
        CompactState compactState = new CompactState();
        compactState.name = this.kludgeName;
        compactState.maxStates = this.stateLabel.lastLabel();
        Integer n2 = (Integer)this.explicit_states.get("END");
        if (n2 != null) {
            compactState.endseq = n2;
        }
        compactState.alphabet = new String[this.alphabet.size()];
        Enumeration<Object> enumeration = this.alphabet.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            n = (Integer)this.alphabet.get(object);
            if (((String)object).equals("@")) {
                object = "@" + compactState.name;
            }
            compactState.alphabet[n] = object;
        }
        compactState.states = new EventState[compactState.maxStates];
        enumeration = this.transitions.elements();
        while (enumeration.hasMoreElements()) {
            object = (Transition)enumeration.nextElement();
            n = (Integer)this.alphabet.get("" + ((Transition)object).event);
            compactState.states[((Transition)object).from] = EventState.add(compactState.states[((Transition)object).from], new EventState(n, ((Transition)object).to));
        }
        if (this.sequentialInserts != null) {
            compactState.expandSequential(this.sequentialInserts);
        }
        if (this.relabels != null) {
            compactState.relabel(this.relabels);
        }
        if (this.hidden != null) {
            if (!this.exposeNotHide) {
                compactState.conceal(this.hidden);
            } else {
                compactState.expose(this.hidden);
            }
        }
        if (this.isProperty) {
            if (compactState.isNonDeterministic() || compactState.hasTau()) {
                Diagnostics.fatal("primitive property processes must be deterministic: " + this.name);
            }
            compactState.makeProperty();
        }
        this.check_for_ERROR(compactState);
        compactState.reachable();
        if (this.isMinimal) {
            object = new Minimiser(compactState, output);
            compactState = ((Minimiser)object).minimise();
        }
        if (this.isDeterministic) {
            object = new Minimiser(compactState, output);
            compactState = ((Minimiser)object).trace_minimise();
        }
        return compactState;
    }

    void check_for_ERROR(CompactState compactState) {
        Integer n = (Integer)this.explicit_states.get(this.name);
        if (n == -1) {
            compactState.states = new EventState[1];
            compactState.maxStates = 1;
            compactState.states[0] = EventState.add(compactState.states[0], new EventState(0, -1));
        }
    }

    void addSequential(Integer n, CompactState compactState) {
        if (this.sequentialInserts == null) {
            this.sequentialInserts = new Hashtable();
        }
        this.sequentialInserts.put(n, compactState);
    }

    void preAddSequential(Integer n, Integer n2, CompactState compactState) {
        if (this.preInsertsLast == null) {
            this.preInsertsLast = new Hashtable();
        }
        if (this.preInsertsMach == null) {
            this.preInsertsMach = new Hashtable();
        }
        this.preInsertsLast.put(n, n2);
        this.preInsertsMach.put(n, compactState);
    }

    private void insertSequential(int[] nArray) {
        if (this.preInsertsMach == null) {
            return;
        }
        Enumeration enumeration = this.preInsertsMach.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            CompactState compactState = (CompactState)this.preInsertsMach.get(n);
            Integer n2 = (Integer)this.preInsertsLast.get(n);
            Integer n3 = new Integer(nArray[n]);
            compactState.offsetSeq(n3, n2 >= 0 ? nArray[n2] : n2);
            this.addSequential(n3, compactState);
        }
    }

    private Integer number(Integer n, Counter counter) {
        if (this.preInsertsMach == null) {
            return counter.label();
        }
        CompactState compactState = (CompactState)this.preInsertsMach.get(n);
        if (compactState == null) {
            return counter.label();
        }
        return counter.interval(compactState.maxStates);
    }

    private void crunch(int n, int[] nArray) {
        int n2 = nArray[n];
        while (n2 >= 0 && n2 != nArray[n2]) {
            n2 = nArray[n2];
        }
        nArray[n] = n2;
    }

    private void renumber() {
        Integer n;
        Serializable serializable;
        int[] nArray = new int[this.stateLabel.lastLabel().intValue()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        Enumeration enumeration = this.aliases.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            serializable = (Integer)this.aliases.get(n2);
            nArray[n2.intValue()] = (Integer)serializable;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.crunch(i, nArray);
        }
        Counter counter = new Counter(0);
        serializable = new Hashtable();
        for (int i = 0; i < nArray.length; ++i) {
            Integer n3;
            n = new Integer(nArray[i]);
            if (!((Hashtable)serializable).containsKey(n)) {
                n3 = nArray[i] >= 0 ? this.number(n, counter) : new Integer(-1);
                ((Hashtable)serializable).put(n, n3);
                nArray[i] = n3;
                continue;
            }
            n3 = (Integer)((Hashtable)serializable).get(n);
            nArray[i] = n3;
        }
        this.insertSequential(nArray);
        enumeration = this.explicit_states.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n = (Integer)this.explicit_states.get(string);
            if (n < 0) continue;
            this.explicit_states.put(string, new Integer(nArray[n]));
        }
        this.stateLabel = counter;
    }

    public void print(LTSOutput lTSOutput) {
        Object object;
        lTSOutput.outln("PROCESS: " + this.name);
        lTSOutput.outln("ALPHABET:");
        Enumeration<Object> enumeration = this.alphabet.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            lTSOutput.outln("\t" + this.alphabet.get(object) + "\t" + (String)object);
        }
        lTSOutput.outln("EXPLICIT STATES:");
        enumeration = this.explicit_states.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            lTSOutput.outln("\t" + this.explicit_states.get(object) + "\t" + (String)object);
        }
        lTSOutput.outln("TRANSITIONS:");
        enumeration = this.transitions.elements();
        while (enumeration.hasMoreElements()) {
            object = (Transition)enumeration.nextElement();
            lTSOutput.outln("\t" + object);
        }
    }

    static String paramString(Vector vector) {
        int n = vector.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        stringBuffer.append("(");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if (i >= n) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

