/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import lts.Automata;
import lts.LTSOutput;
import lts.MyHash;
import lts.MyList;
import lts.MyStack;
import lts.StateCodec;

public class SuperTrace {
    BitSet table;
    MyStack stack;
    int nbits;
    Automata mach;
    LTSOutput output;
    LinkedList errorTrace;
    private static int DEPTHBOUND = 100000;
    private static int HASHSIZE = 8000;
    private static final int SUCCESS = 0;
    private static final int DEADLOCK = 1;
    private static final int ERROR = 2;
    int nstate = 0;
    int nTrans = 0;

    public static void setDepthBound(int n) {
        DEPTHBOUND = n;
    }

    public static int getDepthBound() {
        return DEPTHBOUND;
    }

    public static void setHashSize(int n) {
        HASHSIZE = n;
    }

    public static int getHashSize() {
        return HASHSIZE;
    }

    public SuperTrace(Automata automata, LTSOutput lTSOutput) {
        this.mach = automata;
        this.output = lTSOutput;
        this.nbits = HASHSIZE * 1024 * 8;
        this.table = new BitSet(this.nbits);
        this.stack = new MyStack();
        this.analyse();
    }

    public void analyse() {
        this.output.outln("Analysing using Supertrace (Depth bound " + DEPTHBOUND + " Hashtable size " + HASHSIZE + "K )...");
        System.gc();
        long l = System.currentTimeMillis();
        int n = this.search();
        long l2 = System.currentTimeMillis();
        this.outStatistics(this.stack.depth, this.nstate, this.nTrans);
        if (n == 1) {
            this.output.outln("Trace to DEADLOCK:");
            this.errorTrace = this.computeTrace(false);
            if (this.errorTrace.size() <= 100) {
                this.printPath(this.errorTrace);
            } else {
                this.output.outln("Trace length " + this.errorTrace.size() + ", replay using Check/Run");
            }
        } else if (n == 2) {
            this.output.outln("Trace to property violation in " + this.mach.getViolatedProperty() + ":");
            this.errorTrace = this.computeTrace(true);
            if (this.errorTrace.size() <= 100) {
                this.printPath(this.errorTrace);
            } else {
                this.output.outln("Trace length " + this.errorTrace.size() + ", replay using Check/Run");
            }
        } else {
            this.output.outln("No deadlocks/errors");
        }
        this.output.outln("Analysed using Supertrace in: " + (l2 - l) + "ms");
    }

    private int hashOne(byte[] byArray) {
        return StateCodec.hash(byArray);
    }

    private int hashTwo(byte[] byArray) {
        long l = StateCodec.hashLong(byArray);
        int n = (int)((l += 1325656567898L) ^ l >>> 32);
        return n & Integer.MAX_VALUE;
    }

    private void put(byte[] byArray) {
        this.table.set(this.hashOne(byArray) % this.nbits);
        this.table.set(this.hashTwo(byArray) % this.nbits);
    }

    private boolean contains(byte[] byArray) {
        return this.table.get(this.hashOne(byArray) % this.nbits) && this.table.get(this.hashTwo(byArray) % this.nbits);
    }

    private int search() {
        byte[] byArray = this.mach.START();
        MyHash myHash = null;
        if (this.mach.isPartialOrder()) {
            myHash = new MyHash(DEPTHBOUND + 1);
            this.mach.setStackChecker(myHash);
        }
        this.stack.push(byArray);
        this.put(byArray);
        while (!this.stack.empty()) {
            MyList myList;
            if (this.stack.marked()) {
                if (myHash != null) {
                    myHash.remove(this.stack.peek());
                }
                this.stack.pop();
                continue;
            }
            ++this.nstate;
            if (this.nstate % 10000 == 0) {
                this.outStatistics(this.stack.getDepth(), this.nstate, this.nTrans);
            }
            byte[] byArray2 = this.stack.peek();
            this.stack.mark();
            if (myHash != null) {
                myHash.put(byArray2);
            }
            if ((myList = this.mach.getTransitions(byArray2)).empty() && !this.mach.END(byArray2)) {
                return 1;
            }
            while (!myList.empty()) {
                ++this.nTrans;
                if (myList.getTo() == null) {
                    return 2;
                }
                if (this.stack.getDepth() < DEPTHBOUND && !this.contains(myList.getTo())) {
                    this.stack.push(myList.getTo());
                    this.put(myList.getTo());
                }
                myList.next();
            }
        }
        return 0;
    }

    public LinkedList getErrorTrace() {
        return this.errorTrace;
    }

    private void outStatistics(int n, int n2, int n3) {
        this.output.out("-- Depth: " + n + " States: " + n2 + " Transitions: " + n3);
        Runtime runtime = Runtime.getRuntime();
        this.output.outln(" Memory used: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000L + "K");
    }

    private void printPath(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.output.outln("\t" + (String)iterator.next());
        }
    }

    private LinkedList computeTrace(boolean bl) {
        this.mach.disablePartialOrder();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (bl) {
            while (!this.stack.marked()) {
                this.stack.pop();
            }
            linkedList.addFirst(this.findAction(this.stack.peek(), null));
        }
        byte[] byArray = this.stack.pop();
        while (!this.stack.empty()) {
            if (!this.stack.marked()) {
                this.stack.pop();
                continue;
            }
            linkedList.addFirst(this.findAction(this.stack.peek(), byArray));
            byArray = this.stack.pop();
        }
        return linkedList;
    }

    private String findAction(byte[] byArray, byte[] byArray2) {
        MyList myList = this.mach.getTransitions(byArray);
        while (!myList.empty()) {
            if (StateCodec.equals(myList.getTo(), byArray2)) {
                return this.mach.getAlphabet()[myList.getAction()];
            }
            myList.next();
        }
        return "ACTION NOT FOUND";
    }
}

