/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import gov.nasa.ltl.graph.Degeneralize;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.SCCReduction;
import gov.nasa.ltl.graph.SFSReduction;
import gov.nasa.ltl.graph.Simplify;
import gov.nasa.ltl.graph.SuperSetReduction;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lts.CompactState;
import lts.CompositeState;
import lts.Diagnostics;
import lts.LTSOutput;
import lts.LabelSet;
import lts.Minimiser;
import lts.Symbol;
import lts.ltl.Converter;
import lts.ltl.FluentTrace;
import lts.ltl.FormulaFactory;
import lts.ltl.FormulaSyntax;
import lts.ltl.GeneralizedBuchiAutomata;

public class AssertDefinition {
    Symbol name;
    FormulaFactory fac;
    FormulaSyntax ltl_formula;
    CompositeState cached;
    LabelSet alphaExtension;
    Hashtable init_params;
    Vector params;
    static Hashtable definitions;
    static Hashtable constraints;
    public static boolean addAsterisk;

    private AssertDefinition(Symbol symbol, FormulaSyntax formulaSyntax, LabelSet labelSet, Hashtable hashtable, Vector vector) {
        this.name = symbol;
        this.ltl_formula = formulaSyntax;
        this.cached = null;
        this.alphaExtension = labelSet;
        this.init_params = hashtable;
        this.params = vector;
    }

    public static void put(Symbol symbol, FormulaSyntax formulaSyntax, LabelSet labelSet, Hashtable hashtable, Vector vector, boolean bl) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (constraints == null) {
            constraints = new Hashtable();
        }
        if (!bl) {
            if (definitions.put(symbol.toString(), new AssertDefinition(symbol, formulaSyntax, labelSet, hashtable, vector)) != null) {
                Diagnostics.fatal("duplicate LTL property definition: " + symbol, symbol);
            }
        } else if (constraints.put(symbol.toString(), new AssertDefinition(symbol, formulaSyntax, labelSet, hashtable, vector)) != null) {
            Diagnostics.fatal("duplicate LTL constraint definition: " + symbol, symbol);
        }
    }

    public static void init() {
        definitions = null;
        constraints = null;
    }

    public static String[] names() {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        Enumeration enumeration = definitions.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public static void compileAll(LTSOutput lTSOutput) {
        AssertDefinition.compileAll(definitions, lTSOutput);
        AssertDefinition.compileAll(constraints, lTSOutput);
    }

    private static void compileAll(Hashtable hashtable, LTSOutput lTSOutput) {
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            AssertDefinition assertDefinition = (AssertDefinition)hashtable.get(string);
            assertDefinition.fac = new FormulaFactory();
            assertDefinition.fac.setFormula(assertDefinition.ltl_formula.expand(assertDefinition.fac, new Hashtable(), assertDefinition.init_params));
        }
    }

    public static CompositeState compile(LTSOutput lTSOutput, String string) {
        return AssertDefinition.compile(definitions, lTSOutput, string);
    }

    public static void compileConstraints(LTSOutput lTSOutput, Hashtable hashtable) {
        if (constraints == null) {
            return;
        }
        Enumeration enumeration = constraints.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            CompactState compactState = AssertDefinition.compileConstraint(lTSOutput, string);
            hashtable.put(compactState.name, compactState);
        }
    }

    public static CompactState compileConstraint(LTSOutput lTSOutput, Symbol symbol, String string, Vector vector) {
        Object object;
        if (constraints == null) {
            return null;
        }
        AssertDefinition assertDefinition = (AssertDefinition)constraints.get(symbol.toString());
        if (assertDefinition == null) {
            return null;
        }
        assertDefinition.cached = null;
        assertDefinition.fac = new FormulaFactory();
        if (vector != null) {
            if (vector.size() != assertDefinition.params.size()) {
                Diagnostics.fatal("Actual parameters do not match formals: " + symbol, symbol);
            }
            object = new Hashtable();
            for (int i = 0; i < vector.size(); ++i) {
                ((Hashtable)object).put(assertDefinition.params.elementAt(i), vector.elementAt(i));
            }
            assertDefinition.fac.setFormula(assertDefinition.ltl_formula.expand(assertDefinition.fac, new Hashtable(), (Hashtable)object));
        } else {
            assertDefinition.fac.setFormula(assertDefinition.ltl_formula.expand(assertDefinition.fac, new Hashtable(), assertDefinition.init_params));
        }
        object = AssertDefinition.compile(constraints, lTSOutput, symbol.toString());
        if (object == null) {
            return null;
        }
        if (!((CompositeState)object).isProperty) {
            Diagnostics.fatal("LTL constraint must be safety: " + assertDefinition.name, assertDefinition.name);
        }
        ((CompositeState)object).composition.unMakeProperty();
        ((CompositeState)object).composition.name = string;
        return ((CompositeState)object).composition;
    }

    public static CompactState compileConstraint(LTSOutput lTSOutput, String string) {
        CompositeState compositeState = AssertDefinition.compile(constraints, lTSOutput, string);
        if (compositeState == null) {
            return null;
        }
        if (!compositeState.isProperty) {
            AssertDefinition assertDefinition = (AssertDefinition)constraints.get(string);
            Diagnostics.fatal("LTL constraint must be safety: " + assertDefinition.name, assertDefinition.name);
        }
        compositeState.composition.unMakeProperty();
        return compositeState.composition;
    }

    private static CompositeState compile(Hashtable hashtable, LTSOutput lTSOutput, String string) {
        Vector<String> vector;
        if (hashtable == null || string == null) {
            return null;
        }
        AssertDefinition assertDefinition = (AssertDefinition)hashtable.get(string);
        if (assertDefinition == null) {
            return null;
        }
        if (assertDefinition.cached != null) {
            return assertDefinition.cached;
        }
        lTSOutput.outln("Formula !" + assertDefinition.name.toString() + " = " + assertDefinition.fac.getFormula());
        Vector<String> vector2 = vector = assertDefinition.alphaExtension != null ? assertDefinition.alphaExtension.getActions(null) : null;
        if (vector == null) {
            vector = new Vector<String>();
        }
        if (addAsterisk) {
            vector.add("*");
        }
        GeneralizedBuchiAutomata generalizedBuchiAutomata = new GeneralizedBuchiAutomata(assertDefinition.name.toString(), assertDefinition.fac, vector);
        generalizedBuchiAutomata.translate();
        Graph graph = generalizedBuchiAutomata.Gmake();
        lTSOutput.outln("GBA " + graph.getNodeCount() + " states " + graph.getEdgeCount() + " transitions");
        graph = SuperSetReduction.reduce(graph);
        Graph graph2 = Degeneralize.degeneralize(graph);
        graph2 = SCCReduction.reduce(graph2);
        graph2 = Simplify.simplify(graph2);
        graph2 = SFSReduction.reduce(graph2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Converter converter = new Converter(assertDefinition.name.toString(), graph2, generalizedBuchiAutomata.getLabelFactory());
        lTSOutput.outln("Buchi automata:");
        converter.printFSP(new PrintStream(byteArrayOutputStream));
        lTSOutput.out(byteArrayOutputStream.toString());
        Vector vector3 = generalizedBuchiAutomata.getLabelFactory().propProcs;
        vector3.add(converter);
        CompositeState compositeState = new CompositeState(converter.name, vector3);
        compositeState.hidden = generalizedBuchiAutomata.getLabelFactory().getPrefix();
        compositeState.setFluentTracer(new FluentTrace(generalizedBuchiAutomata.getLabelFactory().getFluents()));
        compositeState.compose(lTSOutput, true);
        compositeState.composition.removeNonDetTau();
        lTSOutput.outln("After Tau elimination = " + compositeState.composition.maxStates + " state");
        Minimiser minimiser = new Minimiser(compositeState.composition, lTSOutput);
        compositeState.composition = minimiser.minimise();
        if (compositeState.composition.isSafetyOnly()) {
            compositeState.composition.makeSafety();
            compositeState.determinise(lTSOutput);
            compositeState.isProperty = true;
        }
        compositeState.composition.removeDetCycles("*");
        assertDefinition.cached = compositeState;
        return compositeState;
    }

    static {
        addAsterisk = true;
    }
}

