/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import lts.CompactState;
import lts.Diagnostics;
import lts.EventState;
import lts.ltl.LabelFactory;

class Converter
extends CompactState {
    BitSet accepting;
    Graph g;
    int iacc = 0;

    Converter(String string, Graph graph, LabelFactory labelFactory) {
        this.name = string;
        this.g = graph;
        this.accepting = this.getAcceptance();
        this.alphabet = labelFactory.makeAlphabet();
        this.makeStates(labelFactory);
    }

    private void makeStates(LabelFactory labelFactory) {
        this.maxStates = this.g.getNodeCount() + this.iacc + 1;
        this.states = new EventState[this.maxStates];
        HashMap hashMap = labelFactory.getTransLabels();
        this.addTrueNode(this.maxStates - 1, hashMap);
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            this.addNode((Node)iterator.next(), hashMap);
        }
        if (this.iacc == 1) {
            this.states[0] = EventState.union(this.states[0], this.states[1]);
        }
        this.addAccepting();
        this.reachable();
    }

    private void addAccepting() {
        for (int i = 0; i < this.maxStates - 1; ++i) {
            if (!this.accepting.get(i)) continue;
            this.states[i + this.iacc] = EventState.add(this.states[i + this.iacc], new EventState(this.alphabet.length - 1, i + this.iacc));
        }
    }

    void addNode(Node node, HashMap hashMap) {
        int n = node.getId();
        BitSet bitSet = new BitSet(this.alphabet.length - 2);
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            this.addEdge((Edge)iterator.next(), n, hashMap, bitSet);
        }
        this.complete(n, bitSet);
    }

    void addTrueNode(int n, HashMap hashMap) {
        BitSet bitSet = (BitSet)hashMap.get("true");
        for (int i = 0; i < bitSet.size(); ++i) {
            if (!bitSet.get(i)) continue;
            this.states[n] = EventState.add(this.states[n], new EventState(i + 1, n));
        }
    }

    void complete(int n, BitSet bitSet) {
        for (int i = 0; i < this.alphabet.length - 2; ++i) {
            if (bitSet.get(i)) continue;
            this.states[n + this.iacc] = EventState.add(this.states[n + this.iacc], new EventState(i + 1, this.maxStates - 1));
        }
    }

    void addEdge(Edge edge, int n, HashMap hashMap, BitSet bitSet) {
        String string = edge.getGuard().equals("-") ? "true" : edge.getGuard();
        BitSet bitSet2 = (BitSet)hashMap.get(string);
        bitSet.or(bitSet2);
        for (int i = 0; i < bitSet2.size(); ++i) {
            if (!bitSet2.get(i)) continue;
            this.states[n + this.iacc] = EventState.add(this.states[n + this.iacc], new EventState(i + 1, edge.getNext().getId() + this.iacc));
        }
    }

    public void printFSP(PrintStream printStream) {
        boolean bl = false;
        if (this.g.getInit() != null) {
            printStream.print(this.name + " = S" + this.g.getInit().getId());
        } else {
            printStream.print("Empty");
            bl = true;
        }
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            printStream.println(",");
            Node node = (Node)iterator.next();
            this.printNode(node, printStream);
        }
        printStream.println(".");
        if (printStream != System.out) {
            printStream.close();
        }
    }

    protected BitSet getAcceptance() {
        BitSet bitSet = new BitSet();
        int n = this.g.getIntAttribute("nsets");
        if (n > 0) {
            Diagnostics.fatal("More than one acceptance set");
        }
        for (Node node : this.g.getNodes()) {
            if (!node.getBooleanAttribute("accepting")) continue;
            bitSet.set(node.getId());
        }
        return bitSet;
    }

    void printNode(Node node, PrintStream printStream) {
        String string = this.accepting.get(node.getId()) ? "@" : "";
        printStream.print("S" + node.getId() + string + " =(");
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            this.printEdge((Edge)iterator.next(), printStream);
            if (!iterator.hasNext()) continue;
            printStream.print(" |");
        }
        printStream.print(")");
    }

    void printEdge(Edge edge, PrintStream printStream) {
        String string = "";
        String string2 = edge.getGuard().equals("-") ? "true" : edge.getGuard();
        printStream.print(string2 + " -> S" + edge.getNext().getId());
    }
}

