/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import java.io.PrintStream;
import java.util.Iterator;

class ConverterGraph {
    Graph g;

    ConverterGraph(Graph graph) {
        this.g = graph;
    }

    public void printFSP(PrintStream printStream) {
        boolean bl = false;
        if (this.g.getInit() != null) {
            printStream.print("RES = S" + this.g.getInit().getId());
        } else {
            printStream.print("Empty");
            bl = true;
        }
        Iterator iterator = this.g.getNodes().iterator();
        while (iterator.hasNext()) {
            printStream.println(",");
            Node node = (Node)iterator.next();
            this.printNode(node, printStream);
        }
        printStream.println(".");
        int n = this.g.getIntAttribute("nsets");
        if (n == 0 && !bl) {
            boolean bl2 = true;
            printStream.print("AS = { ");
            Iterator iterator2 = this.g.getNodes().iterator();
            while (iterator2.hasNext()) {
                Node node = (Node)iterator2.next();
                if (!node.getBooleanAttribute("accepting")) continue;
                if (!bl2) {
                    printStream.print(", ");
                } else {
                    bl2 = false;
                }
                printStream.print("S" + node.getId());
            }
            printStream.println(" }");
        } else if (!bl) {
            int n2 = 0;
            while (n2 < n) {
                boolean bl3 = true;
                printStream.print("AS" + n2 + " = { ");
                Iterator iterator3 = this.g.getNodes().iterator();
                while (iterator3.hasNext()) {
                    Node node = (Node)iterator3.next();
                    if (!node.getBooleanAttribute("acc" + n2)) continue;
                    if (!bl3) {
                        printStream.print(", ");
                    } else {
                        bl3 = false;
                    }
                    printStream.print("S" + node.getId());
                }
                printStream.println(" }");
                ++n2;
            }
        }
        if (printStream != System.out) {
            printStream.close();
        }
    }

    void printNode(Node node, PrintStream printStream) {
        printStream.print("S" + node.getId() + "=(");
        Iterator iterator = node.getOutgoingEdges().iterator();
        while (iterator.hasNext()) {
            this.printEdge((Edge)iterator.next(), printStream);
            if (!iterator.hasNext()) continue;
            printStream.print(" |");
        }
        printStream.print(")");
    }

    void printEdge(Edge edge, PrintStream printStream) {
        String string = "";
        String string2 = edge.getGuard().equals("-") ? "TRUE" : edge.getGuard();
        int n = this.g.getIntAttribute("nsets");
        if (n == 0) {
            if (edge.getBooleanAttribute("accepting")) {
                string = "@";
            }
        } else {
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (edge.getBooleanAttribute("acc" + n2)) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(n2);
                }
                ++n2;
            }
            if (!bl) {
                string = "{" + stringBuffer.toString() + "}";
            }
        }
        printStream.print(string2 + string + "-> S" + edge.getNext().getId());
    }
}

