/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import java.util.List;
import lts.LTSOutput;
import lts.ltl.PredicateDefinition;

public class FluentTrace {
    PredicateDefinition[] fluents;
    int[] state;

    public FluentTrace(PredicateDefinition[] predicateDefinitionArray) {
        if (predicateDefinitionArray != null) {
            this.fluents = predicateDefinitionArray;
            this.state = new int[this.fluents.length];
        }
    }

    private void initialise() {
        if (this.state == null) {
            return;
        }
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = this.fluents[i].initial();
        }
    }

    private void update(String string) {
        if (this.state == null) {
            return;
        }
        for (int i = 0; i < this.state.length; ++i) {
            int n = this.fluents[i].query(string);
            if (n == 0) continue;
            this.state[i] = n;
        }
    }

    private String fluentString() {
        if (this.state == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\t");
        boolean bl = true;
        for (int i = 0; i < this.state.length; ++i) {
            if (this.state[i] <= 0) continue;
            if (!bl) {
                stringBuffer.append(" && ");
            }
            stringBuffer.append(this.fluents[i].toString());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void print(LTSOutput lTSOutput, List list, boolean bl) {
        if (list == null) {
            return;
        }
        if (bl) {
            this.initialise();
        }
        for (String string : list) {
            this.update(string);
            lTSOutput.outln("\t" + string + this.fluentString());
        }
    }
}

