/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import lts.ActionLabels;
import lts.Alphabet;
import lts.Diagnostics;
import lts.Expression;
import lts.Symbol;
import lts.ltl.And;
import lts.ltl.False;
import lts.ltl.Formula;
import lts.ltl.Next;
import lts.ltl.Not;
import lts.ltl.NotVisitor;
import lts.ltl.Or;
import lts.ltl.Proposition;
import lts.ltl.Release;
import lts.ltl.True;
import lts.ltl.Until;
import lts.ltl.UntilVisitor;

public class FormulaFactory {
    NotVisitor nv = new NotVisitor(this);
    int id = 1;
    Map subf = new HashMap();
    SortedSet props = new TreeSet();
    Formula formula;
    Hashtable actionPredicates = null;
    private boolean hasNext = false;
    public static boolean normalLTL = true;

    boolean nextInFormula() {
        return this.hasNext;
    }

    public void setFormula(Formula formula) {
        this.formula = this.makeNot(formula);
    }

    public Formula getFormula() {
        return this.formula;
    }

    public Formula make(Symbol symbol) {
        return this.unique(new Proposition(symbol));
    }

    public Formula make(Symbol symbol, ActionLabels actionLabels, Hashtable hashtable, Hashtable hashtable2) {
        actionLabels.initContext(hashtable, hashtable2);
        Formula formula = null;
        while (actionLabels.hasMoreNames()) {
            String string = actionLabels.nextName();
            Symbol symbol2 = new Symbol(symbol, symbol + "." + string);
            if (formula == null) {
                formula = this.make(symbol2);
                continue;
            }
            formula = this.makeOr(formula, this.make(symbol2));
        }
        actionLabels.clearContext();
        return formula;
    }

    public Formula make(Stack stack, Hashtable hashtable, Hashtable hashtable2) {
        if (Expression.evaluate(stack, hashtable, hashtable2) > 0) {
            return True.make();
        }
        return False.make();
    }

    public Formula make(ActionLabels actionLabels, Hashtable hashtable, Hashtable hashtable2) {
        Vector vector;
        String string;
        if (this.actionPredicates == null) {
            this.actionPredicates = new Hashtable();
        }
        if (!this.actionPredicates.containsKey(string = new Alphabet(vector = actionLabels.getActions(hashtable, hashtable2)).toString())) {
            this.actionPredicates.put(string, vector);
        }
        return this.unique(new Proposition(new Symbol(123, string)));
    }

    public Formula makeTick() {
        if (this.actionPredicates == null) {
            this.actionPredicates = new Hashtable();
        }
        Vector<String> vector = new Vector<String>(1);
        vector.add("tick");
        String string = new Alphabet(vector).toString();
        if (!this.actionPredicates.containsKey(string)) {
            this.actionPredicates.put(string, vector);
        }
        return this.unique(new Proposition(new Symbol(123, string)));
    }

    public SortedSet getProps() {
        return this.props;
    }

    public Formula make(Formula formula, Symbol symbol, Formula formula2) {
        switch (symbol.kind) {
            case 45: {
                return this.makeNot(formula2);
            }
            case 23: {
                if (normalLTL) {
                    return this.makeNext(formula2);
                }
                return this.makeNext(this.makeWeakUntil(this.makeNot(this.makeTick()), this.makeAnd(this.makeTick(), formula2)));
            }
            case 74: {
                if (normalLTL) {
                    return this.makeEventually(formula2);
                }
                return this.makeEventually(this.makeAnd(this.makeTick(), formula2));
            }
            case 75: {
                if (normalLTL) {
                    return this.makeAlways(formula2);
                }
                return this.makeAlways(this.makeImplies(this.makeTick(), formula2));
            }
            case 42: {
                return this.makeAnd(formula, formula2);
            }
            case 40: {
                return this.makeOr(formula, formula2);
            }
            case 69: {
                return this.makeImplies(formula, formula2);
            }
            case 20: {
                if (normalLTL) {
                    return this.makeUntil(formula, formula2);
                }
                return this.makeUntil(this.makeImplies(this.makeTick(), formula), this.makeAnd(this.makeTick(), formula2));
            }
            case 77: {
                if (normalLTL) {
                    return this.makeWeakUntil(formula, formula2);
                }
                return this.makeWeakUntil(this.makeImplies(this.makeTick(), formula), this.makeAnd(this.makeTick(), formula2));
            }
            case 76: {
                return this.makeEquivalent(formula, formula2);
            }
        }
        Diagnostics.fatal("Unexpected operator in LTL expression: " + symbol, symbol);
        return null;
    }

    Formula makeAnd(Formula formula, Formula formula2) {
        if (formula == formula2) {
            return formula;
        }
        if (formula == False.make() || formula2 == False.make()) {
            return False.make();
        }
        if (formula == True.make()) {
            return formula2;
        }
        if (formula2 == True.make()) {
            return formula;
        }
        if (formula == this.makeNot(formula2)) {
            return False.make();
        }
        if (formula instanceof Next && formula2 instanceof Next) {
            return this.makeNext(this.makeAnd(((Next)formula).getNext(), ((Next)formula2).getNext()));
        }
        if (formula.compareTo(formula2) < 0) {
            return this.unique(new And(formula, formula2));
        }
        return this.unique(new And(formula2, formula));
    }

    Formula makeOr(Formula formula, Formula formula2) {
        if (formula == formula2) {
            return formula;
        }
        if (formula == True.make() || formula2 == True.make()) {
            return True.make();
        }
        if (formula == False.make()) {
            return formula2;
        }
        if (formula2 == False.make()) {
            return formula;
        }
        if (formula == this.makeNot(formula2)) {
            return True.make();
        }
        if (formula.compareTo(formula2) < 0) {
            return this.unique(new Or(formula, formula2));
        }
        return this.unique(new Or(formula2, formula));
    }

    Formula makeUntil(Formula formula, Formula formula2) {
        if (formula2 == False.make()) {
            return False.make();
        }
        if (formula instanceof Next && formula2 instanceof Next) {
            return this.makeNext(this.makeUntil(((Next)formula).getNext(), ((Next)formula2).getNext()));
        }
        return this.unique(new Until(formula, formula2));
    }

    Formula makeWeakUntil(Formula formula, Formula formula2) {
        return this.makeRelease(formula2, this.makeOr(formula, formula2));
    }

    Formula makeRelease(Formula formula, Formula formula2) {
        return this.unique(new Release(formula, formula2));
    }

    Formula makeImplies(Formula formula, Formula formula2) {
        return this.makeOr(this.makeNot(formula), formula2);
    }

    Formula makeEquivalent(Formula formula, Formula formula2) {
        return this.makeAnd(this.makeImplies(formula, formula2), this.makeImplies(formula2, formula));
    }

    Formula makeEventually(Formula formula) {
        return this.makeUntil(True.make(), formula);
    }

    Formula makeAlways(Formula formula) {
        return this.makeRelease(False.make(), formula);
    }

    Formula makeNot(Formula formula) {
        return formula.accept(this.nv);
    }

    Formula makeNot(Proposition proposition) {
        return this.unique(new Not(proposition));
    }

    Formula makeNext(Formula formula) {
        this.hasNext = true;
        return this.unique(new Next(formula));
    }

    int processUntils(Formula formula, List list) {
        formula.accept(new UntilVisitor(this, list));
        return list.size();
    }

    boolean specialCaseV(Formula formula, Set set) {
        Formula formula2 = this.makeRelease(False.make(), formula);
        return set.contains(formula2);
    }

    boolean syntaxImplied(Formula formula, SortedSet sortedSet, SortedSet sortedSet2) {
        if (formula == null) {
            return true;
        }
        if (formula instanceof True) {
            return true;
        }
        if (sortedSet.contains(formula)) {
            return true;
        }
        if (formula.isLiteral()) {
            return false;
        }
        Formula formula2 = formula.getSub1();
        Formula formula3 = formula.getSub2();
        Formula formula4 = formula instanceof Until || formula instanceof Release ? formula : null;
        boolean bl = this.syntaxImplied(formula3, sortedSet, sortedSet2);
        boolean bl2 = this.syntaxImplied(formula2, sortedSet, sortedSet2);
        boolean bl3 = formula4 != null ? (sortedSet2 != null ? sortedSet2.contains(formula4) : false) : true;
        if (formula instanceof Until || formula instanceof Or) {
            return bl || bl2 && bl3;
        }
        if (formula instanceof Release) {
            return bl2 && bl || bl2 && bl3;
        }
        if (formula instanceof And) {
            return bl2 && bl;
        }
        if (formula instanceof Next) {
            if (formula2 != null) {
                if (sortedSet2 != null) {
                    return sortedSet2.contains(formula2);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private int newId() {
        return ++this.id;
    }

    private Formula unique(Formula formula) {
        String string = formula.toString();
        if (this.subf.containsKey(string)) {
            return (Formula)this.subf.get(string);
        }
        formula.setId(this.newId());
        this.subf.put(string, formula);
        if (formula instanceof Proposition) {
            this.props.add(formula);
        }
        return formula;
    }
}

