/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import lts.ActionLabels;
import lts.Diagnostics;
import lts.Expression;
import lts.Symbol;
import lts.Value;
import lts.ltl.AssertDefinition;
import lts.ltl.Formula;
import lts.ltl.FormulaFactory;
import lts.ltl.PredicateDefinition;

public class FormulaSyntax {
    FormulaSyntax left;
    FormulaSyntax right;
    Symbol operator;
    Symbol proposition;
    ActionLabels range;
    ActionLabels action;
    Vector parameters;

    private FormulaSyntax(FormulaSyntax formulaSyntax, Symbol symbol, FormulaSyntax formulaSyntax2, Symbol symbol2, ActionLabels actionLabels, ActionLabels actionLabels2, Vector vector) {
        this.left = formulaSyntax;
        this.right = formulaSyntax2;
        this.operator = symbol;
        this.proposition = symbol2;
        this.range = actionLabels;
        this.action = actionLabels2;
        this.parameters = vector;
    }

    public static FormulaSyntax make(FormulaSyntax formulaSyntax, Symbol symbol, FormulaSyntax formulaSyntax2) {
        return new FormulaSyntax(formulaSyntax, symbol, formulaSyntax2, null, null, null, null);
    }

    public static FormulaSyntax make(Symbol symbol) {
        return new FormulaSyntax(null, null, null, symbol, null, null, null);
    }

    public static FormulaSyntax make(Symbol symbol, ActionLabels actionLabels) {
        return new FormulaSyntax(null, null, null, symbol, actionLabels, null, null);
    }

    public static FormulaSyntax make(Symbol symbol, Vector vector) {
        return new FormulaSyntax(null, null, null, symbol, null, null, vector);
    }

    public static FormulaSyntax makeE(Symbol symbol, Stack stack) {
        return new FormulaSyntax(null, symbol, null, null, null, null, stack);
    }

    public static FormulaSyntax make(ActionLabels actionLabels) {
        return new FormulaSyntax(null, null, null, null, null, actionLabels, null);
    }

    public static FormulaSyntax make(Symbol symbol, ActionLabels actionLabels, FormulaSyntax formulaSyntax) {
        return new FormulaSyntax(null, symbol, formulaSyntax, null, actionLabels, null, null);
    }

    public Formula expand(FormulaFactory formulaFactory, Hashtable hashtable, Hashtable hashtable2) {
        if (this.proposition != null) {
            if (this.range == null) {
                if (PredicateDefinition.definitions != null && PredicateDefinition.definitions.containsKey(this.proposition.toString())) {
                    return formulaFactory.make(this.proposition);
                }
                AssertDefinition assertDefinition = (AssertDefinition)AssertDefinition.definitions.get(this.proposition.toString());
                if (assertDefinition == null) {
                    Diagnostics.fatal("LTL fluent or assertion not defined: " + this.proposition, this.proposition);
                }
                if (this.parameters == null) {
                    return assertDefinition.ltl_formula.expand(formulaFactory, hashtable, assertDefinition.init_params);
                }
                if (this.parameters.size() != assertDefinition.params.size()) {
                    Diagnostics.fatal("Actual parameters do not match formals: " + this.proposition, this.proposition);
                }
                Hashtable hashtable3 = new Hashtable();
                Vector vector = this.paramValues(this.parameters, hashtable, hashtable2);
                for (int i = 0; i < this.parameters.size(); ++i) {
                    hashtable3.put(assertDefinition.params.elementAt(i), vector.elementAt(i));
                }
                return assertDefinition.ltl_formula.expand(formulaFactory, hashtable, hashtable3);
            }
            return formulaFactory.make(this.proposition, this.range, hashtable, hashtable2);
        }
        if (this.action != null) {
            return formulaFactory.make(this.action, hashtable, hashtable2);
        }
        if (this.operator.kind == 25) {
            return formulaFactory.make((Stack)this.parameters, hashtable, hashtable2);
        }
        if (this.operator != null && this.range == null) {
            if (this.left == null) {
                return formulaFactory.make(null, this.operator, this.right.expand(formulaFactory, hashtable, hashtable2));
            }
            return formulaFactory.make(this.left.expand(formulaFactory, hashtable, hashtable2), this.operator, this.right.expand(formulaFactory, hashtable, hashtable2));
        }
        if (this.range != null && this.right != null) {
            this.range.initContext(hashtable, hashtable2);
            Formula formula = null;
            while (this.range.hasMoreNames()) {
                this.range.nextName();
                if (formula == null) {
                    formula = this.right.expand(formulaFactory, hashtable, hashtable2);
                    continue;
                }
                if (this.operator.kind == 42) {
                    formula = formulaFactory.makeAnd(formula, this.right.expand(formulaFactory, hashtable, hashtable2));
                    continue;
                }
                formula = formulaFactory.makeOr(formula, this.right.expand(formulaFactory, hashtable, hashtable2));
            }
            this.range.clearContext();
            return formula;
        }
        return null;
    }

    private Vector paramValues(Vector vector, Hashtable hashtable, Hashtable hashtable2) {
        if (vector == null) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        Vector<Value> vector2 = new Vector<Value>();
        while (enumeration.hasMoreElements()) {
            Stack stack = (Stack)enumeration.nextElement();
            vector2.addElement(Expression.getValue(stack, hashtable, hashtable2));
        }
        return vector2;
    }
}

