/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import gov.nasa.ltl.graph.Graph;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import lts.Diagnostics;
import lts.LTSOutput;
import lts.ltl.Formula;
import lts.ltl.FormulaFactory;
import lts.ltl.LabelFactory;
import lts.ltl.Node;
import lts.ltl.State;
import lts.ltl.Transition;

public class GeneralizedBuchiAutomata {
    List nodes;
    Formula formula;
    FormulaFactory fac;
    List untils;
    int maxId = -1;
    Node[] equivClasses;
    State[] states;
    int naccept;
    String name;
    LabelFactory labelFac;

    public GeneralizedBuchiAutomata(String string, FormulaFactory formulaFactory, Vector vector) {
        this.fac = formulaFactory;
        this.name = string;
        this.formula = formulaFactory.getFormula();
        this.nodes = new ArrayList();
        this.labelFac = new LabelFactory(this.name, this.fac, vector);
    }

    public void translate() {
        Node.setAut(this);
        Node.setFactory(this.fac);
        Transition.setLabelFactory(this.labelFac);
        this.untils = new ArrayList();
        this.naccept = this.fac.processUntils(this.formula, this.untils);
        Node node = new Node(this.formula);
        this.nodes = node.expand(this.nodes);
        this.states = this.makeStates();
    }

    public LabelFactory getLabelFactory() {
        return this.labelFac;
    }

    public void printNodes(LTSOutput lTSOutput) {
        for (int i = 0; i < this.states.length; ++i) {
            if (this.states[i] == null || i != this.states[i].getId()) continue;
            this.states[i].print(lTSOutput, this.naccept);
        }
    }

    public int indexEquivalence(Node node) {
        int n;
        for (n = 0; n < this.maxId && this.equivClasses[n] != null; ++n) {
            if (!this.equivClasses[n].next.equals(node.next)) continue;
            return this.equivClasses[n].id;
        }
        if (n == this.maxId) {
            Diagnostics.fatal("size of equivalence classes array was incorrect");
        }
        this.equivClasses[n] = node;
        return this.equivClasses[n].id;
    }

    public State[] makeStates() {
        State[] stateArray = new State[this.maxId];
        this.equivClasses = new Node[this.maxId];
        for (Node node : this.nodes) {
            node.equivId = this.indexEquivalence(node);
            node.makeTransitions(stateArray);
        }
        return stateArray;
    }

    int newId() {
        return ++this.maxId;
    }

    Graph Gmake() {
        int n;
        Graph graph = new Graph();
        graph.setStringAttribute("type", "gba");
        graph.setStringAttribute("ac", "edges");
        if (this.states == null) {
            return graph;
        }
        int n2 = this.maxId;
        gov.nasa.ltl.graph.Node[] nodeArray = new gov.nasa.ltl.graph.Node[n2];
        for (n = 0; n < n2; ++n) {
            if (this.states[n] == null || n != this.states[n].getId()) continue;
            nodeArray[n] = new gov.nasa.ltl.graph.Node(graph);
            nodeArray[n].setStringAttribute("label", "S" + this.states[n].getId());
        }
        for (n = 0; n < n2; ++n) {
            if (this.states[n] == null || n != this.states[n].getId()) continue;
            this.states[n].Gmake(nodeArray, nodeArray[n], this.naccept);
        }
        if (this.naccept == 0) {
            graph.setIntAttribute("nsets", 1);
        } else {
            graph.setIntAttribute("nsets", this.naccept);
        }
        return graph;
    }
}

