/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import lts.Diagnostics;
import lts.Lex;
import lts.Symbol;
import lts.ltl.Formula;
import lts.ltl.FormulaFactory;
import lts.ltl.PredicateDefinition;

public class LTLparser {
    private Lex lex;
    private FormulaFactory fac;
    private Symbol current;

    public LTLparser(Lex lex) {
        this.lex = lex;
        this.fac = new FormulaFactory();
    }

    public FormulaFactory parse() {
        this.current = this.modify(this.lex.current());
        if (this.current == null) {
            this.next_symbol();
        }
        this.fac.setFormula(this.ltl_unary());
        return this.fac;
    }

    private Symbol next_symbol() {
        this.current = this.modify(this.lex.next_symbol());
        return this.current;
    }

    private void push_symbol() {
        this.lex.push_symbol();
    }

    private void current_is(int n, String string) {
        if (this.current.kind != n) {
            Diagnostics.fatal(string, this.current);
        }
    }

    private Symbol modify(Symbol symbol) {
        if (symbol.kind != 123) {
            return symbol;
        }
        if (symbol.toString().equals("X")) {
            Symbol symbol2 = new Symbol(symbol);
            symbol2.kind = 23;
            return symbol2;
        }
        if (symbol.toString().equals("U")) {
            Symbol symbol3 = new Symbol(symbol);
            symbol3.kind = 20;
            return symbol3;
        }
        return symbol;
    }

    private Formula ltl_unary() {
        Symbol symbol = this.current;
        switch (this.current.kind) {
            case 23: 
            case 45: 
            case 74: 
            case 75: {
                this.next_symbol();
                return this.fac.make(null, symbol, this.ltl_unary());
            }
            case 123: {
                this.next_symbol();
                if (!PredicateDefinition.contains(symbol)) {
                    Diagnostics.fatal("proposition not defined " + symbol, symbol);
                }
                return this.fac.make(symbol);
            }
            case 53: {
                this.next_symbol();
                Formula formula = this.ltl_or();
                this.current_is(54, ") expected to end LTL expression");
                this.next_symbol();
                return formula;
            }
        }
        Diagnostics.fatal("syntax error in LTL expression", this.current);
        return null;
    }

    private Formula ltl_and() {
        Formula formula = this.ltl_unary();
        while (this.current.kind == 42) {
            Symbol symbol = this.current;
            this.next_symbol();
            Formula formula2 = this.ltl_unary();
            formula = this.fac.make(formula, symbol, formula2);
        }
        return formula;
    }

    private Formula ltl_or() {
        Formula formula = this.ltl_binary();
        while (this.current.kind == 40) {
            Symbol symbol = this.current;
            this.next_symbol();
            Formula formula2 = this.ltl_binary();
            formula = this.fac.make(formula, symbol, formula2);
        }
        return formula;
    }

    private Formula ltl_binary() {
        Formula formula = this.ltl_and();
        if (this.current.kind == 20 || this.current.kind == 69 || this.current.kind == 76) {
            Symbol symbol = this.current;
            this.next_symbol();
            Formula formula2 = this.ltl_and();
            formula = this.fac.make(formula, symbol, formula2);
        }
        return formula;
    }
}

