/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import lts.CompactState;
import lts.Diagnostics;
import lts.EventState;
import lts.Symbol;
import lts.ltl.Formula;
import lts.ltl.FormulaFactory;
import lts.ltl.PredicateDefinition;
import lts.ltl.Proposition;

public class LabelFactory {
    SortedSet allprops;
    FormulaFactory fac;
    Vector alphaX;
    String name;
    HashMap tr;
    BitSet[] ps;
    BitSet[] nps;
    Vector propProcs;
    SortedSet allActions;
    private List fluents = new ArrayList();

    public LabelFactory(String string, FormulaFactory formulaFactory, Vector vector) {
        this.allprops = formulaFactory.getProps();
        this.fac = formulaFactory;
        this.name = string;
        this.alphaX = vector;
        this.tr = new HashMap();
        this.initPropSets();
        this.compileProps();
    }

    HashMap getTransLabels() {
        return this.tr;
    }

    Vector getPrefix() {
        Vector<String> vector = new Vector<String>();
        Formula formula = (Formula)this.allprops.first();
        vector.add("_" + formula);
        return vector;
    }

    String makeLabel(SortedSet sortedSet) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.allprops.iterator();
        boolean bl = false;
        BitSet bitSet = new BitSet();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Formula)iterator.next();
            if (sortedSet.contains(object)) {
                if (bl) {
                    stringBuffer.append("&");
                    bitSet.and(this.ps[n]);
                } else {
                    bitSet.or(this.ps[n]);
                    bl = true;
                }
                stringBuffer.append(object);
            } else if (sortedSet.contains(this.fac.makeNot((Formula)object))) {
                if (bl) {
                    stringBuffer.append("&");
                    bitSet.and(this.nps[n]);
                } else {
                    bitSet.or(this.nps[n]);
                    bl = true;
                }
                stringBuffer.append("!" + object);
            }
            ++n;
        }
        object = stringBuffer.toString();
        this.tr.put(object, bitSet);
        return object;
    }

    public String[] makeAlphabet() {
        return this.makeAlphabet(null, null, null);
    }

    private String[] makeAlphabet(PredicateDefinition predicateDefinition, BitSet bitSet, BitSet bitSet2) {
        Iterator iterator;
        int n;
        int n2 = 0;
        n2 = predicateDefinition == null ? 1 : predicateDefinition.trueActions.size() + predicateDefinition.falseActions.size();
        int n3 = (1 << this.allprops.size()) + 1 + n2;
        String[] stringArray = new String[n3];
        for (n = 0; n < n3 - n2; ++n) {
            iterator = new StringBuffer();
            Iterator iterator2 = this.allprops.iterator();
            boolean bl = false;
            int n4 = 0;
            while (iterator2.hasNext()) {
                Formula formula = (Formula)iterator2.next();
                if (bl) {
                    ((StringBuffer)((Object)iterator)).append(".");
                }
                bl = true;
                ((StringBuffer)((Object)iterator)).append("_" + formula + "." + (n >> n4) % 2);
                ++n4;
            }
            stringArray[n + 1] = ((StringBuffer)((Object)iterator)).toString();
        }
        stringArray[0] = "tau";
        if (predicateDefinition == null) {
            stringArray[n3 - 1] = "@" + this.name;
        } else {
            n = n3 - n2;
            iterator = predicateDefinition.falseActions.iterator();
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                bitSet2.set(n);
                ++n;
            }
            iterator = predicateDefinition.trueActions.iterator();
            while (iterator.hasNext()) {
                stringArray[n] = (String)iterator.next();
                bitSet.set(n);
                ++n;
            }
        }
        return stringArray;
    }

    void initPropSets() {
        int n;
        int n2 = this.allprops.size();
        this.ps = new BitSet[n2];
        this.nps = new BitSet[n2];
        BitSet bitSet = new BitSet(1 << n2);
        for (n = 0; n < n2; ++n) {
            this.ps[n] = new BitSet(1 << n2);
            this.nps[n] = new BitSet(1 << n2);
        }
        for (n = 0; n < 1 << n2; ++n) {
            bitSet.set(n);
            for (int i = 0; i < n2; ++i) {
                if ((n >> i) % 2 == 1) {
                    this.ps[i].set(n);
                    continue;
                }
                this.nps[i].set(n);
            }
        }
        this.tr.put("true", bitSet);
    }

    public PredicateDefinition[] getFluents() {
        if (this.fluents.size() == 0) {
            return null;
        }
        PredicateDefinition[] predicateDefinitionArray = new PredicateDefinition[this.fluents.size()];
        for (int i = 0; i < predicateDefinitionArray.length; ++i) {
            predicateDefinitionArray[i] = (PredicateDefinition)this.fluents.get(i);
        }
        return predicateDefinitionArray;
    }

    protected void compileProps() {
        Vector vector;
        PredicateDefinition predicateDefinition;
        Proposition proposition;
        this.propProcs = new Vector();
        this.allActions = new TreeSet();
        Iterator iterator = this.allprops.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            proposition = (Proposition)iterator.next();
            predicateDefinition = PredicateDefinition.get(proposition.toString());
            if (predicateDefinition != null) {
                this.fluents.add(predicateDefinition);
                this.allActions.addAll(predicateDefinition.trueActions);
                this.allActions.addAll(predicateDefinition.falseActions);
                this.propProcs.add(this.makePropProcess(predicateDefinition, n));
            } else if (this.fac.actionPredicates != null && this.fac.actionPredicates.containsKey(proposition.toString())) {
                vector = (Vector)this.fac.actionPredicates.get(proposition.toString());
                this.allActions.addAll(vector);
            } else {
                Diagnostics.fatal("Proposition " + proposition + " not found", proposition.sym);
            }
            ++n;
        }
        if (this.alphaX != null) {
            this.allActions.addAll(this.alphaX);
        }
        iterator = this.allprops.iterator();
        n = 0;
        while (iterator.hasNext()) {
            proposition = (Proposition)iterator.next();
            predicateDefinition = PredicateDefinition.get(proposition.toString());
            if (predicateDefinition == null) {
                if (this.fac.actionPredicates != null && this.fac.actionPredicates.containsKey(proposition.toString())) {
                    vector = (Vector)this.fac.actionPredicates.get(proposition.toString());
                    Vector vector2 = new Vector();
                    vector2.addAll(this.allActions);
                    vector2.removeAll(vector);
                    predicateDefinition = new PredicateDefinition(new Symbol(123, proposition.toString()), vector, vector2);
                    CompactState compactState = this.makePropProcess(predicateDefinition, n);
                    this.propProcs.add(compactState);
                } else {
                    Diagnostics.fatal("Proposition " + proposition + " not found", proposition.sym);
                }
            }
            ++n;
        }
        this.propProcs.add(this.makeSyncProcess());
    }

    CompactState makePropProcess(PredicateDefinition predicateDefinition, int n) {
        int n2;
        CompactState compactState = new CompactState();
        compactState.name = predicateDefinition.name.toString();
        compactState.maxStates = 2;
        compactState.states = new EventState[compactState.maxStates];
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        compactState.alphabet = this.makeAlphabet(predicateDefinition, bitSet, bitSet2);
        int n3 = predicateDefinition.initial ? 1 : 0;
        int n4 = predicateDefinition.initial ? 0 : 1;
        for (n2 = 0; n2 < bitSet.size(); ++n2) {
            if (!bitSet.get(n2)) continue;
            compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(n2, n4));
        }
        for (n2 = 0; n2 < bitSet2.size(); ++n2) {
            if (!bitSet2.get(n2)) continue;
            compactState.states[n4] = EventState.add(compactState.states[n4], new EventState(n2, n3));
        }
        for (n2 = 0; n2 < bitSet2.size(); ++n2) {
            if (!bitSet2.get(n2)) continue;
            compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(n2, n3));
        }
        for (n2 = 0; n2 < bitSet.size(); ++n2) {
            if (!bitSet.get(n2)) continue;
            compactState.states[n4] = EventState.add(compactState.states[n4], new EventState(n2, n4));
        }
        for (n2 = 0; n2 < this.nps[n].size(); ++n2) {
            if (!this.nps[n].get(n2)) continue;
            compactState.states[n3] = EventState.add(compactState.states[n3], new EventState(n2 + 1, n3));
        }
        for (n2 = 0; n2 < this.ps[n].size(); ++n2) {
            if (!this.ps[n].get(n2)) continue;
            compactState.states[n4] = EventState.add(compactState.states[n4], new EventState(n2 + 1, n4));
        }
        return compactState;
    }

    CompactState makeSyncProcess() {
        int n;
        CompactState compactState = new CompactState();
        compactState.name = "SYNC";
        compactState.maxStates = 2;
        compactState.states = new EventState[compactState.maxStates];
        String[] stringArray = this.makeAlphabet();
        String[] stringArray2 = new String[this.allActions.size()];
        int n2 = 0;
        Iterator iterator = this.allActions.iterator();
        while (iterator.hasNext()) {
            stringArray2[n2++] = (String)iterator.next();
        }
        compactState.alphabet = new String[stringArray.length - 1 + stringArray2.length];
        compactState.alphabet[0] = "tau";
        for (n = 1; n < stringArray.length - 1; ++n) {
            compactState.alphabet[n] = stringArray[n];
            compactState.states[1] = EventState.add(compactState.states[1], new EventState(n, 0));
        }
        for (n = 0; n < stringArray2.length; ++n) {
            compactState.alphabet[n + stringArray.length - 1] = stringArray2[n];
            compactState.states[0] = EventState.add(compactState.states[0], new EventState(n + stringArray.length - 1, 1));
        }
        return compactState;
    }
}

