/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import lts.ltl.And;
import lts.ltl.False;
import lts.ltl.Formula;
import lts.ltl.FormulaFactory;
import lts.ltl.Next;
import lts.ltl.Not;
import lts.ltl.Or;
import lts.ltl.Proposition;
import lts.ltl.Release;
import lts.ltl.True;
import lts.ltl.Until;
import lts.ltl.Visitor;

class NotVisitor
implements Visitor {
    private FormulaFactory fac;

    NotVisitor(FormulaFactory formulaFactory) {
        this.fac = formulaFactory;
    }

    public Formula visit(True true_) {
        return False.make();
    }

    public Formula visit(False false_) {
        return True.make();
    }

    public Formula visit(Proposition proposition) {
        return this.fac.makeNot(proposition);
    }

    public Formula visit(Not not) {
        return not.getNext();
    }

    public Formula visit(Next next) {
        return this.fac.makeNext(this.fac.makeNot(next.getNext()));
    }

    public Formula visit(And and) {
        return this.fac.makeOr(this.fac.makeNot(and.getLeft()), this.fac.makeNot(and.getRight()));
    }

    public Formula visit(Or or) {
        return this.fac.makeAnd(this.fac.makeNot(or.getLeft()), this.fac.makeNot(or.getRight()));
    }

    public Formula visit(Until until) {
        return this.fac.makeRelease(this.fac.makeNot(until.getLeft()), this.fac.makeNot(until.getRight()));
    }

    public Formula visit(Release release) {
        return this.fac.makeUntil(this.fac.makeNot(release.getLeft()), this.fac.makeNot(release.getRight()));
    }
}

