/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import gov.nasa.ltl.graph.Node;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import lts.LTSOutput;
import lts.ltl.Transition;

class State
implements Comparable {
    private List transitions;
    private int stateId;

    State(List list, int n) {
        this.transitions = list;
        this.stateId = n;
    }

    State() {
        this(new LinkedList(), -1);
    }

    State(int n) {
        this(new LinkedList(), n);
    }

    void setId(int n) {
        this.stateId = n;
    }

    int getId() {
        return this.stateId;
    }

    public int compareTo(Object object) {
        return this != object ? 1 : 0;
    }

    public void add(Transition transition) {
        this.transitions.add(transition);
    }

    void print(LTSOutput lTSOutput, int n) {
        lTSOutput.outln("STATE " + this.stateId);
        Iterator iterator = this.transitions.iterator();
        while (iterator.hasNext()) {
            ((Transition)iterator.next()).print(lTSOutput, n);
        }
    }

    void Gmake(Node[] nodeArray, Node node, int n) {
        ListIterator listIterator = this.transitions.listIterator(0);
        boolean bl = true;
        while (listIterator.hasNext()) {
            Transition transition = (Transition)listIterator.next();
            transition.Gmake(nodeArray, node, n);
        }
    }
}

