/*
 * Decompiled with CFR 0.152.
 */
package lts.ltl;

import gov.nasa.ltl.graph.Edge;
import java.util.BitSet;
import java.util.SortedSet;
import lts.LTSOutput;
import lts.ltl.LabelFactory;
import lts.ltl.Node;

class Transition {
    SortedSet propositions;
    int pointsTo;
    BitSet accepting;
    boolean safe_acc;
    static LabelFactory lf;

    static void setLabelFactory(LabelFactory labelFactory) {
        lf = labelFactory;
    }

    Transition(SortedSet sortedSet, int n, BitSet bitSet, boolean bl) {
        this.propositions = sortedSet;
        this.pointsTo = n;
        this.accepting = new BitSet();
        this.accepting.or(bitSet);
        this.safe_acc = bl;
    }

    int goesTo() {
        return this.pointsTo;
    }

    BitSet computeAccepting(int n) {
        BitSet bitSet = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            if (this.accepting.get(i)) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    void print(LTSOutput lTSOutput, int n) {
        if (this.propositions.isEmpty()) {
            lTSOutput.out("LABEL True");
        } else {
            Node.printFormulaSet(lTSOutput, "LABEL", this.propositions);
        }
        lTSOutput.out(" T0 " + this.goesTo());
        if (n > 0) {
            lTSOutput.outln(" Acc " + this.computeAccepting(n));
        } else if (this.safe_acc) {
            lTSOutput.outln(" Acc {0}");
        } else {
            lTSOutput.outln("");
        }
    }

    void Gmake(gov.nasa.ltl.graph.Node[] nodeArray, gov.nasa.ltl.graph.Node node, int n) {
        String string = "-";
        String string2 = "-";
        if (!this.propositions.isEmpty()) {
            string = lf.makeLabel(this.propositions);
        }
        Edge edge = new Edge(node, nodeArray[this.pointsTo], string, string2);
        if (n == 0) {
            edge.setBooleanAttribute("acc0", true);
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.accepting.get(i)) continue;
                edge.setBooleanAttribute("acc" + i, true);
            }
        }
    }
}

