/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Attributes {
    private Hashtable ht = new Hashtable();

    public Attributes() {
    }

    public Attributes(Attributes a) {
        Enumeration e = a.ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.ht.put(key, a.ht.get(key));
        }
    }

    public Attributes(String s) {
        if (s.equals("-")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String value;
            String key;
            String e = st.nextToken();
            int idx = e.indexOf("=");
            if (idx == -1) {
                key = e;
                value = "";
            } else {
                key = e.substring(0, idx);
                value = e.substring(idx + 1);
            }
            this.ht.put(key, value);
        }
    }

    public void setBoolean(String name, boolean value) {
        if (value) {
            this.ht.put(name, "");
        } else {
            this.ht.remove(name);
        }
    }

    public boolean getBoolean(String name) {
        return this.ht.get(name) != null;
    }

    public void setInt(String name, int value) {
        this.ht.put(name, Integer.toString(value));
    }

    public int getInt(String name) {
        Object o = this.ht.get(name);
        if (o == null) {
            return 0;
        }
        try {
            return Integer.parseInt((String)o);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setString(String name, String value) {
        this.ht.put(name, value);
    }

    public String getString(String name) {
        return (String)this.ht.get(name);
    }

    public synchronized void save(PrintStream out, int format) {
        switch (format) {
            case 2: {
                this.save_xml(out);
            }
        }
    }

    public String toString() {
        if (this.ht.size() == 0) {
            return "-";
        }
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)this.ht.get(key);
            sb.append(key);
            if (!value.equals("")) {
                sb.append('=');
                sb.append((Object)value);
            }
            if (!e.hasMoreElements()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void unset(String name) {
        this.ht.remove(name);
    }

    private synchronized void save_xml(PrintStream out) {
        if (this.ht.size() == 0) {
            return;
        }
        Enumeration e = this.ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.ht.get(key);
            if (value == "") {
                out.println("<" + key + "/>");
                continue;
            }
            out.println("<" + key + ">" + value + "</" + key + ">");
        }
    }
}

