/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.ITypeNeighbor;
import gov.nasa.ltl.graph.Pair;
import java.util.Iterator;
import java.util.TreeSet;

public class ColorPair
extends Pair
implements Comparable {
    public ColorPair(int colorIn, TreeSet iMaxSetIn) {
        super(colorIn, iMaxSetIn);
    }

    public void setColor(int colorIn) {
        super.setValue(colorIn);
    }

    public int getColor() {
        return super.getValue();
    }

    public void setIMaxSet(TreeSet iMaxSetIn) {
        super.setElement(iMaxSetIn);
    }

    public TreeSet getIMaxSet() {
        return (TreeSet)super.getElement();
    }

    public int compareTo(Object o) {
        ColorPair other = (ColorPair)o;
        TreeSet otherSet = other.getIMaxSet();
        if (this.getIMaxSet().size() < otherSet.size()) {
            return -1;
        }
        if (this.getIMaxSet().size() > otherSet.size()) {
            return 1;
        }
        int index = 0;
        Iterator i = this.getIMaxSet().iterator();
        while (i.hasNext()) {
            Object[] otherArray;
            ITypeNeighbor currNeigh = (ITypeNeighbor)i.next();
            int comparison = currNeigh.compareTo((ITypeNeighbor)(otherArray = otherSet.toArray())[index]);
            if (comparison < 0 || comparison > 0) {
                return comparison;
            }
            ++index;
        }
        if (this.getColor() < other.getColor()) {
            return -1;
        }
        if (this.getColor() > other.getColor()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        ColorPair other = (ColorPair)o;
        TreeSet otherSet = other.getIMaxSet();
        if (this.getIMaxSet().size() < otherSet.size()) {
            return false;
        }
        if (this.getIMaxSet().size() > otherSet.size()) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        int index = 0;
        Iterator i = this.getIMaxSet().iterator();
        while (i.hasNext()) {
            Object[] otherArray;
            ITypeNeighbor currNeigh = (ITypeNeighbor)i.next();
            int comparison = currNeigh.compareTo((ITypeNeighbor)(otherArray = otherSet.toArray())[index]);
            if (comparison < 0 || comparison > 0) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

