/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Node;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class Edge {
    private Node source;
    private Node next;
    private String guard;
    private String action;
    private Attributes attributes;

    public Edge(Node s, Node n, String g, String a, Attributes as) {
        this.init(s, n, g, a, as);
    }

    public Edge(Node s, Node n, String g, String a) {
        this.init(s, n, g, a, null);
    }

    public Edge(Node s, Node n, String g) {
        this.init(s, n, g, "-", null);
    }

    public Edge(Node s, Node n) {
        this.init(s, n, "-", "-", null);
    }

    public Edge(Node s, Edge e) {
        this.init(s, e.next, new String(e.guard), new String(e.action), new Attributes(e.attributes));
    }

    public Edge(Edge e, Node n) {
        this.init(e.source, n, new String(e.guard), new String(e.action), new Attributes(e.attributes));
    }

    public Edge(Edge e) {
        this.init(e.source, e.next, new String(e.guard), new String(e.action), new Attributes(e.attributes));
    }

    public String getAction() {
        return this.action;
    }

    public synchronized void setAttributes(Attributes a) {
        this.attributes = new Attributes(a);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.attributes.setBoolean(name, value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.attributes.getBoolean(name);
    }

    public String getGuard() {
        return this.guard;
    }

    public void setIntAttribute(String name, int value) {
        this.attributes.setInt(name, value);
    }

    public int getIntAttribute(String name) {
        return this.attributes.getInt(name);
    }

    public Node getNext() {
        return this.next;
    }

    public Node getSource() {
        return this.source;
    }

    public void setStringAttribute(String name, String value) {
        this.attributes.setString(name, value);
    }

    public String getStringAttribute(String name) {
        return this.attributes.getString(name);
    }

    public synchronized void remove() {
        this.source.removeOutgoingEdge(this);
        this.next.removeIncomingEdge(this);
    }

    void save(PrintStream out, int format) {
        switch (format) {
            case 0: {
                this.save_sm(out);
                break;
            }
            case 1: {
                this.save_fsp(out);
                break;
            }
            case 2: {
                this.save_xml(out);
                break;
            }
            case 3: {
                this.save_spin(out);
                break;
            }
            default: {
                throw new RuntimeException("Unknown format!");
            }
        }
    }

    private void init(Node s, Node n, String g, String a, Attributes as) {
        this.source = s;
        this.next = n;
        this.guard = g;
        this.action = a;
        this.attributes = as == null ? new Attributes() : as;
        s.addOutgoingEdge(this);
        n.addIncomingEdge(this);
    }

    private void save_fsp(PrintStream out) {
        String accs = "";
        String g = this.guard.equals("-") ? "TRUE" : this.guard;
        int nsets = this.source.getGraph().getIntAttribute("nsets");
        if (nsets == 0) {
            if (this.getBooleanAttribute("accepting")) {
                accs = "@";
            }
        } else {
            boolean first = true;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < nsets) {
                if (this.getBooleanAttribute("acc" + i)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(i);
                }
                ++i;
            }
            if (!first) {
                accs = "{" + sb.toString() + "}";
            }
        }
        out.print(g + accs + "-> S" + this.next.getId());
    }

    private void save_sm(PrintStream out) {
        out.print("    ");
        out.println(this.next.getId());
        out.print("    ");
        out.println(this.guard);
        out.print("    ");
        out.println(this.action);
        out.print("    ");
        out.println(this.attributes);
    }

    private void save_spin(PrintStream out) {
        String ln = System.getProperty("line.separator");
        String g = this.guard.equals("-") ? "1" : this.guard;
        String accs = "";
        StringTokenizer tok = new StringTokenizer(new String(g), "&");
        g = "";
        while (tok.hasMoreTokens()) {
            g = g + tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            g = g + " && ";
        }
        tok = new StringTokenizer(new String(g), "|");
        g = "";
        while (tok.hasMoreTokens()) {
            g = g + tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            g = g + " || ";
        }
        int nsets = this.source.getGraph().getIntAttribute("nsets");
        if (nsets == 0) {
            if (this.getBooleanAttribute("accepting")) {
                accs = "@";
            }
        } else {
            boolean first = true;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < nsets) {
                if (this.getBooleanAttribute("acc" + i)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(i);
                }
                ++i;
            }
            if (!first) {
                accs = "{" + sb.toString() + "}";
            }
        }
        out.print("(" + g + ") " + accs + "-> goto ");
        if (this.next.getBooleanAttribute("accepting")) {
            out.print("accept_");
        }
        out.print("S" + this.next.getId());
    }

    private void save_xml(PrintStream out) {
        out.println("<transition to=\"" + this.next.getId() + "\">");
        if (!this.guard.equals("-")) {
            out.println("<guard>" + this.xml_quote(this.guard) + "</guard>");
        }
        if (!this.action.equals("-")) {
            out.println("<action>" + this.xml_quote(this.action) + "</action>");
        }
        this.attributes.save(out, 2);
        out.println("</transition>");
    }

    private String xml_quote(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

