/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;

public class Generate {
    public static Graph generate(int nsets) {
        Node n;
        int nnodes = nsets + 1;
        Node[] nodes = new Node[nnodes];
        Graph g = new Graph();
        g.setIntAttribute("nsets", nsets);
        g.setStringAttribute("type", "ba");
        g.setStringAttribute("ac", "nodes");
        int i = 0;
        while (i < nnodes) {
            nodes[i] = new Node(g);
            StringBuffer label = new StringBuffer();
            int k = 0;
            while (k < i) {
                label.append("acc" + k + "+");
                ++k;
            }
            nodes[i].setStringAttribute("label", label.toString());
            ++i;
        }
        int i2 = 0;
        while (i2 < nsets) {
            Edge e;
            n = nodes[i2];
            int j = nsets;
            while (j > i2) {
                e = new Edge(nodes[i2], nodes[j], "-", "-", null);
                int k = i2;
                while (k < j) {
                    e.setBooleanAttribute("acc" + k, true);
                    ++k;
                }
                --j;
            }
            e = new Edge(nodes[i2], nodes[i2], "-", "-", null);
            e.setBooleanAttribute("else", true);
            ++i2;
        }
        n = nodes[nnodes - 1];
        n.setBooleanAttribute("accepting", true);
        Edge e = new Edge(n, n, "-", "-", null);
        int k = 0;
        while (k < nsets) {
            e.setBooleanAttribute("acc" + k, true);
            ++k;
        }
        int i3 = nsets - 1;
        while (i3 >= 0) {
            e = new Edge(n, nodes[i3], "-", "-", null);
            if (i3 == 0) {
                e.setBooleanAttribute("else", true);
            } else {
                int k2 = 0;
                while (k2 < i3) {
                    e.setBooleanAttribute("acc" + k2, true);
                    ++k2;
                }
            }
            --i3;
        }
        g.setInit(n);
        return g;
    }

    public static void main(String[] args) {
        Graph g = Generate.generate(5);
        g.save(1);
    }
}

