/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.Visitor;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Graph {
    public static final int SM_FORMAT = 0;
    public static final int FSP_FORMAT = 1;
    public static final int XML_FORMAT = 2;
    public static final int SPIN_FORMAT = 3;
    private List nodes;
    private Node init;
    private Attributes attributes;

    public Graph(Attributes a) {
        this.init(a);
    }

    public Graph() {
        this.init(null);
    }

    public synchronized void setAttributes(Attributes a) {
        this.attributes = new Attributes(a);
    }

    public synchronized void setBooleanAttribute(String name, boolean value) {
        this.attributes.setBoolean(name, value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.attributes.getBoolean(name);
    }

    public int getEdgeCount() {
        int count = 0;
        Iterator i = new LinkedList(this.nodes).iterator();
        while (i.hasNext()) {
            count += ((Node)i.next()).getOutgoingEdgeCount();
        }
        return count;
    }

    public synchronized void setInit(Node n) {
        if (this.nodes.contains(n)) {
            this.init = n;
            this.number();
        }
    }

    public Node getInit() {
        return this.init;
    }

    public synchronized void setIntAttribute(String name, int value) {
        this.attributes.setInt(name, value);
    }

    public int getIntAttribute(String name) {
        return this.attributes.getInt(name);
    }

    public Node getNode(int id) {
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n.getId() != id) continue;
            return n;
        }
        return null;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public List getNodes() {
        return new LinkedList(this.nodes);
    }

    public synchronized void setStringAttribute(String name, String value) {
        this.attributes.setString(name, value);
    }

    public String getStringAttribute(String name) {
        return this.attributes.getString(name);
    }

    public static Graph load() throws IOException {
        return Graph.load(new BufferedReader(new InputStreamReader(System.in)));
    }

    public static Graph load(String fname) throws IOException {
        return Graph.load(new BufferedReader(new FileReader(fname)));
    }

    public synchronized void dfs(Visitor v) {
        if (this.init == null) {
            return;
        }
        this.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node n) {
                n.setBooleanAttribute("_reached", false);
            }
        });
        this.dfs(this.init, v);
        this.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node n) {
                n.setBooleanAttribute("_reached", false);
            }
        });
    }

    public synchronized void forAll(Visitor v) {
        Iterator i = new LinkedList(this.nodes).iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            v.visitNode(n);
            n.forAllEdges(v);
        }
    }

    public synchronized void forAllEdges(Visitor v) {
        Iterator i = new LinkedList(this.nodes).iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            n.forAllEdges(v);
        }
    }

    public synchronized void forAllNodes(Visitor v) {
        Iterator i = new LinkedList(this.nodes).iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            v.visitNode(n);
        }
    }

    public synchronized void save(int format) {
        this.save(System.out, format);
    }

    public synchronized void save() {
        this.save(System.out, 0);
    }

    public synchronized void save(String fname, int format) throws IOException {
        this.save(new PrintStream(new FileOutputStream(fname)), format);
    }

    public synchronized void save(String fname) throws IOException {
        this.save(new PrintStream(new FileOutputStream(fname)), 0);
    }

    synchronized void addNode(Node n) {
        this.nodes.add(n);
        if (this.init == null) {
            this.init = n;
        }
        this.number();
    }

    synchronized void removeNode(Node n) {
        this.nodes.remove(n);
        if (this.init == n) {
            this.init = this.nodes.size() != 0 ? (Node)this.nodes.get(0) : null;
        }
        this.number();
    }

    private void init(Attributes a) {
        this.attributes = a == null ? new Attributes() : a;
        this.nodes = new LinkedList();
        this.init = null;
    }

    private static Graph load(BufferedReader in) throws IOException {
        int ns = Graph.readInt(in);
        Node[] nodes = new Node[ns];
        Graph g = new Graph(Graph.readAttributes(in));
        int i = 0;
        while (i < ns) {
            int nt = Graph.readInt(in);
            if (nodes[i] == null) {
                nodes[i] = new Node(g, Graph.readAttributes(in));
            } else {
                nodes[i].setAttributes(Graph.readAttributes(in));
            }
            int j = 0;
            while (j < nt) {
                int nxt = Graph.readInt(in);
                String gu = Graph.readString(in);
                String ac = Graph.readString(in);
                if (nodes[nxt] == null) {
                    nodes[nxt] = new Node(g);
                }
                new Edge(nodes[i], nodes[nxt], gu, ac, Graph.readAttributes(in));
                ++j;
            }
            ++i;
        }
        g.number();
        return g;
    }

    private synchronized void number() {
        int cnt;
        if (this.init != null) {
            this.init.setId(0);
            cnt = 1;
        } else {
            cnt = 0;
        }
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n == this.init) continue;
            n.setId(cnt++);
        }
    }

    private static Attributes readAttributes(BufferedReader in) throws IOException {
        return new Attributes(Graph.readLine(in));
    }

    private static int readInt(BufferedReader in) throws IOException {
        return Integer.parseInt(Graph.readLine(in));
    }

    private static String readLine(BufferedReader in) throws IOException {
        String line;
        do {
            int idx;
            if ((idx = (line = in.readLine()).indexOf(35)) == -1) continue;
            line = line.substring(0, idx);
        } while ((line = line.trim()).length() == 0);
        return line;
    }

    private static String readString(BufferedReader in) throws IOException {
        return Graph.readLine(in);
    }

    private synchronized void dfs(Node n, Visitor v) {
        final Visitor visitor = v;
        if (n.getBooleanAttribute("_reached")) {
            return;
        }
        n.setBooleanAttribute("_reached", true);
        v.visitNode(n);
        n.forAllEdges(new EmptyVisitor(){

            public void visitEdge(Edge e) {
                Graph.this.dfs(e.getNext(), visitor);
            }
        });
    }

    private synchronized void save(PrintStream out, int format) {
        switch (format) {
            case 0: {
                this.save_sm(out);
                break;
            }
            case 1: {
                this.save_fsp(out);
                break;
            }
            case 2: {
                this.save_xml(out);
                break;
            }
            case 3: {
                this.save_spin(out);
                break;
            }
            default: {
                throw new RuntimeException("Unknown format!");
            }
        }
    }

    private synchronized void save_fsp(PrintStream out) {
        boolean empty = false;
        if (this.init != null) {
            out.print("RES = S" + this.init.getId());
        } else {
            out.print("Empty");
            empty = true;
        }
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            out.println(",");
            Node n = (Node)i.next();
            n.save(out, 1);
        }
        out.println(".");
        int nsets = this.getIntAttribute("nsets");
        if (nsets == 0 && !empty) {
            boolean first = true;
            out.print("AS = { ");
            Iterator i2 = this.nodes.iterator();
            while (i2.hasNext()) {
                Node n = (Node)i2.next();
                if (!n.getBooleanAttribute("accepting")) continue;
                if (!first) {
                    out.print(", ");
                } else {
                    first = false;
                }
                out.print("S" + n.getId());
            }
            out.println(" }");
        } else if (!empty) {
            int k = 0;
            while (k < nsets) {
                boolean first = true;
                out.print("AS" + k + " = { ");
                Iterator i3 = this.nodes.iterator();
                while (i3.hasNext()) {
                    Node n = (Node)i3.next();
                    if (!n.getBooleanAttribute("acc" + k)) continue;
                    if (!first) {
                        out.print(", ");
                    } else {
                        first = false;
                    }
                    out.print("S" + n.getId());
                }
                out.println(" }");
                ++k;
            }
        }
        if (out != System.out) {
            out.close();
        }
    }

    private synchronized void save_sm(PrintStream out) {
        out.println(this.nodes.size());
        out.println(this.attributes);
        if (this.init != null) {
            this.init.save(out, 0);
        }
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n == this.init) continue;
            n.save(out, 0);
        }
    }

    private synchronized void save_spin(PrintStream out) {
        String ln = System.getProperty("line.separator");
        out.println("never {");
        this.init.save(out, 3);
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (this.init == n) continue;
            n.save(out, 3);
            out.println();
        }
        out.println("}");
    }

    private synchronized void save_xml(PrintStream out) {
        out.println("<?xml version=\"1.0\"?>");
        out.println("<graph nodes=\"" + this.nodes.size() + "\">");
        this.attributes.save(out, 2);
        Iterator i = this.nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n != this.init) {
                n.save(out, 2);
                continue;
            }
            n.setBooleanAttribute("init", true);
            n.save(out, 2);
            n.setBooleanAttribute("init", false);
        }
        out.println("</graph>");
    }
}

