/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Attributes;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Visitor;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Node {
    private Graph graph;
    private List outgoingEdges;
    private List incomingEdges;
    private Attributes attributes;

    public Node(Graph g, Attributes a) {
        this.init(g, a);
    }

    public Node(Graph g) {
        this.init(g, null);
    }

    public Node(Node n) {
        this.init(n.graph, new Attributes(n.attributes));
        Iterator i = n.outgoingEdges.iterator();
        while (i.hasNext()) {
            new Edge(this, (Edge)i.next());
        }
        Iterator i2 = n.incomingEdges.iterator();
        while (i2.hasNext()) {
            new Edge((Edge)i2.next(), this);
        }
    }

    public synchronized void setAttributes(Attributes a) {
        int id = this.getId();
        this.attributes = new Attributes(a);
        this.setId(id);
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public synchronized void setBooleanAttribute(String name, boolean value) {
        if (name.equals("_id")) {
            return;
        }
        this.attributes.setBoolean(name, value);
    }

    public boolean getBooleanAttribute(String name) {
        return this.attributes.getBoolean(name);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public synchronized int getId() {
        return this.attributes.getInt("_id");
    }

    public int getIncomingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public List getIncomingEdges() {
        return new LinkedList(this.incomingEdges);
    }

    public synchronized void setIntAttribute(String name, int value) {
        if (name.equals("_id")) {
            return;
        }
        this.attributes.setInt(name, value);
    }

    public int getIntAttribute(String name) {
        return this.attributes.getInt(name);
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public List getOutgoingEdges() {
        return new LinkedList(this.outgoingEdges);
    }

    public synchronized void setStringAttribute(String name, String value) {
        if (name.equals("_id")) {
            return;
        }
        this.attributes.setString(name, value);
    }

    public String getStringAttribute(String name) {
        return this.attributes.getString(name);
    }

    public synchronized void forAllEdges(Visitor v) {
        Iterator i = new LinkedList(this.outgoingEdges).iterator();
        while (i.hasNext()) {
            v.visitEdge((Edge)i.next());
        }
    }

    public synchronized void remove() {
        Iterator i = new LinkedList(this.outgoingEdges).iterator();
        while (i.hasNext()) {
            ((Edge)i.next()).remove();
        }
        Iterator i2 = new LinkedList(this.incomingEdges).iterator();
        while (i2.hasNext()) {
            ((Edge)i2.next()).remove();
        }
        this.graph.removeNode(this);
    }

    synchronized void setId(int id) {
        this.attributes.setInt("_id", id);
    }

    synchronized void addIncomingEdge(Edge e) {
        this.incomingEdges.add(e);
    }

    synchronized void addOutgoingEdge(Edge e) {
        this.outgoingEdges.add(e);
    }

    synchronized void removeIncomingEdge(Edge e) {
        this.incomingEdges.remove(e);
    }

    synchronized void removeOutgoingEdge(Edge e) {
        this.outgoingEdges.remove(e);
    }

    void save(PrintStream out, int format) {
        switch (format) {
            case 0: {
                this.save_sm(out);
                break;
            }
            case 1: {
                this.save_fsp(out);
                break;
            }
            case 2: {
                this.save_xml(out);
                break;
            }
            case 3: {
                this.save_spin(out);
                break;
            }
            default: {
                throw new RuntimeException("Unknown format!");
            }
        }
    }

    private void init(Graph g, Attributes a) {
        this.graph = g;
        this.attributes = a == null ? new Attributes() : a;
        this.incomingEdges = new LinkedList();
        this.outgoingEdges = new LinkedList();
        this.graph.addNode(this);
    }

    private void save_fsp(PrintStream out) {
        out.print("S" + this.getId() + "=(");
        Iterator i = this.outgoingEdges.iterator();
        while (i.hasNext()) {
            ((Edge)i.next()).save(out, 1);
            if (!i.hasNext()) continue;
            out.print(" |");
        }
        out.print(")");
    }

    private void save_sm(PrintStream out) {
        int id = this.getId();
        out.print("  ");
        out.println(this.outgoingEdges.size());
        this.attributes.unset("_id");
        out.print("  ");
        out.println(this.attributes);
        this.setId(id);
        Iterator i = this.outgoingEdges.iterator();
        while (i.hasNext()) {
            ((Edge)i.next()).save(out, 0);
        }
    }

    private void save_spin(PrintStream out) {
        String ln = System.getProperty("line.separator");
        String lntab = ln + "     :: ";
        if (this.getBooleanAttribute("accepting")) {
            out.print("accept_");
        }
        out.print("S" + this.getId() + ":" + ln + "     if" + lntab);
        Iterator i = this.outgoingEdges.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            e.save(out, 3);
            if (!i.hasNext()) continue;
            out.print(lntab);
        }
        out.print(ln + "     fi;");
    }

    private void save_xml(PrintStream out) {
        int id = this.getId();
        out.println("<node id=\"" + id + "\">");
        this.attributes.unset("_id");
        this.attributes.save(out, 2);
        this.setId(id);
        Iterator i = this.outgoingEdges.iterator();
        while (i.hasNext()) {
            ((Edge)i.next()).save(out, 2);
        }
        out.println("</node>");
    }
}

