/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SCC {
    public static void help() {
        System.err.println("usage:");
        System.err.println("\tDegenalize [-join|-degeneralize] [outfile]");
        System.exit(1);
    }

    public static void main(String[] args) {
        String outname = null;
        int i = 0;
        int l = args.length;
        while (i < l) {
            if (outname == null) {
                outname = args[i];
            } else {
                SCC.help();
            }
            ++i;
        }
        try {
            Graph g = Graph.load("out.sm");
            List scc = SCC.scc(g);
            Iterator i2 = scc.iterator();
            while (i2.hasNext()) {
                List l2 = (List)i2.next();
                System.out.println("component:");
                Iterator j = l2.iterator();
                while (j.hasNext()) {
                    Node n = (Node)j.next();
                    System.out.println("  " + n.getStringAttribute("label"));
                }
                System.out.println();
            }
            if (outname == null) {
                g.save();
            } else {
                g.save(outname);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void print(List sccs) {
        System.out.println("Strongly connected components:");
        int cnt = 0;
        Iterator i = sccs.iterator();
        while (i.hasNext()) {
            List scc = (List)i.next();
            System.out.println("\tSCC #" + cnt++);
            Iterator j = scc.iterator();
            while (j.hasNext()) {
                Node n = (Node)j.next();
                System.out.println("\t\t" + n.getId() + " - " + n.getStringAttribute("label"));
            }
        }
    }

    public static List scc(Graph g) {
        Node init = g.getInit();
        if (init == null) {
            return new LinkedList();
        }
        init.setBooleanAttribute("_reached", true);
        SCCState s = new SCCState();
        SCC.visit(init, s);
        final List[] scc = new List[s.SCC];
        int i = 0;
        while (i < s.SCC) {
            scc[i] = new LinkedList();
            ++i;
        }
        g.forAllNodes(new EmptyVisitor(){

            public void visitNode(Node n) {
                scc[n.getIntAttribute("_scc")].add(n);
                n.setBooleanAttribute("_reached", false);
                n.setBooleanAttribute("_dfsnum", false);
                n.setBooleanAttribute("_low", false);
                n.setBooleanAttribute("_scc", false);
            }
        });
        LinkedList<List> list = new LinkedList<List>();
        int i2 = 0;
        while (i2 < s.SCC) {
            list.add(scc[i2]);
            ++i2;
        }
        return list;
    }

    private static void visit(Node p, SCCState s) {
        s.L.add(0, p);
        p.setIntAttribute("_dfsnum", s.N);
        p.setIntAttribute("_low", s.N);
        ++s.N;
        Iterator i = p.getOutgoingEdges().iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            Node q = e.getNext();
            if (!q.getBooleanAttribute("_reached")) {
                q.setBooleanAttribute("_reached", true);
                SCC.visit(q, s);
                p.setIntAttribute("_low", Math.min(p.getIntAttribute("_low"), q.getIntAttribute("_low")));
                continue;
            }
            if (q.getIntAttribute("_dfsnum") >= p.getIntAttribute("_dfsnum") || !s.L.contains(q)) continue;
            p.setIntAttribute("_low", Math.min(p.getIntAttribute("_low"), q.getIntAttribute("_dfsnum")));
        }
        if (p.getIntAttribute("_low") == p.getIntAttribute("_dfsnum")) {
            Node v;
            do {
                v = (Node)s.L.remove(0);
                v.setIntAttribute("_scc", s.SCC);
            } while (v != p);
            ++s.SCC;
        }
    }

    private static class SCCState {
        public int N = 0;
        public int SCC = 0;
        public List L = new LinkedList();

        private SCCState() {
        }
    }
}

