/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.SCC;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public class SCCReduction {
    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.ltl.graph.SCCReduction [<filename>]");
            return;
        }
        Graph g = null;
        try {
            g = args.length == 0 ? Graph.load() : Graph.load(args[0]);
        }
        catch (IOException e) {
            System.out.println("Can't load the graph.");
            return;
        }
        g = SCCReduction.reduce(g);
        g.save();
    }

    public static Graph reduce(Graph g) {
        boolean changed;
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        boolean acNodes = ac.equals("nodes");
        Iterator i = SCC.scc(g).iterator();
        while (i.hasNext()) {
            SCCReduction.clearExternalEdges((List)i.next(), g);
        }
        do {
            changed = false;
            List sccs = SCC.scc(g);
            Iterator i2 = sccs.iterator();
            while (i2.hasNext()) {
                List scc = (List)i2.next();
                boolean accepting = SCCReduction.isAccepting(scc, g);
                if (!accepting && SCCReduction.isTerminal(scc)) {
                    changed = true;
                    Iterator j = scc.iterator();
                    while (j.hasNext()) {
                        ((Node)j.next()).remove();
                    }
                    continue;
                }
                if (!SCCReduction.isTransient(scc) && accepting) continue;
                changed |= SCCReduction.anyAcceptingState(scc, g);
                SCCReduction.clearAccepting(scc, g);
            }
        } while (changed);
        return g;
    }

    private static boolean isAccepting(List scc, Graph g) {
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        if (type.equals("ba")) {
            if (ac.equals("nodes")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    if (!((Node)i.next()).getBooleanAttribute("accepting")) continue;
                    return true;
                }
                return false;
            }
            if (ac.equals("edges")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    Iterator j = n.getOutgoingEdges().iterator();
                    while (j.hasNext()) {
                        Edge e = (Edge)j.next();
                        if (!e.getBooleanAttribute("accepting")) continue;
                        return true;
                    }
                }
                return false;
            }
            throw new RuntimeException("invalid accepting type: " + ac);
        }
        if (type.equals("gba")) {
            int nsets = g.getIntAttribute("nsets");
            BitSet found = new BitSet(nsets);
            int nsccs = 0;
            if (ac.equals("nodes")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    int j = 0;
                    while (j < nsets) {
                        if (n.getBooleanAttribute("acc" + j) && !found.get(j)) {
                            found.set(j);
                            ++nsccs;
                        }
                        ++j;
                    }
                }
            } else if (ac.equals("edges")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    Iterator j = n.getOutgoingEdges().iterator();
                    while (j.hasNext()) {
                        Edge e = (Edge)j.next();
                        int k = 0;
                        while (k < nsets) {
                            if (e.getBooleanAttribute("acc" + k) && !found.get(k)) {
                                found.set(k);
                                ++nsccs;
                            }
                            ++k;
                        }
                    }
                }
            } else {
                throw new RuntimeException("invalid accepting type: " + ac);
            }
            return nsccs == nsets;
        }
        throw new RuntimeException("invalid graph type: " + type);
    }

    private static boolean isTerminal(List scc) {
        Iterator i = scc.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            Iterator j = n.getOutgoingEdges().iterator();
            while (j.hasNext()) {
                if (scc.contains(((Edge)j.next()).getNext())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isTransient(List scc) {
        if (scc.size() != 1) {
            return false;
        }
        Node n = (Node)scc.get(0);
        Iterator i = n.getOutgoingEdges().iterator();
        while (i.hasNext()) {
            if (((Edge)i.next()).getNext() != n) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean anyAcceptingState(List scc, Graph g) {
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        if (type.equals("ba")) {
            if (ac.equals("nodes")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    if (!n.getBooleanAttribute("accepting")) continue;
                    return true;
                }
                return false;
            } else {
                if (!ac.equals("edges")) throw new RuntimeException("invalid accepting type: " + ac);
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    Iterator j = n.getOutgoingEdges().iterator();
                    while (j.hasNext()) {
                        Edge e = (Edge)j.next();
                        if (!e.getBooleanAttribute("accepting")) continue;
                        return true;
                    }
                }
            }
            return false;
        } else {
            if (!type.equals("gba")) throw new RuntimeException("invalid graph type: " + type);
            int nsets = g.getIntAttribute("nsets");
            if (ac.equals("nodes")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    int j = 0;
                    while (j < nsets) {
                        if (n.getBooleanAttribute("acc" + j)) {
                            return true;
                        }
                        ++j;
                    }
                }
                return false;
            } else {
                if (!ac.equals("edges")) throw new RuntimeException("invalid accepting type: " + ac);
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    Iterator j = n.getOutgoingEdges().iterator();
                    while (j.hasNext()) {
                        Edge e = (Edge)j.next();
                        int k = 0;
                        while (k < nsets) {
                            if (e.getBooleanAttribute("acc" + j)) {
                                return true;
                            }
                            ++k;
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void clearAccepting(List scc, Graph g) {
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        if (type.equals("ba")) {
            if (ac.equals("nodes")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    n.setBooleanAttribute("accepting", false);
                }
                return;
            } else {
                if (!ac.equals("edges")) throw new RuntimeException("invalid accepting type: " + ac);
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    Iterator j = n.getOutgoingEdges().iterator();
                    while (j.hasNext()) {
                        Edge e = (Edge)j.next();
                        e.setBooleanAttribute("accepting", false);
                    }
                }
            }
            return;
        } else {
            if (!type.equals("gba")) throw new RuntimeException("invalid graph type: " + type);
            int nsets = g.getIntAttribute("nsets");
            if (ac.equals("nodes")) {
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    int j = 0;
                    while (j < nsets) {
                        n.setBooleanAttribute("acc" + j, false);
                        ++j;
                    }
                }
                return;
            } else {
                if (!ac.equals("edges")) throw new RuntimeException("invalid accepting type: " + ac);
                Iterator i = scc.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    Iterator j = n.getOutgoingEdges().iterator();
                    while (j.hasNext()) {
                        Edge e = (Edge)j.next();
                        int k = 0;
                        while (k < nsets) {
                            e.setBooleanAttribute("acc" + k, false);
                            ++k;
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void clearExternalEdges(List scc, Graph g) {
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        if (type.equals("ba")) {
            if (ac.equals("nodes")) return;
            if (!ac.equals("edges")) throw new RuntimeException("invalid accepting type: " + ac);
            Iterator i = scc.iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                Iterator j = n.getOutgoingEdges().iterator();
                while (j.hasNext()) {
                    Edge e = (Edge)j.next();
                    if (scc.contains(e.getNext())) continue;
                    e.setBooleanAttribute("accepting", false);
                }
            }
            return;
        } else {
            if (!type.equals("gba")) throw new RuntimeException("invalid graph type: " + type);
            int nsets = g.getIntAttribute("nsets");
            if (ac.equals("nodes")) return;
            if (!ac.equals("edges")) throw new RuntimeException("invalid accepting type: " + ac);
            Iterator i = scc.iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                Iterator j = n.getOutgoingEdges().iterator();
                while (j.hasNext()) {
                    Edge e = (Edge)j.next();
                    if (scc.contains(e.getNext())) continue;
                    int k = 0;
                    while (k < nsets) {
                        e.setBooleanAttribute("acc" + k, false);
                        ++k;
                    }
                }
            }
        }
    }
}

