/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.ColorPair;
import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.ITypeNeighbor;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.Pair;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class SFSReduction {
    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.ltl.graph.SFSReduction [<filename>]");
            return;
        }
        Graph g = null;
        try {
            g = args.length == 0 ? Graph.load() : Graph.load(args[0]);
        }
        catch (IOException e) {
            System.out.println("Can't load the graph.");
            return;
        }
        Graph reduced = SFSReduction.reduce(g);
        reduced.save();
    }

    public static Graph reduce(Graph g) {
        Graph result;
        Iterator i;
        int prevNumColors = 1;
        int currNumPO = 3;
        int prevNumPO = 1;
        TreeSet<ColorPair> newColorSet = null;
        LinkedList<Pair> newColorList = null;
        boolean accepting = false;
        boolean nonaccepting = false;
        List nodes = g.getNodes();
        Iterator i2 = nodes.iterator();
        while (i2.hasNext()) {
            Node currNode = (Node)i2.next();
            currNode.setIntAttribute("_prevColor", 1);
            if (SFSReduction.isAccepting(currNode)) {
                currNode.setIntAttribute("_currColor", 1);
                accepting = true;
                continue;
            }
            currNode.setIntAttribute("_currColor", 2);
            nonaccepting = true;
        }
        int currNumColors = accepting && nonaccepting ? 2 : 1;
        boolean[][] currPO = new boolean[2][2];
        int i3 = 0;
        while (i3 < 2) {
            int j = 0;
            while (j < 2) {
                currPO[i3][j] = i3 >= j;
                ++j;
            }
            ++i3;
        }
        while (currNumColors != prevNumColors || currNumPO != prevNumPO) {
            Iterator i4 = nodes.iterator();
            while (i4.hasNext()) {
                Node currNode = (Node)i4.next();
                currNode.setIntAttribute("_prevColor", currNode.getIntAttribute("_currColor"));
            }
            boolean[][] prevPO = currPO;
            prevNumColors = currNumColors;
            newColorList = new LinkedList<Pair>();
            newColorSet = new TreeSet<ColorPair>();
            Iterator i5 = nodes.iterator();
            while (i5.hasNext()) {
                Node currNode = (Node)i5.next();
                ColorPair currPair = new ColorPair(currNode.getIntAttribute("_prevColor"), SFSReduction.getPrevN(currNode, prevPO));
                newColorList.add(new Pair(currNode.getId(), currPair));
                newColorSet.add(currPair);
            }
            currNumColors = newColorSet.size();
            LinkedList<ColorPair> ordered = new LinkedList<ColorPair>();
            i = newColorSet.iterator();
            while (i.hasNext()) {
                ColorPair currPair = (ColorPair)i.next();
                ordered.add(currPair);
            }
            Iterator i6 = newColorList.iterator();
            while (i6.hasNext()) {
                Pair cPair = (Pair)i6.next();
                ColorPair currPair = (ColorPair)cPair.getElement();
                g.getNode(cPair.getValue()).setIntAttribute("_currColor", ordered.indexOf(currPair) + 1);
            }
            prevNumPO = currNumPO;
            currNumPO = 0;
            currPO = new boolean[currNumColors][currNumColors];
            Iterator i7 = newColorList.iterator();
            while (i7.hasNext()) {
                ColorPair currPairOne = (ColorPair)((Pair)i7.next()).getElement();
                Iterator j = newColorList.iterator();
                while (j.hasNext()) {
                    ColorPair currPairTwo = (ColorPair)((Pair)j.next()).getElement();
                    boolean po = prevPO[currPairTwo.getColor() - 1][currPairOne.getColor() - 1];
                    boolean dominate = SFSReduction.iDominateSet(currPairOne.getIMaxSet(), currPairTwo.getIMaxSet(), prevPO);
                    if (po && dominate) {
                        currPO[ordered.indexOf((Object)currPairTwo)][ordered.indexOf((Object)currPairOne)] = true;
                        ++currNumPO;
                        continue;
                    }
                    currPO[ordered.indexOf((Object)currPairTwo)][ordered.indexOf((Object)currPairOne)] = false;
                }
            }
        }
        if (newColorList == null) {
            result = g;
        } else {
            result = new Graph();
            Node[] newNodes = new Node[currNumColors];
            int i8 = 0;
            while (i8 < currNumColors) {
                Node n;
                newNodes[i8] = n = new Node(result);
                ++i8;
            }
            i = newColorList.iterator();
            while (i.hasNext()) {
                Pair nodePair = (Pair)i.next();
                int origNodeId = nodePair.getValue();
                ColorPair colPair = (ColorPair)nodePair.getElement();
                if (!newColorSet.contains(colPair)) continue;
                newColorSet.remove(colPair);
                TreeSet pairSet = colPair.getIMaxSet();
                int color = colPair.getColor();
                Node currNode = newNodes[color - 1];
                Iterator j = pairSet.iterator();
                while (j.hasNext()) {
                    ITypeNeighbor neigh = (ITypeNeighbor)j.next();
                    int neighPos = neigh.getColor() - 1;
                    Edge currEdge = new Edge(currNode, newNodes[neighPos], neigh.getTransition());
                }
                if (g.getInit().getId() == origNodeId) {
                    result.setInit(currNode);
                }
                if (!SFSReduction.isAccepting(g.getNode(origNodeId))) continue;
                currNode.setBooleanAttribute("accepting", true);
            }
        }
        return SFSReduction.reachabilityGraph(result);
    }

    private static boolean isAccepting(Node nodeIn) {
        return nodeIn.getBooleanAttribute("accepting");
    }

    private static TreeSet getPrevN(Node currNode, boolean[][] prevPO) {
        ITypeNeighbor iNeigh;
        List edges = currNode.getOutgoingEdges();
        LinkedList<ITypeNeighbor> neighbors = new LinkedList<ITypeNeighbor>();
        TreeSet<ITypeNeighbor> prevN = new TreeSet<ITypeNeighbor>();
        Iterator i = edges.iterator();
        while (i.hasNext()) {
            Edge currEdge = (Edge)i.next();
            iNeigh = new ITypeNeighbor(currEdge.getNext().getIntAttribute("_prevColor"), currEdge.getGuard());
            neighbors.add(iNeigh);
        }
        if (neighbors.size() == 0) {
            return prevN;
        }
        do {
            boolean useless = false;
            iNeigh = (ITypeNeighbor)neighbors.removeFirst();
            Iterator i2 = neighbors.iterator();
            while (i2.hasNext()) {
                ITypeNeighbor nNeigh = (ITypeNeighbor)i2.next();
                ITypeNeighbor dominating = SFSReduction.iDominates(iNeigh, nNeigh, prevPO);
                if (dominating == iNeigh) {
                    i2.remove();
                }
                if (dominating != nNeigh) continue;
                useless = true;
                break;
            }
            if (useless) continue;
            prevN.add(iNeigh);
        } while (neighbors.size() > 0);
        return prevN;
    }

    private static boolean iDominateSet(TreeSet setOne, TreeSet setTwo, boolean[][] prevPO) {
        TreeSet working = new TreeSet(setTwo);
        Iterator i = working.iterator();
        block0: while (i.hasNext()) {
            ITypeNeighbor neighTwo = (ITypeNeighbor)i.next();
            Iterator j = setOne.iterator();
            while (j.hasNext()) {
                ITypeNeighbor neighOne = (ITypeNeighbor)j.next();
                ITypeNeighbor dominating = SFSReduction.iDominates(neighOne, neighTwo, prevPO);
                if (dominating != neighOne) continue;
                i.remove();
                continue block0;
            }
        }
        return working.size() == 0;
    }

    private static ITypeNeighbor iDominates(ITypeNeighbor iNeigh, ITypeNeighbor nNeigh, boolean[][] prevPO) {
        String iTerm = iNeigh.getTransition();
        String nTerm = nNeigh.getTransition();
        int iColor = iNeigh.getColor();
        int nColor = nNeigh.getColor();
        String theSubterm = SFSReduction.subterm(iTerm, nTerm);
        if (theSubterm == iTerm) {
            if (prevPO[nColor - 1][iColor - 1]) {
                return iNeigh;
            }
            return null;
        }
        if (theSubterm == nTerm) {
            if (prevPO[iColor - 1][nColor - 1]) {
                return nNeigh;
            }
            return null;
        }
        if (theSubterm.equals("true")) {
            if (prevPO[nColor - 1][iColor - 1]) {
                return iNeigh;
            }
            if (prevPO[iColor - 1][nColor - 1]) {
                return nNeigh;
            }
        }
        return null;
    }

    private static Graph reachabilityGraph(Graph g) {
        Vector<Node> work = new Vector<Node>();
        Vector<Node> reachable = new Vector<Node>();
        work.add(g.getInit());
        while (!work.isEmpty()) {
            Node currNode = (Node)work.firstElement();
            reachable.add(currNode);
            if (currNode != null) {
                List outgoingEdges = currNode.getOutgoingEdges();
                Iterator i = outgoingEdges.iterator();
                while (i.hasNext()) {
                    Edge currEdge = (Edge)i.next();
                    Node nextNode = currEdge.getNext();
                    if (work.contains(nextNode) || reachable.contains(nextNode)) continue;
                    work.add(nextNode);
                }
            }
            if (work.remove(0) == currNode) continue;
            System.out.println("ERROR");
        }
        List nodes = g.getNodes();
        if (nodes != null) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                if (reachable.contains(n)) continue;
                g.removeNode(n);
            }
        }
        return g;
    }

    private static String subterm(String pred1, String pred2) {
        String tauStr;
        String alphaStr;
        if (pred1.equals("-") && pred2.equals("-")) {
            return "true";
        }
        if (pred1.equals("-")) {
            return pred1;
        }
        if (pred2.equals("-")) {
            return pred2;
        }
        if (pred1.indexOf("true") != -1 && pred2.indexOf("true") != -1) {
            return "true";
        }
        if (pred1.indexOf("true") != -1) {
            return pred1;
        }
        if (pred2.indexOf("true") != -1) {
            return pred2;
        }
        if (pred1.length() <= pred2.length()) {
            alphaStr = pred1;
            tauStr = pred2;
        } else {
            alphaStr = pred2;
            tauStr = pred1;
        }
        StringTokenizer alphaTk = new StringTokenizer(alphaStr, "&");
        StringTokenizer tauTk = new StringTokenizer(tauStr, "&");
        LinkedList<String> tauLst = new LinkedList<String>();
        while (tauTk.hasMoreTokens()) {
            String token = tauTk.nextToken();
            tauLst.add(token);
        }
        while (alphaTk.hasMoreTokens()) {
            String alphaLit = alphaTk.nextToken();
            if (tauLst.contains(alphaLit)) continue;
            return "false";
        }
        if (pred1.length() == pred2.length()) {
            return "true";
        }
        return alphaStr;
    }
}

