/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.io.IOException;

public class SM2Dot {
    public static void endDigraph() {
        System.out.println("}");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage:");
            System.err.println("\tSM2Dot <filename>");
            System.err.println();
            System.exit(1);
        }
        try {
            Graph g = Graph.load(args[0]);
            SM2Dot.startDigraph(args[0]);
            SM2Dot.printInit(g.getInit());
            g.forAllNodes(new EmptyVisitor(){

                public void visitNode(Node n) {
                    SM2Dot.printNode(n);
                    n.forAllEdges(new EmptyVisitor(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void visitEdge(Edge e) {
                            SM2Dot.printEdge(e);
                        }
                    });
                }
            });
            SM2Dot.endDigraph();
        }
        catch (IOException e) {
            System.err.println("Can't load file: " + args[0]);
            System.exit(1);
        }
    }

    public static void printEdge(Edge e) {
        int id = e.getSource().getId();
        int nxt = e.getNext().getId();
        String guard = e.getGuard();
        String action = e.getAction();
        String label = e.getStringAttribute("label");
        StringBuffer sb = new StringBuffer();
        if (label != null) {
            sb.append(label);
            sb.append("\\n");
        }
        if (!guard.equals("-")) {
            if (!action.equals("-")) {
                sb.append(guard + "/" + action + "\\n");
            } else {
                sb.append(guard + "\\n");
            }
        } else if (!action.equals("-")) {
            sb.append(guard + "/" + action + "\\n");
        } else {
            sb.append("true\\n");
        }
        int nsets = e.getSource().getGraph().getIntAttribute("nsets");
        boolean first = true;
        int i = 0;
        while (i < nsets) {
            if (e.getBooleanAttribute("acc" + i)) {
                if (first) {
                    sb.append("{");
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i);
            }
            ++i;
        }
        if (!first) {
            sb.append("}");
        }
        System.out.println("\t" + id + " -> " + nxt + " [label=\"" + sb.toString() + "\"]");
    }

    public static void printInit(Node n) {
        System.out.println("\tinit [color=white, label=\"\"];");
        System.out.println("\tinit -> " + n.getId() + ";");
    }

    public static void printNode(Node n) {
        int id = n.getId();
        if (n.getBooleanAttribute("accepting")) {
            System.out.println("\t" + id + " [shape=doublecircle];");
        } else {
            System.out.println("\t" + id + " [shape=circle];");
        }
        String label = n.getStringAttribute("label");
        StringBuffer sb = new StringBuffer();
        if (label != null) {
            sb.append(label);
            sb.append("\\n");
        }
        sb.append(id + "\\n");
        int nsets = n.getGraph().getIntAttribute("nsets");
        boolean first = true;
        int i = 0;
        while (i < nsets) {
            if (n.getBooleanAttribute("acc" + i)) {
                if (first) {
                    sb.append("{");
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i);
            }
            ++i;
        }
        if (!first) {
            sb.append("}");
        }
        System.out.println("\t" + id + " [label=\"" + sb.toString() + "\"];");
    }

    public static void startDigraph(String name) {
        if (name.lastIndexOf(47) != -1) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        name = name.replace('.', '_');
        name = name.replace('-', '_');
        System.out.println("digraph " + name + " {");
    }
}

