/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.io.IOException;
import java.util.Iterator;

public class Simplify {
    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.ltl.graph.Simplify [<filename>]");
            return;
        }
        Graph g = null;
        try {
            g = args.length == 0 ? Graph.load() : Graph.load(args[0]);
        }
        catch (IOException e) {
            System.out.println("Can't load the graph.");
            return;
        }
        g = Simplify.simplify(g);
        g.save();
    }

    public static Graph simplify(Graph g) {
        boolean simplified;
        do {
            simplified = false;
            Iterator i = g.getNodes().iterator();
            while (i.hasNext()) {
                Node n0 = (Node)i.next();
                Iterator j = g.getNodes().iterator();
                while (j.hasNext()) {
                    Node n1 = (Node)j.next();
                    if (n1.getId() <= n0.getId() || n1.getBooleanAttribute("accepting") != n0.getBooleanAttribute("accepting")) continue;
                    boolean equivalent = true;
                    Iterator k = n0.getOutgoingEdges().iterator();
                    while (equivalent && k.hasNext()) {
                        Edge e0 = (Edge)k.next();
                        equivalent = false;
                        Iterator l = n1.getOutgoingEdges().iterator();
                        while (!equivalent && l.hasNext()) {
                            Edge e1 = (Edge)l.next();
                            if (e0.getNext() != e1.getNext() && (e0.getNext() != n0 && e0.getNext() != n1 || e1.getNext() != n0 && e1.getNext() != n1) || !e0.getGuard().equals(e1.getGuard()) || !e0.getAction().equals(e1.getAction())) continue;
                            equivalent = true;
                        }
                    }
                    Iterator k2 = n1.getOutgoingEdges().iterator();
                    while (equivalent && k2.hasNext()) {
                        Edge e1 = (Edge)k2.next();
                        equivalent = false;
                        Iterator l = n0.getOutgoingEdges().iterator();
                        while (!equivalent && l.hasNext()) {
                            Edge e0 = (Edge)l.next();
                            if (e0.getNext() != e1.getNext() && (e0.getNext() != n0 && e0.getNext() != n1 || e1.getNext() != n0 && e1.getNext() != n1) || !e0.getGuard().equals(e1.getGuard()) || !e0.getAction().equals(e1.getAction())) continue;
                            equivalent = true;
                        }
                    }
                    if (!equivalent) continue;
                    Iterator k3 = n1.getIncomingEdges().iterator();
                    while (equivalent && k3.hasNext()) {
                        Edge e = (Edge)k3.next();
                        new Edge(e.getSource(), n0, e.getGuard(), e.getAction(), e.getAttributes());
                    }
                    n1.remove();
                    simplified = true;
                }
            }
        } while (simplified);
        return g;
    }
}

