/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.EmptyVisitor;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.io.IOException;

public class SuperSetReduction {
    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.ltl.graph.SuperSetReduction [<filename>]");
            return;
        }
        Graph g = null;
        try {
            g = args.length == 0 ? Graph.load() : Graph.load(args[0]);
        }
        catch (IOException e) {
            System.out.println("Can't load the graph.");
            return;
        }
        g = SuperSetReduction.reduce(g);
        g.save();
    }

    public static Graph reduce(Graph g) {
        final int nsets = g.getIntAttribute("nsets");
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        if (!type.equals("gba")) {
            throw new RuntimeException("invalid graph type: " + type);
        }
        if (ac.equals("nodes")) {
            int nnodes = g.getNodeCount();
            final boolean[][] asets = new boolean[nsets][nnodes];
            g.forAllNodes(new EmptyVisitor(){

                public void visitNode(Node n) {
                    int i = 0;
                    while (i < nsets) {
                        String acc = "acc" + i;
                        if (n.getBooleanAttribute(acc)) {
                            asets[i][n.getId()] = true;
                            n.setBooleanAttribute(acc, false);
                        }
                        ++i;
                    }
                }
            });
            boolean[] remove = new boolean[nsets];
            int i = 0;
            while (i < nsets) {
                int j = 0;
                while (j < nsets && !remove[i]) {
                    if (i != j && !remove[j] && SuperSetReduction.included(asets[j], asets[i])) {
                        remove[i] = true;
                    }
                    ++j;
                }
                ++i;
            }
            int n_nsets = 0;
            int i2 = 0;
            while (i2 < nsets) {
                if (!remove[i2]) {
                    ++n_nsets;
                }
                ++i2;
            }
            boolean[][] n_asets = new boolean[n_nsets][nnodes];
            n_nsets = 0;
            int i3 = 0;
            while (i3 < nsets) {
                if (!remove[i3]) {
                    n_asets[n_nsets++] = asets[i3];
                }
                ++i3;
            }
            g.setIntAttribute("nsets", n_nsets);
            int i4 = 0;
            while (i4 < nnodes) {
                Node n = g.getNode(i4);
                int j = 0;
                while (j < n_nsets) {
                    if (n_asets[j][i4]) {
                        n.setBooleanAttribute("acc" + j, true);
                    }
                    ++j;
                }
                ++i4;
            }
            return g;
        }
        if (ac.equals("edges")) {
            int nedges = g.getEdgeCount();
            final boolean[][] asets = new boolean[nsets][nedges];
            final Edge[] edges = new Edge[nedges];
            g.forAllEdges(new EmptyVisitor(new Integer(0)){

                public void visitEdge(Edge e) {
                    int id = (Integer)this.arg;
                    this.arg = new Integer(id + 1);
                    edges[id] = e;
                    int i = 0;
                    while (i < nsets) {
                        String acc = "acc" + i;
                        if (e.getBooleanAttribute(acc)) {
                            asets[i][id] = true;
                            e.setBooleanAttribute(acc, false);
                        }
                        ++i;
                    }
                }
            });
            boolean[] remove = new boolean[nsets];
            int i = 0;
            while (i < nsets) {
                int j = 0;
                while (j < nsets && !remove[i]) {
                    if (i != j && !remove[j] && SuperSetReduction.included(asets[j], asets[i])) {
                        remove[i] = true;
                    }
                    ++j;
                }
                ++i;
            }
            int n_nsets = 0;
            int i5 = 0;
            while (i5 < nsets) {
                if (!remove[i5]) {
                    ++n_nsets;
                }
                ++i5;
            }
            boolean[][] n_asets = new boolean[n_nsets][nedges];
            n_nsets = 0;
            int i6 = 0;
            while (i6 < nsets) {
                if (!remove[i6]) {
                    n_asets[n_nsets++] = asets[i6];
                }
                ++i6;
            }
            g.setIntAttribute("nsets", n_nsets);
            int i7 = 0;
            while (i7 < nedges) {
                Edge e = edges[i7];
                int j = 0;
                while (j < n_nsets) {
                    if (n_asets[j][i7]) {
                        e.setBooleanAttribute("acc" + j, true);
                    }
                    ++j;
                }
                ++i7;
            }
            return g;
        }
        throw new RuntimeException("invalid accepting type: " + ac);
    }

    private static boolean included(boolean[] a, boolean[] b) {
        int al = a.length;
        int bl = b.length;
        int i = 0;
        while (i < al) {
            if (a[i] && !b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

