/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class SynchronousProduct {
    public static void dfs(Graph g, Node[][] nodes, int nsets, Node n0, Node n1) {
        Node n = SynchronousProduct.get(g, nodes, n0, n1);
        List t0 = n0.getOutgoingEdges();
        List t1 = n1.getOutgoingEdges();
        Iterator i0 = t0.iterator();
        while (i0.hasNext()) {
            Edge e0 = (Edge)i0.next();
            Node next0 = e0.getNext();
            Edge theEdge = null;
            boolean found = false;
            Iterator i1 = t1.iterator();
            while (i1.hasNext() && !found) {
                Edge e1 = (Edge)i1.next();
                if (e1.getBooleanAttribute("else")) {
                    if (theEdge == null) {
                        theEdge = e1;
                    }
                } else {
                    found = true;
                    int i = 0;
                    while (i < nsets) {
                        boolean b0 = e0.getBooleanAttribute("acc" + i);
                        boolean b1 = e1.getBooleanAttribute("acc" + i);
                        if (b1 && !b0) {
                            found = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (!found) continue;
                theEdge = e1;
            }
            if (theEdge == null) continue;
            Node next1 = theEdge.getNext();
            boolean newNext = SynchronousProduct.isNew(nodes, next0, next1);
            Node next = SynchronousProduct.get(g, nodes, next0, next1);
            Edge e = new Edge(n, next, e0.getGuard(), theEdge.getAction(), null);
            if (!newNext) continue;
            SynchronousProduct.dfs(g, nodes, nsets, next0, next1);
        }
    }

    public static void main(String[] args) {
        Graph g1;
        Graph g0;
        try {
            g0 = Graph.load(args[0]);
            g1 = Graph.load(args[1]);
        }
        catch (IOException e) {
            System.err.println("Can't load automata");
            System.exit(1);
            return;
        }
        Graph g = SynchronousProduct.product(g0, g1);
        g.save();
    }

    public static Graph product(Graph g0, Graph g1) {
        int nsets = g0.getIntAttribute("nsets");
        if (nsets != g1.getIntAttribute("nsets")) {
            System.err.println("Different number of accepting sets");
            System.exit(1);
        }
        Graph g = new Graph();
        g.setStringAttribute("type", "ba");
        g.setStringAttribute("ac", "nodes");
        Node[][] nodes = new Node[g0.getNodeCount()][g1.getNodeCount()];
        SynchronousProduct.dfs(g, nodes, nsets, g0.getInit(), g1.getInit());
        return g;
    }

    private static boolean isNew(Node[][] nodes, Node n0, Node n1) {
        return nodes[n0.getId()][n1.getId()] == null;
    }

    private static Node get(Graph g, Node[][] nodes, Node n0, Node n1) {
        if (nodes[n0.getId()][n1.getId()] == null) {
            Node n = new Node(g);
            String label0 = n0.getStringAttribute("label");
            String label1 = n1.getStringAttribute("label");
            if (label0 == null) {
                label0 = Integer.toString(n0.getId());
            }
            if (label1 == null) {
                label1 = Integer.toString(n1.getId());
            }
            n.setStringAttribute("label", label0 + "+" + label1);
            if (n1.getBooleanAttribute("accepting")) {
                n.setBooleanAttribute("accepting", true);
            }
            Node node = n;
            nodes[n0.getId()][n1.getId()] = node;
            return node;
        }
        return nodes[n0.getId()][n1.getId()];
    }
}

