/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.trans.LinkNode;
import gov.nasa.ltl.trans.Node;
import gov.nasa.ltl.trans.Pool;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Translator;

class Automaton {
    private LinkNode head = null;
    private LinkNode tail = null;
    private Node[] equivalence_classes = null;

    public static void FSPoutput(State[] automaton) {
        boolean comma = false;
        if (automaton == null) {
            System.out.println("\n\nRES = STOP.");
            return;
        }
        System.out.println("\n\nRES = S0,");
        int size = Pool.assign();
        int i = 0;
        while (i < size) {
            if (automaton[i] != null && i == automaton[i].get_representativeId()) {
                if (comma) {
                    System.out.println("),");
                }
                comma = true;
                System.out.print("S" + automaton[i].get_representativeId());
                System.out.print("=");
                automaton[i].FSPoutput();
            }
            ++i;
        }
        System.out.println(").\n");
    }

    public static Graph SMoutput(State[] automaton) {
        Graph g = new Graph();
        g.setStringAttribute("type", "gba");
        g.setStringAttribute("ac", "edges");
        if (automaton == null) {
            return g;
        }
        int size = Pool.assign();
        gov.nasa.ltl.graph.Node[] nodes = new gov.nasa.ltl.graph.Node[size];
        int i = 0;
        while (i < size) {
            if (automaton[i] != null && i == automaton[i].get_representativeId()) {
                nodes[i] = new gov.nasa.ltl.graph.Node(g);
                nodes[i].setStringAttribute("label", "S" + automaton[i].get_representativeId());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < size) {
            if (automaton[i2] != null && i2 == automaton[i2].get_representativeId()) {
                automaton[i2].SMoutput(nodes, nodes[i2]);
            }
            ++i2;
        }
        if (Node.accepting_conds == 0) {
            g.setIntAttribute("nsets", 1);
        } else {
            g.setIntAttribute("nsets", Node.accepting_conds);
        }
        return g;
    }

    public void add(Node nd) {
        LinkNode newNode = new LinkNode(nd, null);
        if (this.head == null) {
            this.head = this.tail = newNode;
        } else {
            this.tail.LinkWith(newNode);
            this.tail = newNode;
        }
    }

    public Node alreadyThere(Node nd) {
        LinkNode nextNd = this.head;
        while (nextNd != null) {
            Node currState = nextNd.getNode();
            if (currState.getField_next().equals(nd.getField_next()) && currState.compare_accepting(nd) && (Translator.get_algorithm() == 1 || currState.getField_old().equals(nd.getField_old()))) {
                return currState;
            }
            nextNd = nextNd.getNext();
        }
        return null;
    }

    public int index_equivalence(Node nd) {
        int index = 0;
        while (index < Pool.assign()) {
            if (this.equivalence_classes[index] == null) break;
            if (Translator.get_algorithm() == 1 && this.equivalence_classes[index].getField_next().equals(nd.getField_next())) {
                return this.equivalence_classes[index].getNodeId();
            }
            ++index;
        }
        if (index == Pool.assign()) {
            System.out.println("ERROR - size of equivalence classes array was incorrect");
        }
        this.equivalence_classes[index] = nd;
        return this.equivalence_classes[index].getNodeId();
    }

    public State[] structForRuntAnalysis() {
        Pool.stop();
        int automatonSize = Pool.assign();
        State[] RTstruct = new State[automatonSize];
        this.equivalence_classes = new Node[automatonSize];
        if (this.head == null) {
            return RTstruct;
        }
        LinkNode nextNd = this.head;
        while (nextNd != null) {
            Node current = nextNd.getNode();
            current.set_equivalenceId(this.index_equivalence(current));
            nextNd.getNode().RTstructure(RTstruct);
            nextNd = nextNd.getNext();
        }
        return RTstruct;
    }
}

