/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.ParserInternalError;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.TreeSet;

public class Formula
implements Comparable {
    private static int nId = 0;
    private static final int P_ALL = 0;
    private static final int P_IMPLIES = 1;
    private static final int P_OR = 2;
    private static final int P_AND = 3;
    private static final int P_UNTIL = 4;
    private static final int P_WUNTIL = 4;
    private static final int P_RELEASE = 5;
    private static final int P_WRELEASE = 5;
    private static final int P_NOT = 6;
    private static final int P_NEXT = 6;
    private static final int P_ALWAYS = 6;
    private static final int P_EVENTUALLY = 6;
    private static Hashtable ht = new Hashtable();
    private static Hashtable matches = new Hashtable();
    private char content;
    private boolean literal;
    private Formula left;
    private Formula right;
    private int id = nId++;
    private int untils_index;
    private BitSet rightOfWhichUntils;
    private String name;
    private boolean has_been_visited;

    private Formula(char c, boolean l, Formula sx, Formula dx, String n) {
        this.content = c;
        this.literal = l;
        this.left = sx;
        this.right = dx;
        this.name = n;
        this.rightOfWhichUntils = null;
        this.untils_index = -1;
        this.has_been_visited = false;
    }

    public static boolean is_reserved_char(char ch) {
        switch (ch) {
            case ' ': 
            case '(': 
            case ')': 
            case '-': 
            case '<': 
            case '>': 
            case 'M': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    public static void reset_static() {
        Formula.clearMatches();
        Formula.clearHT();
    }

    public char getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public Formula getNext() {
        switch (this.content) {
            case 'U': 
            case 'W': {
                return this;
            }
            case 'V': {
                return this;
            }
            case 'O': {
                return null;
            }
        }
        return null;
    }

    public Formula getSub1() {
        if (this.content == 'V') {
            return this.right;
        }
        return this.left;
    }

    public Formula getSub2() {
        if (this.content == 'V') {
            return this.left;
        }
        return this.right;
    }

    public void addLeft(Formula l) {
        this.left = l;
    }

    public void addRight(Formula r) {
        this.right = r;
    }

    public int compareTo(Object f) {
        Formula ff = (Formula)f;
        return this.id - ff.id;
    }

    public int countUntils(int acc_sets) {
        this.has_been_visited = true;
        if (this.getContent() == 'U') {
            ++acc_sets;
        }
        if (this.left != null && !this.left.has_been_visited) {
            acc_sets = this.left.countUntils(acc_sets);
        }
        if (this.right != null && !this.right.has_been_visited) {
            acc_sets = this.right.countUntils(acc_sets);
        }
        return acc_sets;
    }

    public BitSet get_rightOfWhichUntils() {
        return this.rightOfWhichUntils;
    }

    public int get_untils_index() {
        return this.untils_index;
    }

    public int initialize() {
        int acc_sets = this.countUntils(0);
        this.reset_visited();
        int test = this.processRightUntils(0, acc_sets);
        this.reset_visited();
        return acc_sets;
    }

    public boolean is_literal() {
        return this.literal;
    }

    public boolean is_right_of_until(int size) {
        return this.rightOfWhichUntils != null;
    }

    public boolean is_special_case_of_V(TreeSet check_against) {
        Formula form = Formula.Release(Formula.False(), this);
        return check_against.contains(form);
    }

    public boolean is_synt_implied(TreeSet old, TreeSet next) {
        if (this.getContent() == 't') {
            return true;
        }
        if (old.contains(this)) {
            return true;
        }
        if (!this.is_literal()) {
            Formula form1 = this.getSub1();
            Formula form2 = this.getSub2();
            Formula form3 = this.getNext();
            boolean condition2 = form2 != null ? form2.is_synt_implied(old, next) : true;
            boolean condition1 = form1 != null ? form1.is_synt_implied(old, next) : true;
            boolean condition3 = form3 != null ? (next != null ? next.contains(form3) : false) : true;
            switch (this.getContent()) {
                case 'O': 
                case 'U': 
                case 'W': {
                    return condition2 || condition1 && condition3;
                }
                case 'V': {
                    return condition1 && condition2 || condition1 && condition3;
                }
                case 'X': {
                    if (form1 != null) {
                        if (next != null) {
                            return next.contains(form1);
                        }
                        return false;
                    }
                    return true;
                }
                case 'A': {
                    return condition2 && condition1;
                }
            }
            System.out.println("Default case of switch at Form.synt_implied");
            return false;
        }
        return false;
    }

    public Formula negate() {
        return Formula.Not(this);
    }

    public static Formula parse(String str) throws ParseErrorException {
        Input i = new Input(str);
        return Formula.parse(i, 0);
    }

    public int processRightUntils(int current_index, int acc_sets) {
        this.has_been_visited = true;
        if (this.getContent() == 'U') {
            this.untils_index = current_index;
            if (this.right.rightOfWhichUntils == null) {
                this.right.rightOfWhichUntils = new BitSet(acc_sets);
            }
            this.right.rightOfWhichUntils.set(current_index);
            ++current_index;
        }
        if (this.left != null && !this.left.has_been_visited) {
            current_index = this.left.processRightUntils(current_index, acc_sets);
        }
        if (this.right != null && !this.right.has_been_visited) {
            current_index = this.right.processRightUntils(current_index, acc_sets);
        }
        return current_index;
    }

    public void reset_visited() {
        this.has_been_visited = false;
        if (this.left != null) {
            this.left.reset_visited();
        }
        if (this.right != null) {
            this.right.reset_visited();
        }
    }

    public Formula rewrite(Formula rule, Formula rewritten) {
        switch (this.content) {
            case 'A': 
            case 'O': 
            case 'U': 
            case 'V': 
            case 'W': {
                this.left = this.left.rewrite(rule, rewritten);
                this.right = this.right.rewrite(rule, rewritten);
                break;
            }
            case 'N': 
            case 'X': {
                this.left = this.left.rewrite(rule, rewritten);
                break;
            }
        }
        if (this.match(rule)) {
            Formula expr = rewritten.rewrite();
            Formula.clearMatches();
            return expr;
        }
        Formula.clearMatches();
        return this;
    }

    public int size() {
        switch (this.content) {
            case 'A': 
            case 'O': 
            case 'U': 
            case 'V': 
            case 'W': {
                return this.left.size() + this.right.size() + 1;
            }
            case 'N': 
            case 'X': {
                return this.left.size() + 1;
            }
        }
        return 0;
    }

    public String toString(boolean exprId) {
        if (!exprId) {
            return this.toString();
        }
        switch (this.content) {
            case 'A': {
                return "( " + this.left.toString(true) + " /\\ " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'O': {
                return "( " + this.left.toString(true) + " \\/ " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'U': {
                return "( " + this.left.toString(true) + " U " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'V': {
                return "( " + this.left.toString(true) + " V " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'W': {
                return "( " + this.left.toString(true) + " W " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'X': {
                return "( X " + this.left.toString(true) + " )[" + this.id + "]";
            }
            case 'N': {
                return "( ! " + this.left.toString(true) + " )[" + this.id + "]";
            }
            case 't': {
                return "( true )[" + this.id + "]";
            }
            case 'f': {
                return "( false )[" + this.id + "]";
            }
            case 'p': {
                return "( \"" + this.name + "\" )[" + this.id + "]";
            }
        }
        return "( " + this.content + " )[" + this.id + "]";
    }

    public String toString() {
        switch (this.content) {
            case 'A': {
                return "( " + this.left.toString() + " /\\ " + this.right.toString() + " )";
            }
            case 'O': {
                return "( " + this.left.toString() + " \\/ " + this.right.toString() + " )";
            }
            case 'U': {
                return "( " + this.left.toString() + " U " + this.right.toString() + " )";
            }
            case 'V': {
                return "( " + this.left.toString() + " V " + this.right.toString() + " )";
            }
            case 'W': {
                return "( " + this.left.toString() + " W " + this.right.toString() + " )";
            }
            case 'X': {
                return "( X " + this.left.toString() + " )";
            }
            case 'N': {
                return "( ! " + this.left.toString() + " )";
            }
            case 't': {
                return "( true )";
            }
            case 'f': {
                return "( false )";
            }
            case 'p': {
                return "( \"" + this.name + "\" )";
            }
        }
        return new Character(this.content).toString();
    }

    private static Formula Always(Formula f) {
        return Formula.unique(new Formula('V', false, Formula.False(), f, null));
    }

    private static Formula And(Formula sx, Formula dx) {
        if (sx.id < dx.id) {
            return Formula.unique(new Formula('A', false, sx, dx, null));
        }
        return Formula.unique(new Formula('A', false, dx, sx, null));
    }

    private static Formula Eventually(Formula f) {
        return Formula.unique(new Formula('U', false, Formula.True(), f, null));
    }

    private static Formula False() {
        return Formula.unique(new Formula('f', true, null, null, null));
    }

    private static Formula Implies(Formula sx, Formula dx) {
        return Formula.Or(Formula.Not(sx), dx);
    }

    private static Formula Next(Formula f) {
        return Formula.unique(new Formula('X', false, f, null, null));
    }

    private static Formula Not(Formula f) {
        if (f.literal) {
            switch (f.content) {
                case 't': {
                    return Formula.False();
                }
                case 'f': {
                    return Formula.True();
                }
                case 'N': {
                    return f.left;
                }
            }
            return Formula.unique(new Formula('N', true, f, null, null));
        }
        switch (f.content) {
            case 'A': {
                return Formula.Or(Formula.Not(f.left), Formula.Not(f.right));
            }
            case 'O': {
                return Formula.And(Formula.Not(f.left), Formula.Not(f.right));
            }
            case 'U': {
                return Formula.Release(Formula.Not(f.left), Formula.Not(f.right));
            }
            case 'V': {
                return Formula.Until(Formula.Not(f.left), Formula.Not(f.right));
            }
            case 'W': {
                return Formula.WRelease(Formula.Not(f.left), Formula.Not(f.right));
            }
            case 'N': {
                return f.left;
            }
            case 'X': {
                return Formula.Next(Formula.Not(f.left));
            }
        }
        throw new ParserInternalError();
    }

    private static Formula Or(Formula sx, Formula dx) {
        if (sx.id < dx.id) {
            return Formula.unique(new Formula('O', false, sx, dx, null));
        }
        return Formula.unique(new Formula('O', false, dx, sx, null));
    }

    private static Formula Proposition(String name) {
        return Formula.unique(new Formula('p', true, null, null, name));
    }

    private static Formula Release(Formula sx, Formula dx) {
        return Formula.unique(new Formula('V', false, sx, dx, null));
    }

    private static Formula True() {
        return Formula.unique(new Formula('t', true, null, null, null));
    }

    private static Formula Until(Formula sx, Formula dx) {
        return Formula.unique(new Formula('U', false, sx, dx, null));
    }

    private static Formula WRelease(Formula sx, Formula dx) {
        return Formula.unique(new Formula('U', false, dx, Formula.And(sx, dx), null));
    }

    private static Formula WUntil(Formula sx, Formula dx) {
        return Formula.unique(new Formula('W', false, sx, dx, null));
    }

    private static void clearHT() {
        ht = new Hashtable();
    }

    private static void clearMatches() {
        matches = new Hashtable();
    }

    /*
     * Unable to fully structure code
     */
    private static Formula parse(Input i, int precedence) throws ParseErrorException {
        try {
            while (i.get() == ' ') {
                i.skip();
            }
            ch = i.get();
            switch (ch) {
                case '&': 
                case ')': 
                case '/': 
                case 'M': 
                case 'U': 
                case 'V': 
                case 'W': 
                case '\\': 
                case '|': {
                    throw new ParseErrorException("invalid character: " + ch);
                }
                case '!': {
                    i.skip();
                    formula = Formula.Not(Formula.parse(i, 6));
                    break;
                }
                case 'X': {
                    i.skip();
                    formula = Formula.Next(Formula.parse(i, 6));
                    break;
                }
                case '[': {
                    i.skip();
                    if (i.get() != ']') {
                        throw new ParseErrorException("expected ]");
                    }
                    i.skip();
                    formula = Formula.Always(Formula.parse(i, 6));
                    break;
                }
                case '<': {
                    i.skip();
                    if (i.get() != '>') {
                        throw new ParseErrorException("expected >");
                    }
                    i.skip();
                    formula = Formula.Eventually(Formula.parse(i, 6));
                    break;
                }
                case '(': {
                    i.skip();
                    formula = Formula.parse(i, 0);
                    if (i.get() != ')') {
                        throw new ParseErrorException("invalid character: " + ch);
                    }
                    i.skip();
                    break;
                }
                case '\"': {
                    sb = new StringBuffer();
                    i.skip();
                    while ((ch = i.get()) != '\"') {
                        sb.append(ch);
                        i.skip();
                    }
                    i.skip();
                    formula = Formula.Proposition(sb.toString());
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierStart(ch)) {
                        sbf = new StringBuffer();
                        sbf.append(ch);
                        i.skip();
                        try {
                            while (Character.isJavaIdentifierPart(ch = i.get()) && !Formula.is_reserved_char(ch)) {
                                sbf.append(ch);
                                i.skip();
                            }
                        }
                        catch (EndOfInputException e) {
                            // empty catch block
                        }
                        id = sbf.toString();
                        if (id.equals("true")) {
                            formula = Formula.True();
                            break;
                        }
                        if (id.equals("false")) {
                            formula = Formula.False();
                            break;
                        }
                        formula = Formula.Proposition(sbf.toString());
                        break;
                    }
                    throw new ParseErrorException("invalid character: " + ch);
                }
            }
            try {
                while (i.get() == ' ') {
                    i.skip();
                }
                ch = i.get();
            }
            catch (EndOfInputException e) {
                return formula;
            }
            while (true) lbl-1000:
            // 2 sources

            {
                switch (ch) {
                    case '/': {
                        if (precedence > 3) {
                            return formula;
                        }
                        i.skip();
                        if (i.get() != '\\') {
                            throw new ParseErrorException("expected \\");
                        }
                        i.skip();
                        formula = Formula.And(formula, Formula.parse(i, 3));
                        break;
                    }
                    case '&': {
                        if (precedence > 3) {
                            return formula;
                        }
                        i.skip();
                        if (i.get() != '&') {
                            throw new ParseErrorException("expected &&");
                        }
                        i.skip();
                        formula = Formula.And(formula, Formula.parse(i, 3));
                        break;
                    }
                    case '\\': {
                        if (precedence > 2) {
                            return formula;
                        }
                        i.skip();
                        if (i.get() != '/') {
                            throw new ParseErrorException("expected /");
                        }
                        i.skip();
                        formula = Formula.Or(formula, Formula.parse(i, 2));
                        break;
                    }
                    case '|': {
                        if (precedence > 2) {
                            return formula;
                        }
                        i.skip();
                        if (i.get() != '|') {
                            throw new ParseErrorException("expected ||");
                        }
                        i.skip();
                        formula = Formula.Or(formula, Formula.parse(i, 2));
                        break;
                    }
                    case 'U': {
                        if (precedence > 4) {
                            return formula;
                        }
                        i.skip();
                        formula = Formula.Until(formula, Formula.parse(i, 4));
                        break;
                    }
                    case 'W': {
                        if (precedence > 4) {
                            return formula;
                        }
                        i.skip();
                        formula = Formula.WUntil(formula, Formula.parse(i, 4));
                        break;
                    }
                    case 'V': {
                        if (precedence > 5) {
                            return formula;
                        }
                        i.skip();
                        formula = Formula.Release(formula, Formula.parse(i, 5));
                        break;
                    }
                    case 'M': {
                        if (precedence > 5) {
                            return formula;
                        }
                        i.skip();
                        formula = Formula.WRelease(formula, Formula.parse(i, 5));
                        break;
                    }
                    case '-': {
                        if (precedence > 1) {
                            return formula;
                        }
                        i.skip();
                        if (i.get() != '>') {
                            throw new ParseErrorException("expected >");
                        }
                        i.skip();
                        formula = Formula.Implies(formula, Formula.parse(i, 1));
                        break;
                    }
                    case ')': {
                        return formula;
                    }
                    default: {
                        throw new ParseErrorException("invalid character: " + ch);
                    }
                }
                try {
                    while (i.get() == ' ') {
                        i.skip();
                    }
                    ch = i.get();
                    continue;
                }
                catch (EndOfInputException e) {
                    return formula;
                }
                break;
            }
        }
        catch (EndOfInputException e) {
            throw new ParseErrorException("unexpected end of input");
        }
        {
            ** while (true)
        }
    }

    private static Formula unique(Formula f) {
        String s = f.toString();
        if (ht.containsKey(s)) {
            return (Formula)ht.get(s);
        }
        ht.put(s, f);
        return f;
    }

    private Formula getMatch(String name) {
        return (Formula)matches.get(name);
    }

    private void addMatch(String name, Formula expr) {
        matches.put(name, expr);
    }

    private boolean match(Formula rule) {
        if (rule.content == 'p') {
            Formula match = this.getMatch(rule.name);
            if (match == null) {
                this.addMatch(rule.name, this);
                return true;
            }
            return match == this;
        }
        if (rule.content != this.content) {
            return false;
        }
        Hashtable saved = (Hashtable)matches.clone();
        switch (this.content) {
            case 'A': 
            case 'O': {
                if (this.left.match(rule.left) && this.right.match(rule.right)) {
                    return true;
                }
                matches = saved;
                if (this.right.match(rule.left) && this.left.match(rule.right)) {
                    return true;
                }
                matches = saved;
                return false;
            }
            case 'U': 
            case 'V': 
            case 'W': {
                if (this.left.match(rule.left) && this.right.match(rule.right)) {
                    return true;
                }
                matches = saved;
                return false;
            }
            case 'N': 
            case 'X': {
                if (this.left.match(rule.left)) {
                    return true;
                }
                matches = saved;
                return false;
            }
            case 'f': 
            case 't': {
                return true;
            }
        }
        throw new RuntimeException("code should not be reached");
    }

    private Formula rewrite() {
        if (this.content == 'p') {
            return this.getMatch(this.name);
        }
        switch (this.content) {
            case 'A': {
                return Formula.And(this.left.rewrite(), this.right.rewrite());
            }
            case 'O': {
                return Formula.Or(this.left.rewrite(), this.right.rewrite());
            }
            case 'U': {
                return Formula.Until(this.left.rewrite(), this.right.rewrite());
            }
            case 'V': {
                return Formula.Release(this.left.rewrite(), this.right.rewrite());
            }
            case 'W': {
                return Formula.WUntil(this.left.rewrite(), this.right.rewrite());
            }
            case 'X': {
                return Formula.Next(this.left.rewrite());
            }
            case 'N': {
                return Formula.Not(this.left.rewrite());
            }
            case 't': {
                return Formula.True();
            }
            case 'f': {
                return Formula.False();
            }
        }
        throw new RuntimeException("code should not be reached");
    }

    private static class Input {
        private StringBuffer sb;

        public Input(String str) {
            this.sb = new StringBuffer(str);
        }

        public char get() throws EndOfInputException {
            try {
                return this.sb.charAt(0);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new EndOfInputException();
            }
        }

        public void skip() throws EndOfInputException {
            try {
                this.sb.deleteCharAt(0);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new EndOfInputException();
            }
        }
    }

    public static class EndOfInputException
    extends Exception {
    }
}

