/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Degeneralize;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.SCCReduction;
import gov.nasa.ltl.graph.SFSReduction;
import gov.nasa.ltl.graph.Simplify;
import gov.nasa.ltl.graph.SuperSetReduction;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTLErrorException;
import gov.nasa.ltl.trans.Node;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.Pool;
import gov.nasa.ltl.trans.Rewriter;
import gov.nasa.ltl.trans.Translator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class LTL2Buchi {
    private static boolean debug = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String ltl = null;
        boolean rewrite = true;
        boolean bisim = true;
        boolean fairSim = true;
        boolean file_provided = false;
        debug = true;
        System.out.println("\nAuthors Dimitra Giannakopoulou & Flavio Lerda, \n(c) 2001,2003 NASA Ames Research Center\n");
        Translator.set_algorithm(1);
        if (args.length != 0) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-a")) {
                    if (++i >= args.length) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    if (args[i].equals("ltl2buchi")) {
                        Translator.set_algorithm(1);
                    } else {
                        if (!args[i].equals("ltl2aut")) {
                            LTL2Buchi.usage_warning();
                            return;
                        }
                        Translator.set_algorithm(0);
                    }
                } else if (args[i].equals("-norw")) {
                    rewrite = false;
                } else if (args[i].equals("-nobisim")) {
                    bisim = false;
                } else if (args[i].equals("-nofsim")) {
                    fairSim = false;
                } else if (args[i].equals("-nodebug")) {
                    debug = false;
                } else {
                    if (!args[i].equals("-f")) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    if (++i >= args.length) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                    ltl = args[i];
                    if (ltl.endsWith(".ltl")) {
                        ltl = LTL2Buchi.loadLTL(ltl);
                        file_provided = true;
                    } else if (!ltl.equals("-")) {
                        LTL2Buchi.usage_warning();
                        return;
                    }
                }
                ++i;
            }
        }
        if (!file_provided) {
            ltl = LTL2Buchi.readLTL();
        }
        try {
            Graph g = LTL2Buchi.translate(ltl, rewrite, bisim, fairSim);
            g.save(1);
            System.out.println("\n***********************\n");
            return;
        }
        catch (ParseErrorException ex) {
            System.out.println("Error: " + ex);
            return;
        }
    }

    public static void reset_all_static() {
        Node.reset_static();
        Formula.reset_static();
        Pool.reset_static();
    }

    public static Graph translate(String formula, boolean rewrite, boolean bisim, boolean fair_sim) throws ParseErrorException {
        boolean superset = true;
        boolean scc = true;
        if (rewrite) {
            try {
                formula = Rewriter.rewrite(formula);
            }
            catch (ParseErrorException e) {
                throw new ParseErrorException(e.getMessage());
            }
            System.out.println("Rewritten as       : " + formula);
            System.out.println();
        }
        if (formula == null) {
            System.out.println("Unexpected null formula");
        }
        Graph gba = Translator.translate(formula);
        if (debug) {
            System.out.println("\n***********************");
            System.out.println("\nGeneralized buchi automaton generated");
            System.out.println("\t" + gba.getNodeCount() + " states " + gba.getEdgeCount() + " transitions");
        }
        if (superset) {
            gba = SuperSetReduction.reduce(gba);
            if (debug) {
                System.out.println("\n***********************");
                System.out.println("Superset reduction");
                System.out.println("\t" + gba.getNodeCount() + " states " + gba.getEdgeCount() + " transitions");
            }
        }
        Graph ba = Degeneralize.degeneralize(gba);
        if (debug) {
            System.out.println("\n***********************");
            System.out.println("Degeneralized buchi automaton generated");
            System.out.println("\t" + ba.getNodeCount() + " states " + ba.getEdgeCount() + " transitions");
        }
        if (scc) {
            ba = SCCReduction.reduce(ba);
            if (debug) {
                System.out.println("\n***********************");
                System.out.println("Strongly connected component reduction");
                System.out.println("\t" + ba.getNodeCount() + " states " + ba.getEdgeCount() + " transitions");
            }
        }
        if (bisim) {
            ba = Simplify.simplify(ba);
            if (debug) {
                System.out.println("\n***********************");
                System.out.println("Bisimulation applied");
                System.out.println("\t" + ba.getNodeCount() + " states " + ba.getEdgeCount() + " transitions");
            }
        }
        if (fair_sim) {
            ba = SFSReduction.reduce(ba);
            if (debug) {
                System.out.println("\n***********************");
                System.out.println("Fair simulation applied");
                System.out.println("\t" + ba.getNodeCount() + " states " + ba.getEdgeCount() + " transitions");
            }
        }
        System.out.println("***********************\n");
        LTL2Buchi.reset_all_static();
        return ba;
    }

    public static Graph translate(String formula) throws ParseErrorException {
        return LTL2Buchi.translate(formula, true, true, true);
    }

    public static Graph translate(File file) throws ParseErrorException {
        String formula = "";
        try {
            LineNumberReader f = new LineNumberReader(new FileReader(file));
            formula = f.readLine().trim();
            f.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return LTL2Buchi.translate(formula, true, true, true);
    }

    public static void usage_warning() {
        System.out.println("\n*******  USAGE *******");
        System.out.println("java gov.nasa.ltl.trans.LTL2Buchi <options>");
        System.out.println("\toptions can be (in any order):");
        System.out.println("\t\t \"-f <filename.ltl>\" (read formula from file)");
        System.out.println("\t\t \"-a [ltl2buchi|ltl2aut]\" (set algorithm to be used)");
        System.out.println("\t\t \"-norw\" (no rewriting)");
        System.out.println("\t\t \"-nobisim\" (no bisimulation reduction)");
        System.out.println("\t\t \"-nofsim\" (no fair simulation reduction");
    }

    private static String loadLTL(String fname) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(fname));
            return in.readLine();
        }
        catch (FileNotFoundException e) {
            throw new LTLErrorException("Can't load LTL formula: " + fname);
        }
        catch (IOException e) {
            throw new LTLErrorException("Error read on LTL formula: " + fname);
        }
    }

    private static String readLTL() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("\nInsert LTL formula: ");
            return in.readLine();
        }
        catch (IOException e) {
            throw new LTLErrorException("Invalid LTL formula");
        }
    }
}

