/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.trans.Automaton;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.Pool;
import gov.nasa.ltl.trans.State;
import gov.nasa.ltl.trans.Transition;
import java.util.BitSet;
import java.util.Iterator;
import java.util.TreeSet;

class Node
implements Comparable {
    public static int accepting_conds = 0;
    private static boolean init_collapsed = false;
    private int nodeId = Pool.assign();
    private TreeSet incoming;
    private TreeSet toBeDone;
    private TreeSet old;
    private TreeSet next;
    private BitSet accepting;
    private BitSet right_of_untils;
    private Node OtherTransitionSource;
    private int equivalenceId;

    public Node() {
        this.incoming = new TreeSet();
        this.toBeDone = new TreeSet();
        this.old = new TreeSet();
        this.next = new TreeSet();
        this.OtherTransitionSource = null;
        this.accepting = new BitSet(accepting_conds);
        this.right_of_untils = new BitSet(accepting_conds);
    }

    public Node(TreeSet in, TreeSet newForm, TreeSet done, TreeSet nx, BitSet acc, BitSet rous) {
        this.incoming = new TreeSet(in);
        this.toBeDone = new TreeSet(newForm);
        this.old = new TreeSet(done);
        this.next = new TreeSet(nx);
        this.OtherTransitionSource = null;
        this.accepting = new BitSet(accepting_conds);
        this.accepting.or(acc);
        this.right_of_untils = new BitSet(accepting_conds);
        this.right_of_untils.or(rous);
    }

    public static int getAcceptingConds() {
        return accepting_conds;
    }

    public static Node createInitial(Formula form) {
        accepting_conds = form.initialize();
        Node init = new Node();
        init.nodeId = 0;
        if (form.getContent() != 't') {
            init.decompose_ands_for_next(form);
        }
        return init;
    }

    public static void reset_static() {
        accepting_conds = 0;
        init_collapsed = false;
    }

    public TreeSet getField_next() {
        return this.next;
    }

    public TreeSet getField_old() {
        return this.old;
    }

    public int getId() {
        return this.nodeId;
    }

    public boolean isInitial() {
        return this.nodeId == 0;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public void RTstructure(State[] RTautomaton) {
        boolean safety = false;
        if (RTautomaton[this.nodeId] == null) {
            RTautomaton[this.nodeId] = new State(this.accepting, this.equivalenceId);
        } else {
            RTautomaton[this.nodeId].update_acc(this.accepting, this.equivalenceId);
        }
        if (this.is_safety_acc_node()) {
            RTautomaton[this.nodeId].update_safety_acc(true);
            safety = true;
        }
        Node Alternative = this;
        while (Alternative != null) {
            Iterator iterIncom = Alternative.incoming.iterator();
            while (iterIncom.hasNext()) {
                Node nextNode = (Node)iterIncom.next();
                int stateId = nextNode.getId();
                if (RTautomaton[stateId] == null) {
                    RTautomaton[stateId] = new State();
                }
                RTautomaton[stateId].add(new Transition(Alternative.old, this.equivalenceId, this.accepting, safety));
            }
            Alternative = Alternative.OtherTransitionSource;
        }
    }

    public int compareTo(Object f) {
        if (this == f) {
            return 0;
        }
        return 1;
    }

    public boolean compare_accepting(Node nd) {
        if (this.nodeId == 0 && !init_collapsed) {
            return true;
        }
        return this.accepting.equals(nd.accepting);
    }

    public void debug() {
        Iterator iterOld = this.old.iterator();
        Formula nextForm = null;
        while (iterOld.hasNext()) {
            nextForm = (Formula)iterOld.next();
        }
    }

    public void decompose_ands_for_next(Formula form) {
        if (form.getContent() == 'A') {
            this.decompose_ands_for_next(form.getSub1());
            this.decompose_ands_for_next(form.getSub2());
        } else if (!Node.is_redundant(this.next, null, form)) {
            this.next.add(form);
        }
    }

    public Automaton expand(Automaton states) {
        if (this.toBeDone.isEmpty()) {
            Node tempNode;
            if (this.nodeId != 0) {
                this.update_accepting();
            }
            if ((tempNode = states.alreadyThere(this)) != null) {
                tempNode.modify(this);
                return states;
            }
            Node NewN = new Node();
            NewN.incoming.add(this);
            NewN.toBeDone.addAll(this.next);
            states.add(this);
            return NewN.expand(states);
        }
        Formula ita = (Formula)this.toBeDone.first();
        this.toBeDone.remove(ita);
        if (this.testForContradictions(ita)) {
            return states;
        }
        if (ita.is_right_of_until(accepting_conds)) {
            this.right_of_untils.or(ita.get_rightOfWhichUntils());
        }
        TreeSet set_checked_against = new TreeSet();
        set_checked_against.addAll(this.old);
        set_checked_against.addAll(this.toBeDone);
        if (Node.is_redundant(set_checked_against, this.next, ita)) {
            return this.expand(states);
        }
        if (ita.getContent() == 'U') {
            this.accepting.set(ita.get_untils_index());
        }
        if (!ita.is_literal()) {
            switch (ita.getContent()) {
                case 'O': 
                case 'U': 
                case 'V': 
                case 'W': {
                    Node node2 = this.split(ita);
                    return node2.expand(this.expand(states));
                }
                case 'X': {
                    this.decompose_ands_for_next(ita.getSub1());
                    return this.expand(states);
                }
                case 'A': {
                    Formula temp_form = ita.getSub1();
                    if (!this.old.contains(temp_form)) {
                        this.toBeDone.add(temp_form);
                    }
                    if (!this.old.contains(temp_form = ita.getSub2())) {
                        this.toBeDone.add(temp_form);
                    }
                    return this.expand(states);
                }
            }
            System.out.println("default case of switch entered");
            return null;
        }
        if (ita.getContent() != 't') {
            this.old.add(ita);
        }
        return this.expand(states);
    }

    public int get_equivalenceId() {
        return this.equivalenceId;
    }

    public void set_equivalenceId(int value) {
        this.equivalenceId = value;
    }

    public void update_accepting() {
        this.accepting.andNot(this.right_of_untils);
    }

    private static boolean is_redundant(TreeSet main_set, TreeSet next_set, Formula ita) {
        return ita.is_special_case_of_V(main_set) || ita.is_synt_implied(main_set, next_set) && (ita.getContent() != 'U' || ita.getSub2().is_synt_implied(main_set, next_set));
    }

    private boolean is_safety_acc_node() {
        if (this.next.isEmpty()) {
            return true;
        }
        Iterator iterNext = this.next.iterator();
        Formula nextForm = null;
        while (iterNext.hasNext()) {
            nextForm = (Formula)iterNext.next();
            if (nextForm.getContent() == 'V' || nextForm.getContent() == 'W') continue;
            return false;
        }
        return true;
    }

    private void modify(Node current) {
        boolean match = false;
        Node Tail = this;
        Node Alternative = this;
        if (this.nodeId == 0 && !init_collapsed) {
            this.accepting = current.accepting;
            init_collapsed = true;
        }
        while (Alternative != null) {
            if (Alternative.old.equals(current.old)) {
                Alternative.incoming.addAll(current.incoming);
                match = true;
            }
            Tail = Alternative;
            Alternative = Alternative.OtherTransitionSource;
        }
        if (!match) {
            Tail.OtherTransitionSource = current;
        }
    }

    private Node split(Formula form) {
        Node Node2 = new Node(this.incoming, this.toBeDone, this.old, this.next, this.accepting, this.right_of_untils);
        Formula temp_form = form.getSub2();
        if (!this.old.contains(temp_form)) {
            Node2.toBeDone.add(temp_form);
        }
        if (form.getContent() == 'V' && !this.old.contains(temp_form = form.getSub1())) {
            Node2.toBeDone.add(temp_form);
        }
        if (!this.old.contains(temp_form = form.getSub1())) {
            this.toBeDone.add(temp_form);
        }
        if ((temp_form = form.getNext()) != null) {
            this.decompose_ands_for_next(temp_form);
        }
        if (form.is_literal()) {
            this.old.add(form);
            System.out.println("added " + form);
            Node2.old.add(form);
        }
        return Node2;
    }

    private boolean testForContradictions(Formula ita) {
        Formula Not_ita = ita.negate();
        return Not_ita.is_synt_implied(this.old, this.next);
    }
}

