/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.RulesClass;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;

public class Rewriter {
    public static Formula applyRule(Formula expr, Formula rule, Formula rewritten) {
        return expr.rewrite(rule, rewritten);
    }

    public static void main(String[] args) {
        block8: {
            int osize = 0;
            int rsize = 0;
            try {
                if (args.length != 0) {
                    int i = 0;
                    while (i < args.length) {
                        Formula f = Formula.parse(args[i]);
                        osize += f.size();
                        f = Rewriter.rewrite(f);
                        System.out.println(f);
                        System.err.println((rsize += f.size()) * 100 / osize + "% (" + osize + " => " + rsize + ")");
                        ++i;
                    }
                    break block8;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                block5: while (true) {
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            if (line.equals("")) continue;
                            Formula f = Formula.parse(line);
                            osize += f.size();
                            f = Rewriter.rewrite(f);
                            System.out.println(f);
                            System.err.println((rsize += f.size()) * 100 / osize + "% (" + osize + " => " + rsize + ")");
                            continue block5;
                        }
                        break;
                    }
                    catch (IOException e) {
                        System.out.println("error");
                    }
                }
            }
            catch (ParseErrorException e) {
                System.err.println("parse error: " + e.getMessage());
            }
        }
    }

    public static Formula[] readRules() {
        Formula[] rules = new Formula[]{};
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(RulesClass.getRules()));
            while ((line = in.readLine()) != null) {
                if (line.equals("")) continue;
                Formula rule = Formula.parse(line);
                Formula[] n = new Formula[rules.length + 1];
                System.arraycopy(rules, 0, n, 0, rules.length);
                n[rules.length] = rule;
                rules = n;
            }
        }
        catch (IOException e) {
        }
        catch (ParseErrorException e) {
            System.err.println("parse error: " + e.getMessage());
            System.exit(1);
        }
        return rules;
    }

    public static String rewrite(String expr) throws ParseErrorException {
        try {
            Formula formula = Formula.parse(expr);
            return Rewriter.rewrite(formula).toString();
        }
        catch (ParseErrorException e) {
            throw new ParseErrorException(e.getMessage());
        }
    }

    public static Formula rewrite(Formula expr) throws ParseErrorException {
        Formula[] rules = Rewriter.readRules();
        if (rules == null) {
            return expr;
        }
        try {
            boolean changed;
            boolean negated = false;
            do {
                Formula old;
                changed = false;
                do {
                    old = expr;
                    int i = 0;
                    while (i < rules.length) {
                        expr = Rewriter.applyRule(expr, rules[i], rules[i + 1]);
                        i += 2;
                    }
                    if (old == expr) continue;
                    changed = true;
                } while (old != expr);
                negated = !negated;
                expr = Formula.parse("!" + expr.toString());
            } while (changed || negated);
            return expr;
        }
        catch (ParseErrorException e) {
            throw new ParseErrorException(e.getMessage());
        }
    }
}

