/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.trans.Transition;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;

class State
implements Comparable {
    private int representativeId = -1;
    private LinkedList transitions = new LinkedList();
    private BitSet accepting;
    private boolean safety_acceptance;

    public State(BitSet acc) {
        this.accepting = acc;
        this.safety_acceptance = false;
    }

    public State(BitSet acc, int equivId) {
        this.accepting = acc;
        this.safety_acceptance = false;
        this.representativeId = equivId;
    }

    public State() {
        this.accepting = null;
        this.safety_acceptance = false;
    }

    public State(int equivId) {
        this.accepting = null;
        this.safety_acceptance = false;
        this.representativeId = equivId;
    }

    public void FSPoutput() {
        ListIterator iter = this.transitions.listIterator(0);
        boolean first_trans = true;
        while (iter.hasNext()) {
            Transition nextTrans = (Transition)iter.next();
            if (first_trans) {
                System.out.print("(");
                first_trans = false;
            } else {
                System.out.print("|");
            }
            nextTrans.FSPoutput();
        }
    }

    public void SMoutput(Node[] nodes, Node node) {
        ListIterator iter = this.transitions.listIterator(0);
        boolean first_trans = true;
        while (iter.hasNext()) {
            Transition nextTrans = (Transition)iter.next();
            nextTrans.SMoutput(nodes, node);
        }
    }

    public boolean accepts(int i) {
        return !this.accepting.get(i);
    }

    public void add(Transition trans) {
        this.transitions.add(trans);
    }

    public int compareTo(Object f) {
        if (this == f) {
            return 0;
        }
        return 1;
    }

    public int get_representativeId() {
        return this.representativeId;
    }

    public boolean is_safe() {
        return this.safety_acceptance;
    }

    public void set_representativeId(int id) {
        this.representativeId = id;
    }

    public void step(Hashtable ProgramState, TreeSet newStates, State[] automaton) {
        ListIterator iter = this.transitions.listIterator(0);
        while (iter.hasNext()) {
            Transition nextTrans = (Transition)iter.next();
            if (!nextTrans.enabled(ProgramState)) continue;
            newStates.add(automaton[nextTrans.goesTo()]);
        }
    }

    public void update_acc(BitSet acc) {
        this.accepting = acc;
    }

    public void update_acc(BitSet acc, int equivId) {
        this.accepting = acc;
        this.representativeId = equivId;
    }

    public void update_safety_acc(boolean val) {
        this.safety_acceptance = val;
    }
}

