/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.Node;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

class Transition {
    private TreeSet propositions;
    private int pointsTo;
    private BitSet accepting;
    private boolean safe_accepting;

    public Transition(TreeSet prop, int nd_id, BitSet acc, boolean safety) {
        this.propositions = prop;
        this.pointsTo = nd_id;
        this.accepting = new BitSet(Node.getAcceptingConds());
        this.accepting.or(acc);
        this.safe_accepting = safety;
    }

    public void FSPoutput() {
        if (this.propositions.isEmpty()) {
            System.out.print("TRUE{");
        } else {
            Iterator it = this.propositions.iterator();
            Formula nextForm = null;
            StringBuffer act = new StringBuffer();
            boolean need_AND = false;
            while (it.hasNext()) {
                nextForm = (Formula)it.next();
                char cont = nextForm.getContent();
                if (need_AND) {
                    act.append("_AND_");
                }
                need_AND = true;
                switch (cont) {
                    case 'N': {
                        act.append('N');
                        act.append(nextForm.getSub1().getName());
                        break;
                    }
                    case 't': {
                        act.append("TRUE");
                        break;
                    }
                    default: {
                        act.append(nextForm.getName());
                    }
                }
            }
            System.out.print(act + "{");
        }
        if (Node.accepting_conds == 0) {
            if (this.safe_accepting) {
                System.out.print("0");
            }
        } else {
            int i = 0;
            while (i < Node.accepting_conds) {
                if (!this.accepting.get(i)) {
                    System.out.print(i);
                }
                ++i;
            }
        }
        System.out.print("} -> S" + this.pointsTo + " ");
    }

    public void SMoutput(gov.nasa.ltl.graph.Node[] nodes, gov.nasa.ltl.graph.Node node) {
        String guard = "-";
        String action = "-";
        if (!this.propositions.isEmpty()) {
            Iterator it = this.propositions.iterator();
            Formula nextForm = null;
            StringBuffer sb = new StringBuffer();
            boolean need_AND = false;
            while (it.hasNext()) {
                nextForm = (Formula)it.next();
                char cont = nextForm.getContent();
                if (need_AND) {
                    sb.append("&");
                }
                need_AND = true;
                switch (cont) {
                    case 'N': {
                        sb.append('!');
                        sb.append(nextForm.getSub1().getName());
                        break;
                    }
                    case 't': {
                        sb.append("true");
                        break;
                    }
                    default: {
                        sb.append(nextForm.getName());
                    }
                }
            }
            guard = sb.toString();
        }
        Edge e = new Edge(node, nodes[this.pointsTo], guard, action);
        if (Node.accepting_conds == 0) {
            e.setBooleanAttribute("acc0", true);
        } else {
            int i = 0;
            while (i < Node.accepting_conds) {
                if (!this.accepting.get(i)) {
                    e.setBooleanAttribute("acc" + i, true);
                }
                ++i;
            }
        }
    }

    public boolean enabled(Hashtable ProgramState) {
        Iterator mustHold = this.propositions.iterator();
        Formula form = null;
        while (mustHold.hasNext()) {
            form = (Formula)mustHold.next();
            char c = form.getContent();
            switch (c) {
                case 'N': {
                    Boolean value = (Boolean)ProgramState.get(form.getSub1().getName());
                    if (value == null) {
                        return false;
                    }
                    if (!value.booleanValue()) break;
                    return false;
                }
                case 't': {
                    break;
                }
                case 'p': {
                    Boolean value = (Boolean)ProgramState.get(form.getName());
                    if (value == null) {
                        return false;
                    }
                    if (value.booleanValue()) break;
                    return false;
                }
            }
        }
        return true;
    }

    public int goesTo() {
        return this.pointsTo;
    }
}

