/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.trans.Automaton;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTLErrorException;
import gov.nasa.ltl.trans.Node;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.State;

public class Translator {
    public static final int LTL2AUT = 0;
    public static final int LTL2BUCHI = 1;
    private static int algorithm = 1;

    public static int get_algorithm() {
        return algorithm;
    }

    public static boolean set_algorithm(int alg) {
        if (alg == 0 || alg == 1) {
            algorithm = alg;
            return true;
        }
        return false;
    }

    public static Graph translate(String formula) {
        try {
            Formula ltl = Formula.parse(formula);
            Node init = Node.createInitial(ltl);
            State[] states = init.expand(new Automaton()).structForRuntAnalysis();
            return Automaton.SMoutput(states);
        }
        catch (ParseErrorException e) {
            throw new LTLErrorException("parse error: " + e.getMessage());
        }
    }
}

