package money;

class Money implements IMoney {
    private int fAmount;
    private String fCurrency;

    public Money(int amount, String currency) {
      fAmount= amount;
      fCurrency= currency;
    }

    public int amount() {
      return fAmount;
    }

    public String currency() {
      return fCurrency;
    }

    public IMoney add(IMoney m) {
      return m.addMoney(this);
    }

    public IMoney addMoney(Money m) {
      if (m.currency().equals(currency()) )
         return new Money(amount()+m.amount(), currency());
      return new MoneyBag(this, m);
    }

    public IMoney addMoneyBag(MoneyBag s) {
      return s.addMoney(this);
    }

    public IMoney subtract(IMoney m) {
      return add(m.negate());
    }

    public IMoney negate() {
      return new Money(-amount(),currency());
    }

    public boolean isZero() {
      return amount() == 0;
    }

    public boolean equals(Object anObject) {
      if (! (anObject instanceof IMoney)) return false;
      if (isZero() && ((IMoney)anObject).isZero()) return true;
      if (! (anObject instanceof Money) ) return false;
      Money m= (Money)anObject;
      return m.currency().equals(currency())
        && amount() == m.amount();
    }

    public int hashCode() {
      return currency().hashCode() + amount();
    }

    public String toString() {
      return "["+amount()+" "+currency()+"]";
    }

}
